/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.MeasuredParagraph;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.IntArray;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;

public class MeasuredText
implements Spanned {
    private static final char LINE_FEED = '\n';
    private final CharSequence mText;
    private final int mStart;
    private final int mEnd;
    private final TextPaint mPaint;
    private final TextDirectionHeuristic mTextDir;
    private final MeasuredParagraph[] mMeasuredParagraphs;
    private final int[] mParagraphBreakPoints;
    private final int mBreakStrategy;
    private final int mHyphenationFrequency;

    private MeasuredText(CharSequence text, int start, int end, TextPaint paint, TextDirectionHeuristic textDir, int breakStrategy, int frequency, MeasuredParagraph[] measuredTexts, int[] paragraphBreakPoints) {
        this.mText = text;
        this.mStart = start;
        this.mEnd = end;
        this.mPaint = new TextPaint(paint);
        this.mMeasuredParagraphs = measuredTexts;
        this.mParagraphBreakPoints = paragraphBreakPoints;
        this.mTextDir = textDir;
        this.mBreakStrategy = breakStrategy;
        this.mHyphenationFrequency = frequency;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getEnd() {
        return this.mEnd;
    }

    public TextDirectionHeuristic getTextDir() {
        return this.mTextDir;
    }

    public TextPaint getPaint() {
        return this.mPaint;
    }

    public int getParagraphCount() {
        return this.mParagraphBreakPoints.length;
    }

    public int getParagraphStart(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return paraIndex == 0 ? this.mStart : this.mParagraphBreakPoints[paraIndex - 1];
    }

    public int getParagraphEnd(int paraIndex) {
        Preconditions.checkArgumentInRange(paraIndex, 0, this.getParagraphCount(), "paraIndex");
        return this.mParagraphBreakPoints[paraIndex];
    }

    public MeasuredParagraph getMeasuredParagraph(int paraIndex) {
        return this.mMeasuredParagraphs[paraIndex];
    }

    public int getBreakStrategy() {
        return this.mBreakStrategy;
    }

    public int getHyphenationFrequency() {
        return this.mHyphenationFrequency;
    }

    public boolean canUseMeasuredResult(TextPaint paint) {
        return this.mPaint.getTextSize() == paint.getTextSize() && this.mPaint.getTextSkewX() == paint.getTextSkewX() && this.mPaint.getTextScaleX() == paint.getTextScaleX() && this.mPaint.getLetterSpacing() == paint.getLetterSpacing() && this.mPaint.getWordSpacing() == paint.getWordSpacing() && this.mPaint.getFlags() == paint.getFlags() && this.mPaint.getTextLocales() == paint.getTextLocales() && this.mPaint.getFontVariationSettings() == paint.getFontVariationSettings() && this.mPaint.getTypeface() == paint.getTypeface() && TextUtils.equals(this.mPaint.getFontFeatureSettings(), paint.getFontFeatureSettings());
    }

    public int findParaIndex(int pos) {
        for (int i = 0; i < this.mParagraphBreakPoints.length; ++i) {
            if (pos >= this.mParagraphBreakPoints[i]) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("pos must be less than " + this.mParagraphBreakPoints[this.mParagraphBreakPoints.length - 1] + ", gave " + pos);
    }

    public float getWidth(int start, int end) {
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new RuntimeException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        return this.getMeasuredParagraph(paraIndex).getWidth(start - paraStart, end - paraStart);
    }

    public int getMemoryUsage() {
        int r = 0;
        for (int i = 0; i < this.getParagraphCount(); ++i) {
            r += this.getMeasuredParagraph(i).getMemoryUsage();
        }
        return r;
    }

    @Override
    public <T> T[] getSpans(int start, int end, Class<T> type) {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpans(start, end, type);
        }
        return ArrayUtils.emptyArray(type);
    }

    @Override
    public int getSpanStart(Object tag) {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpanStart(tag);
        }
        return -1;
    }

    @Override
    public int getSpanEnd(Object tag) {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpanEnd(tag);
        }
        return -1;
    }

    @Override
    public int getSpanFlags(Object tag) {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpanFlags(tag);
        }
        return 0;
    }

    @Override
    public int nextSpanTransition(int start, int limit, Class type) {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).nextSpanTransition(start, limit, type);
        }
        return this.mText.length();
    }

    @Override
    public int length() {
        return this.mText.length();
    }

    @Override
    public char charAt(int index) {
        return this.mText.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.mText.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.mText.toString();
    }

    public static final class Builder {
        private final CharSequence mText;
        private final TextPaint mPaint;
        private int mStart;
        private int mEnd;
        private TextDirectionHeuristic mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
        private int mBreakStrategy = 1;
        private int mHyphenationFrequency = 1;

        public Builder(CharSequence text, TextPaint paint) {
            Preconditions.checkNotNull(text);
            Preconditions.checkNotNull(paint);
            this.mText = text;
            this.mPaint = paint;
            this.mStart = 0;
            this.mEnd = text.length();
        }

        public Builder setRange(int start, int end) {
            Preconditions.checkArgumentInRange(start, 0, this.mText.length(), "start");
            Preconditions.checkArgumentInRange(end, 0, this.mText.length(), "end");
            Preconditions.checkArgument(start <= end, "The range is reversed.");
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        public Builder setTextDirection(TextDirectionHeuristic textDir) {
            Preconditions.checkNotNull(textDir);
            this.mTextDir = textDir;
            return this;
        }

        public Builder setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        public Builder setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        public MeasuredText build() {
            return this.build(true);
        }

        public MeasuredText build(boolean computeLayout) {
            boolean needHyphenation = this.mBreakStrategy != 0 && this.mHyphenationFrequency != 0;
            IntArray paragraphEnds = new IntArray();
            ArrayList<MeasuredParagraph> measuredTexts = new ArrayList<MeasuredParagraph>();
            int paraEnd = 0;
            int paraStart = this.mStart;
            while (paraStart < this.mEnd) {
                paraEnd = TextUtils.indexOf(this.mText, '\n', paraStart, this.mEnd);
                paraEnd = paraEnd < 0 ? this.mEnd : ++paraEnd;
                paragraphEnds.add(paraEnd);
                measuredTexts.add(MeasuredParagraph.buildForStaticLayout(this.mPaint, this.mText, paraStart, paraEnd, this.mTextDir, needHyphenation, computeLayout, null));
                paraStart = paraEnd;
            }
            return new MeasuredText(this.mText, this.mStart, this.mEnd, this.mPaint, this.mTextDir, this.mBreakStrategy, this.mHyphenationFrequency, measuredTexts.toArray(new MeasuredParagraph[measuredTexts.size()]), paragraphEnds.toArray());
        }
    }
}

