/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TypeEvaluator;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

public class TransitionUtils {
    private static int MAX_IMAGE_SIZE = 0x100000;

    static Animator mergeAnimators(Animator animator1, Animator animator2) {
        if (animator1 == null) {
            return animator2;
        }
        if (animator2 == null) {
            return animator1;
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animator1, animator2);
        return animatorSet;
    }

    public static Transition mergeTransitions(Transition ... transitions) {
        int count = 0;
        int nonNullIndex = -1;
        for (int i = 0; i < transitions.length; ++i) {
            if (transitions[i] == null) continue;
            ++count;
            nonNullIndex = i;
        }
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return transitions[nonNullIndex];
        }
        TransitionSet transitionSet = new TransitionSet();
        for (int i = 0; i < transitions.length; ++i) {
            if (transitions[i] == null) continue;
            transitionSet.addTransition(transitions[i]);
        }
        return transitionSet;
    }

    public static View copyViewImage(ViewGroup sceneRoot, View view, View parent) {
        Matrix matrix = new Matrix();
        matrix.setTranslate(-parent.getScrollX(), -parent.getScrollY());
        view.transformMatrixToGlobal(matrix);
        sceneRoot.transformMatrixToLocal(matrix);
        RectF bounds = new RectF(0.0f, 0.0f, view.getWidth(), view.getHeight());
        matrix.mapRect(bounds);
        int left = Math.round(bounds.left);
        int top = Math.round(bounds.top);
        int right = Math.round(bounds.right);
        int bottom = Math.round(bounds.bottom);
        ImageView copy = new ImageView(view.getContext());
        copy.setScaleType(ImageView.ScaleType.CENTER_CROP);
        Bitmap bitmap = TransitionUtils.createViewBitmap(view, matrix, bounds, sceneRoot);
        if (bitmap != null) {
            copy.setImageBitmap(bitmap);
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec(right - left, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(bottom - top, 0x40000000);
        copy.measure(widthSpec, heightSpec);
        copy.layout(left, top, right, bottom);
        return copy;
    }

    public static Bitmap createDrawableBitmap(Drawable drawable2, View hostView) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        float scale = Math.min(1.0f, (float)MAX_IMAGE_SIZE / (float)(width * height));
        if (drawable2 instanceof BitmapDrawable && scale == 1.0f) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int bitmapWidth = (int)((float)width * scale);
        int bitmapHeight = (int)((float)height * scale);
        RenderNode node = RenderNode.create("TransitionUtils", hostView);
        node.setLeftTopRightBottom(0, 0, width, height);
        node.setClipToBounds(false);
        DisplayListCanvas canvas = node.start(width, height);
        Rect existingBounds = drawable2.getBounds();
        int left = existingBounds.left;
        int top = existingBounds.top;
        int right = existingBounds.right;
        int bottom = existingBounds.bottom;
        drawable2.setBounds(0, 0, bitmapWidth, bitmapHeight);
        drawable2.draw(canvas);
        drawable2.setBounds(left, top, right, bottom);
        node.end(canvas);
        return ThreadedRenderer.createHardwareBitmap(node, width, height);
    }

    public static Bitmap createViewBitmap(View view, Matrix matrix, RectF bounds, ViewGroup sceneRoot) {
        boolean addToOverlay = !view.isAttachedToWindow();
        ViewGroup parent = null;
        int indexInParent = 0;
        if (addToOverlay) {
            if (sceneRoot == null || !sceneRoot.isAttachedToWindow()) {
                return null;
            }
            parent = (ViewGroup)view.getParent();
            indexInParent = parent.indexOfChild(view);
            sceneRoot.getOverlay().add(view);
        }
        Bitmap bitmap = null;
        int bitmapWidth = Math.round(bounds.width());
        int bitmapHeight = Math.round(bounds.height());
        if (bitmapWidth > 0 && bitmapHeight > 0) {
            float scale = Math.min(1.0f, (float)MAX_IMAGE_SIZE / (float)(bitmapWidth * bitmapHeight));
            bitmapWidth = (int)((float)bitmapWidth * scale);
            bitmapHeight = (int)((float)bitmapHeight * scale);
            matrix.postTranslate(-bounds.left, -bounds.top);
            matrix.postScale(scale, scale);
            RenderNode node = RenderNode.create("TransitionUtils", view);
            node.setLeftTopRightBottom(0, 0, bitmapWidth, bitmapHeight);
            node.setClipToBounds(false);
            DisplayListCanvas canvas = node.start(bitmapWidth, bitmapHeight);
            canvas.concat(matrix);
            view.draw(canvas);
            node.end(canvas);
            bitmap = ThreadedRenderer.createHardwareBitmap(node, bitmapWidth, bitmapHeight);
        }
        if (addToOverlay) {
            sceneRoot.getOverlay().remove(view);
            parent.addView(view, indexInParent);
        }
        return bitmap;
    }

    public static class MatrixEvaluator
    implements TypeEvaluator<Matrix> {
        float[] mTempStartValues = new float[9];
        float[] mTempEndValues = new float[9];
        Matrix mTempMatrix = new Matrix();

        @Override
        public Matrix evaluate(float fraction2, Matrix startValue, Matrix endValue) {
            startValue.getValues(this.mTempStartValues);
            endValue.getValues(this.mTempEndValues);
            for (int i = 0; i < 9; ++i) {
                float diff = this.mTempEndValues[i] - this.mTempStartValues[i];
                this.mTempEndValues[i] = this.mTempStartValues[i] + fraction2 * diff;
            }
            this.mTempMatrix.setValues(this.mTempEndValues);
            return this.mTempMatrix;
        }
    }
}

