/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.LayerDrawable;
import android.util.SparseArray;

public final class LauncherIcons {
    private static final float ICON_SIZE_BLUR_FACTOR = 0.010416667f;
    private static final float ICON_SIZE_KEY_SHADOW_DELTA_FACTOR = 0.020833334f;
    private static final int KEY_SHADOW_ALPHA = 61;
    private static final int AMBIENT_SHADOW_ALPHA = 30;
    private final SparseArray<Bitmap> mShadowCache = new SparseArray();
    private final int mIconSize;
    private final Resources mRes;

    public LauncherIcons(Context context) {
        this.mRes = context.getResources();
        this.mIconSize = this.mRes.getDimensionPixelSize(0x1050000);
    }

    public Drawable wrapIconDrawableWithShadow(Drawable drawable2) {
        if (!(drawable2 instanceof AdaptiveIconDrawable)) {
            return drawable2;
        }
        Bitmap shadow = this.getShadowBitmap((AdaptiveIconDrawable)drawable2);
        return new ShadowDrawable(shadow, drawable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getShadowBitmap(AdaptiveIconDrawable d) {
        int shadowSize = Math.max(this.mIconSize, d.getIntrinsicHeight());
        SparseArray<Bitmap> sparseArray = this.mShadowCache;
        synchronized (sparseArray) {
            Bitmap shadow = this.mShadowCache.get(shadowSize);
            if (shadow != null) {
                return shadow;
            }
        }
        d.setBounds(0, 0, shadowSize, shadowSize);
        float blur = 0.010416667f * (float)shadowSize;
        float keyShadowDistance = 0.020833334f * (float)shadowSize;
        int bitmapSize = (int)((float)shadowSize + 2.0f * blur + keyShadowDistance);
        Bitmap shadow = Bitmap.createBitmap(bitmapSize, bitmapSize, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(shadow);
        canvas.translate(blur + keyShadowDistance / 2.0f, blur);
        Paint paint = new Paint(1);
        paint.setColor(0);
        paint.setShadowLayer(blur, 0.0f, 0.0f, 0x1E000000);
        canvas.drawPath(d.getIconMask(), paint);
        canvas.translate(0.0f, keyShadowDistance);
        paint.setShadowLayer(blur, 0.0f, 0.0f, 0x3D000000);
        canvas.drawPath(d.getIconMask(), paint);
        canvas.setBitmap(null);
        SparseArray<Bitmap> sparseArray2 = this.mShadowCache;
        synchronized (sparseArray2) {
            this.mShadowCache.put(shadowSize, shadow);
        }
        return shadow;
    }

    public Drawable getBadgeDrawable(int foregroundRes, int backgroundColor) {
        return this.getBadgedDrawable(null, foregroundRes, backgroundColor);
    }

    public Drawable getBadgedDrawable(Drawable base, int foregroundRes, int backgroundColor) {
        Drawable[] drawableArray;
        Resources sysRes = Resources.getSystem();
        Drawable badgeShadow = sysRes.getDrawable(17302328);
        Drawable badgeColor = sysRes.getDrawable(17302327).getConstantState().newDrawable().mutate();
        badgeColor.setTint(backgroundColor);
        Drawable badgeForeground = sysRes.getDrawable(foregroundRes);
        if (base == null) {
            Drawable[] drawableArray2 = new Drawable[3];
            drawableArray2[0] = badgeShadow;
            drawableArray2[1] = badgeColor;
            drawableArray = drawableArray2;
            drawableArray2[2] = badgeForeground;
        } else {
            Drawable[] drawableArray3 = new Drawable[4];
            drawableArray3[0] = base;
            drawableArray3[1] = badgeShadow;
            drawableArray3[2] = badgeColor;
            drawableArray = drawableArray3;
            drawableArray3[3] = badgeForeground;
        }
        Drawable[] drawables = drawableArray;
        return new LayerDrawable(drawables);
    }

    private static class ShadowDrawable
    extends DrawableWrapper {
        final MyConstantState mState;

        public ShadowDrawable(Bitmap shadow, Drawable dr) {
            super(dr);
            this.mState = new MyConstantState(shadow, dr.getConstantState());
        }

        ShadowDrawable(MyConstantState state) {
            super(state.mChildState.newDrawable());
            this.mState = state;
        }

        @Override
        public Drawable.ConstantState getConstantState() {
            return this.mState;
        }

        @Override
        public void draw(Canvas canvas) {
            Rect bounds = this.getBounds();
            canvas.drawBitmap(this.mState.mShadow, null, bounds, this.mState.mPaint);
            canvas.save();
            float factor = 0.9599999f;
            canvas.translate((float)bounds.width() * factor * 0.020833334f, (float)bounds.height() * factor * 0.010416667f);
            canvas.scale(factor, factor);
            super.draw(canvas);
            canvas.restore();
        }

        private static class MyConstantState
        extends Drawable.ConstantState {
            final Paint mPaint = new Paint(2);
            final Bitmap mShadow;
            final Drawable.ConstantState mChildState;

            MyConstantState(Bitmap shadow, Drawable.ConstantState childState) {
                this.mShadow = shadow;
                this.mChildState = childState;
            }

            @Override
            public Drawable newDrawable() {
                return new ShadowDrawable(this);
            }

            @Override
            public int getChangingConfigurations() {
                return this.mChildState.getChangingConfigurations();
            }
        }
    }
}

