/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import libcore.util.EmptyArray;

public class LongArray
implements Cloneable {
    private static final int MIN_CAPACITY_INCREMENT = 12;
    private long[] mValues;
    private int mSize;

    private LongArray(long[] array2, int size) {
        this.mValues = array2;
        this.mSize = Preconditions.checkArgumentInRange(size, 0, array2.length, "size");
    }

    public LongArray() {
        this(10);
    }

    public LongArray(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.LONG : ArrayUtils.newUnpaddedLongArray(initialCapacity);
        this.mSize = 0;
    }

    public static LongArray wrap(long[] array2) {
        return new LongArray(array2, array2.length);
    }

    public static LongArray fromArray(long[] array2, int size) {
        return LongArray.wrap(Arrays.copyOf(array2, size));
    }

    public void resize(int newSize) {
        Preconditions.checkArgumentNonnegative(newSize);
        if (newSize <= this.mValues.length) {
            Arrays.fill(this.mValues, newSize, this.mValues.length, 0L);
        } else {
            this.ensureCapacity(newSize - this.mSize);
        }
        this.mSize = newSize;
    }

    public void add(long value) {
        this.add(this.mSize, value);
    }

    public void add(int index, long value) {
        this.ensureCapacity(1);
        int rightSegment = this.mSize - index;
        ++this.mSize;
        this.checkBounds(index);
        if (rightSegment != 0) {
            System.arraycopy((long[])this.mValues, (int)index, (long[])this.mValues, (int)(index + 1), (int)rightSegment);
        }
        this.mValues[index] = value;
    }

    public void addAll(LongArray values) {
        int count = values.mSize;
        this.ensureCapacity(count);
        System.arraycopy((long[])values.mValues, (int)0, (long[])this.mValues, (int)this.mSize, (int)count);
        this.mSize += count;
    }

    private void ensureCapacity(int count) {
        int currentSize = this.mSize;
        int minCapacity = currentSize + count;
        if (minCapacity >= this.mValues.length) {
            int targetCap = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
            int newCapacity = targetCap > minCapacity ? targetCap : minCapacity;
            long[] newValues = ArrayUtils.newUnpaddedLongArray(newCapacity);
            System.arraycopy((long[])this.mValues, (int)0, (long[])newValues, (int)0, (int)currentSize);
            this.mValues = newValues;
        }
    }

    public void clear() {
        this.mSize = 0;
    }

    public LongArray clone() {
        LongArray clone = null;
        try {
            clone = (LongArray)super.clone();
            clone.mValues = (long[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public long get(int index) {
        this.checkBounds(index);
        return this.mValues[index];
    }

    public void set(int index, long value) {
        this.checkBounds(index);
        this.mValues[index] = value;
    }

    public int indexOf(long value) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void remove(int index) {
        this.checkBounds(index);
        System.arraycopy((long[])this.mValues, (int)(index + 1), (long[])this.mValues, (int)index, (int)(this.mSize - index - 1));
        --this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public long[] toArray() {
        return Arrays.copyOf(this.mValues, this.mSize);
    }

    private void checkBounds(int index) {
        if (index < 0 || this.mSize <= index) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, index);
        }
    }
}

