/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import libcore.io.IoUtils;

public final class MemoryIntArray
implements Parcelable,
Closeable {
    private static final String TAG = "MemoryIntArray";
    private static final boolean DEBUG = Process.myUid() < 10000;
    private static final int MAX_SIZE = 1024;
    private final Object mLock = new Object();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final boolean mIsOwner;
    private final long mMemoryAddr;
    @GuardedBy(value="mLock")
    private int mFd = -1;
    public static final Parcelable.Creator<MemoryIntArray> CREATOR = new Parcelable.Creator<MemoryIntArray>(){

        @Override
        public MemoryIntArray createFromParcel(Parcel parcel) {
            try {
                return new MemoryIntArray(parcel);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Error unparceling MemoryIntArray");
            }
        }

        public MemoryIntArray[] newArray(int size) {
            return new MemoryIntArray[size];
        }
    };

    public MemoryIntArray(int size) throws IOException {
        if (size > 1024) {
            throw new IllegalArgumentException("Max size is 1024");
        }
        this.mIsOwner = true;
        String name = UUID.randomUUID().toString();
        this.mFd = this.nativeCreate(name, size);
        this.mMemoryAddr = this.nativeOpen(this.mFd, this.mIsOwner);
        this.mCloseGuard.open("close");
        if (DEBUG) {
            Log.i(TAG, "created " + this.getString());
        }
    }

    private MemoryIntArray(Parcel parcel) throws IOException {
        this.mIsOwner = false;
        ParcelFileDescriptor pfd = (ParcelFileDescriptor)parcel.readParcelable(null);
        if (pfd == null) {
            throw new IOException("No backing file descriptor");
        }
        this.mFd = pfd.detachFd();
        this.mMemoryAddr = this.nativeOpen(this.mFd, this.mIsOwner);
        this.mCloseGuard.open("close");
        if (DEBUG) {
            Log.i(TAG, "created from parcel " + this.getString());
        }
    }

    public boolean isWritable() {
        this.enforceNotClosed();
        return this.mIsOwner;
    }

    public int get(int index) throws IOException {
        this.enforceNotClosed();
        this.enforceValidIndex(index);
        return this.nativeGet(this.mFd, this.mMemoryAddr, index);
    }

    public void set(int index, int value) throws IOException {
        this.enforceNotClosed();
        this.enforceWritable();
        this.enforceValidIndex(index);
        this.nativeSet(this.mFd, this.mMemoryAddr, index, value);
    }

    public int size() throws IOException {
        this.enforceNotClosed();
        return this.nativeSize(this.mFd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            block10: {
                if (!this.isClosed()) {
                    if (DEBUG) {
                        try {
                            throw new Exception();
                        }
                        catch (Exception here) {
                            Log.i(TAG, "closing " + this.getString(), here);
                        }
                    }
                    this.nativeClose(this.mFd, this.mMemoryAddr, this.mIsOwner);
                    this.mFd = -1;
                    this.mCloseGuard.close();
                } else {
                    try {
                        throw new Exception();
                    }
                    catch (Exception here) {
                        if (!DEBUG) break block10;
                        Log.i(TAG, this.getString() + " already closed", here);
                    }
                }
            }
        }
    }

    private String getString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " mMemoryAddr=" + this.mMemoryAddr + " mFd=" + this.mFd;
    }

    public boolean isClosed() {
        return this.mFd == -1;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.isClosed()) {
                IoUtils.closeQuietly(this);
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public int describeContents() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        ParcelFileDescriptor pfd = ParcelFileDescriptor.adoptFd(this.mFd);
        try {
            parcel.writeParcelable(pfd, flags & 0xFFFFFFFE);
        }
        finally {
            pfd.detachFd();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryIntArray other = (MemoryIntArray)obj;
        return this.mFd == other.mFd;
    }

    public int hashCode() {
        return this.mFd;
    }

    private void enforceNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cannot interact with a closed instance " + this.getString());
        }
    }

    private void enforceValidIndex(int index) throws IOException {
        int size = this.size();
        if (index < 0 || index > size - 1) {
            throw new IndexOutOfBoundsException(index + " not between 0 and " + (size - 1));
        }
    }

    private void enforceWritable() {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException("array is not writable");
        }
    }

    private native int nativeCreate(String var1, int var2);

    private native long nativeOpen(int var1, boolean var2);

    private native void nativeClose(int var1, long var2, boolean var4);

    private native int nativeGet(int var1, long var2, int var4);

    private native void nativeSet(int var1, long var2, int var4, int var5);

    private native int nativeSize(int var1);

    public static int getMaxSize() {
        return 1024;
    }
}

