/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.IBinder;
import android.os.IStatsManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;

public class StatsManager {
    IStatsManager mService;
    private static final String TAG = "StatsManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConfiguration(String configKey, byte[] config, String pkg, String cls) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when adding configuration");
                    return false;
                }
                return service.addConfiguration(Long.parseLong(configKey), config, pkg, cls);
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connect to statsd when adding configuration");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConfiguration(long configKey, byte[] config, String pkg, String cls) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when adding configuration");
                    return false;
                }
                return service.addConfiguration(configKey, config, pkg, cls);
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connect to statsd when adding configuration");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfiguration(String configKey) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when removing configuration");
                    return false;
                }
                return service.removeConfiguration(Long.parseLong(configKey));
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connect to statsd when removing configuration");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfiguration(long configKey) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when removing configuration");
                    return false;
                }
                return service.removeConfiguration(configKey);
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connect to statsd when removing configuration");
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String configKey) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when getting data");
                    return null;
                }
                return service.getData(Long.parseLong(configKey));
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connecto statsd when getting data");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(long configKey) {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when getting data");
                    return null;
                }
                return service.getData(configKey);
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connecto statsd when getting data");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMetadata() {
        StatsManager statsManager = this;
        synchronized (statsManager) {
            try {
                IStatsManager service = this.getIStatsManagerLocked();
                if (service == null) {
                    Slog.d(TAG, "Failed to find statsd when getting metadata");
                    return null;
                }
                return service.getMetadata();
            }
            catch (RemoteException e) {
                Slog.d(TAG, "Failed to connecto statsd when getting metadata");
                return null;
            }
        }
    }

    private IStatsManager getIStatsManagerLocked() throws RemoteException {
        if (this.mService != null) {
            return this.mService;
        }
        this.mService = IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
        if (this.mService != null) {
            this.mService.asBinder().linkToDeath(new StatsdDeathRecipient(), 0);
        }
        return this.mService;
    }

    private class StatsdDeathRecipient
    implements IBinder.DeathRecipient {
        private StatsdDeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            StatsdDeathRecipient statsdDeathRecipient = this;
            synchronized (statsdDeathRecipient) {
                StatsManager.this.mService = null;
            }
        }
    }
}

