/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.PathParser;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;

public final class DisplayCutout {
    private static final String TAG = "DisplayCutout";
    private static final String DP_MARKER = "@dp";
    private static final Rect ZERO_RECT = new Rect();
    private static final Region EMPTY_REGION = new Region();
    public static final DisplayCutout NO_CUTOUT = new DisplayCutout(ZERO_RECT, EMPTY_REGION);
    private final Rect mSafeInsets;
    private final Region mBounds;

    @VisibleForTesting
    public DisplayCutout(Rect safeInsets, Region bounds) {
        this.mSafeInsets = safeInsets != null ? safeInsets : ZERO_RECT;
        this.mBounds = bounds != null ? bounds : Region.obtain();
    }

    public boolean isEmpty() {
        return this.mSafeInsets.equals(ZERO_RECT);
    }

    public int getSafeInsetTop() {
        return this.mSafeInsets.top;
    }

    public int getSafeInsetBottom() {
        return this.mSafeInsets.bottom;
    }

    public int getSafeInsetLeft() {
        return this.mSafeInsets.left;
    }

    public int getSafeInsetRight() {
        return this.mSafeInsets.right;
    }

    public Rect getSafeInsets() {
        return new Rect(this.mSafeInsets);
    }

    public Region getBounds() {
        return Region.obtain(this.mBounds);
    }

    public Rect getBoundingRect() {
        return this.mBounds.getBounds();
    }

    public int hashCode() {
        int result = this.mSafeInsets.hashCode();
        result = result * 31 + this.mBounds.getBounds().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayCutout) {
            DisplayCutout c = (DisplayCutout)o;
            return this.mSafeInsets.equals(c.mSafeInsets) && this.mBounds.equals(c.mBounds);
        }
        return false;
    }

    public String toString() {
        return "DisplayCutout{insets=" + this.mSafeInsets + " boundingRect=" + this.getBoundingRect() + "}";
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mSafeInsets.writeToProto(proto, 0x10B00000001L);
        this.mBounds.getBounds().writeToProto(proto, 1146756268034L);
        proto.end(token);
    }

    public DisplayCutout inset(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        if (this.mBounds.isEmpty() || insetLeft == 0 && insetTop == 0 && insetRight == 0 && insetBottom == 0) {
            return this;
        }
        Rect safeInsets = new Rect(this.mSafeInsets);
        Region bounds = Region.obtain(this.mBounds);
        if (insetTop > 0 || safeInsets.top > 0) {
            safeInsets.top = DisplayCutout.atLeastZero(safeInsets.top - insetTop);
        }
        if (insetBottom > 0 || safeInsets.bottom > 0) {
            safeInsets.bottom = DisplayCutout.atLeastZero(safeInsets.bottom - insetBottom);
        }
        if (insetLeft > 0 || safeInsets.left > 0) {
            safeInsets.left = DisplayCutout.atLeastZero(safeInsets.left - insetLeft);
        }
        if (insetRight > 0 || safeInsets.right > 0) {
            safeInsets.right = DisplayCutout.atLeastZero(safeInsets.right - insetRight);
        }
        bounds.translate(-insetLeft, -insetTop);
        return new DisplayCutout(safeInsets, bounds);
    }

    public DisplayCutout calculateRelativeTo(Rect frame) {
        if (this.mBounds.isEmpty() || !Rect.intersects(frame, this.mBounds.getBounds())) {
            return NO_CUTOUT;
        }
        return DisplayCutout.calculateRelativeTo(frame, Region.obtain(this.mBounds));
    }

    private static DisplayCutout calculateRelativeTo(Rect frame, Region bounds) {
        Rect boundingRect = bounds.getBounds();
        Rect safeRect = new Rect();
        int bestArea = 0;
        int bestVariant = 0;
        for (int variant = 0; variant <= 3; ++variant) {
            int area = DisplayCutout.calculateInsetVariantArea(frame, boundingRect, variant, safeRect);
            if (bestArea >= area) continue;
            bestArea = area;
            bestVariant = variant;
        }
        DisplayCutout.calculateInsetVariantArea(frame, boundingRect, bestVariant, safeRect);
        if (safeRect.isEmpty()) {
            safeRect.set(0, frame.height(), 0, 0);
        } else {
            safeRect.set(Math.max(0, safeRect.left - frame.left), Math.max(0, safeRect.top - frame.top), Math.max(0, frame.right - safeRect.right), Math.max(0, frame.bottom - safeRect.bottom));
        }
        bounds.translate(-frame.left, -frame.top);
        return new DisplayCutout(safeRect, bounds);
    }

    private static int calculateInsetVariantArea(Rect frame, Rect boundingRect, int variant, Rect outSafeRect) {
        switch (variant) {
            case 0: {
                outSafeRect.set(frame.left, frame.top, frame.right, boundingRect.top);
                break;
            }
            case 1: {
                outSafeRect.set(frame.left, frame.top, boundingRect.left, frame.bottom);
                break;
            }
            case 2: {
                outSafeRect.set(frame.left, boundingRect.bottom, frame.right, frame.bottom);
                break;
            }
            case 3: {
                outSafeRect.set(boundingRect.right, frame.top, frame.right, frame.bottom);
            }
        }
        return outSafeRect.isEmpty() ? 0 : outSafeRect.width() * outSafeRect.height();
    }

    private static int atLeastZero(int value) {
        return value < 0 ? 0 : value;
    }

    public static DisplayCutout fromBoundingPolygon(List<Point> points) {
        Path path = new Path();
        path.reset();
        for (int i = 0; i < points.size(); ++i) {
            Point point = points.get(i);
            if (i == 0) {
                path.moveTo(point.x, point.y);
                continue;
            }
            path.lineTo(point.x, point.y);
        }
        path.close();
        return DisplayCutout.fromBounds(path);
    }

    public static DisplayCutout fromBounds(Path path) {
        RectF clipRect = new RectF();
        path.computeBounds(clipRect, false);
        Region clipRegion = Region.obtain();
        clipRegion.set((int)clipRect.left, (int)clipRect.top, (int)clipRect.right, (int)clipRect.bottom);
        Region bounds = new Region();
        bounds.setPath(path, clipRegion);
        clipRegion.recycle();
        return new DisplayCutout(ZERO_RECT, bounds);
    }

    public static DisplayCutout fromResources(Resources res, int displayWidth) {
        Path p;
        String spec = res.getString(17039688);
        if (TextUtils.isEmpty(spec)) {
            return null;
        }
        boolean inDp = (spec = spec.trim()).endsWith(DP_MARKER);
        if (inDp) {
            spec = spec.substring(0, spec.length() - DP_MARKER.length());
        }
        try {
            p = PathParser.createPathFromPathData(spec);
        }
        catch (Throwable e) {
            Log.wtf(TAG, "Could not inflate cutout: ", e);
            return null;
        }
        Matrix m = new Matrix();
        if (inDp) {
            float dpToPx = res.getDisplayMetrics().density;
            m.postScale(dpToPx, dpToPx);
        }
        m.postTranslate((float)displayWidth / 2.0f, 0.0f);
        p.transform(m);
        return DisplayCutout.fromBounds(p);
    }

    public static final class ParcelableWrapper
    implements Parcelable {
        private DisplayCutout mInner;
        public static final Parcelable.Creator<ParcelableWrapper> CREATOR = new Parcelable.Creator<ParcelableWrapper>(){

            @Override
            public ParcelableWrapper createFromParcel(Parcel in) {
                return new ParcelableWrapper(ParcelableWrapper.readCutoutFromParcel(in));
            }

            public ParcelableWrapper[] newArray(int size) {
                return new ParcelableWrapper[size];
            }
        };

        public ParcelableWrapper() {
            this(NO_CUTOUT);
        }

        public ParcelableWrapper(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            ParcelableWrapper.writeCutoutToParcel(this.mInner, out, flags);
        }

        public static void writeCutoutToParcel(DisplayCutout cutout, Parcel out, int flags) {
            if (cutout == null) {
                out.writeInt(-1);
            } else if (cutout == NO_CUTOUT) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeTypedObject(cutout.mSafeInsets, flags);
                out.writeTypedObject(cutout.mBounds, flags);
            }
        }

        public void readFromParcel(Parcel in) {
            this.mInner = ParcelableWrapper.readCutoutFromParcel(in);
        }

        public static DisplayCutout readCutoutFromParcel(Parcel in) {
            int variant = in.readInt();
            if (variant == -1) {
                return null;
            }
            if (variant == 0) {
                return NO_CUTOUT;
            }
            Rect safeInsets = in.readTypedObject(Rect.CREATOR);
            Region bounds = in.readTypedObject(Region.CREATOR);
            return new DisplayCutout(safeInsets, bounds);
        }

        public DisplayCutout get() {
            return this.mInner;
        }

        public void set(ParcelableWrapper cutout) {
            this.mInner = cutout.get();
        }

        public void set(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        public int hashCode() {
            return this.mInner.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ParcelableWrapper && this.mInner.equals(((ParcelableWrapper)o).mInner);
        }

        public String toString() {
            return String.valueOf(this.mInner);
        }
    }
}

