/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.util.Pools;
import android.view.HardwareLayer;
import android.view.RecordingCanvas;
import android.view.RenderNode;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;

public final class DisplayListCanvas
extends RecordingCanvas {
    private static final int POOL_LIMIT = 25;
    private static final int MAX_BITMAP_SIZE = 0x6400000;
    private static final Pools.SynchronizedPool<DisplayListCanvas> sPool = new Pools.SynchronizedPool(25);
    RenderNode mNode;
    private int mWidth;
    private int mHeight;

    static DisplayListCanvas obtain(RenderNode node, int width, int height) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        DisplayListCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new DisplayListCanvas(node, width, height);
        } else {
            DisplayListCanvas.nResetDisplayListCanvas(canvas.mNativeCanvasWrapper, node.mNativeRenderNode, width, height);
        }
        canvas.mNode = node;
        canvas.mWidth = width;
        canvas.mHeight = height;
        return canvas;
    }

    void recycle() {
        this.mNode = null;
        sPool.release(this);
    }

    long finishRecording() {
        return DisplayListCanvas.nFinishRecording(this.mNativeCanvasWrapper);
    }

    @Override
    public boolean isRecordingFor(Object o) {
        return o == this.mNode;
    }

    private DisplayListCanvas(RenderNode node, int width, int height) {
        super(DisplayListCanvas.nCreateDisplayListCanvas(node.mNativeRenderNode, width, height));
        this.mDensity = 0;
    }

    @Override
    public void setDensity(int density) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return DisplayListCanvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return DisplayListCanvas.nGetMaximumTextureHeight();
    }

    @Override
    public void insertReorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, true);
    }

    @Override
    public void insertInorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, false);
    }

    public void callDrawGLFunction2(long drawGLFunction) {
        DisplayListCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunction, null);
    }

    public void drawGLFunctor2(long drawGLFunctor, Runnable releasedCallback) {
        DisplayListCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunctor, releasedCallback);
    }

    public void drawRenderNode(RenderNode renderNode) {
        DisplayListCanvas.nDrawRenderNode(this.mNativeCanvasWrapper, renderNode.getNativeDisplayList());
    }

    void drawHardwareLayer(HardwareLayer layer) {
        DisplayListCanvas.nDrawLayer(this.mNativeCanvasWrapper, layer.getLayerHandle());
    }

    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    @Override
    protected void throwIfCannotDraw(Bitmap bitmap) {
        super.throwIfCannotDraw(bitmap);
        int bitmapSize = bitmap.getByteCount();
        if (bitmapSize > 0x6400000) {
            throw new RuntimeException("Canvas: trying to draw too large(" + bitmapSize + "bytes) bitmap.");
        }
    }

    @FastNative
    private static native void nCallDrawGLFunction(long var0, long var2, Runnable var4);

    @CriticalNative
    private static native long nCreateDisplayListCanvas(long var0, int var2, int var3);

    @CriticalNative
    private static native void nResetDisplayListCanvas(long var0, long var2, int var4, int var5);

    @CriticalNative
    private static native int nGetMaximumTextureWidth();

    @CriticalNative
    private static native int nGetMaximumTextureHeight();

    @CriticalNative
    private static native void nInsertReorderBarrier(long var0, boolean var2);

    @CriticalNative
    private static native long nFinishRecording(long var0);

    @CriticalNative
    private static native void nDrawRenderNode(long var0, long var2);

    @CriticalNative
    private static native void nDrawLayer(long var0, long var2);

    @CriticalNative
    private static native void nDrawCircle(long var0, long var2, long var4, long var6, long var8);

    @CriticalNative
    private static native void nDrawRoundRect(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);
}

