/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.CachingIconView;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class NotificationHeaderView
extends ViewGroup {
    public static final int NO_COLOR = 1;
    private final int mChildMinWidth;
    private final int mContentEndMargin;
    private final int mGravity;
    private View mAppName;
    private View mHeaderText;
    private View mSecondaryHeaderText;
    private View.OnClickListener mExpandClickListener;
    private HeaderTouchListener mTouchListener = new HeaderTouchListener();
    private ImageView mExpandButton;
    private CachingIconView mIcon;
    private View mProfileBadge;
    private int mIconColor;
    private int mOriginalNotificationColor;
    private boolean mExpanded;
    private boolean mShowExpandButtonAtEnd;
    private boolean mShowWorkBadgeAtEnd;
    private Drawable mBackground;
    private boolean mEntireHeaderClickable;
    private boolean mExpandOnlyOnButton;
    private boolean mAcceptAllTouches;
    private int mTotalWidth;
    ViewOutlineProvider mProvider = new ViewOutlineProvider(){

        @Override
        public void getOutline(View view, Outline outline) {
            if (NotificationHeaderView.this.mBackground != null) {
                outline.setRect(0, 0, NotificationHeaderView.this.getWidth(), NotificationHeaderView.this.getHeight());
                outline.setAlpha(1.0f);
            }
        }
    };

    public NotificationHeaderView(Context context) {
        this(context, null);
    }

    public NotificationHeaderView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NotificationHeaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationHeaderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = this.getResources();
        this.mChildMinWidth = res.getDimensionPixelSize(17105205);
        this.mContentEndMargin = res.getDimensionPixelSize(17105183);
        this.mEntireHeaderClickable = res.getBoolean(17956993);
        int[] attrIds = new int[]{16842927};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrIds, defStyleAttr, defStyleRes);
        this.mGravity = ta.getInt(0, 0);
        ta.recycle();
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mAppName = this.findViewById(16908719);
        this.mHeaderText = this.findViewById(16908933);
        this.mSecondaryHeaderText = this.findViewById(16908935);
        this.mExpandButton = (ImageView)this.findViewById(16908857);
        this.mIcon = (CachingIconView)this.findViewById(16908294);
        this.mProfileBadge = this.findViewById(16909193);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int givenWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int givenHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int wrapContentWidthSpec = View.MeasureSpec.makeMeasureSpec(givenWidth, Integer.MIN_VALUE);
        int wrapContentHeightSpec = View.MeasureSpec.makeMeasureSpec(givenHeight, Integer.MIN_VALUE);
        int totalWidth = this.getPaddingStart() + this.getPaddingEnd();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidthSpec = NotificationHeaderView.getChildMeasureSpec(wrapContentWidthSpec, lp.leftMargin + lp.rightMargin, lp.width);
            int childHeightSpec = NotificationHeaderView.getChildMeasureSpec(wrapContentHeightSpec, lp.topMargin + lp.bottomMargin, lp.height);
            child.measure(childWidthSpec, childHeightSpec);
            totalWidth += lp.leftMargin + lp.rightMargin + child.getMeasuredWidth();
        }
        if (totalWidth > givenWidth) {
            int overFlow = totalWidth - givenWidth;
            overFlow = this.shrinkViewForOverflow(wrapContentHeightSpec, overFlow, this.mAppName, this.mChildMinWidth);
            overFlow = this.shrinkViewForOverflow(wrapContentHeightSpec, overFlow, this.mHeaderText, 0);
            this.shrinkViewForOverflow(wrapContentHeightSpec, overFlow, this.mSecondaryHeaderText, 0);
        }
        this.mTotalWidth = Math.min(totalWidth, givenWidth);
        this.setMeasuredDimension(givenWidth, givenHeight);
    }

    private int shrinkViewForOverflow(int heightSpec, int overFlow, View targetView, int minimumWidth) {
        int oldWidth = targetView.getMeasuredWidth();
        if (overFlow > 0 && targetView.getVisibility() != 8 && oldWidth > minimumWidth) {
            int newSize = Math.max(minimumWidth, oldWidth - overFlow);
            int childWidthSpec = View.MeasureSpec.makeMeasureSpec(newSize, Integer.MIN_VALUE);
            targetView.measure(childWidthSpec, heightSpec);
            overFlow -= oldWidth - newSize;
        }
        return overFlow;
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        boolean centerAligned;
        int left = this.getPaddingStart();
        int end = this.getMeasuredWidth();
        boolean bl = centerAligned = (this.mGravity & 1) != 0;
        if (centerAligned) {
            left += this.getMeasuredWidth() / 2 - this.mTotalWidth / 2;
        }
        int childCount = this.getChildCount();
        int ownHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childHeight = child.getMeasuredHeight();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int right = (left += params.getMarginStart()) + child.getMeasuredWidth();
            int top = (int)((float)this.getPaddingTop() + (float)(ownHeight - childHeight) / 2.0f);
            int bottom = top + childHeight;
            int layoutLeft = left;
            int layoutRight = right;
            if (child == this.mExpandButton && this.mShowExpandButtonAtEnd) {
                layoutRight = end - this.mContentEndMargin;
                end = layoutLeft = layoutRight - child.getMeasuredWidth();
            }
            if (child == this.mProfileBadge) {
                int paddingEnd = this.getPaddingEnd();
                if (this.mShowWorkBadgeAtEnd) {
                    paddingEnd = this.mContentEndMargin;
                }
                layoutRight = end - paddingEnd;
                end = layoutLeft = layoutRight - child.getMeasuredWidth();
            }
            if (this.getLayoutDirection() == 1) {
                int ltrLeft = layoutLeft;
                layoutLeft = this.getWidth() - layoutRight;
                layoutRight = this.getWidth() - ltrLeft;
            }
            child.layout(layoutLeft, top, layoutRight, bottom);
            left = right + params.getMarginEnd();
        }
        this.updateTouchListener();
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    public void setHeaderBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.setWillNotDraw(false);
            this.mBackground = drawable2;
            this.mBackground.setCallback(this);
            this.setOutlineProvider(this.mProvider);
        } else {
            this.setWillNotDraw(true);
            this.mBackground = null;
            this.setOutlineProvider(null);
        }
        this.invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mBackground != null) {
            this.mBackground.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.mBackground.draw(canvas);
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mBackground;
    }

    @Override
    protected void drawableStateChanged() {
        if (this.mBackground != null && this.mBackground.isStateful()) {
            this.mBackground.setState(this.getDrawableState());
        }
    }

    private void updateTouchListener() {
        if (this.mExpandClickListener != null) {
            this.mTouchListener.bindTouchRects();
        }
    }

    @Override
    public void setOnClickListener(View.OnClickListener l) {
        this.mExpandClickListener = l;
        this.setOnTouchListener(this.mExpandClickListener != null ? this.mTouchListener : null);
        this.mExpandButton.setOnClickListener(this.mExpandClickListener);
        this.updateTouchListener();
    }

    @RemotableViewMethod
    public void setOriginalIconColor(int color2) {
        this.mIconColor = color2;
    }

    public int getOriginalIconColor() {
        return this.mIconColor;
    }

    @RemotableViewMethod
    public void setOriginalNotificationColor(int color2) {
        this.mOriginalNotificationColor = color2;
    }

    public int getOriginalNotificationColor() {
        return this.mOriginalNotificationColor;
    }

    @RemotableViewMethod
    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
        this.updateExpandButton();
    }

    private void updateExpandButton() {
        int contentDescriptionId;
        int drawableId;
        if (this.mExpanded) {
            drawableId = 17302307;
            contentDescriptionId = 17039835;
        } else {
            drawableId = 17302363;
            contentDescriptionId = 17039834;
        }
        this.mExpandButton.setImageDrawable(this.getContext().getDrawable(drawableId));
        this.mExpandButton.setColorFilter(this.mOriginalNotificationColor);
        this.mExpandButton.setContentDescription(this.mContext.getText(contentDescriptionId));
    }

    public void setShowWorkBadgeAtEnd(boolean showWorkBadgeAtEnd) {
        if (showWorkBadgeAtEnd != this.mShowWorkBadgeAtEnd) {
            this.setClipToPadding(!showWorkBadgeAtEnd);
            this.mShowWorkBadgeAtEnd = showWorkBadgeAtEnd;
        }
    }

    public void setShowExpandButtonAtEnd(boolean showExpandButtonAtEnd) {
        if (showExpandButtonAtEnd != this.mShowExpandButtonAtEnd) {
            this.setClipToPadding(!showExpandButtonAtEnd);
            this.mShowExpandButtonAtEnd = showExpandButtonAtEnd;
        }
    }

    public View getWorkProfileIcon() {
        return this.mProfileBadge;
    }

    public CachingIconView getIcon() {
        return this.mIcon;
    }

    private View getFirstChildNotGone() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            return child;
        }
        return this;
    }

    public ImageView getExpandButton() {
        return this.mExpandButton;
    }

    @Override
    public boolean hasOverlappingRendering() {
        return false;
    }

    public boolean isInTouchRect(float x, float y) {
        if (this.mExpandClickListener == null) {
            return false;
        }
        return this.mTouchListener.isInside(x, y);
    }

    @RemotableViewMethod
    public void setAcceptAllTouches(boolean acceptAllTouches) {
        this.mAcceptAllTouches = this.mEntireHeaderClickable || acceptAllTouches;
    }

    @RemotableViewMethod
    public void setExpandOnlyOnButton(boolean expandOnlyOnButton) {
        this.mExpandOnlyOnButton = expandOnlyOnButton;
    }

    public class HeaderTouchListener
    implements View.OnTouchListener {
        private final ArrayList<Rect> mTouchRects = new ArrayList();
        private Rect mExpandButtonRect;
        private int mTouchSlop;
        private boolean mTrackGesture;
        private float mDownX;
        private float mDownY;

        public void bindTouchRects() {
            this.mTouchRects.clear();
            this.addRectAroundView(NotificationHeaderView.this.mIcon);
            this.mExpandButtonRect = this.addRectAroundView(NotificationHeaderView.this.mExpandButton);
            this.addWidthRect();
            this.mTouchSlop = ViewConfiguration.get(NotificationHeaderView.this.getContext()).getScaledTouchSlop();
        }

        private void addWidthRect() {
            Rect r = new Rect();
            r.top = 0;
            r.bottom = (int)(32.0f * NotificationHeaderView.this.getResources().getDisplayMetrics().density);
            r.left = 0;
            r.right = NotificationHeaderView.this.getWidth();
            this.mTouchRects.add(r);
        }

        private Rect addRectAroundView(View view) {
            Rect r = this.getRectAroundView(view);
            this.mTouchRects.add(r);
            return r;
        }

        private Rect getRectAroundView(View view) {
            float size = 48.0f * NotificationHeaderView.this.getResources().getDisplayMetrics().density;
            Rect r = new Rect();
            if (view.getVisibility() == 8) {
                view = NotificationHeaderView.this.getFirstChildNotGone();
                r.left = (int)((float)view.getLeft() - size / 2.0f);
            } else {
                r.left = (int)((float)(view.getLeft() + view.getRight()) / 2.0f - size / 2.0f);
            }
            r.top = (int)((float)(view.getTop() + view.getBottom()) / 2.0f - size / 2.0f);
            r.bottom = (int)((float)r.top + size);
            r.right = (int)((float)r.left + size);
            return r;
        }

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getActionMasked() & 0xFF) {
                case 0: {
                    this.mTrackGesture = false;
                    if (!this.isInside(x, y)) break;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mTrackGesture = true;
                    return true;
                }
                case 2: {
                    if (!this.mTrackGesture || !(Math.abs(this.mDownX - x) > (float)this.mTouchSlop) && !(Math.abs(this.mDownY - y) > (float)this.mTouchSlop)) break;
                    this.mTrackGesture = false;
                    break;
                }
                case 1: {
                    if (!this.mTrackGesture) break;
                    NotificationHeaderView.this.mExpandButton.performClick();
                }
            }
            return this.mTrackGesture;
        }

        private boolean isInside(float x, float y) {
            if (NotificationHeaderView.this.mAcceptAllTouches) {
                return true;
            }
            if (NotificationHeaderView.this.mExpandOnlyOnButton) {
                return this.mExpandButtonRect.contains((int)x, (int)y);
            }
            for (int i = 0; i < this.mTouchRects.size(); ++i) {
                Rect r = this.mTouchRects.get(i);
                if (!r.contains((int)x, (int)y)) continue;
                return true;
            }
            return false;
        }
    }
}

