/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.MeasuredText;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import dalvik.annotation.optimization.FastNative;

public class RecordingCanvas
extends Canvas {
    public RecordingCanvas(long nativeCanvas) {
        super(nativeCanvas);
    }

    @Override
    public final void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        RecordingCanvas.nDrawArc(this.mNativeCanvasWrapper, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.getNativeInstance());
    }

    @Override
    public final void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.drawArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public final void drawARGB(int a, int r, int g, int b) {
        this.drawColor(Color.argb(a, r, g, b));
    }

    @Override
    public final void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.throwIfCannotDraw(bitmap);
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, paint != null ? paint.getNativeInstance() : 0L, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    @Override
    public final void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        RecordingCanvas.nDrawBitmapMatrix(this.mNativeCanvasWrapper, bitmap, matrix.ni(), paint != null ? paint.getNativeInstance() : 0L);
    }

    @Override
    public final void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Override
    public final void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Override
    @Deprecated
    public final void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        RecordingCanvas.nDrawBitmap(this.mNativeCanvasWrapper, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.getNativeInstance() : 0L);
    }

    @Override
    @Deprecated
    public final void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    @Override
    public final void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        RecordingCanvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            RecordingCanvas.checkRange(colors.length, colorOffset, count);
        }
        RecordingCanvas.nDrawBitmapMesh(this.mNativeCanvasWrapper, bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.getNativeInstance() : 0L);
    }

    @Override
    public final void drawCircle(float cx, float cy, float radius, Paint paint) {
        RecordingCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx, cy, radius, paint.getNativeInstance());
    }

    @Override
    public final void drawColor(int color2) {
        RecordingCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @Override
    public final void drawColor(int color2, PorterDuff.Mode mode) {
        RecordingCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, mode.nativeInt);
    }

    @Override
    public final void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        RecordingCanvas.nDrawLine(this.mNativeCanvasWrapper, startX, startY, stopX, stopY, paint.getNativeInstance());
    }

    @Override
    public final void drawLines(float[] pts, int offset, int count, Paint paint) {
        RecordingCanvas.nDrawLines(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    @Override
    public final void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    @Override
    public final void drawOval(float left, float top, float right, float bottom, Paint paint) {
        RecordingCanvas.nDrawOval(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    @Override
    public final void drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        this.drawOval(oval.left, oval.top, oval.right, oval.bottom, paint);
    }

    @Override
    public final void drawPaint(Paint paint) {
        RecordingCanvas.nDrawPaint(this.mNativeCanvasWrapper, paint.getNativeInstance());
    }

    @Override
    public final void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        RecordingCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    @Override
    public final void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        RecordingCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    @Override
    public final void drawPath(Path path, Paint paint) {
        if (path.isSimplePath && path.rects != null) {
            RecordingCanvas.nDrawRegion(this.mNativeCanvasWrapper, path.rects.mNativeRegion, paint.getNativeInstance());
        } else {
            RecordingCanvas.nDrawPath(this.mNativeCanvasWrapper, path.readOnlyNI(), paint.getNativeInstance());
        }
    }

    @Override
    public final void drawPicture(Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    @Override
    public final void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    @Override
    public final void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    @Override
    public final void drawPoint(float x, float y, Paint paint) {
        RecordingCanvas.nDrawPoint(this.mNativeCanvasWrapper, x, y, paint.getNativeInstance());
    }

    @Override
    public final void drawPoints(float[] pts, int offset, int count, Paint paint) {
        RecordingCanvas.nDrawPoints(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    @Override
    public final void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @Override
    @Deprecated
    public final void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < count; ++i) {
            this.drawText(text, index + i, 1, pos[i * 2], pos[i * 2 + 1], paint);
        }
    }

    @Override
    @Deprecated
    public final void drawPosText(String text, float[] pos, Paint paint) {
        this.drawPosText(text.toCharArray(), 0, text.length(), pos, paint);
    }

    @Override
    public final void drawRect(float left, float top, float right, float bottom, Paint paint) {
        RecordingCanvas.nDrawRect(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    @Override
    public final void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public final void drawRect(RectF rect, Paint paint) {
        RecordingCanvas.nDrawRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, paint.getNativeInstance());
    }

    @Override
    public final void drawRGB(int r, int g, int b) {
        this.drawColor(Color.rgb(r, g, b));
    }

    @Override
    public final void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        RecordingCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left, top, right, bottom, rx, ry, paint.getNativeInstance());
    }

    @Override
    public final void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint);
    }

    @Override
    public final void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text, index, count, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public final void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text.toString(), start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, buf, 0, end - start, x, y, paint.mBidiFlags, paint.getNativeInstance());
            TemporaryBuffer.recycle(buf);
        }
    }

    @Override
    public final void drawText(String text, float x, float y, Paint paint) {
        RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text, 0, text.length(), x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public final void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawText(this.mNativeCanvasWrapper, text, start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public final void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, index, count, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
    }

    @Override
    public final void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            RecordingCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
        }
    }

    @Override
    public final void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((index | count | contextIndex | contextCount | index - contextIndex | contextIndex + contextCount - (index + count) | text.length - (contextIndex + contextCount)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordingCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.getNativeInstance(), 0L, 0);
    }

    @Override
    public final void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((start | end | contextStart | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            RecordingCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int paraIndex;
            MeasuredText mt;
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            long measuredTextPtr = 0L;
            int measuredTextOffset = 0;
            if (text instanceof MeasuredText && end <= (mt = (MeasuredText)text).getParagraphEnd(paraIndex = mt.findParaIndex(start))) {
                measuredTextPtr = mt.getMeasuredParagraph(paraIndex).getNativePtr();
                measuredTextOffset = start - mt.getParagraphStart(paraIndex);
            }
            RecordingCanvas.nDrawTextRun(this.mNativeCanvasWrapper, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.getNativeInstance(), measuredTextPtr, measuredTextOffset);
            TemporaryBuffer.recycle(buf);
        }
    }

    @Override
    public final void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        RecordingCanvas.checkRange(verts.length, vertOffset, vertexCount);
        if (this.isHardwareAccelerated()) {
            return;
        }
        if (texs != null) {
            RecordingCanvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            RecordingCanvas.checkRange(colors.length, colorOffset, vertexCount / 2);
        }
        if (indices != null) {
            RecordingCanvas.checkRange(indices.length, indexOffset, indexCount);
        }
        RecordingCanvas.nDrawVertices(this.mNativeCanvasWrapper, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.getNativeInstance());
    }

    @FastNative
    private static native void nDrawBitmap(long var0, Bitmap var2, float var3, float var4, long var5, int var7, int var8, int var9);

    @FastNative
    private static native void nDrawBitmap(long var0, Bitmap var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, long var11, int var13, int var14);

    @FastNative
    private static native void nDrawBitmap(long var0, int[] var2, int var3, int var4, float var5, float var6, int var7, int var8, boolean var9, long var10);

    @FastNative
    private static native void nDrawColor(long var0, int var2, int var3);

    @FastNative
    private static native void nDrawPaint(long var0, long var2);

    @FastNative
    private static native void nDrawPoint(long var0, float var2, float var3, long var4);

    @FastNative
    private static native void nDrawPoints(long var0, float[] var2, int var3, int var4, long var5);

    @FastNative
    private static native void nDrawLine(long var0, float var2, float var3, float var4, float var5, long var6);

    @FastNative
    private static native void nDrawLines(long var0, float[] var2, int var3, int var4, long var5);

    @FastNative
    private static native void nDrawRect(long var0, float var2, float var3, float var4, float var5, long var6);

    @FastNative
    private static native void nDrawOval(long var0, float var2, float var3, float var4, float var5, long var6);

    @FastNative
    private static native void nDrawCircle(long var0, float var2, float var3, float var4, long var5);

    @FastNative
    private static native void nDrawArc(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, long var9);

    @FastNative
    private static native void nDrawRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    @FastNative
    private static native void nDrawPath(long var0, long var2, long var4);

    @FastNative
    private static native void nDrawRegion(long var0, long var2, long var4);

    @FastNative
    private static native void nDrawNinePatch(long var0, long var2, long var4, float var6, float var7, float var8, float var9, long var10, int var12, int var13);

    @FastNative
    private static native void nDrawBitmapMatrix(long var0, Bitmap var2, long var3, long var5);

    @FastNative
    private static native void nDrawBitmapMesh(long var0, Bitmap var2, int var3, int var4, float[] var5, int var6, int[] var7, int var8, long var9);

    @FastNative
    private static native void nDrawVertices(long var0, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int[] var8, int var9, short[] var10, int var11, int var12, long var13);

    @FastNative
    private static native void nDrawText(long var0, char[] var2, int var3, int var4, float var5, float var6, int var7, long var8);

    @FastNative
    private static native void nDrawText(long var0, String var2, int var3, int var4, float var5, float var6, int var7, long var8);

    @FastNative
    private static native void nDrawTextRun(long var0, String var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10);

    @FastNative
    private static native void nDrawTextRun(long var0, char[] var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12, int var14);

    @FastNative
    private static native void nDrawTextOnPath(long var0, char[] var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10);

    @FastNative
    private static native void nDrawTextOnPath(long var0, String var2, long var3, float var5, float var6, int var7, long var8);
}

