/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.view.DisplayListCanvas;
import android.view.RenderNodeAnimator;
import android.view.SurfaceView;
import android.view.View;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import libcore.util.NativeAllocationRegistry;

public class RenderNode {
    final long mNativeRenderNode;
    private final View mOwningView;

    private RenderNode(String name, View owningView) {
        this.mNativeRenderNode = RenderNode.nCreate(name);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeRenderNode);
        this.mOwningView = owningView;
    }

    private RenderNode(long nativePtr) {
        this.mNativeRenderNode = nativePtr;
        NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeRenderNode);
        this.mOwningView = null;
    }

    public void destroy() {
    }

    public static RenderNode create(String name, View owningView) {
        return new RenderNode(name, owningView);
    }

    public static RenderNode adopt(long nativePtr) {
        return new RenderNode(nativePtr);
    }

    public void requestPositionUpdates(SurfaceView view) {
        RenderNode.nRequestPositionUpdates(this.mNativeRenderNode, view);
    }

    public DisplayListCanvas start(int width, int height) {
        return DisplayListCanvas.obtain(this, width, height);
    }

    public void end(DisplayListCanvas canvas) {
        long displayList = canvas.finishRecording();
        RenderNode.nSetDisplayList(this.mNativeRenderNode, displayList);
        canvas.recycle();
    }

    public void discardDisplayList() {
        RenderNode.nSetDisplayList(this.mNativeRenderNode, 0L);
    }

    public boolean isValid() {
        return RenderNode.nIsValid(this.mNativeRenderNode);
    }

    long getNativeDisplayList() {
        if (!this.isValid()) {
            throw new IllegalStateException("The display list is not valid.");
        }
        return this.mNativeRenderNode;
    }

    public boolean hasIdentityMatrix() {
        return RenderNode.nHasIdentityMatrix(this.mNativeRenderNode);
    }

    public void getMatrix(Matrix outMatrix) {
        RenderNode.nGetTransformMatrix(this.mNativeRenderNode, outMatrix.native_instance);
    }

    public void getInverseMatrix(Matrix outMatrix) {
        RenderNode.nGetInverseTransformMatrix(this.mNativeRenderNode, outMatrix.native_instance);
    }

    public boolean setLayerType(int layerType) {
        return RenderNode.nSetLayerType(this.mNativeRenderNode, layerType);
    }

    public boolean setLayerPaint(Paint paint) {
        return RenderNode.nSetLayerPaint(this.mNativeRenderNode, paint != null ? paint.getNativeInstance() : 0L);
    }

    public boolean setClipBounds(Rect rect) {
        if (rect == null) {
            return RenderNode.nSetClipBoundsEmpty(this.mNativeRenderNode);
        }
        return RenderNode.nSetClipBounds(this.mNativeRenderNode, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean setClipToBounds(boolean clipToBounds) {
        return RenderNode.nSetClipToBounds(this.mNativeRenderNode, clipToBounds);
    }

    public boolean setProjectBackwards(boolean shouldProject) {
        return RenderNode.nSetProjectBackwards(this.mNativeRenderNode, shouldProject);
    }

    public boolean setProjectionReceiver(boolean shouldRecieve) {
        return RenderNode.nSetProjectionReceiver(this.mNativeRenderNode, shouldRecieve);
    }

    public boolean setOutline(Outline outline) {
        if (outline == null) {
            return RenderNode.nSetOutlineNone(this.mNativeRenderNode);
        }
        switch (outline.mMode) {
            case 0: {
                return RenderNode.nSetOutlineEmpty(this.mNativeRenderNode);
            }
            case 1: {
                return RenderNode.nSetOutlineRoundRect(this.mNativeRenderNode, outline.mRect.left, outline.mRect.top, outline.mRect.right, outline.mRect.bottom, outline.mRadius, outline.mAlpha);
            }
            case 2: {
                return RenderNode.nSetOutlineConvexPath(this.mNativeRenderNode, outline.mPath.mNativePath, outline.mAlpha);
            }
        }
        throw new IllegalArgumentException("Unrecognized outline?");
    }

    public boolean hasShadow() {
        return RenderNode.nHasShadow(this.mNativeRenderNode);
    }

    public boolean setSpotShadowColor(int color2) {
        return RenderNode.nSetSpotShadowColor(this.mNativeRenderNode, color2);
    }

    public boolean setAmbientShadowColor(int color2) {
        return RenderNode.nSetAmbientShadowColor(this.mNativeRenderNode, color2);
    }

    public int getSpotShadowColor() {
        return RenderNode.nGetSpotShadowColor(this.mNativeRenderNode);
    }

    public int getAmbientShadowColor() {
        return RenderNode.nGetAmbientShadowColor(this.mNativeRenderNode);
    }

    public boolean setClipToOutline(boolean clipToOutline) {
        return RenderNode.nSetClipToOutline(this.mNativeRenderNode, clipToOutline);
    }

    public boolean getClipToOutline() {
        return RenderNode.nGetClipToOutline(this.mNativeRenderNode);
    }

    public boolean setRevealClip(boolean shouldClip, float x, float y, float radius) {
        return RenderNode.nSetRevealClip(this.mNativeRenderNode, shouldClip, x, y, radius);
    }

    public boolean setStaticMatrix(Matrix matrix) {
        return RenderNode.nSetStaticMatrix(this.mNativeRenderNode, matrix.native_instance);
    }

    public boolean setAnimationMatrix(Matrix matrix) {
        return RenderNode.nSetAnimationMatrix(this.mNativeRenderNode, matrix != null ? matrix.native_instance : 0L);
    }

    public boolean setAlpha(float alpha) {
        return RenderNode.nSetAlpha(this.mNativeRenderNode, alpha);
    }

    public float getAlpha() {
        return RenderNode.nGetAlpha(this.mNativeRenderNode);
    }

    public boolean setHasOverlappingRendering(boolean hasOverlappingRendering) {
        return RenderNode.nSetHasOverlappingRendering(this.mNativeRenderNode, hasOverlappingRendering);
    }

    public boolean hasOverlappingRendering() {
        return RenderNode.nHasOverlappingRendering(this.mNativeRenderNode);
    }

    public boolean setElevation(float lift) {
        return RenderNode.nSetElevation(this.mNativeRenderNode, lift);
    }

    public float getElevation() {
        return RenderNode.nGetElevation(this.mNativeRenderNode);
    }

    public boolean setTranslationX(float translationX) {
        return RenderNode.nSetTranslationX(this.mNativeRenderNode, translationX);
    }

    public float getTranslationX() {
        return RenderNode.nGetTranslationX(this.mNativeRenderNode);
    }

    public boolean setTranslationY(float translationY) {
        return RenderNode.nSetTranslationY(this.mNativeRenderNode, translationY);
    }

    public float getTranslationY() {
        return RenderNode.nGetTranslationY(this.mNativeRenderNode);
    }

    public boolean setTranslationZ(float translationZ) {
        return RenderNode.nSetTranslationZ(this.mNativeRenderNode, translationZ);
    }

    public float getTranslationZ() {
        return RenderNode.nGetTranslationZ(this.mNativeRenderNode);
    }

    public boolean setRotation(float rotation) {
        return RenderNode.nSetRotation(this.mNativeRenderNode, rotation);
    }

    public float getRotation() {
        return RenderNode.nGetRotation(this.mNativeRenderNode);
    }

    public boolean setRotationX(float rotationX) {
        return RenderNode.nSetRotationX(this.mNativeRenderNode, rotationX);
    }

    public float getRotationX() {
        return RenderNode.nGetRotationX(this.mNativeRenderNode);
    }

    public boolean setRotationY(float rotationY) {
        return RenderNode.nSetRotationY(this.mNativeRenderNode, rotationY);
    }

    public float getRotationY() {
        return RenderNode.nGetRotationY(this.mNativeRenderNode);
    }

    public boolean setScaleX(float scaleX) {
        return RenderNode.nSetScaleX(this.mNativeRenderNode, scaleX);
    }

    public float getScaleX() {
        return RenderNode.nGetScaleX(this.mNativeRenderNode);
    }

    public boolean setScaleY(float scaleY) {
        return RenderNode.nSetScaleY(this.mNativeRenderNode, scaleY);
    }

    public float getScaleY() {
        return RenderNode.nGetScaleY(this.mNativeRenderNode);
    }

    public boolean setPivotX(float pivotX) {
        return RenderNode.nSetPivotX(this.mNativeRenderNode, pivotX);
    }

    public float getPivotX() {
        return RenderNode.nGetPivotX(this.mNativeRenderNode);
    }

    public boolean setPivotY(float pivotY) {
        return RenderNode.nSetPivotY(this.mNativeRenderNode, pivotY);
    }

    public float getPivotY() {
        return RenderNode.nGetPivotY(this.mNativeRenderNode);
    }

    public boolean isPivotExplicitlySet() {
        return RenderNode.nIsPivotExplicitlySet(this.mNativeRenderNode);
    }

    public boolean setCameraDistance(float distance) {
        return RenderNode.nSetCameraDistance(this.mNativeRenderNode, distance);
    }

    public float getCameraDistance() {
        return RenderNode.nGetCameraDistance(this.mNativeRenderNode);
    }

    public boolean setLeft(int left) {
        return RenderNode.nSetLeft(this.mNativeRenderNode, left);
    }

    public boolean setTop(int top) {
        return RenderNode.nSetTop(this.mNativeRenderNode, top);
    }

    public boolean setRight(int right) {
        return RenderNode.nSetRight(this.mNativeRenderNode, right);
    }

    public boolean setBottom(int bottom) {
        return RenderNode.nSetBottom(this.mNativeRenderNode, bottom);
    }

    public boolean setLeftTopRightBottom(int left, int top, int right, int bottom) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, left, top, right, bottom);
    }

    public boolean offsetLeftAndRight(int offset) {
        return RenderNode.nOffsetLeftAndRight(this.mNativeRenderNode, offset);
    }

    public boolean offsetTopAndBottom(int offset) {
        return RenderNode.nOffsetTopAndBottom(this.mNativeRenderNode, offset);
    }

    public void output() {
        RenderNode.nOutput(this.mNativeRenderNode);
    }

    public int getDebugSize() {
        return RenderNode.nGetDebugSize(this.mNativeRenderNode);
    }

    public void addAnimator(RenderNodeAnimator animator2) {
        if (this.mOwningView == null || this.mOwningView.mAttachInfo == null) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        RenderNode.nAddAnimator(this.mNativeRenderNode, animator2.getNativeAnimator());
        this.mOwningView.mAttachInfo.mViewRootImpl.registerAnimatingRenderNode(this);
    }

    public boolean isAttached() {
        return this.mOwningView != null && this.mOwningView.mAttachInfo != null;
    }

    public void registerVectorDrawableAnimator(AnimatedVectorDrawable.VectorDrawableAnimatorRT animatorSet) {
        if (this.mOwningView == null || this.mOwningView.mAttachInfo == null) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        this.mOwningView.mAttachInfo.mViewRootImpl.registerVectorDrawableAnimator(animatorSet);
    }

    public void endAllAnimators() {
        RenderNode.nEndAllAnimators(this.mNativeRenderNode);
    }

    private static native long nCreate(String var0);

    private static native long nGetNativeFinalizer();

    private static native void nOutput(long var0);

    private static native int nGetDebugSize(long var0);

    private static native void nRequestPositionUpdates(long var0, SurfaceView var2);

    private static native void nAddAnimator(long var0, long var2);

    private static native void nEndAllAnimators(long var0);

    @FastNative
    private static native void nSetDisplayList(long var0, long var2);

    @CriticalNative
    private static native boolean nIsValid(long var0);

    @CriticalNative
    private static native void nGetTransformMatrix(long var0, long var2);

    @CriticalNative
    private static native void nGetInverseTransformMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nHasIdentityMatrix(long var0);

    @CriticalNative
    private static native boolean nOffsetTopAndBottom(long var0, int var2);

    @CriticalNative
    private static native boolean nOffsetLeftAndRight(long var0, int var2);

    @CriticalNative
    private static native boolean nSetLeftTopRightBottom(long var0, int var2, int var3, int var4, int var5);

    @CriticalNative
    private static native boolean nSetBottom(long var0, int var2);

    @CriticalNative
    private static native boolean nSetRight(long var0, int var2);

    @CriticalNative
    private static native boolean nSetTop(long var0, int var2);

    @CriticalNative
    private static native boolean nSetLeft(long var0, int var2);

    @CriticalNative
    private static native boolean nSetCameraDistance(long var0, float var2);

    @CriticalNative
    private static native boolean nSetPivotY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetPivotX(long var0, float var2);

    @CriticalNative
    private static native boolean nSetLayerType(long var0, int var2);

    @CriticalNative
    private static native boolean nSetLayerPaint(long var0, long var2);

    @CriticalNative
    private static native boolean nSetClipToBounds(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetClipBounds(long var0, int var2, int var3, int var4, int var5);

    @CriticalNative
    private static native boolean nSetClipBoundsEmpty(long var0);

    @CriticalNative
    private static native boolean nSetProjectBackwards(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetProjectionReceiver(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetOutlineRoundRect(long var0, int var2, int var3, int var4, int var5, float var6, float var7);

    @CriticalNative
    private static native boolean nSetOutlineConvexPath(long var0, long var2, float var4);

    @CriticalNative
    private static native boolean nSetOutlineEmpty(long var0);

    @CriticalNative
    private static native boolean nSetOutlineNone(long var0);

    @CriticalNative
    private static native boolean nHasShadow(long var0);

    @CriticalNative
    private static native boolean nSetSpotShadowColor(long var0, int var2);

    @CriticalNative
    private static native boolean nSetAmbientShadowColor(long var0, int var2);

    @CriticalNative
    private static native int nGetSpotShadowColor(long var0);

    @CriticalNative
    private static native int nGetAmbientShadowColor(long var0);

    @CriticalNative
    private static native boolean nSetClipToOutline(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetRevealClip(long var0, boolean var2, float var3, float var4, float var5);

    @CriticalNative
    private static native boolean nSetAlpha(long var0, float var2);

    @CriticalNative
    private static native boolean nSetHasOverlappingRendering(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetElevation(long var0, float var2);

    @CriticalNative
    private static native boolean nSetTranslationX(long var0, float var2);

    @CriticalNative
    private static native boolean nSetTranslationY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetTranslationZ(long var0, float var2);

    @CriticalNative
    private static native boolean nSetRotation(long var0, float var2);

    @CriticalNative
    private static native boolean nSetRotationX(long var0, float var2);

    @CriticalNative
    private static native boolean nSetRotationY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetScaleX(long var0, float var2);

    @CriticalNative
    private static native boolean nSetScaleY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetStaticMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nSetAnimationMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nHasOverlappingRendering(long var0);

    @CriticalNative
    private static native boolean nGetClipToOutline(long var0);

    @CriticalNative
    private static native float nGetAlpha(long var0);

    @CriticalNative
    private static native float nGetCameraDistance(long var0);

    @CriticalNative
    private static native float nGetScaleX(long var0);

    @CriticalNative
    private static native float nGetScaleY(long var0);

    @CriticalNative
    private static native float nGetElevation(long var0);

    @CriticalNative
    private static native float nGetTranslationX(long var0);

    @CriticalNative
    private static native float nGetTranslationY(long var0);

    @CriticalNative
    private static native float nGetTranslationZ(long var0);

    @CriticalNative
    private static native float nGetRotation(long var0);

    @CriticalNative
    private static native float nGetRotationX(long var0);

    @CriticalNative
    private static native float nGetRotationY(long var0);

    @CriticalNative
    private static native boolean nIsPivotExplicitlySet(long var0);

    @CriticalNative
    private static native float nGetPivotX(long var0);

    @CriticalNative
    private static native float nGetPivotY(long var0);

    static /* synthetic */ long access$000() {
        return RenderNode.nGetNativeFinalizer();
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(RenderNode.class.getClassLoader(), RenderNode.access$000(), 1024L);

        private NoImagePreloadHolder() {
        }
    }
}

