/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.os.Parcel;
import android.os.Parcelable;

public final class AutofillId
implements Parcelable {
    private final int mViewId;
    private final boolean mVirtual;
    private final int mVirtualId;
    public static final Parcelable.Creator<AutofillId> CREATOR = new Parcelable.Creator<AutofillId>(){

        @Override
        public AutofillId createFromParcel(Parcel source) {
            return new AutofillId(source);
        }

        public AutofillId[] newArray(int size) {
            return new AutofillId[size];
        }
    };

    public AutofillId(int id2) {
        this.mVirtual = false;
        this.mViewId = id2;
        this.mVirtualId = -1;
    }

    public AutofillId(AutofillId parent, int virtualChildId) {
        this.mVirtual = true;
        this.mViewId = parent.mViewId;
        this.mVirtualId = virtualChildId;
    }

    public AutofillId(int parentId, int virtualChildId) {
        this.mVirtual = true;
        this.mViewId = parentId;
        this.mVirtualId = virtualChildId;
    }

    public int getViewId() {
        return this.mViewId;
    }

    public int getVirtualChildId() {
        return this.mVirtualId;
    }

    public boolean isVirtual() {
        return this.mVirtual;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mViewId;
        result = 31 * result + this.mVirtualId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutofillId other = (AutofillId)obj;
        if (this.mViewId != other.mViewId) {
            return false;
        }
        return this.mVirtualId == other.mVirtualId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.mViewId);
        if (this.mVirtual) {
            builder.append(':').append(this.mVirtualId);
        }
        return builder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mViewId);
        parcel.writeInt(this.mVirtual ? 1 : 0);
        parcel.writeInt(this.mVirtualId);
    }

    private AutofillId(Parcel parcel) {
        this.mViewId = parcel.readInt();
        this.mVirtual = parcel.readInt() == 1;
        this.mVirtualId = parcel.readInt();
    }
}

