/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.res.AssetFileDescriptor;

final class SmartSelection {
    static final int HINT_FLAG_URL = 1;
    static final int HINT_FLAG_EMAIL = 2;
    private final long mCtx;

    SmartSelection(int fd) {
        this.mCtx = SmartSelection.nativeNew(fd);
    }

    SmartSelection(String path) {
        this.mCtx = SmartSelection.nativeNewFromPath(path);
    }

    SmartSelection(AssetFileDescriptor afd) {
        this.mCtx = SmartSelection.nativeNewFromAssetFileDescriptor(afd, afd.getStartOffset(), afd.getLength());
        if (this.mCtx == 0L) {
            throw new IllegalArgumentException("Couldn't initialize TC from given AssetFileDescriptor");
        }
    }

    public int[] suggest(String context, int selectionBegin, int selectionEnd) {
        return SmartSelection.nativeSuggest(this.mCtx, context, selectionBegin, selectionEnd);
    }

    public ClassificationResult[] classifyText(String context, int selectionBegin, int selectionEnd, int hintFlags) {
        return SmartSelection.nativeClassifyText(this.mCtx, context, selectionBegin, selectionEnd, hintFlags);
    }

    public AnnotatedSpan[] annotate(String text) {
        return SmartSelection.nativeAnnotate(this.mCtx, text);
    }

    public void close() {
        SmartSelection.nativeClose(this.mCtx);
    }

    public static String getLanguages(int fd) {
        return SmartSelection.nativeGetLanguage(fd);
    }

    public static int getVersion(int fd) {
        return SmartSelection.nativeGetVersion(fd);
    }

    private static native long nativeNew(int var0);

    private static native long nativeNewFromPath(String var0);

    private static native long nativeNewFromAssetFileDescriptor(AssetFileDescriptor var0, long var1, long var3);

    private static native int[] nativeSuggest(long var0, String var2, int var3, int var4);

    private static native ClassificationResult[] nativeClassifyText(long var0, String var2, int var3, int var4, int var5);

    private static native AnnotatedSpan[] nativeAnnotate(long var0, String var2);

    private static native void nativeClose(long var0);

    private static native String nativeGetLanguage(int var0);

    private static native int nativeGetVersion(int var0);

    static {
        System.loadLibrary("textclassifier");
    }

    public static final class AnnotatedSpan {
        final int mStartIndex;
        final int mEndIndex;
        final ClassificationResult[] mClassification;

        AnnotatedSpan(int startIndex, int endIndex, ClassificationResult[] classification) {
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
            this.mClassification = classification;
        }

        public int getStartIndex() {
            return this.mStartIndex;
        }

        public int getEndIndex() {
            return this.mEndIndex;
        }

        public ClassificationResult[] getClassification() {
            return this.mClassification;
        }
    }

    static final class DatetimeParseResult {
        long mMsSinceEpoch;

        DatetimeParseResult() {
        }
    }

    static final class ClassificationResult {
        final String mCollection;
        final float mScore;
        final DatetimeParseResult mDatetime;

        ClassificationResult(String collection, float score) {
            this.mCollection = collection;
            this.mScore = score;
            this.mDatetime = null;
        }

        ClassificationResult(String collection, float score, DatetimeParseResult datetime) {
            this.mCollection = collection;
            this.mScore = score;
            this.mDatetime = datetime;
        }
    }
}

