/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.textclassifier.ITextClassificationCallback;
import android.service.textclassifier.ITextClassifierService;
import android.service.textclassifier.ITextLinksCallback;
import android.service.textclassifier.ITextSelectionCallback;
import android.view.textclassifier.Log;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

final class SystemTextClassifier
implements TextClassifier {
    private static final String LOG_TAG = "SystemTextClassifier";
    private final ITextClassifierService mManagerService = ITextClassifierService.Stub.asInterface(ServiceManager.getServiceOrThrow("textclassification"));
    private final TextClassifier mFallback;

    SystemTextClassifier(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mFallback = new TextClassifierImpl(context);
    }

    @Override
    public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options) {
        TextClassifier.Utils.validate(text, selectionStartIndex, selectionEndIndex, false);
        try {
            TextSelectionCallback callback = new TextSelectionCallback();
            this.mManagerService.onSuggestSelection(text, selectionStartIndex, selectionEndIndex, options, callback);
            TextSelection selection = callback.mReceiver.get();
            if (selection != null) {
                return selection;
            }
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        catch (InterruptedException e) {
            Log.d(LOG_TAG, e.getMessage());
        }
        return this.mFallback.suggestSelection(text, selectionStartIndex, selectionEndIndex, options);
    }

    @Override
    public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options) {
        TextClassifier.Utils.validate(text, startIndex, endIndex, false);
        try {
            TextClassificationCallback callback = new TextClassificationCallback();
            this.mManagerService.onClassifyText(text, startIndex, endIndex, options, callback);
            TextClassification classification = callback.mReceiver.get();
            if (classification != null) {
                return classification;
            }
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        catch (InterruptedException e) {
            Log.d(LOG_TAG, e.getMessage());
        }
        return this.mFallback.classifyText(text, startIndex, endIndex, options);
    }

    @Override
    public TextLinks generateLinks(CharSequence text, TextLinks.Options options) {
        TextClassifier.Utils.validate(text, false);
        try {
            TextLinksCallback callback = new TextLinksCallback();
            this.mManagerService.onGenerateLinks(text, options, callback);
            TextLinks links = callback.mReceiver.get();
            if (links != null) {
                return links;
            }
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        catch (InterruptedException e) {
            Log.d(LOG_TAG, e.getMessage());
        }
        return this.mFallback.generateLinks(text, options);
    }

    private static final class ResponseReceiver<T> {
        private final CountDownLatch mLatch = new CountDownLatch(1);
        private T mResponse;

        private ResponseReceiver() {
        }

        public void onSuccess(T response) {
            this.mResponse = response;
            this.mLatch.countDown();
        }

        public void onFailure() {
            Log.e(SystemTextClassifier.LOG_TAG, "Request failed.", null);
            this.mLatch.countDown();
        }

        public T get() throws InterruptedException {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mLatch.await(2L, TimeUnit.SECONDS);
            }
            return this.mResponse;
        }
    }

    private static final class TextLinksCallback
    extends ITextLinksCallback.Stub {
        final ResponseReceiver<TextLinks> mReceiver = new ResponseReceiver();

        private TextLinksCallback() {
        }

        @Override
        public void onSuccess(TextLinks links) {
            this.mReceiver.onSuccess(links);
        }

        @Override
        public void onFailure() {
            this.mReceiver.onFailure();
        }
    }

    private static final class TextClassificationCallback
    extends ITextClassificationCallback.Stub {
        final ResponseReceiver<TextClassification> mReceiver = new ResponseReceiver();

        private TextClassificationCallback() {
        }

        @Override
        public void onSuccess(TextClassification classification) {
            this.mReceiver.onSuccess(classification);
        }

        @Override
        public void onFailure() {
            this.mReceiver.onFailure();
        }
    }

    private static final class TextSelectionCallback
    extends ITextSelectionCallback.Stub {
        final ResponseReceiver<TextSelection> mReceiver = new ResponseReceiver();

        private TextSelectionCallback() {
        }

        @Override
        public void onSuccess(TextSelection selection) {
            this.mReceiver.onSuccess(selection);
        }

        @Override
        public void onFailure() {
            this.mReceiver.onFailure();
        }
    }
}

