/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class TextClassification
implements Parcelable {
    static final TextClassification EMPTY = new Builder().build();
    private static final int MAX_PRIMARY_ICON_SIZE = 192;
    private static final int MAX_SECONDARY_ICON_SIZE = 144;
    private final String mText;
    private final Drawable mPrimaryIcon;
    private final String mPrimaryLabel;
    private final Intent mPrimaryIntent;
    private final View.OnClickListener mPrimaryOnClickListener;
    private final List<Drawable> mSecondaryIcons;
    private final List<String> mSecondaryLabels;
    private final List<Intent> mSecondaryIntents;
    private final EntityConfidence mEntityConfidence;
    private final String mSignature;
    public static final Parcelable.Creator<TextClassification> CREATOR = new Parcelable.Creator<TextClassification>(){

        @Override
        public TextClassification createFromParcel(Parcel in) {
            return new TextClassification(in);
        }

        public TextClassification[] newArray(int size) {
            return new TextClassification[size];
        }
    };

    private TextClassification(String text, Drawable primaryIcon, String primaryLabel, Intent primaryIntent, View.OnClickListener primaryOnClickListener, List<Drawable> secondaryIcons, List<String> secondaryLabels, List<Intent> secondaryIntents, Map<String, Float> entityConfidence, String signature) {
        Preconditions.checkArgument(secondaryLabels.size() == secondaryIntents.size());
        Preconditions.checkArgument(secondaryIcons.size() == secondaryIntents.size());
        this.mText = text;
        this.mPrimaryIcon = primaryIcon;
        this.mPrimaryLabel = primaryLabel;
        this.mPrimaryIntent = primaryIntent;
        this.mPrimaryOnClickListener = primaryOnClickListener;
        this.mSecondaryIcons = secondaryIcons;
        this.mSecondaryLabels = secondaryLabels;
        this.mSecondaryIntents = secondaryIntents;
        this.mEntityConfidence = new EntityConfidence(entityConfidence);
        this.mSignature = signature;
    }

    public String getText() {
        return this.mText;
    }

    public int getEntityCount() {
        return this.mEntityConfidence.getEntities().size();
    }

    public String getEntity(int index) {
        return this.mEntityConfidence.getEntities().get(index);
    }

    public float getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    public int getSecondaryActionsCount() {
        return this.mSecondaryIntents.size();
    }

    public Drawable getSecondaryIcon(int index) {
        return this.mSecondaryIcons.get(index);
    }

    public Drawable getIcon() {
        return this.mPrimaryIcon;
    }

    public CharSequence getSecondaryLabel(int index) {
        return this.mSecondaryLabels.get(index);
    }

    public CharSequence getLabel() {
        return this.mPrimaryLabel;
    }

    public Intent getSecondaryIntent(int index) {
        return this.mSecondaryIntents.get(index);
    }

    public Intent getIntent() {
        return this.mPrimaryIntent;
    }

    public View.OnClickListener getOnClickListener() {
        return this.mPrimaryOnClickListener;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public String toString() {
        return String.format(Locale.US, "TextClassification {text=%s, entities=%s, primaryLabel=%s, secondaryLabels=%s, primaryIntent=%s, secondaryIntents=%s, signature=%s}", this.mText, this.mEntityConfidence, this.mPrimaryLabel, this.mSecondaryLabels, this.mPrimaryIntent, this.mSecondaryIntents, this.mSignature);
    }

    public static View.OnClickListener createStartActivityOnClickListener(Context context, Intent intent) {
        Preconditions.checkArgument(context != null);
        Preconditions.checkArgument(intent != null);
        return v -> context.startActivity(intent);
    }

    private static Bitmap drawableToBitmap(Drawable drawable2, int maxDims) {
        if (drawable2 == null) {
            return null;
        }
        int actualWidth = Math.max(1, drawable2.getIntrinsicWidth());
        int actualHeight = Math.max(1, drawable2.getIntrinsicHeight());
        double scaleWidth = (double)maxDims / (double)actualWidth;
        double scaleHeight = (double)maxDims / (double)actualHeight;
        double scale = Math.min(1.0, Math.min(scaleWidth, scaleHeight));
        int width = (int)((double)actualWidth * scale);
        int height = (int)((double)actualHeight * scale);
        if (drawable2 instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            if (actualWidth != width || actualHeight != height) {
                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), width, height, false);
            }
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static List<Bitmap> drawablesToBitmaps(List<Drawable> drawables, int maxDims) {
        ArrayList<Bitmap> bitmaps = new ArrayList<Bitmap>(drawables.size());
        for (Drawable drawable2 : drawables) {
            bitmaps.add(TextClassification.drawableToBitmap(drawable2, maxDims));
        }
        return bitmaps;
    }

    private static List<Drawable> bitmapsToDrawables(List<Bitmap> bitmaps) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>(bitmaps.size());
        for (Bitmap bitmap : bitmaps) {
            if (bitmap != null) {
                drawables.add(new BitmapDrawable(null, bitmap));
                continue;
            }
            drawables.add(null);
        }
        return drawables;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mText);
        Bitmap primaryIconBitmap = TextClassification.drawableToBitmap(this.mPrimaryIcon, 192);
        dest.writeInt(primaryIconBitmap != null ? 1 : 0);
        if (primaryIconBitmap != null) {
            primaryIconBitmap.writeToParcel(dest, flags);
        }
        dest.writeString(this.mPrimaryLabel);
        dest.writeInt(this.mPrimaryIntent != null ? 1 : 0);
        if (this.mPrimaryIntent != null) {
            this.mPrimaryIntent.writeToParcel(dest, flags);
        }
        dest.writeTypedList(TextClassification.drawablesToBitmaps(this.mSecondaryIcons, 144));
        dest.writeStringList(this.mSecondaryLabels);
        dest.writeTypedList(this.mSecondaryIntents);
        this.mEntityConfidence.writeToParcel(dest, flags);
        dest.writeString(this.mSignature);
    }

    private TextClassification(Parcel in) {
        this.mText = in.readString();
        this.mPrimaryIcon = in.readInt() == 0 ? null : new BitmapDrawable(null, Bitmap.CREATOR.createFromParcel(in));
        this.mPrimaryLabel = in.readString();
        this.mPrimaryIntent = in.readInt() == 0 ? null : Intent.CREATOR.createFromParcel(in);
        this.mPrimaryOnClickListener = null;
        this.mSecondaryIcons = TextClassification.bitmapsToDrawables(in.createTypedArrayList(Bitmap.CREATOR));
        this.mSecondaryLabels = in.createStringArrayList();
        this.mSecondaryIntents = in.createTypedArrayList(Intent.CREATOR);
        this.mEntityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
        this.mSignature = in.readString();
    }

    public static final class Options
    implements Parcelable {
        private LocaleList mDefaultLocales;
        private Calendar mReferenceTime;
        public static final Parcelable.Creator<Options> CREATOR = new Parcelable.Creator<Options>(){

            @Override
            public Options createFromParcel(Parcel in) {
                return new Options(in);
            }

            public Options[] newArray(int size) {
                return new Options[size];
            }
        };

        public Options() {
        }

        public Options setDefaultLocales(LocaleList defaultLocales) {
            this.mDefaultLocales = defaultLocales;
            return this;
        }

        public Options setReferenceTime(Calendar referenceTime) {
            this.mReferenceTime = referenceTime;
            return this;
        }

        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        public Calendar getReferenceTime() {
            return this.mReferenceTime;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mDefaultLocales != null ? 1 : 0);
            if (this.mDefaultLocales != null) {
                this.mDefaultLocales.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mReferenceTime != null ? 1 : 0);
            if (this.mReferenceTime != null) {
                dest.writeSerializable(this.mReferenceTime);
            }
        }

        private Options(Parcel in) {
            if (in.readInt() > 0) {
                this.mDefaultLocales = LocaleList.CREATOR.createFromParcel(in);
            }
            if (in.readInt() > 0) {
                this.mReferenceTime = (Calendar)in.readSerializable();
            }
        }
    }

    public static final class Builder {
        private String mText;
        private final List<Drawable> mSecondaryIcons = new ArrayList<Drawable>();
        private final List<String> mSecondaryLabels = new ArrayList<String>();
        private final List<Intent> mSecondaryIntents = new ArrayList<Intent>();
        private final Map<String, Float> mEntityConfidence = new ArrayMap<String, Float>();
        Drawable mPrimaryIcon;
        String mPrimaryLabel;
        Intent mPrimaryIntent;
        View.OnClickListener mPrimaryOnClickListener;
        private String mSignature = "";

        public Builder setText(String text) {
            this.mText = text;
            return this;
        }

        public Builder setEntityType(String type, float confidenceScore) {
            this.mEntityConfidence.put(type, Float.valueOf(confidenceScore));
            return this;
        }

        public Builder addSecondaryAction(Intent intent, String label, Drawable icon) {
            if (intent != null || label != null || icon != null) {
                this.mSecondaryIntents.add(intent);
                this.mSecondaryLabels.add(label);
                this.mSecondaryIcons.add(icon);
            }
            return this;
        }

        public Builder clearSecondaryActions() {
            this.mSecondaryIntents.clear();
            this.mSecondaryLabels.clear();
            this.mSecondaryIcons.clear();
            return this;
        }

        public Builder setPrimaryAction(Intent intent, String label, Drawable icon) {
            return this.setIntent(intent).setLabel(label).setIcon(icon);
        }

        public Builder setIcon(Drawable icon) {
            this.mPrimaryIcon = icon;
            return this;
        }

        public Builder setLabel(String label) {
            this.mPrimaryLabel = label;
            return this;
        }

        public Builder setIntent(Intent intent) {
            this.mPrimaryIntent = intent;
            return this;
        }

        public Builder setOnClickListener(View.OnClickListener onClickListener) {
            this.mPrimaryOnClickListener = onClickListener;
            return this;
        }

        public Builder setSignature(String signature) {
            this.mSignature = Preconditions.checkNotNull(signature);
            return this;
        }

        public TextClassification build() {
            return new TextClassification(this.mText, this.mPrimaryIcon, this.mPrimaryLabel, this.mPrimaryIntent, this.mPrimaryOnClickListener, this.mSecondaryIcons, this.mSecondaryLabels, this.mSecondaryIntents, this.mEntityConfidence, this.mSignature);
        }
    }
}

