/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.ServiceManager;
import android.service.textclassifier.TextClassifierService;
import android.view.textclassifier.Log;
import android.view.textclassifier.SystemTextClassifier;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl;
import com.android.internal.util.Preconditions;

public final class TextClassificationManager {
    private static final boolean SYSTEM_TEXT_CLASSIFIER_ENABLED = true;
    private static final String LOG_TAG = "TextClassificationManager";
    private final Object mLock = new Object();
    private final Context mContext;
    private TextClassifier mTextClassifier;
    private TextClassifier mSystemTextClassifier;

    public TextClassificationManager(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClassifier getSystemDefaultTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSystemTextClassifier == null && this.isSystemTextClassifierEnabled()) {
                try {
                    Log.d(LOG_TAG, "Initialized SystemTextClassifier");
                    this.mSystemTextClassifier = new SystemTextClassifier(this.mContext);
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    Log.e(LOG_TAG, "Could not initialize SystemTextClassifier", e);
                }
            }
            if (this.mSystemTextClassifier == null) {
                Log.d(LOG_TAG, "Using an in-process TextClassifier as the system default");
                this.mSystemTextClassifier = new TextClassifierImpl(this.mContext);
            }
        }
        return this.mSystemTextClassifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClassifier getTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTextClassifier == null) {
                this.mTextClassifier = this.isSystemTextClassifierEnabled() ? this.getSystemDefaultTextClassifier() : new TextClassifierImpl(this.mContext);
            }
            return this.mTextClassifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextClassifier(TextClassifier textClassifier) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTextClassifier = textClassifier;
        }
    }

    private boolean isSystemTextClassifierEnabled() {
        return TextClassifierService.getServiceComponentName(this.mContext) != null;
    }
}

