/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.Slog;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifierConstants;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import android.view.textclassifier.logging.Logger;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface TextClassifier {
    public static final String DEFAULT_LOG_TAG = "androidtc";
    public static final String TYPE_UNKNOWN = "";
    public static final String TYPE_OTHER = "other";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_PHONE = "phone";
    public static final String TYPE_ADDRESS = "address";
    public static final String TYPE_URL = "url";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATE_TIME = "datetime";
    public static final String TYPE_FLIGHT_NUMBER = "flight";
    public static final int ENTITY_PRESET_ALL = 0;
    public static final int ENTITY_PRESET_NONE = 1;
    public static final int ENTITY_PRESET_BASE = 2;
    public static final TextClassifier NO_OP = new TextClassifier(){};

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options) {
        Utils.validate(text, selectionStartIndex, selectionEndIndex, false);
        return new TextSelection.Builder(selectionStartIndex, selectionEndIndex).build();
    }

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex) {
        return this.suggestSelection(text, selectionStartIndex, selectionEndIndex, (TextSelection.Options)null);
    }

    default public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, LocaleList defaultLocales) {
        TextSelection.Options options = defaultLocales != null ? new TextSelection.Options().setDefaultLocales(defaultLocales) : null;
        return this.suggestSelection(text, selectionStartIndex, selectionEndIndex, options);
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options) {
        Utils.validate(text, startIndex, endIndex, false);
        return TextClassification.EMPTY;
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex) {
        return this.classifyText(text, startIndex, endIndex, (TextClassification.Options)null);
    }

    default public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales) {
        TextClassification.Options options = defaultLocales != null ? new TextClassification.Options().setDefaultLocales(defaultLocales) : null;
        return this.classifyText(text, startIndex, endIndex, options);
    }

    default public TextLinks generateLinks(CharSequence text, TextLinks.Options options) {
        Utils.validate(text, false);
        return new TextLinks.Builder(text.toString()).build();
    }

    default public TextLinks generateLinks(CharSequence text) {
        return this.generateLinks(text, null);
    }

    default public Collection<String> getEntitiesForPreset(int entityPreset) {
        return Collections.EMPTY_LIST;
    }

    default public Logger getLogger(Logger.Config config) {
        Preconditions.checkNotNull(config);
        return Logger.DISABLED;
    }

    default public TextClassifierConstants getSettings() {
        return TextClassifierConstants.DEFAULT;
    }

    public static final class Utils {
        public static void validate(CharSequence text, int startIndex, int endIndex, boolean allowInMainThread) {
            Preconditions.checkArgument(text != null);
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex <= text.length());
            Preconditions.checkArgument(endIndex > startIndex);
            Utils.checkMainThread(allowInMainThread);
        }

        public static void validate(CharSequence text, boolean allowInMainThread) {
            Preconditions.checkArgument(text != null);
            Utils.checkMainThread(allowInMainThread);
        }

        private static void checkMainThread(boolean allowInMainThread) {
            if (!allowInMainThread && Looper.myLooper() == Looper.getMainLooper()) {
                Slog.w(TextClassifier.DEFAULT_LOG_TAG, "TextClassifier called on main thread");
            }
        }
    }

    public static final class EntityConfig
    implements Parcelable {
        private final int mEntityPreset;
        private final Collection<String> mExcludedEntityTypes;
        private final Collection<String> mIncludedEntityTypes;
        public static final Parcelable.Creator<EntityConfig> CREATOR = new Parcelable.Creator<EntityConfig>(){

            @Override
            public EntityConfig createFromParcel(Parcel in) {
                return new EntityConfig(in);
            }

            public EntityConfig[] newArray(int size) {
                return new EntityConfig[size];
            }
        };

        public EntityConfig(int mEntityPreset) {
            this.mEntityPreset = mEntityPreset;
            this.mExcludedEntityTypes = new ArraySet<String>();
            this.mIncludedEntityTypes = new ArraySet<String>();
        }

        public EntityConfig includeEntities(String ... entities) {
            for (String entity : entities) {
                this.mIncludedEntityTypes.add(entity);
            }
            return this;
        }

        public EntityConfig excludeEntities(String ... entities) {
            for (String entity : entities) {
                this.mExcludedEntityTypes.add(entity);
            }
            return this;
        }

        public List<String> getEntities(TextClassifier textClassifier) {
            ArrayList<String> entities = new ArrayList<String>();
            for (String entity : textClassifier.getEntitiesForPreset(this.mEntityPreset)) {
                if (this.mExcludedEntityTypes.contains(entity)) continue;
                entities.add(entity);
            }
            for (String entity : this.mIncludedEntityTypes) {
                if (this.mExcludedEntityTypes.contains(entity) || entities.contains(entity)) continue;
                entities.add(entity);
            }
            return Collections.unmodifiableList(entities);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mEntityPreset);
            dest.writeStringList(new ArrayList<String>(this.mExcludedEntityTypes));
            dest.writeStringList(new ArrayList<String>(this.mIncludedEntityTypes));
        }

        private EntityConfig(Parcel in) {
            this.mEntityPreset = in.readInt();
            this.mExcludedEntityTypes = new ArraySet<String>(in.createStringArrayList());
            this.mIncludedEntityTypes = new ArraySet<String>(in.createStringArrayList());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntityPreset {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntityType {
    }
}

