/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.ComponentName;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.os.UserManager;
import android.provider.CalendarContract;
import android.provider.Settings;
import android.text.util.Linkify;
import android.util.Patterns;
import android.view.textclassifier.Log;
import android.view.textclassifier.SmartSelection;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierConstants;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import android.view.textclassifier.logging.DefaultLogger;
import android.view.textclassifier.logging.Logger;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextClassifierImpl
implements TextClassifier {
    private static final String LOG_TAG = "androidtc";
    private static final String MODEL_DIR = "/etc/textclassifier/";
    private static final String MODEL_FILE_REGEX = "textclassifier\\.(.*)\\.model";
    private static final String UPDATED_MODEL_FILE_PATH = "/data/misc/textclassifier/textclassifier.model";
    private static final List<String> ENTITY_TYPES_ALL = Collections.unmodifiableList(Arrays.asList("address", "email", "phone", "url", "date", "datetime", "flight"));
    private static final List<String> ENTITY_TYPES_BASE = Collections.unmodifiableList(Arrays.asList("address", "email", "phone", "url"));
    private final Context mContext;
    private final TextClassifier mFallback;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private List<ModelFile> mAllModelFiles;
    @GuardedBy(value="mLock")
    private ModelFile mModel;
    @GuardedBy(value="mLock")
    private SmartSelection mSmartSelection;
    private final Object mLoggerLock = new Object();
    @GuardedBy(value="mLoggerLock")
    private WeakReference<Logger.Config> mLoggerConfig = new WeakReference<Object>(null);
    @GuardedBy(value="mLoggerLock")
    private Logger mLogger;
    private TextClassifierConstants mSettings;

    public TextClassifierImpl(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mFallback = TextClassifier.NO_OP;
    }

    @Override
    public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options) {
        TextClassifier.Utils.validate(text, selectionStartIndex, selectionEndIndex, false);
        try {
            if (text.length() > 0) {
                int end;
                int start;
                LocaleList locales = options == null ? null : options.getDefaultLocales();
                boolean darkLaunchAllowed = options != null && options.isDarkLaunchAllowed();
                SmartSelection smartSelection = this.getSmartSelection(locales);
                String string2 = text.toString();
                if (this.getSettings().isDarkLaunch() && !darkLaunchAllowed) {
                    start = selectionStartIndex;
                    end = selectionEndIndex;
                } else {
                    int[] startEnd = smartSelection.suggest(string2, selectionStartIndex, selectionEndIndex);
                    start = startEnd[0];
                    end = startEnd[1];
                }
                if (start < end && start >= 0 && end <= string2.length() && start <= selectionStartIndex && end >= selectionEndIndex) {
                    TextSelection.Builder tsBuilder = new TextSelection.Builder(start, end);
                    SmartSelection.ClassificationResult[] results = smartSelection.classifyText(string2, start, end, TextClassifierImpl.getHintFlags(string2, start, end));
                    int size = results.length;
                    for (int i = 0; i < size; ++i) {
                        tsBuilder.setEntityType(results[i].mCollection, results[i].mScore);
                    }
                    return tsBuilder.setSignature(this.getSignature(string2, selectionStartIndex, selectionEndIndex)).build();
                }
                Log.d(LOG_TAG, "Got bad indices for input text. Ignoring result.");
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error suggesting selection for text. No changes to selection suggested.", t);
        }
        return this.mFallback.suggestSelection(text, selectionStartIndex, selectionEndIndex, options);
    }

    @Override
    public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options) {
        TextClassifier.Utils.validate(text, startIndex, endIndex, false);
        try {
            if (text.length() > 0) {
                String string2 = text.toString();
                LocaleList locales = options == null ? null : options.getDefaultLocales();
                Calendar refTime = options == null ? null : options.getReferenceTime();
                SmartSelection.ClassificationResult[] results = this.getSmartSelection(locales).classifyText(string2, startIndex, endIndex, TextClassifierImpl.getHintFlags(string2, startIndex, endIndex));
                if (results.length > 0) {
                    return this.createClassificationResult(results, string2, startIndex, endIndex, refTime);
                }
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting text classification info.", t);
        }
        return this.mFallback.classifyText(text, startIndex, endIndex, options);
    }

    @Override
    public TextLinks generateLinks(CharSequence text, TextLinks.Options options) {
        TextClassifier.Utils.validate(text, false);
        String textString = text.toString();
        TextLinks.Builder builder = new TextLinks.Builder(textString);
        if (!this.getSettings().isSmartLinkifyEnabled()) {
            return builder.build();
        }
        try {
            SmartSelection.AnnotatedSpan[] annotations;
            LocaleList defaultLocales = options != null ? options.getDefaultLocales() : null;
            List<String> entitiesToIdentify = options != null && options.getEntityConfig() != null ? options.getEntityConfig().getEntities(this) : ENTITY_TYPES_ALL;
            SmartSelection smartSelection = this.getSmartSelection(defaultLocales);
            for (SmartSelection.AnnotatedSpan span : annotations = smartSelection.annotate(textString)) {
                SmartSelection.ClassificationResult[] results = span.getClassification();
                if (results.length == 0 || !entitiesToIdentify.contains(results[0].mCollection)) continue;
                HashMap<String, Float> entityScores = new HashMap<String, Float>();
                for (int i = 0; i < results.length; ++i) {
                    entityScores.put(results[i].mCollection, Float.valueOf(results[i].mScore));
                }
                builder.addLink(span.getStartIndex(), span.getEndIndex(), entityScores);
            }
            return builder.build();
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting links info.", t);
            return this.mFallback.generateLinks(text, options);
        }
    }

    @Override
    public Collection<String> getEntitiesForPreset(int entityPreset) {
        switch (entityPreset) {
            case 1: {
                return Collections.emptyList();
            }
            case 2: {
                return ENTITY_TYPES_BASE;
            }
        }
        return ENTITY_TYPES_ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getLogger(Logger.Config config) {
        Preconditions.checkNotNull(config);
        Object object = this.mLoggerLock;
        synchronized (object) {
            if (this.mLoggerConfig.get() == null || !((Logger.Config)this.mLoggerConfig.get()).equals(config)) {
                this.mLoggerConfig = new WeakReference<Logger.Config>(config);
                this.mLogger = new DefaultLogger(config);
            }
            return this.mLogger;
        }
    }

    @Override
    public TextClassifierConstants getSettings() {
        if (this.mSettings == null) {
            this.mSettings = TextClassifierConstants.loadFromString(Settings.Global.getString(this.mContext.getContentResolver(), "text_classifier_constants"));
        }
        return this.mSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmartSelection getSmartSelection(LocaleList localeList) throws FileNotFoundException {
        Object object = this.mLock;
        synchronized (object) {
            localeList = localeList == null ? LocaleList.getEmptyLocaleList() : localeList;
            ModelFile bestModel = this.findBestModelLocked(localeList);
            if (bestModel == null) {
                throw new FileNotFoundException("No model for " + localeList.toLanguageTags());
            }
            if (this.mSmartSelection == null || !Objects.equals(this.mModel, bestModel)) {
                Log.d(LOG_TAG, "Loading " + bestModel);
                this.destroySmartSelectionIfExistsLocked();
                ParcelFileDescriptor fd = ParcelFileDescriptor.open(new File(bestModel.getPath()), 0x10000000);
                this.mSmartSelection = new SmartSelection(fd.getFd());
                TextClassifierImpl.closeAndLogError(fd);
                this.mModel = bestModel;
            }
            return this.mSmartSelection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSignature(String text, int start, int end) {
        Object object = this.mLock;
        synchronized (object) {
            return DefaultLogger.createSignature(text, start, end, this.mContext, this.mModel.getVersion(), this.mModel.getSupportedLocales());
        }
    }

    @GuardedBy(value="mLock")
    private void destroySmartSelectionIfExistsLocked() {
        if (this.mSmartSelection != null) {
            this.mSmartSelection.close();
            this.mSmartSelection = null;
        }
    }

    @GuardedBy(value="mLock")
    private ModelFile findBestModelLocked(LocaleList localeList) {
        String languages = localeList.isEmpty() ? LocaleList.getDefault().toLanguageTags() : localeList.toLanguageTags() + "," + LocaleList.getDefault().toLanguageTags();
        List<Locale.LanguageRange> languageRangeList = Locale.LanguageRange.parse(languages);
        ModelFile bestModel = null;
        int bestModelVersion = -1;
        for (ModelFile model : this.listAllModelsLocked()) {
            if (!model.isAnyLanguageSupported(languageRangeList) || model.getVersion() < bestModelVersion) continue;
            bestModel = model;
            bestModelVersion = model.getVersion();
        }
        return bestModel;
    }

    @GuardedBy(value="mLock")
    private List<ModelFile> listAllModelsLocked() {
        if (this.mAllModelFiles == null) {
            File modelsDir;
            ModelFile updatedModel;
            ArrayList<ModelFile> allModels = new ArrayList<ModelFile>();
            if (new File(UPDATED_MODEL_FILE_PATH).exists() && (updatedModel = ModelFile.fromPath(UPDATED_MODEL_FILE_PATH)) != null) {
                allModels.add(updatedModel);
            }
            if ((modelsDir = new File(MODEL_DIR)).exists() && modelsDir.isDirectory()) {
                File[] modelFiles = modelsDir.listFiles();
                Pattern modelFilenamePattern = Pattern.compile(MODEL_FILE_REGEX);
                for (File modelFile : modelFiles) {
                    ModelFile model;
                    Matcher matcher = modelFilenamePattern.matcher(modelFile.getName());
                    if (!matcher.matches() || !modelFile.isFile() || (model = ModelFile.fromPath(modelFile.getAbsolutePath())) == null) continue;
                    allModels.add(model);
                }
            }
            this.mAllModelFiles = allModels;
        }
        return this.mAllModelFiles;
    }

    private TextClassification createClassificationResult(SmartSelection.ClassificationResult[] classifications, String text, int start, int end, Calendar referenceTime) {
        String classifiedText = text.substring(start, end);
        TextClassification.Builder builder = new TextClassification.Builder().setText(classifiedText);
        int size = classifications.length;
        SmartSelection.ClassificationResult highestScoringResult = null;
        float highestScore = Float.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            builder.setEntityType(classifications[i].mCollection, classifications[i].mScore);
            if (!(classifications[i].mScore > highestScore)) continue;
            highestScoringResult = classifications[i];
            highestScore = classifications[i].mScore;
        }
        this.addActions(builder, IntentFactory.create(this.mContext, referenceTime, highestScoringResult, classifiedText));
        return builder.setSignature(this.getSignature(text, start, end)).build();
    }

    private void addActions(TextClassification.Builder builder, List<Intent> intents) {
        PackageManager pm = this.mContext.getPackageManager();
        int size = intents.size();
        for (int i = 0; i < size; ++i) {
            Drawable icon;
            Intent intent = intents.get(i);
            ResolveInfo resolveInfo = intent != null ? pm.resolveActivity(intent, 0) : null;
            if (resolveInfo == null || resolveInfo.activityInfo == null) continue;
            String packageName = resolveInfo.activityInfo.packageName;
            String label = IntentFactory.getLabel(this.mContext, intent);
            if ("android".equals(packageName)) {
                icon = null;
            } else {
                intent.setComponent(new ComponentName(packageName, resolveInfo.activityInfo.name));
                icon = resolveInfo.activityInfo.loadIcon(pm);
                if (icon == null) {
                    icon = resolveInfo.loadIcon(pm);
                }
            }
            if (i == 0) {
                builder.setPrimaryAction(intent, label, icon);
                continue;
            }
            builder.addSecondaryAction(intent, label, icon);
        }
    }

    private static int getHintFlags(CharSequence text, int start, int end) {
        int flag = 0;
        CharSequence subText = text.subSequence(start, end);
        if (Patterns.AUTOLINK_EMAIL_ADDRESS.matcher(subText).matches()) {
            flag |= 2;
        }
        if (Patterns.AUTOLINK_WEB_URL.matcher(subText).matches() && Linkify.sUrlMatchFilter.acceptMatch(text, start, end)) {
            flag |= 1;
        }
        return flag;
    }

    private static void closeAndLogError(ParcelFileDescriptor fd) {
        try {
            fd.close();
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Error closing file.", e);
        }
    }

    static final class IntentFactory {
        private static final long MIN_EVENT_FUTURE_MILLIS = TimeUnit.MINUTES.toMillis(5L);
        private static final long DEFAULT_EVENT_DURATION = TimeUnit.HOURS.toMillis(1L);

        private IntentFactory() {
        }

        public static List<Intent> create(Context context, Calendar referenceTime, SmartSelection.ClassificationResult classification, String text) {
            String type = classification.mCollection.trim().toLowerCase(Locale.ENGLISH);
            text = text.trim();
            switch (type) {
                case "email": {
                    return IntentFactory.createForEmail(text);
                }
                case "phone": {
                    return IntentFactory.createForPhone(context, text);
                }
                case "address": {
                    return IntentFactory.createForAddress(text);
                }
                case "url": {
                    return IntentFactory.createForUrl(context, text);
                }
                case "date": 
                case "datetime": {
                    if (classification.mDatetime != null) {
                        Calendar eventTime = Calendar.getInstance();
                        eventTime.setTimeInMillis(classification.mDatetime.mMsSinceEpoch);
                        return IntentFactory.createForDatetime(type, referenceTime, eventTime);
                    }
                    return new ArrayList<Intent>();
                }
                case "flight": {
                    return IntentFactory.createForFlight(text);
                }
            }
            return new ArrayList<Intent>();
        }

        private static List<Intent> createForEmail(String text) {
            return Arrays.asList(new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("mailto:%s", text))), new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("email", text));
        }

        private static List<Intent> createForPhone(Context context, String text) {
            Bundle userRestrictions;
            ArrayList<Intent> intents = new ArrayList<Intent>();
            UserManager userManager = context.getSystemService(UserManager.class);
            Bundle bundle = userRestrictions = userManager != null ? userManager.getUserRestrictions() : new Bundle();
            if (!userRestrictions.getBoolean("no_outgoing_calls", false)) {
                intents.add(new Intent("android.intent.action.DIAL").setData(Uri.parse(String.format("tel:%s", text))));
            }
            intents.add(new Intent("android.intent.action.INSERT_OR_EDIT").setType("vnd.android.cursor.item/contact").putExtra("phone", text));
            if (!userRestrictions.getBoolean("no_sms", false)) {
                intents.add(new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("smsto:%s", text))));
            }
            return intents;
        }

        private static List<Intent> createForAddress(String text) {
            return Arrays.asList(new Intent("android.intent.action.VIEW").setData(Uri.parse(String.format("geo:0,0?q=%s", text))));
        }

        private static List<Intent> createForUrl(Context context, String text) {
            String httpPrefix = "http://";
            String httpsPrefix = "https://";
            text = text.toLowerCase().startsWith("http://") ? "http://" + text.substring("http://".length()) : (text.toLowerCase().startsWith("https://") ? "https://" + text.substring("https://".length()) : "http://" + text);
            return Arrays.asList(new Intent("android.intent.action.VIEW", Uri.parse(text)).putExtra("com.android.browser.application_id", context.getPackageName()));
        }

        private static List<Intent> createForDatetime(String type, Calendar referenceTime, Calendar eventTime) {
            if (referenceTime == null) {
                referenceTime = Calendar.getInstance();
            }
            ArrayList<Intent> intents = new ArrayList<Intent>();
            intents.add(IntentFactory.createCalendarViewIntent(eventTime));
            long millisSinceReference = eventTime.getTimeInMillis() - referenceTime.getTimeInMillis();
            if (millisSinceReference > MIN_EVENT_FUTURE_MILLIS) {
                intents.add(IntentFactory.createCalendarCreateEventIntent(eventTime, type));
            }
            return intents;
        }

        private static List<Intent> createForFlight(String text) {
            return Arrays.asList(new Intent("android.intent.action.WEB_SEARCH").putExtra("query", text));
        }

        private static Intent createCalendarViewIntent(Calendar eventTime) {
            Uri.Builder builder = CalendarContract.CONTENT_URI.buildUpon();
            builder.appendPath("time");
            ContentUris.appendId(builder, eventTime.getTimeInMillis());
            return new Intent("android.intent.action.VIEW").setData(builder.build());
        }

        private static Intent createCalendarCreateEventIntent(Calendar eventTime, String type) {
            boolean isAllDay = "date".equals(type);
            return new Intent("android.intent.action.INSERT").setData(CalendarContract.Events.CONTENT_URI).putExtra("allDay", isAllDay).putExtra("beginTime", eventTime.getTimeInMillis()).putExtra("endTime", eventTime.getTimeInMillis() + DEFAULT_EVENT_DURATION);
        }

        public static String getLabel(Context context, Intent intent) {
            if (intent == null || intent.getAction() == null) {
                return null;
            }
            String authority = intent.getData() == null ? null : intent.getData().getAuthority();
            switch (intent.getAction()) {
                case "android.intent.action.DIAL": {
                    return context.getString(17039791);
                }
                case "android.intent.action.SENDTO": {
                    if ("mailto".equals(intent.getScheme())) {
                        return context.getString(17039811);
                    }
                    if ("smsto".equals(intent.getScheme())) {
                        return context.getString(17040847);
                    }
                    return null;
                }
                case "android.intent.action.INSERT": {
                    if ("com.android.calendar".equals(authority)) {
                        return context.getString(17039448);
                    }
                    return null;
                }
                case "android.intent.action.INSERT_OR_EDIT": {
                    if ("vnd.android.cursor.item/contact".equals(intent.getType())) {
                        return context.getString(17039449);
                    }
                    return null;
                }
                case "android.intent.action.VIEW": {
                    if ("com.android.calendar".equals(authority)) {
                        return context.getString(17040986);
                    }
                    if ("geo".equals(intent.getScheme())) {
                        return context.getString(17040184);
                    }
                    if ("http".equals(intent.getScheme()) || "https".equals(intent.getScheme())) {
                        return context.getString(17039577);
                    }
                    return null;
                }
                case "android.intent.action.WEB_SEARCH": {
                    return context.getString(17040987);
                }
            }
            return null;
        }
    }

    private static final class ModelFile {
        private final String mPath;
        private final String mName;
        private final int mVersion;
        private final List<Locale> mSupportedLocales;

        static ModelFile fromPath(String path) {
            File file = new File(path);
            try {
                ParcelFileDescriptor modelFd = ParcelFileDescriptor.open(file, 0x10000000);
                int version = SmartSelection.getVersion(modelFd.getFd());
                String supportedLocalesStr = SmartSelection.getLanguages(modelFd.getFd());
                if (supportedLocalesStr.isEmpty()) {
                    Log.d(TextClassifierImpl.LOG_TAG, "Ignoring " + file.getAbsolutePath());
                    return null;
                }
                ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
                for (String langTag : supportedLocalesStr.split(",")) {
                    supportedLocales.add(Locale.forLanguageTag(langTag));
                }
                TextClassifierImpl.closeAndLogError(modelFd);
                return new ModelFile(path, file.getName(), version, supportedLocales);
            }
            catch (FileNotFoundException e) {
                Log.e(TextClassifierImpl.LOG_TAG, "Failed to peek " + file.getAbsolutePath(), e);
                return null;
            }
        }

        String getPath() {
            return this.mPath;
        }

        String getName() {
            return this.mName;
        }

        int getVersion() {
            return this.mVersion;
        }

        boolean isAnyLanguageSupported(List<Locale.LanguageRange> languageRanges) {
            return Locale.lookup(languageRanges, this.mSupportedLocales) != null;
        }

        List<Locale> getSupportedLocales() {
            return Collections.unmodifiableList(this.mSupportedLocales);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !ModelFile.class.isAssignableFrom(other.getClass())) {
                return false;
            }
            ModelFile otherModel = (ModelFile)other;
            return this.mPath.equals(otherModel.mPath);
        }

        public String toString() {
            StringJoiner localesJoiner = new StringJoiner(",");
            for (Locale locale : this.mSupportedLocales) {
                localesJoiner.add(locale.toLanguageTag());
            }
            return String.format(Locale.US, "ModelFile { path=%s name=%s version=%d locales=%s }", this.mPath, this.mName, this.mVersion, localesJoiner.toString());
        }

        private ModelFile(String path, String name, int version, List<Locale> supportedLocales) {
            this.mPath = path;
            this.mName = name;
            this.mVersion = version;
            this.mSupportedLocales = supportedLocales;
        }
    }
}

