/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.TextClassifier;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class TextLinks
implements Parcelable {
    public static final int STATUS_LINKS_APPLIED = 0;
    public static final int STATUS_NO_LINKS_FOUND = 1;
    public static final int STATUS_NO_LINKS_APPLIED = 2;
    public static final int STATUS_DIFFERENT_TEXT = 3;
    public static final int APPLY_STRATEGY_IGNORE = 0;
    public static final int APPLY_STRATEGY_REPLACE = 1;
    private final String mFullText;
    private final List<TextLink> mLinks;
    public static final Parcelable.Creator<TextLinks> CREATOR = new Parcelable.Creator<TextLinks>(){

        @Override
        public TextLinks createFromParcel(Parcel in) {
            return new TextLinks(in);
        }

        public TextLinks[] newArray(int size) {
            return new TextLinks[size];
        }
    };
    private static final Function<TextLink, TextLinkSpan> DEFAULT_SPAN_FACTORY = textLink -> new TextLinkSpan((TextLink)textLink);

    private TextLinks(String fullText, ArrayList<TextLink> links) {
        this.mFullText = fullText;
        this.mLinks = Collections.unmodifiableList(links);
    }

    public Collection<TextLink> getLinks() {
        return this.mLinks;
    }

    public int apply(Spannable text, int applyStrategy, Function<TextLink, TextLinkSpan> spanFactory) {
        Preconditions.checkNotNull(text);
        TextLinks.checkValidApplyStrategy(applyStrategy);
        if (!this.mFullText.equals(text.toString())) {
            return 3;
        }
        if (this.mLinks.isEmpty()) {
            return 1;
        }
        if (spanFactory == null) {
            spanFactory = DEFAULT_SPAN_FACTORY;
        }
        int applyCount = 0;
        for (TextLink link : this.mLinks) {
            TextLinkSpan span = spanFactory.apply(link);
            if (span == null) continue;
            ClickableSpan[] existingSpans = text.getSpans(link.getStart(), link.getEnd(), ClickableSpan.class);
            if (existingSpans.length > 0) {
                if (applyStrategy != 1) continue;
                for (ClickableSpan existingSpan : existingSpans) {
                    text.removeSpan(existingSpan);
                }
                text.setSpan(span, link.getStart(), link.getEnd(), 33);
                ++applyCount;
                continue;
            }
            text.setSpan(span, link.getStart(), link.getEnd(), 33);
            ++applyCount;
        }
        if (applyCount == 0) {
            return 2;
        }
        return 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mFullText);
        dest.writeTypedList(this.mLinks);
    }

    private TextLinks(Parcel in) {
        this.mFullText = in.readString();
        this.mLinks = in.createTypedArrayList(TextLink.CREATOR);
    }

    private static void checkValidApplyStrategy(int applyStrategy) {
        if (applyStrategy != 0 && applyStrategy != 1) {
            throw new IllegalArgumentException("Invalid apply strategy. See TextLinks.ApplyStrategy for options.");
        }
    }

    public static final class Builder {
        private final String mFullText;
        private final ArrayList<TextLink> mLinks;

        public Builder(String fullText) {
            this.mFullText = Preconditions.checkNotNull(fullText);
            this.mLinks = new ArrayList();
        }

        public Builder addLink(int start, int end, Map<String, Float> entityScores) {
            this.mLinks.add(new TextLink(start, end, entityScores));
            return this;
        }

        public Builder clearTextLinks() {
            this.mLinks.clear();
            return this;
        }

        public TextLinks build() {
            return new TextLinks(this.mFullText, this.mLinks);
        }
    }

    public static class TextLinkSpan
    extends ClickableSpan {
        private final TextLink mTextLink;

        public TextLinkSpan(TextLink textLink) {
            this.mTextLink = textLink;
        }

        @Override
        public void onClick(View widget) {
            if (widget instanceof TextView) {
                TextView textView = (TextView)widget;
                textView.requestActionMode(this.mTextLink);
            }
        }

        public final TextLink getTextLink() {
            return this.mTextLink;
        }
    }

    public static final class Options
    implements Parcelable {
        private LocaleList mDefaultLocales;
        private TextClassifier.EntityConfig mEntityConfig;
        private int mApplyStrategy;
        private Function<TextLink, TextLinkSpan> mSpanFactory;
        public static final Parcelable.Creator<Options> CREATOR = new Parcelable.Creator<Options>(){

            @Override
            public Options createFromParcel(Parcel in) {
                return new Options(in);
            }

            public Options[] newArray(int size) {
                return new Options[size];
            }
        };

        public static Options fromLinkMask(int mask) {
            TextClassifier.EntityConfig entityConfig = new TextClassifier.EntityConfig(1);
            if ((mask & 1) != 0) {
                entityConfig.includeEntities("url");
            }
            if ((mask & 2) != 0) {
                entityConfig.includeEntities("email");
            }
            if ((mask & 4) != 0) {
                entityConfig.includeEntities("phone");
            }
            if ((mask & 8) != 0) {
                entityConfig.includeEntities("address");
            }
            return new Options().setEntityConfig(entityConfig);
        }

        public Options() {
        }

        public Options setDefaultLocales(LocaleList defaultLocales) {
            this.mDefaultLocales = defaultLocales;
            return this;
        }

        public Options setEntityConfig(TextClassifier.EntityConfig entityConfig) {
            this.mEntityConfig = entityConfig;
            return this;
        }

        public Options setApplyStrategy(int applyStrategy) {
            TextLinks.checkValidApplyStrategy(applyStrategy);
            this.mApplyStrategy = applyStrategy;
            return this;
        }

        public Options setSpanFactory(Function<TextLink, TextLinkSpan> spanFactory) {
            this.mSpanFactory = spanFactory;
            return this;
        }

        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        public TextClassifier.EntityConfig getEntityConfig() {
            return this.mEntityConfig;
        }

        public int getApplyStrategy() {
            return this.mApplyStrategy;
        }

        public Function<TextLink, TextLinkSpan> getSpanFactory() {
            return this.mSpanFactory;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mDefaultLocales != null ? 1 : 0);
            if (this.mDefaultLocales != null) {
                this.mDefaultLocales.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mEntityConfig != null ? 1 : 0);
            if (this.mEntityConfig != null) {
                this.mEntityConfig.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mApplyStrategy);
        }

        private Options(Parcel in) {
            if (in.readInt() > 0) {
                this.mDefaultLocales = LocaleList.CREATOR.createFromParcel(in);
            }
            if (in.readInt() > 0) {
                this.mEntityConfig = TextClassifier.EntityConfig.CREATOR.createFromParcel(in);
            }
            this.mApplyStrategy = in.readInt();
        }
    }

    public static final class TextLink
    implements Parcelable {
        private final EntityConfidence mEntityScores;
        private final int mStart;
        private final int mEnd;
        public static final Parcelable.Creator<TextLink> CREATOR = new Parcelable.Creator<TextLink>(){

            @Override
            public TextLink createFromParcel(Parcel in) {
                return new TextLink(in);
            }

            public TextLink[] newArray(int size) {
                return new TextLink[size];
            }
        };

        TextLink(int start, int end, Map<String, Float> entityScores) {
            Preconditions.checkNotNull(entityScores);
            Preconditions.checkArgument(!entityScores.isEmpty());
            Preconditions.checkArgument(start <= end);
            this.mStart = start;
            this.mEnd = end;
            this.mEntityScores = new EntityConfidence(entityScores);
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getEntityCount() {
            return this.mEntityScores.getEntities().size();
        }

        public String getEntity(int index) {
            return this.mEntityScores.getEntities().get(index);
        }

        public float getConfidenceScore(String entityType) {
            return this.mEntityScores.getConfidenceScore(entityType);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mEntityScores.writeToParcel(dest, flags);
            dest.writeInt(this.mStart);
            dest.writeInt(this.mEnd);
        }

        private TextLink(Parcel in) {
            this.mEntityScores = EntityConfidence.CREATOR.createFromParcel(in);
            this.mStart = in.readInt();
            this.mEnd = in.readInt();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplyStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

