/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.textclassifier.EntityConfidence;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Map;

public final class TextSelection
implements Parcelable {
    private final int mStartIndex;
    private final int mEndIndex;
    private final EntityConfidence mEntityConfidence;
    private final String mSignature;
    public static final Parcelable.Creator<TextSelection> CREATOR = new Parcelable.Creator<TextSelection>(){

        @Override
        public TextSelection createFromParcel(Parcel in) {
            return new TextSelection(in);
        }

        public TextSelection[] newArray(int size) {
            return new TextSelection[size];
        }
    };

    private TextSelection(int startIndex, int endIndex, Map<String, Float> entityConfidence, String signature) {
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mEntityConfidence = new EntityConfidence(entityConfidence);
        this.mSignature = signature;
    }

    public int getSelectionStartIndex() {
        return this.mStartIndex;
    }

    public int getSelectionEndIndex() {
        return this.mEndIndex;
    }

    public int getEntityCount() {
        return this.mEntityConfidence.getEntities().size();
    }

    public String getEntity(int index) {
        return this.mEntityConfidence.getEntities().get(index);
    }

    public float getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    public String getSignature() {
        return this.mSignature;
    }

    public String toString() {
        return String.format(Locale.US, "TextSelection {startIndex=%d, endIndex=%d, entities=%s, signature=%s}", this.mStartIndex, this.mEndIndex, this.mEntityConfidence, this.mSignature);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStartIndex);
        dest.writeInt(this.mEndIndex);
        this.mEntityConfidence.writeToParcel(dest, flags);
        dest.writeString(this.mSignature);
    }

    private TextSelection(Parcel in) {
        this.mStartIndex = in.readInt();
        this.mEndIndex = in.readInt();
        this.mEntityConfidence = EntityConfidence.CREATOR.createFromParcel(in);
        this.mSignature = in.readString();
    }

    public static final class Options
    implements Parcelable {
        private LocaleList mDefaultLocales;
        private boolean mDarkLaunchAllowed;
        public static final Parcelable.Creator<Options> CREATOR = new Parcelable.Creator<Options>(){

            @Override
            public Options createFromParcel(Parcel in) {
                return new Options(in);
            }

            public Options[] newArray(int size) {
                return new Options[size];
            }
        };

        public Options() {
        }

        public Options setDefaultLocales(LocaleList defaultLocales) {
            this.mDefaultLocales = defaultLocales;
            return this;
        }

        public LocaleList getDefaultLocales() {
            return this.mDefaultLocales;
        }

        public void setDarkLaunchAllowed(boolean allowed) {
            this.mDarkLaunchAllowed = allowed;
        }

        public boolean isDarkLaunchAllowed() {
            return this.mDarkLaunchAllowed;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mDefaultLocales != null ? 1 : 0);
            if (this.mDefaultLocales != null) {
                this.mDefaultLocales.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mDarkLaunchAllowed ? 1 : 0);
        }

        private Options(Parcel in) {
            if (in.readInt() > 0) {
                this.mDefaultLocales = LocaleList.CREATOR.createFromParcel(in);
            }
            this.mDarkLaunchAllowed = in.readInt() != 0;
        }
    }

    public static final class Builder {
        private final int mStartIndex;
        private final int mEndIndex;
        private final Map<String, Float> mEntityConfidence = new ArrayMap<String, Float>();
        private String mSignature = "";

        public Builder(int startIndex, int endIndex) {
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex > startIndex);
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
        }

        public Builder setEntityType(String type, float confidenceScore) {
            this.mEntityConfidence.put(type, Float.valueOf(confidenceScore));
            return this;
        }

        public Builder setSignature(String signature) {
            this.mSignature = Preconditions.checkNotNull(signature);
            return this;
        }

        public TextSelection build() {
            return new TextSelection(this.mStartIndex, this.mEndIndex, this.mEntityConfidence, this.mSignature);
        }
    }
}

