/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier.logging;

import android.content.Context;
import android.util.Log;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextSelection;
import android.view.textclassifier.logging.SelectionEvent;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public abstract class Logger {
    public static final int OUT_OF_BOUNDS = Integer.MAX_VALUE;
    public static final int OUT_OF_BOUNDS_NEGATIVE = Integer.MIN_VALUE;
    private static final String LOG_TAG = "Logger";
    static final boolean DEBUG_LOG_ENABLED = true;
    private static final String NO_SIGNATURE = "";
    public static final String WIDGET_TEXTVIEW = "textview";
    public static final String WIDGET_EDITTEXT = "edittext";
    public static final String WIDGET_UNSELECTABLE_TEXTVIEW = "nosel-textview";
    public static final String WIDGET_WEBVIEW = "webview";
    public static final String WIDGET_EDIT_WEBVIEW = "edit-webview";
    public static final String WIDGET_CUSTOM_TEXTVIEW = "customview";
    public static final String WIDGET_CUSTOM_EDITTEXT = "customedit";
    public static final String WIDGET_CUSTOM_UNSELECTABLE_TEXTVIEW = "nosel-customview";
    public static final String WIDGET_UNKNOWN = "unknown";
    private SelectionEvent mPrevEvent;
    private SelectionEvent mSmartEvent;
    private SelectionEvent mStartEvent;
    public static final Logger DISABLED = new Logger(){

        @Override
        public void writeEvent(SelectionEvent event) {
        }
    };
    private final Config mConfig;

    public Logger(Config config) {
        this.mConfig = Preconditions.checkNotNull(config);
    }

    private Logger() {
        this.mConfig = null;
    }

    public abstract void writeEvent(SelectionEvent var1);

    public boolean isSmartSelection(String signature) {
        return false;
    }

    public BreakIterator getTokenIterator(Locale locale) {
        return BreakIterator.getWordInstance(Preconditions.checkNotNull(locale));
    }

    public final void logSelectionStartedEvent(int start) {
        if (this.mConfig == null) {
            return;
        }
        this.logEvent(new SelectionEvent(start, start + 1, 1, NO_SIGNATURE, NO_SIGNATURE, this.mConfig));
    }

    public final void logSelectionModifiedEvent(int start, int end) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        if (this.mConfig == null) {
            return;
        }
        this.logEvent(new SelectionEvent(start, end, 2, NO_SIGNATURE, NO_SIGNATURE, this.mConfig));
    }

    public final void logSelectionModifiedEvent(int start, int end, TextClassification classification) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        Preconditions.checkNotNull(classification);
        if (this.mConfig == null) {
            return;
        }
        String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : NO_SIGNATURE;
        String signature = classification.getSignature();
        this.logEvent(new SelectionEvent(start, end, 2, entityType, signature, this.mConfig));
    }

    public final void logSelectionModifiedEvent(int start, int end, TextSelection selection) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        Preconditions.checkNotNull(selection);
        if (this.mConfig == null) {
            return;
        }
        int eventType = this.isSmartSelection(selection.getSignature()) ? (end - start > 1 ? 4 : 3) : 5;
        String entityType = selection.getEntityCount() > 0 ? selection.getEntity(0) : NO_SIGNATURE;
        String signature = selection.getSignature();
        this.logEvent(new SelectionEvent(start, end, eventType, entityType, signature, this.mConfig));
    }

    public final void logSelectionActionEvent(int start, int end, int actionType) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        Logger.checkActionType(actionType);
        if (this.mConfig == null) {
            return;
        }
        this.logEvent(new SelectionEvent(start, end, actionType, NO_SIGNATURE, NO_SIGNATURE, this.mConfig));
    }

    public final void logSelectionActionEvent(int start, int end, int actionType, TextClassification classification) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        Preconditions.checkNotNull(classification);
        Logger.checkActionType(actionType);
        if (this.mConfig == null) {
            return;
        }
        String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : NO_SIGNATURE;
        String signature = classification.getSignature();
        this.logEvent(new SelectionEvent(start, end, actionType, entityType, signature, this.mConfig));
    }

    private void logEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        if (event.getEventType() != 1 && this.mStartEvent == null) {
            Log.d(LOG_TAG, "Selection session not yet started. Ignoring event");
            return;
        }
        long now = System.currentTimeMillis();
        switch (event.getEventType()) {
            case 1: {
                Preconditions.checkArgument(event.getAbsoluteEnd() == event.getAbsoluteStart() + 1);
                event.setSessionId(this.startNewSession());
                this.mStartEvent = event;
                break;
            }
            case 3: 
            case 4: {
                this.mSmartEvent = event;
                break;
            }
            case 2: 
            case 5: {
                if (this.mPrevEvent == null || this.mPrevEvent.getAbsoluteStart() != event.getAbsoluteStart() || this.mPrevEvent.getAbsoluteEnd() != event.getAbsoluteEnd()) break;
                return;
            }
        }
        event.setEventTime(now);
        if (this.mStartEvent != null) {
            event.setSessionId(this.mStartEvent.getSessionId()).setDurationSinceSessionStart(now - this.mStartEvent.getEventTime()).setStart(event.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setEnd(event.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
        }
        if (this.mSmartEvent != null) {
            event.setSignature(this.mSmartEvent.getSignature()).setSmartStart(this.mSmartEvent.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setSmartEnd(this.mSmartEvent.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
        }
        if (this.mPrevEvent != null) {
            event.setDurationSincePreviousEvent(now - this.mPrevEvent.getEventTime()).setEventIndex(this.mPrevEvent.getEventIndex() + 1);
        }
        this.writeEvent(event);
        this.mPrevEvent = event;
        if (event.isTerminal()) {
            this.endSession();
        }
    }

    private String startNewSession() {
        this.endSession();
        return UUID.randomUUID().toString();
    }

    private void endSession() {
        this.mPrevEvent = null;
        this.mSmartEvent = null;
        this.mStartEvent = null;
    }

    private static void checkActionType(int eventType) throws IllegalArgumentException {
        switch (eventType) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 200: 
            case 201: {
                return;
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, "%d is not an eventType", eventType));
    }

    public static final class Config {
        private final String mPackageName;
        private final String mWidgetType;
        private final String mWidgetVersion;

        public Config(Context context, String widgetType, String widgetVersion) {
            this.mPackageName = Preconditions.checkNotNull(context).getPackageName();
            this.mWidgetType = widgetType;
            this.mWidgetVersion = widgetVersion;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public String getWidgetType() {
            return this.mWidgetType;
        }

        public String getWidgetVersion() {
            return this.mWidgetVersion;
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mWidgetType, this.mWidgetVersion);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Config)) {
                return false;
            }
            Config other = (Config)obj;
            return Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mWidgetType, other.mWidgetType) && Objects.equals(this.mWidgetVersion, other.mWidgetType);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetType {
    }
}

