/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier.logging;

import android.view.textclassifier.logging.Logger;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public final class SelectionEvent {
    public static final int ACTION_OVERTYPE = 100;
    public static final int ACTION_COPY = 101;
    public static final int ACTION_PASTE = 102;
    public static final int ACTION_CUT = 103;
    public static final int ACTION_SHARE = 104;
    public static final int ACTION_SMART_SHARE = 105;
    public static final int ACTION_DRAG = 106;
    public static final int ACTION_ABANDON = 107;
    public static final int ACTION_OTHER = 108;
    public static final int ACTION_SELECT_ALL = 200;
    public static final int ACTION_RESET = 201;
    public static final int EVENT_SELECTION_STARTED = 1;
    public static final int EVENT_SELECTION_MODIFIED = 2;
    public static final int EVENT_SMART_SELECTION_SINGLE = 3;
    public static final int EVENT_SMART_SELECTION_MULTI = 4;
    public static final int EVENT_AUTO_SELECTION = 5;
    private final int mAbsoluteStart;
    private final int mAbsoluteEnd;
    private final int mEventType;
    private final String mEntityType;
    private final String mWidgetVersion;
    private final String mPackageName;
    private final String mWidgetType;
    private String mSignature;
    private long mEventTime;
    private long mDurationSinceSessionStart;
    private long mDurationSinceLastEvent;
    private int mEventIndex;
    private String mSessionId;
    private int mStart;
    private int mEnd;
    private int mSmartStart;
    private int mSmartEnd;

    SelectionEvent(int start, int end, int eventType, String entityType, String signature, Logger.Config config) {
        Preconditions.checkArgument(end >= start, "end cannot be less than start");
        this.mAbsoluteStart = start;
        this.mAbsoluteEnd = end;
        this.mEventType = eventType;
        this.mEntityType = Preconditions.checkNotNull(entityType);
        this.mSignature = Preconditions.checkNotNull(signature);
        Preconditions.checkNotNull(config);
        this.mWidgetVersion = config.getWidgetVersion();
        this.mPackageName = Preconditions.checkNotNull(config.getPackageName());
        this.mWidgetType = Preconditions.checkNotNull(config.getWidgetType());
    }

    int getAbsoluteStart() {
        return this.mAbsoluteStart;
    }

    int getAbsoluteEnd() {
        return this.mAbsoluteEnd;
    }

    public int getEventType() {
        return this.mEventType;
    }

    public String getEntityType() {
        return this.mEntityType;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getWidgetType() {
        return this.mWidgetType;
    }

    public String getWidgetVersion() {
        return this.mWidgetVersion;
    }

    public String getSignature() {
        return this.mSignature;
    }

    SelectionEvent setSignature(String signature) {
        this.mSignature = Preconditions.checkNotNull(signature);
        return this;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    SelectionEvent setEventTime(long timeMs) {
        this.mEventTime = timeMs;
        return this;
    }

    public long getDurationSinceSessionStart() {
        return this.mDurationSinceSessionStart;
    }

    SelectionEvent setDurationSinceSessionStart(long durationMs) {
        this.mDurationSinceSessionStart = durationMs;
        return this;
    }

    public long getDurationSincePreviousEvent() {
        return this.mDurationSinceLastEvent;
    }

    SelectionEvent setDurationSincePreviousEvent(long durationMs) {
        this.mDurationSinceLastEvent = durationMs;
        return this;
    }

    public int getEventIndex() {
        return this.mEventIndex;
    }

    SelectionEvent setEventIndex(int index) {
        this.mEventIndex = index;
        return this;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    SelectionEvent setSessionId(String id2) {
        this.mSessionId = id2;
        return this;
    }

    public int getStart() {
        return this.mStart;
    }

    SelectionEvent setStart(int start) {
        this.mStart = start;
        return this;
    }

    public int getEnd() {
        return this.mEnd;
    }

    SelectionEvent setEnd(int end) {
        this.mEnd = end;
        return this;
    }

    public int getSmartStart() {
        return this.mSmartStart;
    }

    SelectionEvent setSmartStart(int start) {
        this.mSmartStart = start;
        return this;
    }

    public int getSmartEnd() {
        return this.mSmartEnd;
    }

    SelectionEvent setSmartEnd(int end) {
        this.mSmartEnd = end;
        return this;
    }

    boolean isTerminal() {
        switch (this.mEventType) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format(Locale.US, "SelectionEvent {absoluteStart=%d, absoluteEnd=%d, eventType=%d, entityType=%s, widgetVersion=%s, packageName=%s, widgetType=%s, signature=%s, eventTime=%d, durationSinceSessionStart=%d, durationSinceLastEvent=%d, eventIndex=%d, sessionId=%s, start=%d, end=%d, smartStart=%d, smartEnd=%d}", this.mAbsoluteStart, this.mAbsoluteEnd, this.mEventType, this.mEntityType, this.mWidgetVersion, this.mPackageName, this.mWidgetType, this.mSignature, this.mEventTime, this.mDurationSinceSessionStart, this.mDurationSinceLastEvent, this.mEventIndex, this.mSessionId, this.mStart, this.mEnd, this.mSmartStart, this.mSmartEnd);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActionType {
    }
}

