/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.LoadedApk;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.SystemService;
import android.os.ZygoteProcess;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;

public class WebViewZygote {
    private static final String LOGTAG = "WebViewZygote";
    private static final String WEBVIEW_ZYGOTE_SERVICE_32 = "webview_zygote32";
    private static final String WEBVIEW_ZYGOTE_SERVICE_64 = "webview_zygote64";
    private static final String WEBVIEW_ZYGOTE_SOCKET = "webview_zygote";
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static ZygoteProcess sZygote;
    @GuardedBy(value="sLock")
    private static boolean sStartedService;
    @GuardedBy(value="sLock")
    private static PackageInfo sPackage;
    @GuardedBy(value="sLock")
    private static ApplicationInfo sPackageOriginalAppInfo;
    @GuardedBy(value="sLock")
    private static boolean sMultiprocessEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZygoteProcess getProcess() {
        Object object = sLock;
        synchronized (object) {
            if (sZygote != null) {
                return sZygote;
            }
            WebViewZygote.waitForServiceStartAndConnect();
            return sZygote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageName() {
        Object object = sLock;
        synchronized (object) {
            return WebViewZygote.sPackage.packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMultiprocessEnabled() {
        Object object = sLock;
        synchronized (object) {
            return sMultiprocessEnabled && sPackage != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMultiprocessEnabled(boolean enabled) {
        Object object = sLock;
        synchronized (object) {
            sMultiprocessEnabled = enabled;
            String serviceName = WebViewZygote.getServiceNameLocked();
            if (serviceName == null) {
                return;
            }
            if (enabled) {
                if (!sStartedService) {
                    SystemService.start(serviceName);
                    sStartedService = true;
                }
            } else {
                SystemService.stop(serviceName);
                sStartedService = false;
                sZygote = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onWebViewProviderChanged(PackageInfo packageInfo, ApplicationInfo originalAppInfo) {
        Object object = sLock;
        synchronized (object) {
            sPackage = packageInfo;
            sPackageOriginalAppInfo = originalAppInfo;
            if (!sMultiprocessEnabled) {
                return;
            }
            String serviceName = WebViewZygote.getServiceNameLocked();
            sZygote = null;
            if (SystemService.isStopped(serviceName)) {
                SystemService.start(serviceName);
            } else {
                SystemService.restart(serviceName);
            }
            sStartedService = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForServiceStartAndConnect() {
        String serviceName;
        if (!sStartedService) {
            throw new AndroidRuntimeException("Tried waiting for the WebView Zygote Service to start running without first starting the service.");
        }
        Object object = sLock;
        synchronized (object) {
            serviceName = WebViewZygote.getServiceNameLocked();
        }
        try {
            SystemService.waitForState(serviceName, SystemService.State.RUNNING, 5000L);
        }
        catch (TimeoutException e) {
            Log.e(LOGTAG, "Timed out waiting for " + serviceName);
            return;
        }
        object = sLock;
        synchronized (object) {
            WebViewZygote.connectToZygoteIfNeededLocked();
        }
    }

    @GuardedBy(value="sLock")
    private static String getServiceNameLocked() {
        if (sPackage == null) {
            return null;
        }
        if (Arrays.asList(Build.SUPPORTED_64_BIT_ABIS).contains(WebViewZygote.sPackage.applicationInfo.primaryCpuAbi)) {
            return WEBVIEW_ZYGOTE_SERVICE_64;
        }
        return WEBVIEW_ZYGOTE_SERVICE_32;
    }

    @GuardedBy(value="sLock")
    private static void connectToZygoteIfNeededLocked() {
        if (sZygote != null) {
            return;
        }
        if (sPackage == null) {
            Log.e(LOGTAG, "Cannot connect to zygote, no package specified");
            return;
        }
        String serviceName = WebViewZygote.getServiceNameLocked();
        if (!SystemService.isRunning(serviceName)) {
            Log.e(LOGTAG, serviceName + " is not running");
            return;
        }
        try {
            sZygote = new ZygoteProcess(WEBVIEW_ZYGOTE_SOCKET, null);
            ArrayList<String> zipPaths = new ArrayList<String>(10);
            ArrayList<String> libPaths = new ArrayList<String>(10);
            LoadedApk.makePaths(null, false, WebViewZygote.sPackage.applicationInfo, zipPaths, libPaths);
            String librarySearchPath = TextUtils.join((CharSequence)File.pathSeparator, libPaths);
            String zip = zipPaths.size() == 1 ? (String)zipPaths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
            LoadedApk.makePaths(null, false, sPackageOriginalAppInfo, zipPaths, null);
            String cacheKey = zipPaths.size() == 1 ? (String)zipPaths.get(0) : TextUtils.join((CharSequence)File.pathSeparator, zipPaths);
            ZygoteProcess.waitForConnectionToZygote(WEBVIEW_ZYGOTE_SOCKET);
            Log.d(LOGTAG, "Preloading package " + zip + " " + librarySearchPath);
            sZygote.preloadPackageForAbi(zip, librarySearchPath, cacheKey, Build.SUPPORTED_ABIS[0]);
        }
        catch (Exception e) {
            Log.e(LOGTAG, "Error connecting to " + serviceName, e);
            sZygote = null;
        }
    }

    static {
        sStartedService = false;
        sMultiprocessEnabled = false;
    }
}

