/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.widget.ImageView;
import android.widget.PopupWindow;
import com.android.internal.util.Preconditions;

public final class Magnifier {
    private static final int NONEXISTENT_PREVIOUS_CONFIG_VALUE = -1;
    private final View mView;
    private final int[] mViewCoordinatesInSurface;
    private final PopupWindow mWindow;
    private final Point mWindowCoords = new Point();
    private final int mWindowWidth;
    private final int mWindowHeight;
    private final Bitmap mBitmap;
    private final Point mCenterZoomCoords = new Point();
    private final Handler mPixelCopyHandler = Handler.getMain();
    private final float mZoomScale;
    private final Point mPrevStartCoordsInSurface = new Point(-1, -1);
    private final PointF mPrevPosInView = new PointF(-1.0f, -1.0f);
    private final Rect mPixelCopyRequestRect = new Rect();

    public Magnifier(View view) {
        this.mView = Preconditions.checkNotNull(view);
        Context context = this.mView.getContext();
        float elevation = context.getResources().getDimension(0x1050100);
        View content = LayoutInflater.from(context).inflate(17367168, null);
        ((View)content.findViewById(16909037)).setClipToOutline(true);
        this.mWindowWidth = context.getResources().getDimensionPixelSize(17105155);
        this.mWindowHeight = context.getResources().getDimensionPixelSize(0x1050101);
        this.mZoomScale = context.getResources().getFloat(17105156);
        this.mViewCoordinatesInSurface = new int[2];
        this.mWindow = new PopupWindow(context);
        this.mWindow.setContentView(content);
        this.mWindow.setWidth(this.mWindowWidth);
        this.mWindow.setHeight(this.mWindowHeight);
        this.mWindow.setElevation(elevation);
        this.mWindow.setTouchable(false);
        this.mWindow.setBackgroundDrawable(null);
        int bitmapWidth = Math.round((float)this.mWindowWidth / this.mZoomScale);
        int bitmapHeight = Math.round((float)this.mWindowHeight / this.mZoomScale);
        this.mBitmap = Bitmap.createBitmap(bitmapWidth, bitmapHeight, Bitmap.Config.ARGB_8888);
        this.getImageView().setImageBitmap(this.mBitmap);
    }

    public void show(float xPosInView, float yPosInView) {
        xPosInView = Math.max(0.0f, Math.min(xPosInView, (float)this.mView.getWidth()));
        yPosInView = Math.max(0.0f, Math.min(yPosInView, (float)this.mView.getHeight()));
        this.configureCoordinates(xPosInView, yPosInView);
        int zeroScrollXInSurface = this.mViewCoordinatesInSurface[0];
        int actualWidth = this.mView.getWidth();
        ViewParent viewParent = this.mView.getParent();
        while (viewParent instanceof View) {
            View container = (View)((Object)viewParent);
            if (container.canScrollHorizontally(-1) || container.canScrollHorizontally(1)) {
                zeroScrollXInSurface += container.getScrollX();
                actualWidth = Math.min(actualWidth, container.getWidth() - container.getPaddingLeft() - container.getPaddingRight());
            }
            viewParent = viewParent.getParent();
        }
        int startX = Math.max(zeroScrollXInSurface, Math.min(this.mCenterZoomCoords.x - this.mBitmap.getWidth() / 2, zeroScrollXInSurface + actualWidth - this.mBitmap.getWidth()));
        int startY = this.mCenterZoomCoords.y - this.mBitmap.getHeight() / 2;
        if (xPosInView != this.mPrevPosInView.x || yPosInView != this.mPrevPosInView.y) {
            this.performPixelCopy(startX, startY);
            this.mPrevPosInView.x = xPosInView;
            this.mPrevPosInView.y = yPosInView;
            if (this.mWindow.isShowing()) {
                this.mWindow.update(this.mWindowCoords.x, this.mWindowCoords.y, this.mWindow.getWidth(), this.mWindow.getHeight());
            } else {
                this.mWindow.showAtLocation(this.mView, 0, this.mWindowCoords.x, this.mWindowCoords.y);
            }
        }
    }

    public void dismiss() {
        this.mWindow.dismiss();
    }

    public void update() {
        if (this.mWindow.isShowing()) {
            this.performPixelCopy(this.mPrevStartCoordsInSurface.x, this.mPrevStartCoordsInSurface.y);
        }
    }

    private void configureCoordinates(float xPosInView, float yPosInView) {
        float contentPosY;
        float contentPosX;
        if (this.mView instanceof SurfaceView) {
            contentPosX = xPosInView;
            contentPosY = yPosInView;
        } else {
            this.mView.getLocationInSurface(this.mViewCoordinatesInSurface);
            contentPosX = xPosInView + (float)this.mViewCoordinatesInSurface[0];
            contentPosY = yPosInView + (float)this.mViewCoordinatesInSurface[1];
        }
        this.mCenterZoomCoords.x = Math.round(contentPosX);
        this.mCenterZoomCoords.y = Math.round(contentPosY);
        int[] viewCoordinatesInWindow = new int[2];
        this.mView.getLocationInWindow(viewCoordinatesInWindow);
        int verticalOffset = this.mView.getContext().getResources().getDimensionPixelSize(17105154);
        float magnifierPosX = xPosInView + (float)viewCoordinatesInWindow[0];
        float magnifierPosY = yPosInView + (float)viewCoordinatesInWindow[1] - (float)verticalOffset;
        this.mWindowCoords.x = Math.round(magnifierPosX - (float)(this.mWindowWidth / 2));
        this.mWindowCoords.y = Math.round(magnifierPosY - (float)(this.mWindowHeight / 2));
    }

    private void performPixelCopy(int startXInSurface, int startYInSurface) {
        int surfaceHeight;
        int surfaceWidth;
        Surface surface;
        if (this.mView instanceof SurfaceView) {
            SurfaceHolder surfaceHolder = ((SurfaceView)this.mView).getHolder();
            surface = surfaceHolder.getSurface();
            surfaceWidth = surfaceHolder.getSurfaceFrame().right;
            surfaceHeight = surfaceHolder.getSurfaceFrame().bottom;
        } else if (this.mView.getViewRootImpl() != null) {
            ViewRootImpl viewRootImpl = this.mView.getViewRootImpl();
            surface = viewRootImpl.mSurface;
            surfaceWidth = viewRootImpl.getWidth();
            surfaceHeight = viewRootImpl.getHeight();
        } else {
            surface = null;
            surfaceWidth = -1;
            surfaceHeight = -1;
        }
        if (surface == null || !surface.isValid()) {
            return;
        }
        int clampedStartXInSurface = Math.max(0, Math.min(startXInSurface, surfaceWidth - this.mWindowWidth));
        int clampedStartYInSurface = Math.max(0, Math.min(startYInSurface, surfaceHeight - this.mWindowHeight));
        this.mPixelCopyRequestRect.set(clampedStartXInSurface, clampedStartYInSurface, clampedStartXInSurface + this.mBitmap.getWidth(), clampedStartYInSurface + this.mBitmap.getHeight());
        PixelCopy.request(surface, this.mPixelCopyRequestRect, this.mBitmap, result -> {
            this.getImageView().invalidate();
            this.mPrevStartCoordsInSurface.x = startXInSurface;
            this.mPrevStartCoordsInSurface.y = startYInSurface;
        }, this.mPixelCopyHandler);
    }

    private ImageView getImageView() {
        return (ImageView)this.mWindow.getContentView().findViewById(16909036);
    }

    public Bitmap getContent() {
        return this.mBitmap;
    }

    public Rect getWindowPositionOnScreen() {
        int[] viewLocationOnScreen = new int[2];
        this.mView.getLocationOnScreen(viewLocationOnScreen);
        int[] viewLocationInSurface = new int[2];
        this.mView.getLocationInSurface(viewLocationInSurface);
        int left = this.mWindowCoords.x + viewLocationOnScreen[0] - viewLocationInSurface[0];
        int top = this.mWindowCoords.y + viewLocationOnScreen[1] - viewLocationInSurface[1];
        return new Rect(left, top, left + this.mWindow.getWidth(), top + this.mWindow.getHeight());
    }

    public static PointF getMagnifierDefaultSize() {
        Resources resources = Resources.getSystem();
        float density = resources.getDisplayMetrics().density;
        PointF size = new PointF();
        size.x = resources.getDimension(17105155) / density;
        size.y = resources.getDimension(0x1050101) / density;
        return size;
    }
}

