/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.IServiceConnection;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.IRemoteViewsFactory;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class RemoteViewsAdapter
extends BaseAdapter
implements Handler.Callback {
    private static final String TAG = "RemoteViewsAdapter";
    private static final int DEFAULT_CACHE_SIZE = 40;
    private static final int UNBIND_SERVICE_DELAY = 5000;
    private static final int DEFAULT_LOADING_VIEW_HEIGHT = 50;
    private static final HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> sCachedRemoteViewsCaches = new HashMap();
    private static final HashMap<RemoteViewsCacheKey, Runnable> sRemoteViewsCacheRemoveRunnables = new HashMap();
    private static HandlerThread sCacheRemovalThread;
    private static Handler sCacheRemovalQueue;
    private static final int REMOTE_VIEWS_CACHE_DURATION = 5000;
    private final Context mContext;
    private final Intent mIntent;
    private final int mAppWidgetId;
    private final Executor mAsyncViewLoadExecutor;
    private RemoteViews.OnClickHandler mRemoteViewsOnClickHandler;
    private final FixedSizeRemoteViewsCache mCache;
    private int mVisibleWindowLowerBound;
    private int mVisibleWindowUpperBound;
    private RemoteViewsFrameLayoutRefSet mRequestedViews;
    private final HandlerThread mWorkerThread;
    private final Handler mMainHandler;
    private final RemoteServiceHandler mServiceHandler;
    private final RemoteAdapterConnectionCallback mCallback;
    private boolean mDataReady = false;
    private ApplicationInfo mLastRemoteViewAppInfo;
    static final int MSG_REQUEST_BIND = 1;
    static final int MSG_NOTIFY_DATA_SET_CHANGED = 2;
    static final int MSG_LOAD_NEXT_ITEM = 3;
    static final int MSG_UNBIND_SERVICE = 4;
    private static final int MSG_MAIN_HANDLER_COMMIT_METADATA = 1;
    private static final int MSG_MAIN_HANDLER_SUPER_NOTIFY_DATA_SET_CHANGED = 2;
    private static final int MSG_MAIN_HANDLER_REMOTE_ADAPTER_CONNECTED = 3;
    private static final int MSG_MAIN_HANDLER_REMOTE_ADAPTER_DISCONNECTED = 4;
    private static final int MSG_MAIN_HANDLER_REMOTE_VIEWS_LOADED = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteViewsAdapter(Context context, Intent intent, RemoteAdapterConnectionCallback callback, boolean useAsyncLoader) {
        this.mContext = context;
        this.mIntent = intent;
        if (this.mIntent == null) {
            throw new IllegalArgumentException("Non-null Intent must be specified.");
        }
        this.mAppWidgetId = intent.getIntExtra("remoteAdapterAppWidgetId", -1);
        this.mRequestedViews = new RemoteViewsFrameLayoutRefSet();
        if (intent.hasExtra("remoteAdapterAppWidgetId")) {
            intent.removeExtra("remoteAdapterAppWidgetId");
        }
        this.mWorkerThread = new HandlerThread("RemoteViewsCache-loader");
        this.mWorkerThread.start();
        this.mMainHandler = new Handler(Looper.myLooper(), this);
        this.mServiceHandler = new RemoteServiceHandler(this.mWorkerThread.getLooper(), this, context.getApplicationContext());
        this.mAsyncViewLoadExecutor = useAsyncLoader ? new HandlerThreadExecutor(this.mWorkerThread) : null;
        this.mCallback = callback;
        if (sCacheRemovalThread == null) {
            sCacheRemovalThread = new HandlerThread("RemoteViewsAdapter-cachePruner");
            sCacheRemovalThread.start();
            sCacheRemovalQueue = new Handler(sCacheRemovalThread.getLooper());
        }
        RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sCachedRemoteViewsCaches.containsKey(key)) {
                this.mCache = sCachedRemoteViewsCaches.get(key);
                RemoteViewsMetaData remoteViewsMetaData = this.mCache.mMetaData;
                synchronized (remoteViewsMetaData) {
                    if (((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count > 0) {
                        this.mDataReady = true;
                    }
                }
            } else {
                this.mCache = new FixedSizeRemoteViewsCache(40);
            }
            if (!this.mDataReady) {
                this.requestBindService();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.mServiceHandler.unbindNow();
            this.mWorkerThread.quit();
        }
        finally {
            super.finalize();
        }
    }

    public boolean isDataReady() {
        return this.mDataReady;
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler handler) {
        this.mRemoteViewsOnClickHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRemoteViewsCache() {
        RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                sCacheRemovalQueue.removeCallbacks(sRemoteViewsCacheRemoveRunnables.get(key));
                sRemoteViewsCacheRemoveRunnables.remove(key);
            }
            int metaDataCount = 0;
            int numRemoteViewsCached = 0;
            Object object = this.mCache.mMetaData;
            synchronized (object) {
                metaDataCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
            }
            object = this.mCache;
            synchronized (object) {
                numRemoteViewsCached = this.mCache.mIndexRemoteViews.size();
            }
            if (metaDataCount > 0 && numRemoteViewsCached > 0) {
                sCachedRemoteViewsCaches.put(key, this.mCache);
            }
            Runnable r = () -> {
                HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
                synchronized (hashMap) {
                    if (sCachedRemoteViewsCaches.containsKey(key)) {
                        sCachedRemoteViewsCaches.remove(key);
                    }
                    if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                        sRemoteViewsCacheRemoveRunnables.remove(key);
                    }
                }
            };
            sRemoteViewsCacheRemoveRunnables.put(key, r);
            sCacheRemovalQueue.postDelayed(r, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTemporaryMetaData(IRemoteViewsFactory factory) {
        try {
            RemoteViewsMetaData tmpMetaData;
            RemoteViews firstView;
            boolean hasStableIds = factory.hasStableIds();
            int viewTypeCount = factory.getViewTypeCount();
            int count = factory.getCount();
            LoadingViewTemplate loadingTemplate = new LoadingViewTemplate(factory.getLoadingView(), this.mContext);
            if (count > 0 && loadingTemplate.remoteViews == null && (firstView = factory.getViewAt(0)) != null) {
                loadingTemplate.loadFirstViewHeight(firstView, this.mContext, new HandlerThreadExecutor(this.mWorkerThread));
            }
            RemoteViewsMetaData remoteViewsMetaData = tmpMetaData = this.mCache.getTemporaryMetaData();
            synchronized (remoteViewsMetaData) {
                tmpMetaData.hasStableIds = hasStableIds;
                tmpMetaData.viewTypeCount = viewTypeCount + 1;
                tmpMetaData.count = count;
                tmpMetaData.loadingTemplate = loadingTemplate;
            }
        }
        catch (RemoteException | RuntimeException e) {
            Log.e(TAG, "Error in updateMetaData: " + e.getMessage());
            Object object = this.mCache.getMetaData();
            synchronized (object) {
                this.mCache.getMetaData().reset();
            }
            object = this.mCache;
            synchronized (object) {
                this.mCache.reset();
            }
            this.mMainHandler.sendEmptyMessage(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteViews(IRemoteViewsFactory factory, int position, boolean notifyWhenLoaded) {
        int cacheCount;
        boolean viewTypeInRange;
        long itemId;
        RemoteViews remoteViews;
        try {
            remoteViews = factory.getViewAt(position);
            itemId = factory.getItemId(position);
            if (remoteViews == null) {
                throw new RuntimeException("Null remoteViews");
            }
        }
        catch (RemoteException | RuntimeException e) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + e.getMessage());
            return;
        }
        if (remoteViews.mApplication != null) {
            if (this.mLastRemoteViewAppInfo != null && remoteViews.hasSameAppInfo(this.mLastRemoteViewAppInfo)) {
                remoteViews.mApplication = this.mLastRemoteViewAppInfo;
            } else {
                this.mLastRemoteViewAppInfo = remoteViews.mApplication;
            }
        }
        int layoutId = remoteViews.getLayoutId();
        RemoteViewsMetaData metaData = this.mCache.getMetaData();
        Object object = metaData;
        synchronized (object) {
            viewTypeInRange = metaData.isViewTypeInRange(layoutId);
            cacheCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
        }
        object = this.mCache;
        synchronized (object) {
            if (viewTypeInRange) {
                int[] visibleWindow = this.getVisibleWindow(cacheCount);
                this.mCache.insert(position, remoteViews, itemId, visibleWindow);
                if (notifyWhenLoaded) {
                    Message.obtain(this.mMainHandler, 5, position, 0, remoteViews).sendToTarget();
                }
            } else {
                Log.e(TAG, "Error: widget's RemoteViewsFactory returns more view types than  indicated by getViewTypeCount() ");
            }
        }
    }

    public Intent getRemoteViewsServiceIntent() {
        return this.mIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.count;
        }
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getItemId(int position) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (this.mCache.containsMetaDataAt(position)) {
                return this.mCache.getMetaDataAt((int)position).itemId;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemViewType(int position) {
        RemoteViewsMetaData metaData;
        int typeId;
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (!this.mCache.containsMetaDataAt(position)) {
                return 0;
            }
            typeId = this.mCache.getMetaDataAt((int)position).typeId;
        }
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.getMappedViewType(typeId);
        }
    }

    public void setVisibleRangeHint(int lowerBound, int upperBound) {
        this.mVisibleWindowLowerBound = lowerBound;
        this.mVisibleWindowUpperBound = upperBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            RemoteViewsFrameLayout layout2;
            RemoteViews rv = this.mCache.getRemoteViewsAt(position);
            boolean isInCache = rv != null;
            boolean hasNewItems = false;
            if (convertView != null && convertView instanceof RemoteViewsFrameLayout) {
                this.mRequestedViews.removeView((RemoteViewsFrameLayout)convertView);
            }
            if (!isInCache) {
                this.requestBindService();
            } else {
                hasNewItems = this.mCache.queuePositionsToBePreloadedFromRequestedPosition(position);
            }
            if (convertView instanceof RemoteViewsFrameLayout) {
                layout2 = (RemoteViewsFrameLayout)convertView;
            } else {
                layout2 = new RemoteViewsFrameLayout(parent.getContext(), this.mCache);
                layout2.setExecutor(this.mAsyncViewLoadExecutor);
            }
            if (isInCache) {
                layout2.onRemoteViewsLoaded(rv, this.mRemoteViewsOnClickHandler, false);
                if (hasNewItems) {
                    this.mServiceHandler.sendEmptyMessage(3);
                }
            } else {
                layout2.onRemoteViewsLoaded(this.mCache.getMetaData().getLoadingTemplate((Context)this.mContext).remoteViews, this.mRemoteViewsOnClickHandler, false);
                this.mRequestedViews.add(position, layout2);
                this.mCache.queueRequestedPositionToLoad(position);
                this.mServiceHandler.sendEmptyMessage(3);
            }
            return layout2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getViewTypeCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.viewTypeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStableIds() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.hasStableIds;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() <= 0;
    }

    private int[] getVisibleWindow(int count) {
        int[] window;
        int lower = this.mVisibleWindowLowerBound;
        int upper = this.mVisibleWindowUpperBound;
        if (lower == 0 && upper == 0 || lower < 0 || upper < 0) {
            return new int[0];
        }
        if (lower <= upper) {
            window = new int[upper + 1 - lower];
            int i = lower;
            int j = 0;
            while (i <= upper) {
                window[j] = i++;
                ++j;
            }
        } else {
            count = Math.max(count, lower);
            window = new int[count - lower + upper + 1];
            int j = 0;
            int i = 0;
            while (i <= upper) {
                window[j] = i++;
                ++j;
            }
            i = lower;
            while (i < count) {
                window[j] = i++;
                ++j;
            }
        }
        return window;
    }

    @Override
    public void notifyDataSetChanged() {
        this.mServiceHandler.removeMessages(4);
        this.mServiceHandler.sendEmptyMessage(2);
    }

    void superNotifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.mCache.commitTemporaryMetaData();
                return true;
            }
            case 2: {
                this.superNotifyDataSetChanged();
                return true;
            }
            case 3: {
                if (this.mCallback != null) {
                    this.mCallback.onRemoteAdapterConnected();
                }
                return true;
            }
            case 4: {
                if (this.mCallback != null) {
                    this.mCallback.onRemoteAdapterDisconnected();
                }
                return true;
            }
            case 5: {
                this.mRequestedViews.notifyOnRemoteViewsLoaded(msg.arg1, (RemoteViews)msg.obj);
                return true;
            }
        }
        return false;
    }

    private void requestBindService() {
        this.mServiceHandler.removeMessages(4);
        Message.obtain(this.mServiceHandler, 1, this.mAppWidgetId, 0, this.mIntent).sendToTarget();
    }

    private static class LoadingViewTemplate {
        public final RemoteViews remoteViews;
        public int defaultHeight;

        LoadingViewTemplate(RemoteViews views, Context context) {
            this.remoteViews = views;
            float density = context.getResources().getDisplayMetrics().density;
            this.defaultHeight = Math.round(50.0f * density);
        }

        public void loadFirstViewHeight(RemoteViews firstView, Context context, Executor executor) {
            firstView.applyAsync(context, new RemoteViewsFrameLayout(context, null), executor, new RemoteViews.OnViewAppliedListener(){

                @Override
                public void onViewApplied(View v) {
                    try {
                        v.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
                        defaultHeight = v.getMeasuredHeight();
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                }

                @Override
                public void onError(Exception e) {
                    Log.w(RemoteViewsAdapter.TAG, "Error inflating first RemoteViews", e);
                }
            });
        }
    }

    private static class HandlerThreadExecutor
    implements Executor {
        private final HandlerThread mThread;

        HandlerThreadExecutor(HandlerThread thread) {
            this.mThread = thread;
        }

        @Override
        public void execute(Runnable runnable) {
            if (Thread.currentThread().getId() == this.mThread.getId()) {
                runnable.run();
            } else {
                new Handler(this.mThread.getLooper()).post(runnable);
            }
        }
    }

    static class RemoteViewsCacheKey {
        final Intent.FilterComparison filter;
        final int widgetId;

        RemoteViewsCacheKey(Intent.FilterComparison filter, int widgetId) {
            this.filter = filter;
            this.widgetId = widgetId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RemoteViewsCacheKey)) {
                return false;
            }
            RemoteViewsCacheKey other = (RemoteViewsCacheKey)o;
            return other.filter.equals(this.filter) && other.widgetId == this.widgetId;
        }

        public int hashCode() {
            return (this.filter == null ? 0 : this.filter.hashCode()) ^ this.widgetId << 2;
        }
    }

    private static class FixedSizeRemoteViewsCache {
        private final RemoteViewsMetaData mMetaData = new RemoteViewsMetaData();
        private final RemoteViewsMetaData mTemporaryMetaData = new RemoteViewsMetaData();
        private final SparseArray<RemoteViewsIndexMetaData> mIndexMetaData = new SparseArray();
        private final SparseArray<RemoteViews> mIndexRemoteViews = new SparseArray();
        private final SparseBooleanArray mIndicesToLoad = new SparseBooleanArray();
        private int mLastRequestedIndex;
        private int mPreloadLowerBound;
        private int mPreloadUpperBound;
        private final int mMaxCount;
        private final int mMaxCountSlack;
        private static final float sMaxCountSlackPercent = 0.75f;
        private static final int sMaxMemoryLimitInBytes = 0x200000;

        public FixedSizeRemoteViewsCache(int maxCacheSize) {
            this.mMaxCount = maxCacheSize;
            this.mMaxCountSlack = Math.round(0.75f * (float)(this.mMaxCount / 2));
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
        }

        public void insert(int position, RemoteViews v, long itemId, int[] visibleWindow) {
            int trimIndex;
            int pruneFromPosition;
            if (this.mIndexRemoteViews.size() >= this.mMaxCount) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(position, visibleWindow));
            }
            int n = pruneFromPosition = this.mLastRequestedIndex > -1 ? this.mLastRequestedIndex : position;
            while (this.getRemoteViewsBitmapMemoryUsage() >= 0x200000 && (trimIndex = this.getFarthestPositionFrom(pruneFromPosition, visibleWindow)) >= 0) {
                this.mIndexRemoteViews.remove(trimIndex);
            }
            RemoteViewsIndexMetaData metaData = this.mIndexMetaData.get(position);
            if (metaData != null) {
                metaData.set(v, itemId);
            } else {
                this.mIndexMetaData.put(position, new RemoteViewsIndexMetaData(v, itemId));
            }
            this.mIndexRemoteViews.put(position, v);
        }

        public RemoteViewsMetaData getMetaData() {
            return this.mMetaData;
        }

        public RemoteViewsMetaData getTemporaryMetaData() {
            return this.mTemporaryMetaData;
        }

        public RemoteViews getRemoteViewsAt(int position) {
            return this.mIndexRemoteViews.get(position);
        }

        public RemoteViewsIndexMetaData getMetaDataAt(int position) {
            return this.mIndexMetaData.get(position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitTemporaryMetaData() {
            RemoteViewsMetaData remoteViewsMetaData = this.mTemporaryMetaData;
            synchronized (remoteViewsMetaData) {
                RemoteViewsMetaData remoteViewsMetaData2 = this.mMetaData;
                synchronized (remoteViewsMetaData2) {
                    this.mMetaData.set(this.mTemporaryMetaData);
                }
            }
        }

        private int getRemoteViewsBitmapMemoryUsage() {
            int mem = 0;
            for (int i = this.mIndexRemoteViews.size() - 1; i >= 0; --i) {
                RemoteViews v = this.mIndexRemoteViews.valueAt(i);
                if (v == null) continue;
                mem += v.estimateMemoryUsage();
            }
            return mem;
        }

        private int getFarthestPositionFrom(int pos, int[] visibleWindow) {
            int maxDist = 0;
            int maxDistIndex = -1;
            int maxDistNotVisible = 0;
            int maxDistIndexNotVisible = -1;
            for (int i = this.mIndexRemoteViews.size() - 1; i >= 0; --i) {
                int index = this.mIndexRemoteViews.keyAt(i);
                int dist = Math.abs(index - pos);
                if (dist > maxDistNotVisible && Arrays.binarySearch(visibleWindow, index) < 0) {
                    maxDistIndexNotVisible = index;
                    maxDistNotVisible = dist;
                }
                if (dist < maxDist) continue;
                maxDistIndex = index;
                maxDist = dist;
            }
            if (maxDistIndexNotVisible > -1) {
                return maxDistIndexNotVisible;
            }
            return maxDistIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueRequestedPositionToLoad(int position) {
            this.mLastRequestedIndex = position;
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                this.mIndicesToLoad.put(position, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queuePositionsToBePreloadedFromRequestedPosition(int position) {
            int count;
            int center;
            if (this.mPreloadLowerBound <= position && position <= this.mPreloadUpperBound && Math.abs(position - (center = (this.mPreloadUpperBound + this.mPreloadLowerBound) / 2)) < this.mMaxCountSlack) {
                return false;
            }
            Object object = this.mMetaData;
            synchronized (object) {
                count = this.mMetaData.count;
            }
            object = this.mIndicesToLoad;
            synchronized (object) {
                for (int i = this.mIndicesToLoad.size() - 1; i >= 0; --i) {
                    if (this.mIndicesToLoad.valueAt(i)) continue;
                    this.mIndicesToLoad.removeAt(i);
                }
                int halfMaxCount = this.mMaxCount / 2;
                this.mPreloadLowerBound = position - halfMaxCount;
                this.mPreloadUpperBound = position + halfMaxCount;
                int effectiveLowerBound = Math.max(0, this.mPreloadLowerBound);
                int effectiveUpperBound = Math.min(this.mPreloadUpperBound, count - 1);
                for (int i = effectiveLowerBound; i <= effectiveUpperBound; ++i) {
                    if (this.mIndexRemoteViews.indexOfKey(i) >= 0 || this.mIndicesToLoad.get(i)) continue;
                    this.mIndicesToLoad.put(i, false);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNextIndexToLoad() {
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                int index = this.mIndicesToLoad.indexOfValue(true);
                if (index < 0) {
                    index = this.mIndicesToLoad.indexOfValue(false);
                }
                if (index < 0) {
                    return -1;
                }
                int key = this.mIndicesToLoad.keyAt(index);
                this.mIndicesToLoad.removeAt(index);
                return key;
            }
        }

        public boolean containsRemoteViewAt(int position) {
            return this.mIndexRemoteViews.indexOfKey(position) >= 0;
        }

        public boolean containsMetaDataAt(int position) {
            return this.mIndexMetaData.indexOfKey(position) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
            this.mIndexRemoteViews.clear();
            this.mIndexMetaData.clear();
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                this.mIndicesToLoad.clear();
            }
        }
    }

    private static class RemoteViewsIndexMetaData {
        int typeId;
        long itemId;

        public RemoteViewsIndexMetaData(RemoteViews v, long itemId) {
            this.set(v, itemId);
        }

        public void set(RemoteViews v, long id2) {
            this.itemId = id2;
            this.typeId = v != null ? v.getLayoutId() : 0;
        }
    }

    private static class RemoteViewsMetaData {
        int count;
        int viewTypeCount;
        boolean hasStableIds;
        LoadingViewTemplate loadingTemplate;
        private final SparseIntArray mTypeIdIndexMap = new SparseIntArray();

        public RemoteViewsMetaData() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(RemoteViewsMetaData d) {
            RemoteViewsMetaData remoteViewsMetaData = d;
            synchronized (remoteViewsMetaData) {
                this.count = d.count;
                this.viewTypeCount = d.viewTypeCount;
                this.hasStableIds = d.hasStableIds;
                this.loadingTemplate = d.loadingTemplate;
            }
        }

        public void reset() {
            this.count = 0;
            this.viewTypeCount = 1;
            this.hasStableIds = true;
            this.loadingTemplate = null;
            this.mTypeIdIndexMap.clear();
        }

        public int getMappedViewType(int typeId) {
            int mappedTypeId = this.mTypeIdIndexMap.get(typeId, -1);
            if (mappedTypeId == -1) {
                mappedTypeId = this.mTypeIdIndexMap.size() + 1;
                this.mTypeIdIndexMap.put(typeId, mappedTypeId);
            }
            return mappedTypeId;
        }

        public boolean isViewTypeInRange(int typeId) {
            int mappedType = this.getMappedViewType(typeId);
            return mappedType < this.viewTypeCount;
        }

        public synchronized LoadingViewTemplate getLoadingTemplate(Context context) {
            if (this.loadingTemplate == null) {
                this.loadingTemplate = new LoadingViewTemplate(null, context);
            }
            return this.loadingTemplate;
        }
    }

    private class RemoteViewsFrameLayoutRefSet
    extends SparseArray<LinkedList<RemoteViewsFrameLayout>> {
        private RemoteViewsFrameLayoutRefSet() {
        }

        public void add(int position, RemoteViewsFrameLayout layout2) {
            LinkedList<RemoteViewsFrameLayout> refs = (LinkedList<RemoteViewsFrameLayout>)this.get(position);
            if (refs == null) {
                refs = new LinkedList<RemoteViewsFrameLayout>();
                this.put(position, refs);
            }
            layout2.cacheIndex = position;
            refs.add(layout2);
        }

        public void notifyOnRemoteViewsLoaded(int position, RemoteViews view) {
            if (view == null) {
                return;
            }
            LinkedList refs = (LinkedList)this.removeReturnOld(position);
            if (refs != null) {
                for (RemoteViewsFrameLayout ref : refs) {
                    ref.onRemoteViewsLoaded(view, RemoteViewsAdapter.this.mRemoteViewsOnClickHandler, true);
                }
            }
        }

        public void removeView(RemoteViewsFrameLayout rvfl) {
            if (rvfl.cacheIndex < 0) {
                return;
            }
            LinkedList refs = (LinkedList)this.get(rvfl.cacheIndex);
            if (refs != null) {
                refs.remove(rvfl);
            }
            rvfl.cacheIndex = -1;
        }
    }

    static class RemoteViewsFrameLayout
    extends AppWidgetHostView {
        private final FixedSizeRemoteViewsCache mCache;
        public int cacheIndex = -1;

        public RemoteViewsFrameLayout(Context context, FixedSizeRemoteViewsCache cache) {
            super(context);
            this.mCache = cache;
        }

        public void onRemoteViewsLoaded(RemoteViews view, RemoteViews.OnClickHandler handler, boolean forceApplyAsync) {
            this.setOnClickHandler(handler);
            this.applyRemoteViews(view, forceApplyAsync || view != null && view.prefersAsyncApply());
        }

        @Override
        protected View getDefaultView() {
            int viewHeight = this.mCache.getMetaData().getLoadingTemplate((Context)this.getContext()).defaultHeight;
            TextView loadingTextView = (TextView)LayoutInflater.from(this.getContext()).inflate(17367243, (ViewGroup)this, false);
            loadingTextView.setHeight(viewHeight);
            return loadingTextView;
        }

        @Override
        protected Context getRemoteContext() {
            return null;
        }

        @Override
        protected View getErrorView() {
            return this.getDefaultView();
        }
    }

    private static class RemoteServiceHandler
    extends Handler
    implements ServiceConnection {
        private final WeakReference<RemoteViewsAdapter> mAdapter;
        private final Context mContext;
        private IRemoteViewsFactory mRemoteViewsFactory;
        private boolean mNotifyDataSetChangedPending = false;
        private boolean mBindRequested = false;

        RemoteServiceHandler(Looper workerLooper, RemoteViewsAdapter adapter, Context context) {
            super(workerLooper);
            this.mAdapter = new WeakReference<RemoteViewsAdapter>(adapter);
            this.mContext = context;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mRemoteViewsFactory = IRemoteViewsFactory.Stub.asInterface(service);
            this.enqueueDeferredUnbindServiceMessage();
            RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            if (this.mNotifyDataSetChangedPending) {
                this.mNotifyDataSetChangedPending = false;
                Message msg = Message.obtain((Handler)this, 2);
                this.handleMessage(msg);
                msg.recycle();
            } else {
                if (!this.sendNotifyDataSetChange(false)) {
                    return;
                }
                adapter.updateTemporaryMetaData(this.mRemoteViewsFactory);
                adapter.mMainHandler.sendEmptyMessage(1);
                adapter.mMainHandler.sendEmptyMessage(3);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.mRemoteViewsFactory = null;
            RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter != null) {
                adapter.mMainHandler.sendEmptyMessage(4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            switch (msg.what) {
                case 1: {
                    if (adapter == null || this.mRemoteViewsFactory != null) {
                        this.enqueueDeferredUnbindServiceMessage();
                    }
                    if (this.mBindRequested) {
                        return;
                    }
                    int flags = 0x2000001;
                    IServiceConnection sd = this.mContext.getServiceDispatcher(this, this, flags);
                    Intent intent = (Intent)msg.obj;
                    int appWidgetId = msg.arg1;
                    this.mBindRequested = AppWidgetManager.getInstance(this.mContext).bindRemoteViewsService(this.mContext, appWidgetId, intent, sd, flags);
                    return;
                }
                case 2: {
                    int[] visibleWindow;
                    int newCount;
                    this.enqueueDeferredUnbindServiceMessage();
                    if (adapter == null) {
                        return;
                    }
                    if (this.mRemoteViewsFactory == null) {
                        this.mNotifyDataSetChangedPending = true;
                        adapter.requestBindService();
                        return;
                    }
                    if (!this.sendNotifyDataSetChange(true)) {
                        return;
                    }
                    FixedSizeRemoteViewsCache flags = adapter.mCache;
                    synchronized (flags) {
                        adapter.mCache.reset();
                    }
                    adapter.updateTemporaryMetaData(this.mRemoteViewsFactory);
                    RemoteViewsMetaData remoteViewsMetaData = adapter.mCache.getTemporaryMetaData();
                    synchronized (remoteViewsMetaData) {
                        newCount = ((RemoteViewsAdapter)adapter).mCache.getTemporaryMetaData().count;
                        visibleWindow = adapter.getVisibleWindow(newCount);
                    }
                    for (Object position : (RemoteViewsMetaData)visibleWindow) {
                        if (position >= newCount) continue;
                        adapter.updateRemoteViews(this.mRemoteViewsFactory, (int)position, false);
                    }
                    adapter.mMainHandler.sendEmptyMessage(1);
                    adapter.mMainHandler.sendEmptyMessage(2);
                    return;
                }
                case 3: {
                    if (adapter == null || this.mRemoteViewsFactory == null) {
                        return;
                    }
                    this.removeMessages(4);
                    int position = adapter.mCache.getNextIndexToLoad();
                    if (position > -1) {
                        adapter.updateRemoteViews(this.mRemoteViewsFactory, position, true);
                        this.sendEmptyMessage(3);
                    } else {
                        this.enqueueDeferredUnbindServiceMessage();
                    }
                    return;
                }
                case 4: {
                    this.unbindNow();
                    return;
                }
            }
        }

        protected void unbindNow() {
            if (this.mBindRequested) {
                this.mBindRequested = false;
                this.mContext.unbindService(this);
            }
            this.mRemoteViewsFactory = null;
        }

        private boolean sendNotifyDataSetChange(boolean always) {
            try {
                if (always || !this.mRemoteViewsFactory.isCreated()) {
                    this.mRemoteViewsFactory.onDataSetChanged();
                }
                return true;
            }
            catch (RemoteException | RuntimeException e) {
                Log.e(RemoteViewsAdapter.TAG, "Error in updateNotifyDataSetChanged(): " + e.getMessage());
                return false;
            }
        }

        private void enqueueDeferredUnbindServiceMessage() {
            this.removeMessages(4);
            this.sendEmptyMessageDelayed(4, 5000L);
        }
    }

    public static class AsyncRemoteAdapterAction
    implements Runnable {
        private final RemoteAdapterConnectionCallback mCallback;
        private final Intent mIntent;

        public AsyncRemoteAdapterAction(RemoteAdapterConnectionCallback callback, Intent intent) {
            this.mCallback = callback;
            this.mIntent = intent;
        }

        @Override
        public void run() {
            this.mCallback.setRemoteViewsAdapter(this.mIntent, true);
        }
    }

    public static interface RemoteAdapterConnectionCallback {
        public boolean onRemoteAdapterConnected();

        public void onRemoteAdapterDisconnected();

        public void deferNotifyDataSetChanged();

        public void setRemoteViewsAdapter(Intent var1, boolean var2);
    }
}

