/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.LocaleList;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Log;
import android.view.ActionMode;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import android.view.textclassifier.logging.Logger;
import android.widget.Editor;
import android.widget.SmartSelectSprite;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public final class SelectionActionModeHelper {
    private static final String LOG_TAG = "SelectActionModeHelper";
    private static final boolean SMART_SELECT_ANIMATION_ENABLED = true;
    private final Editor mEditor;
    private final TextView mTextView;
    private final TextClassificationHelper mTextClassificationHelper;
    private TextClassification mTextClassification;
    private AsyncTask mTextClassificationAsyncTask;
    private final SelectionTracker mSelectionTracker;
    private final SmartSelectSprite mSmartSelectSprite;

    SelectionActionModeHelper(Editor editor) {
        this.mEditor = Preconditions.checkNotNull(editor);
        this.mTextView = this.mEditor.getTextView();
        this.mTextClassificationHelper = new TextClassificationHelper(this.mTextView.getContext(), this.mTextView.getTextClassifier(), SelectionActionModeHelper.getText(this.mTextView), 0, 1, this.mTextView.getTextLocales());
        this.mSelectionTracker = new SelectionTracker(this.mTextView);
        this.mSmartSelectSprite = new SmartSelectSprite(this.mTextView.getContext(), editor.getTextView().mHighlightColor, this.mTextView::invalidate);
    }

    public void startSelectionActionModeAsync(boolean adjustSelection) {
        adjustSelection &= !this.mTextView.isTextEditable() || this.mTextView.getTextClassifier().getSettings().isSuggestSelectionEnabledForEditableText();
        this.mSelectionTracker.onOriginalSelection(SelectionActionModeHelper.getText(this.mTextView), this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd());
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.startSelectionActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), adjustSelection ? this.mTextClassificationHelper::suggestSelection : this.mTextClassificationHelper::classifyText, this.mSmartSelectSprite != null ? this::startSelectionActionModeWithSmartSelectAnimation : this::startSelectionActionMode).execute(new Void[0]);
        }
    }

    public void startLinkActionModeAsync(TextLinks.TextLink textLink) {
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.startLinkActionMode(null);
        } else {
            this.resetTextClassificationHelper(textLink.getStart(), textLink.getEnd());
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), this.mTextClassificationHelper::classifyText, this::startLinkActionMode).execute(new Void[0]);
        }
    }

    public void invalidateActionModeAsync() {
        this.cancelAsyncTask();
        if (this.skipTextClassification()) {
            this.invalidateActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mTextView, this.mTextClassificationHelper.getTimeoutDuration(), this.mTextClassificationHelper::classifyText, this::invalidateActionMode).execute(new Void[0]);
        }
    }

    public void onSelectionAction(int menuItemId) {
        this.mSelectionTracker.onSelectionAction(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SelectionActionModeHelper.getActionType(menuItemId), this.mTextClassification);
    }

    public void onSelectionDrag() {
        this.mSelectionTracker.onSelectionAction(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), 106, this.mTextClassification);
    }

    public void onTextChanged(int start, int end) {
        this.mSelectionTracker.onTextChanged(start, end, this.mTextClassification);
    }

    public boolean resetSelection(int textIndex) {
        if (this.mSelectionTracker.resetSelection(textIndex, this.mEditor)) {
            this.invalidateActionModeAsync();
            return true;
        }
        return false;
    }

    public TextClassification getTextClassification() {
        return this.mTextClassification;
    }

    public void onDestroyActionMode() {
        this.cancelSmartSelectAnimation();
        this.mSelectionTracker.onSelectionDestroyed();
        this.cancelAsyncTask();
    }

    public void onDraw(Canvas canvas) {
        if (this.isDrawingHighlight() && this.mSmartSelectSprite != null) {
            this.mSmartSelectSprite.draw(canvas);
        }
    }

    public boolean isDrawingHighlight() {
        return this.mSmartSelectSprite != null && this.mSmartSelectSprite.isAnimationActive();
    }

    private void cancelAsyncTask() {
        if (this.mTextClassificationAsyncTask != null) {
            this.mTextClassificationAsyncTask.cancel(true);
            this.mTextClassificationAsyncTask = null;
        }
        this.mTextClassification = null;
    }

    private boolean skipTextClassification() {
        boolean noOpTextClassifier = this.mTextView.getTextClassifier() == TextClassifier.NO_OP;
        boolean noSelection = this.mTextView.getSelectionEnd() == this.mTextView.getSelectionStart();
        boolean password = this.mTextView.hasPasswordTransformationMethod() || TextView.isPasswordInputType(this.mTextView.getInputType());
        return noOpTextClassifier || noSelection || password;
    }

    private void startLinkActionMode(SelectionResult result) {
        this.startActionMode(2, result);
    }

    private void startSelectionActionMode(SelectionResult result) {
        this.startActionMode(0, result);
    }

    private void startActionMode(@Editor.TextActionMode int actionMode, SelectionResult result) {
        CharSequence text = SelectionActionModeHelper.getText(this.mTextView);
        if (result != null && text instanceof Spannable && (this.mTextView.isTextSelectable() || this.mTextView.isTextEditable() || actionMode == 2)) {
            if (!this.mTextView.getTextClassifier().getSettings().isDarkLaunch()) {
                Selection.setSelection((Spannable)text, result.mStart, result.mEnd);
                this.mTextView.invalidate();
            }
            this.mTextClassification = result.mClassification;
        } else {
            this.mTextClassification = null;
        }
        if (this.mEditor.startActionModeInternal(actionMode)) {
            Editor.SelectionModifierCursorController controller = this.mEditor.getSelectionController();
            if (controller != null && (this.mTextView.isTextSelectable() || this.mTextView.isTextEditable())) {
                controller.show();
            }
            if (result != null) {
                switch (actionMode) {
                    case 0: {
                        this.mSelectionTracker.onSmartSelection(result);
                        break;
                    }
                    case 2: {
                        this.mSelectionTracker.onLinkSelected(result);
                        break;
                    }
                }
            }
        }
        this.mEditor.setRestartActionModeOnNextRefresh(false);
        this.mTextClassificationAsyncTask = null;
    }

    private void startSelectionActionModeWithSmartSelectAnimation(SelectionResult result) {
        boolean didSelectionChange;
        Layout layout2 = this.mTextView.getLayout();
        Runnable onAnimationEndCallback = () -> this.startSelectionActionMode(result);
        boolean bl = didSelectionChange = result != null && (this.mTextView.getSelectionStart() != result.mStart || this.mTextView.getSelectionEnd() != result.mEnd);
        if (!didSelectionChange) {
            onAnimationEndCallback.run();
            return;
        }
        List<SmartSelectSprite.RectangleWithTextSelectionLayout> selectionRectangles = this.convertSelectionToRectangles(layout2, result.mStart, result.mEnd);
        PointF touchPoint = new PointF(this.mEditor.getLastUpPositionX(), this.mEditor.getLastUpPositionY());
        PointF animationStartPoint = SelectionActionModeHelper.movePointInsideNearestRectangle(touchPoint, selectionRectangles, SmartSelectSprite.RectangleWithTextSelectionLayout::getRectangle);
        this.mSmartSelectSprite.startAnimation(animationStartPoint, selectionRectangles, onAnimationEndCallback);
    }

    private List<SmartSelectSprite.RectangleWithTextSelectionLayout> convertSelectionToRectangles(Layout layout2, int start, int end) {
        ArrayList<SmartSelectSprite.RectangleWithTextSelectionLayout> result = new ArrayList<SmartSelectSprite.RectangleWithTextSelectionLayout>();
        Layout.SelectionRectangleConsumer consumer = (left, top, right, bottom, textSelectionLayout) -> SelectionActionModeHelper.mergeRectangleIntoList(result, new RectF(left, top, right, bottom), SmartSelectSprite.RectangleWithTextSelectionLayout::getRectangle, r -> new SmartSelectSprite.RectangleWithTextSelectionLayout((RectF)r, textSelectionLayout));
        layout2.getSelection(start, end, consumer);
        result.sort(Comparator.comparing(SmartSelectSprite.RectangleWithTextSelectionLayout::getRectangle, SmartSelectSprite.RECTANGLE_COMPARATOR));
        return result;
    }

    @VisibleForTesting
    public static <T> void mergeRectangleIntoList(List<T> list, RectF candidate, Function<T, RectF> extractor, Function<RectF, T> packer) {
        int index;
        if (candidate.isEmpty()) {
            return;
        }
        int elementCount = list.size();
        for (index = 0; index < elementCount; ++index) {
            boolean canMerge;
            RectF existingRectangle = extractor.apply(list.get(index));
            if (existingRectangle.contains(candidate)) {
                return;
            }
            if (candidate.contains(existingRectangle)) {
                existingRectangle.setEmpty();
                continue;
            }
            boolean rectanglesContinueEachOther = candidate.left == existingRectangle.right || candidate.right == existingRectangle.left;
            boolean bl = canMerge = candidate.top == existingRectangle.top && candidate.bottom == existingRectangle.bottom && (RectF.intersects(candidate, existingRectangle) || rectanglesContinueEachOther);
            if (!canMerge) continue;
            candidate.union(existingRectangle);
            existingRectangle.setEmpty();
        }
        for (index = elementCount - 1; index >= 0; --index) {
            RectF rectangle = extractor.apply(list.get(index));
            if (!rectangle.isEmpty()) continue;
            list.remove(index);
        }
        list.add(packer.apply(candidate));
    }

    @VisibleForTesting
    public static <T> PointF movePointInsideNearestRectangle(PointF point, List<T> list, Function<T, RectF> extractor) {
        float bestX = -1.0f;
        float bestY = -1.0f;
        double bestDistance = Double.MAX_VALUE;
        int elementCount = list.size();
        for (int index = 0; index < elementCount; ++index) {
            RectF rectangle = extractor.apply(list.get(index));
            float candidateY = rectangle.centerY();
            float candidateX = point.x > rectangle.right ? rectangle.right : (point.x < rectangle.left ? rectangle.left : point.x);
            double candidateDistance = Math.pow(point.x - candidateX, 2.0) + Math.pow(point.y - candidateY, 2.0);
            if (!(candidateDistance < bestDistance)) continue;
            bestX = candidateX;
            bestY = candidateY;
            bestDistance = candidateDistance;
        }
        return new PointF(bestX, bestY);
    }

    private void invalidateActionMode(SelectionResult result) {
        this.cancelSmartSelectAnimation();
        this.mTextClassification = result != null ? result.mClassification : null;
        ActionMode actionMode = this.mEditor.getTextActionMode();
        if (actionMode != null) {
            actionMode.invalidate();
        }
        this.mSelectionTracker.onSelectionUpdated(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), this.mTextClassification);
        this.mTextClassificationAsyncTask = null;
    }

    private void resetTextClassificationHelper(int selectionStart, int selectionEnd) {
        if (selectionStart < 0 || selectionEnd < 0) {
            selectionStart = this.mTextView.getSelectionStart();
            selectionEnd = this.mTextView.getSelectionEnd();
        }
        this.mTextClassificationHelper.init(this.mTextView.getContext(), this.mTextView.getTextClassifier(), SelectionActionModeHelper.getText(this.mTextView), selectionStart, selectionEnd, this.mTextView.getTextLocales());
    }

    private void resetTextClassificationHelper() {
        this.resetTextClassificationHelper(-1, -1);
    }

    private void cancelSmartSelectAnimation() {
        if (this.mSmartSelectSprite != null) {
            this.mSmartSelectSprite.cancelAnimation();
        }
    }

    private static int getActionType(int menuItemId) {
        switch (menuItemId) {
            case 16908319: {
                return 200;
            }
            case 0x1020020: {
                return 103;
            }
            case 0x1020021: {
                return 101;
            }
            case 0x1020022: 
            case 16908337: {
                return 102;
            }
            case 16908341: {
                return 104;
            }
            case 16908353: {
                return 105;
            }
        }
        return 108;
    }

    private static CharSequence getText(TextView textView) {
        CharSequence text = textView.getText();
        if (text != null) {
            return text;
        }
        return "";
    }

    private static final class SelectionResult {
        private final int mStart;
        private final int mEnd;
        private final TextClassification mClassification;
        private final TextSelection mSelection;

        SelectionResult(int start, int end, TextClassification classification, TextSelection selection) {
            this.mStart = start;
            this.mEnd = end;
            this.mClassification = Preconditions.checkNotNull(classification);
            this.mSelection = selection;
        }
    }

    private static final class TextClassificationHelper {
        private static final int TRIM_DELTA = 120;
        private Context mContext;
        private TextClassifier mTextClassifier;
        private String mText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private final TextSelection.Options mSelectionOptions = new TextSelection.Options();
        private final TextClassification.Options mClassificationOptions = new TextClassification.Options();
        private CharSequence mTrimmedText;
        private int mTrimStart;
        private int mRelativeStart;
        private int mRelativeEnd;
        private CharSequence mLastClassificationText;
        private int mLastClassificationSelectionStart;
        private int mLastClassificationSelectionEnd;
        private LocaleList mLastClassificationLocales;
        private SelectionResult mLastClassificationResult;
        private boolean mHot;

        TextClassificationHelper(Context context, TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.init(context, textClassifier, text, selectionStart, selectionEnd, locales);
        }

        public void init(Context context, TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.mContext = Preconditions.checkNotNull(context);
            this.mTextClassifier = Preconditions.checkNotNull(textClassifier);
            this.mText = Preconditions.checkNotNull(text).toString();
            this.mLastClassificationText = null;
            Preconditions.checkArgument(selectionEnd > selectionStart);
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            this.mClassificationOptions.setDefaultLocales(locales);
            this.mSelectionOptions.setDefaultLocales(locales).setDarkLaunchAllowed(true);
        }

        public SelectionResult classifyText() {
            this.mHot = true;
            return this.performClassification(null);
        }

        public SelectionResult suggestSelection() {
            this.mHot = true;
            this.trimText();
            TextSelection selection = this.mContext.getApplicationInfo().targetSdkVersion > 27 ? this.mTextClassifier.suggestSelection(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mSelectionOptions) : this.mTextClassifier.suggestSelection(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mSelectionOptions.getDefaultLocales());
            if (!this.mTextClassifier.getSettings().isDarkLaunch()) {
                this.mSelectionStart = Math.max(0, selection.getSelectionStartIndex() + this.mTrimStart);
                this.mSelectionEnd = Math.min(this.mText.length(), selection.getSelectionEndIndex() + this.mTrimStart);
            }
            return this.performClassification(selection);
        }

        public int getTimeoutDuration() {
            if (this.mHot) {
                return 200;
            }
            return 500;
        }

        private SelectionResult performClassification(TextSelection selection) {
            if (!Objects.equals(this.mText, this.mLastClassificationText) || this.mSelectionStart != this.mLastClassificationSelectionStart || this.mSelectionEnd != this.mLastClassificationSelectionEnd || !Objects.equals(this.mClassificationOptions.getDefaultLocales(), this.mLastClassificationLocales)) {
                this.mLastClassificationText = this.mText;
                this.mLastClassificationSelectionStart = this.mSelectionStart;
                this.mLastClassificationSelectionEnd = this.mSelectionEnd;
                this.mLastClassificationLocales = this.mClassificationOptions.getDefaultLocales();
                this.trimText();
                TextClassification classification = this.mContext.getApplicationInfo().targetSdkVersion > 27 ? this.mTextClassifier.classifyText(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mClassificationOptions) : this.mTextClassifier.classifyText(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mClassificationOptions.getDefaultLocales());
                this.mLastClassificationResult = new SelectionResult(this.mSelectionStart, this.mSelectionEnd, classification, selection);
            }
            return this.mLastClassificationResult;
        }

        private void trimText() {
            this.mTrimStart = Math.max(0, this.mSelectionStart - 120);
            int referenceEnd = Math.min(this.mText.length(), this.mSelectionEnd + 120);
            this.mTrimmedText = this.mText.subSequence(this.mTrimStart, referenceEnd);
            this.mRelativeStart = this.mSelectionStart - this.mTrimStart;
            this.mRelativeEnd = this.mSelectionEnd - this.mTrimStart;
        }
    }

    private static final class TextClassificationAsyncTask
    extends AsyncTask<Void, Void, SelectionResult> {
        private final int mTimeOutDuration;
        private final Supplier<SelectionResult> mSelectionResultSupplier;
        private final Consumer<SelectionResult> mSelectionResultCallback;
        private final TextView mTextView;
        private final String mOriginalText;

        TextClassificationAsyncTask(TextView textView, int timeOut, Supplier<SelectionResult> selectionResultSupplier, Consumer<SelectionResult> selectionResultCallback) {
            super(textView != null ? textView.getHandler() : null);
            this.mTextView = Preconditions.checkNotNull(textView);
            this.mTimeOutDuration = timeOut;
            this.mSelectionResultSupplier = Preconditions.checkNotNull(selectionResultSupplier);
            this.mSelectionResultCallback = Preconditions.checkNotNull(selectionResultCallback);
            this.mOriginalText = SelectionActionModeHelper.getText(this.mTextView).toString();
        }

        protected SelectionResult doInBackground(Void ... params) {
            Runnable onTimeOut = this::onTimeOut;
            this.mTextView.postDelayed(onTimeOut, this.mTimeOutDuration);
            SelectionResult result = this.mSelectionResultSupplier.get();
            this.mTextView.removeCallbacks(onTimeOut);
            return result;
        }

        @Override
        protected void onPostExecute(SelectionResult result) {
            result = TextUtils.equals(this.mOriginalText, SelectionActionModeHelper.getText(this.mTextView)) ? result : null;
            this.mSelectionResultCallback.accept(result);
        }

        private void onTimeOut() {
            if (this.getStatus() == AsyncTask.Status.RUNNING) {
                this.onPostExecute(null);
            }
            this.cancel(true);
        }
    }

    private static final class SelectionMetricsLogger {
        private static final String LOG_TAG = "SelectionMetricsLogger";
        private static final Pattern PATTERN_WHITESPACE = Pattern.compile("\\s+");
        private final Logger mLogger;
        private final boolean mEditTextLogger;
        private final BreakIterator mTokenIterator;
        private int mStartIndex;
        private String mText;

        SelectionMetricsLogger(TextView textView) {
            Preconditions.checkNotNull(textView);
            this.mLogger = textView.getTextClassifier().getLogger(new Logger.Config(textView.getContext(), SelectionMetricsLogger.getWidetType(textView), null));
            this.mEditTextLogger = textView.isTextEditable();
            this.mTokenIterator = this.mLogger.getTokenIterator(textView.getTextLocale());
        }

        private static String getWidetType(TextView textView) {
            if (textView.isTextEditable()) {
                return "edittext";
            }
            if (textView.isTextSelectable()) {
                return "textview";
            }
            return "nosel-textview";
        }

        public void logSelectionStarted(CharSequence text, int index) {
            try {
                Preconditions.checkNotNull(text);
                Preconditions.checkArgumentInRange(index, 0, text.length(), "index");
                if (this.mText == null || !this.mText.contentEquals(text)) {
                    this.mText = text.toString();
                }
                this.mTokenIterator.setText(this.mText);
                this.mStartIndex = index;
                this.mLogger.logSelectionStartedEvent(0);
            }
            catch (Exception e) {
                Log.d(LOG_TAG, e.getMessage());
            }
        }

        public void logSelectionModified(int start, int end, TextClassification classification, TextSelection selection) {
            try {
                Preconditions.checkArgumentInRange(start, 0, this.mText.length(), "start");
                Preconditions.checkArgumentInRange(end, start, this.mText.length(), "end");
                int[] wordIndices = this.getWordDelta(start, end);
                if (selection != null) {
                    this.mLogger.logSelectionModifiedEvent(wordIndices[0], wordIndices[1], selection);
                } else if (classification != null) {
                    this.mLogger.logSelectionModifiedEvent(wordIndices[0], wordIndices[1], classification);
                } else {
                    this.mLogger.logSelectionModifiedEvent(wordIndices[0], wordIndices[1]);
                }
            }
            catch (Exception e) {
                Log.d(LOG_TAG, e.getMessage());
            }
        }

        public void logSelectionAction(int start, int end, int action, TextClassification classification) {
            try {
                Preconditions.checkArgumentInRange(start, 0, this.mText.length(), "start");
                Preconditions.checkArgumentInRange(end, start, this.mText.length(), "end");
                int[] wordIndices = this.getWordDelta(start, end);
                if (classification != null) {
                    this.mLogger.logSelectionActionEvent(wordIndices[0], wordIndices[1], action, classification);
                } else {
                    this.mLogger.logSelectionActionEvent(wordIndices[0], wordIndices[1], action);
                }
            }
            catch (Exception e) {
                Log.d(LOG_TAG, e.getMessage());
            }
        }

        public boolean isEditTextLogger() {
            return this.mEditTextLogger;
        }

        private int[] getWordDelta(int start, int end) {
            int[] wordIndices = new int[2];
            if (start == this.mStartIndex) {
                wordIndices[0] = 0;
            } else if (start < this.mStartIndex) {
                wordIndices[0] = -this.countWordsForward(start);
            } else {
                wordIndices[0] = this.countWordsBackward(start);
                if (!this.mTokenIterator.isBoundary(start) && !this.isWhitespace(this.mTokenIterator.preceding(start), this.mTokenIterator.following(start))) {
                    wordIndices[0] = wordIndices[0] - 1;
                }
            }
            wordIndices[1] = end == this.mStartIndex ? 0 : (end < this.mStartIndex ? -this.countWordsForward(end) : this.countWordsBackward(end));
            return wordIndices;
        }

        private int countWordsBackward(int from) {
            Preconditions.checkArgument(from >= this.mStartIndex);
            int wordCount = 0;
            int offset = from;
            while (offset > this.mStartIndex) {
                int start = this.mTokenIterator.preceding(offset);
                if (!this.isWhitespace(start, offset)) {
                    ++wordCount;
                }
                offset = start;
            }
            return wordCount;
        }

        private int countWordsForward(int from) {
            Preconditions.checkArgument(from <= this.mStartIndex);
            int wordCount = 0;
            int offset = from;
            while (offset < this.mStartIndex) {
                int end = this.mTokenIterator.following(offset);
                if (!this.isWhitespace(offset, end)) {
                    ++wordCount;
                }
                offset = end;
            }
            return wordCount;
        }

        private boolean isWhitespace(int start, int end) {
            return PATTERN_WHITESPACE.matcher(this.mText.substring(start, end)).matches();
        }
    }

    private static final class SelectionTracker {
        private final TextView mTextView;
        private SelectionMetricsLogger mLogger;
        private int mOriginalStart;
        private int mOriginalEnd;
        private int mSelectionStart;
        private int mSelectionEnd;
        private boolean mAllowReset;
        private final LogAbandonRunnable mDelayedLogAbandon = new LogAbandonRunnable();

        SelectionTracker(TextView textView) {
            this.mTextView = Preconditions.checkNotNull(textView);
            this.mLogger = new SelectionMetricsLogger(textView);
        }

        public void onOriginalSelection(CharSequence text, int selectionStart, int selectionEnd) {
            this.mDelayedLogAbandon.flush();
            this.mOriginalStart = this.mSelectionStart = selectionStart;
            this.mOriginalEnd = this.mSelectionEnd = selectionEnd;
            this.mAllowReset = false;
            this.maybeInvalidateLogger();
            this.mLogger.logSelectionStarted(text, selectionStart);
        }

        public void onSmartSelection(SelectionResult result) {
            this.onClassifiedSelection(result);
            this.mLogger.logSelectionModified(result.mStart, result.mEnd, result.mClassification, result.mSelection);
        }

        public void onLinkSelected(SelectionResult result) {
            this.onClassifiedSelection(result);
        }

        private void onClassifiedSelection(SelectionResult result) {
            if (this.isSelectionStarted()) {
                this.mSelectionStart = result.mStart;
                this.mSelectionEnd = result.mEnd;
                this.mAllowReset = this.mSelectionStart != this.mOriginalStart || this.mSelectionEnd != this.mOriginalEnd;
            }
        }

        public void onSelectionUpdated(int selectionStart, int selectionEnd, TextClassification classification) {
            if (this.isSelectionStarted()) {
                this.mSelectionStart = selectionStart;
                this.mSelectionEnd = selectionEnd;
                this.mAllowReset = false;
                this.mLogger.logSelectionModified(selectionStart, selectionEnd, classification, null);
            }
        }

        public void onSelectionDestroyed() {
            this.mAllowReset = false;
            this.mDelayedLogAbandon.schedule(100);
        }

        public void onSelectionAction(int selectionStart, int selectionEnd, int action, TextClassification classification) {
            if (this.isSelectionStarted()) {
                this.mAllowReset = false;
                this.mLogger.logSelectionAction(selectionStart, selectionEnd, action, classification);
            }
        }

        public boolean resetSelection(int textIndex, Editor editor) {
            TextView textView = editor.getTextView();
            if (this.isSelectionStarted() && this.mAllowReset && textIndex >= this.mSelectionStart && textIndex <= this.mSelectionEnd && SelectionActionModeHelper.getText(textView) instanceof Spannable) {
                this.mAllowReset = false;
                boolean selected = editor.selectCurrentWord();
                if (selected) {
                    this.mSelectionStart = editor.getTextView().getSelectionStart();
                    this.mSelectionEnd = editor.getTextView().getSelectionEnd();
                    this.mLogger.logSelectionAction(textView.getSelectionStart(), textView.getSelectionEnd(), 201, null);
                }
                return selected;
            }
            return false;
        }

        public void onTextChanged(int start, int end, TextClassification classification) {
            if (this.isSelectionStarted() && start == this.mSelectionStart && end == this.mSelectionEnd) {
                this.onSelectionAction(start, end, 100, classification);
            }
        }

        private void maybeInvalidateLogger() {
            if (this.mLogger.isEditTextLogger() != this.mTextView.isTextEditable()) {
                this.mLogger = new SelectionMetricsLogger(this.mTextView);
            }
        }

        private boolean isSelectionStarted() {
            return this.mSelectionStart >= 0 && this.mSelectionEnd >= 0 && this.mSelectionStart != this.mSelectionEnd;
        }

        private final class LogAbandonRunnable
        implements Runnable {
            private boolean mIsPending;

            private LogAbandonRunnable() {
            }

            void schedule(int delayMillis) {
                if (this.mIsPending) {
                    Log.e(SelectionActionModeHelper.LOG_TAG, "Force flushing abandon due to new scheduling request");
                    this.flush();
                }
                this.mIsPending = true;
                SelectionTracker.this.mTextView.postDelayed(this, delayMillis);
            }

            void flush() {
                SelectionTracker.this.mTextView.removeCallbacks(this);
                this.run();
            }

            @Override
            public void run() {
                if (this.mIsPending) {
                    SelectionTracker.this.mLogger.logSelectionAction(SelectionTracker.this.mSelectionStart, SelectionTracker.this.mSelectionEnd, 107, null);
                    SelectionTracker.this.mSelectionStart = (SelectionTracker.this.mSelectionEnd = -1);
                    this.mIsPending = false;
                }
            }
        }
    }
}

