/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Checkable;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.ThemedSpinnerAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleAdapter
extends BaseAdapter
implements Filterable,
ThemedSpinnerAdapter {
    private final LayoutInflater mInflater;
    private int[] mTo;
    private String[] mFrom;
    private ViewBinder mViewBinder;
    private List<? extends Map<String, ?>> mData;
    private int mResource;
    private int mDropDownResource;
    private LayoutInflater mDropDownInflater;
    private SimpleFilter mFilter;
    private ArrayList<Map<String, ?>> mUnfilteredData;

    public SimpleAdapter(Context context, List<? extends Map<String, ?>> data, int resource, String[] from, int[] to) {
        this.mData = data;
        this.mResource = this.mDropDownResource = resource;
        this.mFrom = from;
        this.mTo = to;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    @Override
    public int getCount() {
        return this.mData.size();
    }

    @Override
    public Object getItem(int position) {
        return this.mData.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createViewFromResource(this.mInflater, position, convertView, parent, this.mResource);
    }

    private View createViewFromResource(LayoutInflater inflater, int position, View convertView, ViewGroup parent, int resource) {
        View v = convertView == null ? inflater.inflate(resource, parent, false) : convertView;
        this.bindView(position, v);
        return v;
    }

    public void setDropDownViewResource(int resource) {
        this.mDropDownResource = resource;
    }

    @Override
    public void setDropDownViewTheme(Resources.Theme theme) {
        if (theme == null) {
            this.mDropDownInflater = null;
        } else if (theme == this.mInflater.getContext().getTheme()) {
            this.mDropDownInflater = this.mInflater;
        } else {
            ContextThemeWrapper context = new ContextThemeWrapper(this.mInflater.getContext(), theme);
            this.mDropDownInflater = LayoutInflater.from(context);
        }
    }

    @Override
    public Resources.Theme getDropDownViewTheme() {
        return this.mDropDownInflater == null ? null : this.mDropDownInflater.getContext().getTheme();
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = this.mDropDownInflater == null ? this.mInflater : this.mDropDownInflater;
        return this.createViewFromResource(inflater, position, convertView, parent, this.mDropDownResource);
    }

    private void bindView(int position, View view) {
        Map<String, ?> dataSet = this.mData.get(position);
        if (dataSet == null) {
            return;
        }
        ViewBinder binder = this.mViewBinder;
        String[] from = this.mFrom;
        int[] to = this.mTo;
        int count = to.length;
        for (int i = 0; i < count; ++i) {
            String text;
            Object v = view.findViewById(to[i]);
            if (v == null) continue;
            Object data = dataSet.get(from[i]);
            String string2 = text = data == null ? "" : data.toString();
            if (text == null) {
                text = "";
            }
            boolean bound = false;
            if (binder != null) {
                bound = binder.setViewValue((View)v, data, text);
            }
            if (bound) continue;
            if (v instanceof Checkable) {
                if (data instanceof Boolean) {
                    ((Checkable)v).setChecked((Boolean)data);
                    continue;
                }
                if (v instanceof TextView) {
                    this.setViewText((TextView)v, text);
                    continue;
                }
                throw new IllegalStateException(v.getClass().getName() + " should be bound to a Boolean, not a " + (data == null ? "<unknown type>" : data.getClass()));
            }
            if (v instanceof TextView) {
                this.setViewText((TextView)v, text);
                continue;
            }
            if (v instanceof ImageView) {
                if (data instanceof Integer) {
                    this.setViewImage((ImageView)v, (Integer)data);
                    continue;
                }
                this.setViewImage((ImageView)v, text);
                continue;
            }
            throw new IllegalStateException(v.getClass().getName() + " is not a  view that can be bounds by this SimpleAdapter");
        }
    }

    public ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    public void setViewBinder(ViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
    }

    public void setViewImage(ImageView v, int value) {
        v.setImageResource(value);
    }

    public void setViewImage(ImageView v, String value) {
        try {
            v.setImageResource(Integer.parseInt(value));
        }
        catch (NumberFormatException nfe) {
            v.setImageURI(Uri.parse(value));
        }
    }

    public void setViewText(TextView v, String text) {
        v.setText(text);
    }

    @Override
    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new SimpleFilter();
        }
        return this.mFilter;
    }

    private class SimpleFilter
    extends Filter {
        private SimpleFilter() {
        }

        @Override
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (SimpleAdapter.this.mUnfilteredData == null) {
                SimpleAdapter.this.mUnfilteredData = new ArrayList(SimpleAdapter.this.mData);
            }
            if (prefix == null || prefix.length() == 0) {
                ArrayList list = SimpleAdapter.this.mUnfilteredData;
                results.values = list;
                results.count = list.size();
            } else {
                String prefixString = prefix.toString().toLowerCase();
                ArrayList unfilteredValues = SimpleAdapter.this.mUnfilteredData;
                int count = unfilteredValues.size();
                ArrayList<Map> newValues = new ArrayList<Map>(count);
                for (int i = 0; i < count; ++i) {
                    Map h = (Map)unfilteredValues.get(i);
                    if (h == null) continue;
                    int len = SimpleAdapter.this.mTo.length;
                    block1: for (int j = 0; j < len; ++j) {
                        String str = (String)h.get(SimpleAdapter.this.mFrom[j]);
                        for (String word : str.split(" ")) {
                            if (!word.toLowerCase().startsWith(prefixString)) continue;
                            newValues.add(h);
                            continue block1;
                        }
                    }
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        @Override
        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            SimpleAdapter.this.mData = (List)results.values;
            if (results.count > 0) {
                SimpleAdapter.this.notifyDataSetChanged();
            } else {
                SimpleAdapter.this.notifyDataSetInvalidated();
            }
        }
    }

    public static interface ViewBinder {
        public boolean setViewValue(View var1, Object var2, String var3);
    }
}

