/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class SmartSelectSprite {
    private static final int EXPAND_DURATION = 300;
    private static final int CORNER_DURATION = 50;
    private final Interpolator mExpandInterpolator;
    private final Interpolator mCornerInterpolator;
    private Animator mActiveAnimator = null;
    private final Runnable mInvalidator;
    private final int mFillColor;
    static final Comparator<RectF> RECTANGLE_COMPARATOR = Comparator.comparingDouble(e -> e.bottom).thenComparingDouble(e -> e.left);
    private Drawable mExistingDrawable = null;
    private RectangleList mExistingRectangleList = null;

    SmartSelectSprite(Context context, int highlightColor, Runnable invalidator) {
        this.mExpandInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mCornerInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mFillColor = highlightColor;
        this.mInvalidator = Preconditions.checkNotNull(invalidator);
    }

    public void startAnimation(PointF start, List<RectangleWithTextSelectionLayout> destinationRectangles, Runnable onAnimationEnd) {
        this.cancelAnimation();
        ValueAnimator.AnimatorUpdateListener updateListener = valueAnimator -> this.mInvalidator.run();
        int rectangleCount = destinationRectangles.size();
        ArrayList<RoundedRectangleShape> shapes = new ArrayList<RoundedRectangleShape>(rectangleCount);
        ArrayList<Animator> cornerAnimators = new ArrayList<Animator>(rectangleCount);
        RectangleWithTextSelectionLayout centerRectangle = null;
        int startingOffset = 0;
        for (RectangleWithTextSelectionLayout rectangleWithTextSelectionLayout : destinationRectangles) {
            RectF rectangle = rectangleWithTextSelectionLayout.getRectangle();
            if (SmartSelectSprite.contains(rectangle, start)) {
                centerRectangle = rectangleWithTextSelectionLayout;
                break;
            }
            startingOffset = (int)((float)startingOffset + rectangle.width());
        }
        if (centerRectangle == null) {
            throw new IllegalArgumentException("Center point is not inside any of the rectangles!");
        }
        startingOffset = (int)((float)startingOffset + (start.x - centerRectangle.getRectangle().left));
        int[] expansionDirections = SmartSelectSprite.generateDirections(centerRectangle, destinationRectangles);
        for (int index = 0; index < rectangleCount; ++index) {
            RectangleWithTextSelectionLayout rectangleWithTextSelectionLayout = destinationRectangles.get(index);
            RectF rectangle = rectangleWithTextSelectionLayout.getRectangle();
            RoundedRectangleShape shape = new RoundedRectangleShape(rectangle, expansionDirections[index], rectangleWithTextSelectionLayout.getTextSelectionLayout() == 0);
            cornerAnimators.add(this.createCornerAnimator(shape, updateListener));
            shapes.add(shape);
        }
        RectangleList rectangleList = new RectangleList(shapes);
        ShapeDrawable shapeDrawable = new ShapeDrawable(rectangleList);
        Paint paint = shapeDrawable.getPaint();
        paint.setColor(this.mFillColor);
        paint.setStyle(Paint.Style.FILL);
        this.mExistingRectangleList = rectangleList;
        this.mExistingDrawable = shapeDrawable;
        this.mActiveAnimator = this.createAnimator(rectangleList, startingOffset, startingOffset, cornerAnimators, updateListener, onAnimationEnd);
        this.mActiveAnimator.start();
    }

    public boolean isAnimationActive() {
        return this.mActiveAnimator != null && this.mActiveAnimator.isRunning();
    }

    private Animator createAnimator(RectangleList rectangleList, float startingOffsetLeft, float startingOffsetRight, List<Animator> cornerAnimators, ValueAnimator.AnimatorUpdateListener updateListener, Runnable onAnimationEnd) {
        ObjectAnimator rightBoundaryAnimator = ObjectAnimator.ofFloat((Object)rectangleList, "rightBoundary", startingOffsetRight, rectangleList.getTotalWidth());
        ObjectAnimator leftBoundaryAnimator = ObjectAnimator.ofFloat((Object)rectangleList, "leftBoundary", startingOffsetLeft, 0.0f);
        rightBoundaryAnimator.setDuration(300L);
        leftBoundaryAnimator.setDuration(300L);
        rightBoundaryAnimator.addUpdateListener(updateListener);
        leftBoundaryAnimator.addUpdateListener(updateListener);
        rightBoundaryAnimator.setInterpolator(this.mExpandInterpolator);
        leftBoundaryAnimator.setInterpolator(this.mExpandInterpolator);
        AnimatorSet cornerAnimator = new AnimatorSet();
        cornerAnimator.playTogether(cornerAnimators);
        AnimatorSet boundaryAnimator = new AnimatorSet();
        boundaryAnimator.playTogether(leftBoundaryAnimator, rightBoundaryAnimator);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(boundaryAnimator, cornerAnimator);
        this.setUpAnimatorListener(animatorSet, onAnimationEnd);
        return animatorSet;
    }

    private void setUpAnimatorListener(Animator animator2, final Runnable onAnimationEnd) {
        animator2.addListener(new Animator.AnimatorListener(){

            @Override
            public void onAnimationStart(Animator animator2) {
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                SmartSelectSprite.this.mExistingRectangleList.setDisplayType(1);
                SmartSelectSprite.this.mInvalidator.run();
                onAnimationEnd.run();
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
            }

            @Override
            public void onAnimationRepeat(Animator animator2) {
            }
        });
    }

    private ObjectAnimator createCornerAnimator(RoundedRectangleShape shape, ValueAnimator.AnimatorUpdateListener listener) {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)shape, "roundRatio", shape.getRoundRatio(), 0.0f);
        animator2.setDuration(50L);
        animator2.addUpdateListener(listener);
        animator2.setInterpolator(this.mCornerInterpolator);
        return animator2;
    }

    private static int[] generateDirections(RectangleWithTextSelectionLayout centerRectangle, List<RectangleWithTextSelectionLayout> rectangles) {
        int i;
        int[] result = new int[rectangles.size()];
        int centerRectangleIndex = rectangles.indexOf(centerRectangle);
        for (i = 0; i < centerRectangleIndex - 1; ++i) {
            result[i] = -1;
        }
        result[centerRectangleIndex] = rectangles.size() == 1 ? 0 : (centerRectangleIndex == 0 ? -1 : (centerRectangleIndex == rectangles.size() - 1 ? 1 : 0));
        for (i = centerRectangleIndex + 1; i < result.length; ++i) {
            result[i] = 1;
        }
        return result;
    }

    private static boolean contains(RectF rectangle, PointF point) {
        float x = point.x;
        float y = point.y;
        return x >= rectangle.left && x <= rectangle.right && y >= rectangle.top && y <= rectangle.bottom;
    }

    private void removeExistingDrawables() {
        this.mExistingDrawable = null;
        this.mExistingRectangleList = null;
        this.mInvalidator.run();
    }

    public void cancelAnimation() {
        if (this.mActiveAnimator != null) {
            this.mActiveAnimator.cancel();
            this.mActiveAnimator = null;
            this.removeExistingDrawables();
        }
    }

    public void draw(Canvas canvas) {
        if (this.mExistingDrawable != null) {
            this.mExistingDrawable.draw(canvas);
        }
    }

    private static final class RectangleList
    extends Shape {
        private static final String PROPERTY_RIGHT_BOUNDARY = "rightBoundary";
        private static final String PROPERTY_LEFT_BOUNDARY = "leftBoundary";
        private final List<RoundedRectangleShape> mRectangles;
        private final List<RoundedRectangleShape> mReversedRectangles;
        private final Path mOutlinePolygonPath;
        private int mDisplayType = 0;

        private RectangleList(List<RoundedRectangleShape> rectangles) {
            this.mRectangles = new ArrayList<RoundedRectangleShape>(rectangles);
            this.mReversedRectangles = new ArrayList<RoundedRectangleShape>(rectangles);
            Collections.reverse(this.mReversedRectangles);
            this.mOutlinePolygonPath = RectangleList.generateOutlinePolygonPath(rectangles);
        }

        private void setLeftBoundary(float leftBoundary) {
            float boundarySoFar = this.getTotalWidth();
            for (RoundedRectangleShape rectangle : this.mReversedRectangles) {
                float rectangleLeftBoundary = boundarySoFar - rectangle.getBoundingWidth();
                if (leftBoundary < rectangleLeftBoundary) {
                    rectangle.setStartBoundary(0.0f);
                } else if (leftBoundary > boundarySoFar) {
                    rectangle.setStartBoundary(rectangle.getBoundingWidth());
                } else {
                    rectangle.setStartBoundary(rectangle.getBoundingWidth() - boundarySoFar + leftBoundary);
                }
                boundarySoFar = rectangleLeftBoundary;
            }
        }

        private void setRightBoundary(float rightBoundary) {
            float boundarySoFar = 0.0f;
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                float rectangleRightBoundary = rectangle.getBoundingWidth() + boundarySoFar;
                if (rectangleRightBoundary < rightBoundary) {
                    rectangle.setEndBoundary(rectangle.getBoundingWidth());
                } else if (boundarySoFar > rightBoundary) {
                    rectangle.setEndBoundary(0.0f);
                } else {
                    rectangle.setEndBoundary(rightBoundary - boundarySoFar);
                }
                boundarySoFar = rectangleRightBoundary;
            }
        }

        void setDisplayType(int displayType) {
            this.mDisplayType = displayType;
        }

        private int getTotalWidth() {
            int sum = 0;
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                sum = (int)((float)sum + rectangle.getBoundingWidth());
            }
            return sum;
        }

        @Override
        public void draw(Canvas canvas, Paint paint) {
            if (this.mDisplayType == 1) {
                this.drawPolygon(canvas, paint);
            } else {
                this.drawRectangles(canvas, paint);
            }
        }

        private void drawRectangles(Canvas canvas, Paint paint) {
            for (RoundedRectangleShape rectangle : this.mRectangles) {
                rectangle.draw(canvas, paint);
            }
        }

        private void drawPolygon(Canvas canvas, Paint paint) {
            canvas.drawPath(this.mOutlinePolygonPath, paint);
        }

        private static Path generateOutlinePolygonPath(List<RoundedRectangleShape> rectangles) {
            Path path = new Path();
            for (RoundedRectangleShape shape : rectangles) {
                Path rectanglePath = new Path();
                rectanglePath.addRect(shape.mBoundingRectangle, Path.Direction.CW);
                path.op(rectanglePath, Path.Op.UNION);
            }
            return path;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface DisplayType {
            public static final int RECTANGLES = 0;
            public static final int POLYGON = 1;
        }
    }

    private static final class RoundedRectangleShape
    extends Shape {
        private static final String PROPERTY_ROUND_RATIO = "roundRatio";
        private final RectF mBoundingRectangle;
        private float mRoundRatio = 1.0f;
        private final int mExpansionDirection;
        private final RectF mDrawRect = new RectF();
        private final Path mClipPath = new Path();
        private float mLeftBoundary = 0.0f;
        private float mRightBoundary = 0.0f;
        private final boolean mInverted;
        private final float mBoundingWidth;

        private static int invert(int expansionDirection) {
            return expansionDirection * -1;
        }

        private RoundedRectangleShape(RectF boundingRectangle, int expansionDirection, boolean inverted) {
            this.mBoundingRectangle = new RectF(boundingRectangle);
            this.mBoundingWidth = boundingRectangle.width();
            this.mInverted = inverted && expansionDirection != 0;
            this.mExpansionDirection = inverted ? RoundedRectangleShape.invert(expansionDirection) : expansionDirection;
            if (boundingRectangle.height() > boundingRectangle.width()) {
                this.setRoundRatio(0.0f);
            } else {
                this.setRoundRatio(1.0f);
            }
        }

        @Override
        public void draw(Canvas canvas, Paint paint) {
            if (this.mLeftBoundary == this.mRightBoundary) {
                return;
            }
            float cornerRadius = this.getCornerRadius();
            float adjustedCornerRadius = this.getAdjustedCornerRadius();
            this.mDrawRect.set(this.mBoundingRectangle);
            this.mDrawRect.left = this.mBoundingRectangle.left + this.mLeftBoundary - cornerRadius / 2.0f;
            this.mDrawRect.right = this.mBoundingRectangle.left + this.mRightBoundary + cornerRadius / 2.0f;
            canvas.save();
            this.mClipPath.reset();
            this.mClipPath.addRoundRect(this.mDrawRect, adjustedCornerRadius, adjustedCornerRadius, Path.Direction.CW);
            canvas.clipPath(this.mClipPath);
            canvas.drawRect(this.mBoundingRectangle, paint);
            canvas.restore();
        }

        void setRoundRatio(float roundRatio) {
            this.mRoundRatio = roundRatio;
        }

        float getRoundRatio() {
            return this.mRoundRatio;
        }

        private void setStartBoundary(float startBoundary) {
            if (this.mInverted) {
                this.mRightBoundary = this.mBoundingWidth - startBoundary;
            } else {
                this.mLeftBoundary = startBoundary;
            }
        }

        private void setEndBoundary(float endBoundary) {
            if (this.mInverted) {
                this.mLeftBoundary = this.mBoundingWidth - endBoundary;
            } else {
                this.mRightBoundary = endBoundary;
            }
        }

        private float getCornerRadius() {
            return Math.min(this.mBoundingRectangle.width(), this.mBoundingRectangle.height());
        }

        private float getAdjustedCornerRadius() {
            return this.getCornerRadius() * this.mRoundRatio;
        }

        private float getBoundingWidth() {
            return (int)(this.mBoundingRectangle.width() + this.getCornerRadius());
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface ExpansionDirection {
            public static final int LEFT = -1;
            public static final int CENTER = 0;
            public static final int RIGHT = 1;
        }
    }

    static final class RectangleWithTextSelectionLayout {
        private final RectF mRectangle;
        private final int mTextSelectionLayout;

        RectangleWithTextSelectionLayout(RectF rectangle, int textSelectionLayout) {
            this.mRectangle = Preconditions.checkNotNull(rectangle);
            this.mTextSelectionLayout = textSelectionLayout;
        }

        public RectF getRectangle() {
            return this.mRectangle;
        }

        public int getTextSelectionLayout() {
            return this.mTextSelectionLayout;
        }
    }
}

