/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.telecom.TelecomManager;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsCallSession;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.util.Log;
import com.android.ims.ImsCall;
import com.android.ims.ImsConfig;
import com.android.ims.ImsConfigListener;
import com.android.ims.ImsConnectionStateListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsMultiEndpoint;
import com.android.ims.ImsUt;
import com.android.ims.ImsUtInterface;
import com.android.ims.MmTelFeatureConnection;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsUt;
import com.android.internal.annotations.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;

public class ImsManager {
    public static final String PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE = "persist.dbg.volte_avail_ovr";
    public static final int PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE_DEFAULT = 0;
    public static final String PROPERTY_DBG_VT_AVAIL_OVERRIDE = "persist.dbg.vt_avail_ovr";
    public static final int PROPERTY_DBG_VT_AVAIL_OVERRIDE_DEFAULT = 0;
    public static final String PROPERTY_DBG_WFC_AVAIL_OVERRIDE = "persist.dbg.wfc_avail_ovr";
    public static final int PROPERTY_DBG_WFC_AVAIL_OVERRIDE_DEFAULT = 0;
    public static final String PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE = "persist.dbg.allow_ims_off";
    public static final int PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE_DEFAULT = 0;
    public static final int INCOMING_CALL_RESULT_CODE = 101;
    public static final String EXTRA_CALL_ID = "android:imsCallID";
    public static final String ACTION_IMS_SERVICE_UP = "com.android.ims.IMS_SERVICE_UP";
    public static final String ACTION_IMS_SERVICE_DOWN = "com.android.ims.IMS_SERVICE_DOWN";
    public static final String ACTION_IMS_REGISTRATION_ERROR = "com.android.ims.REGISTRATION_ERROR";
    public static final String EXTRA_PHONE_ID = "android:phone_id";
    public static final String ACTION_IMS_INCOMING_CALL = "com.android.ims.IMS_INCOMING_CALL";
    public static final String EXTRA_SERVICE_ID = "android:imsServiceId";
    public static final String EXTRA_USSD = "android:ussd";
    public static final String EXTRA_IS_UNKNOWN_CALL = "android:isUnknown";
    private static final int SYSTEM_PROPERTY_NOT_SET = -1;
    private static final int SUB_PROPERTY_NOT_INITIALIZED = -1;
    private static final String TAG = "ImsManager";
    private static final boolean DBG = true;
    private static HashMap<Integer, ImsManager> sImsManagerInstances = new HashMap();
    private Context mContext;
    private CarrierConfigManager mConfigManager;
    private int mPhoneId;
    private final boolean mConfigDynamicBind;
    private MmTelFeatureConnection mMmTelFeatureConnection = null;
    private ImsServiceDeathRecipient mDeathRecipient = new ImsServiceDeathRecipient();
    private ImsUt mUt = null;
    private ImsConfig mConfig = null;
    private boolean mConfigUpdated = false;
    private ImsConfigListener mImsConfigListener;
    private ImsEcbm mEcbm = null;
    private ImsMultiEndpoint mMultiEndpoint = null;
    private Set<MmTelFeatureConnection.IFeatureUpdate> mStatusCallbacks = new CopyOnWriteArraySet<MmTelFeatureConnection.IFeatureUpdate>();
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final int MAX_RECENT_DISCONNECT_REASONS = 16;
    private ConcurrentLinkedDeque<ImsReasonInfo> mRecentDisconnectReasons = new ConcurrentLinkedDeque();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImsManager getInstance(Context context, int phoneId) {
        HashMap<Integer, ImsManager> hashMap = sImsManagerInstances;
        synchronized (hashMap) {
            if (sImsManagerInstances.containsKey(phoneId)) {
                ImsManager m = sImsManagerInstances.get(phoneId);
                if (m != null) {
                    m.connectIfServiceIsAvailable();
                }
                return m;
            }
            ImsManager mgr = new ImsManager(context, phoneId);
            sImsManagerInstances.put(phoneId, mgr);
            return mgr;
        }
    }

    public static boolean isEnhanced4gLteModeSettingEnabledByUser(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isEnhanced4gLteModeSettingEnabledByUser();
        }
        ImsManager.loge("isEnhanced4gLteModeSettingEnabledByUser: ImsManager null, returning default value.");
        return false;
    }

    public boolean isEnhanced4gLteModeSettingEnabledByUser() {
        int setting = SubscriptionManager.getIntegerSubscriptionProperty(this.getSubId(), "volte_vt_enabled", -1, this.mContext);
        boolean onByDefault = this.getBooleanCarrierConfig("enhanced_4g_lte_on_by_default_bool");
        if (!this.getBooleanCarrierConfig("editable_enhanced_4g_lte_bool") || setting == -1) {
            return onByDefault;
        }
        return setting == 1;
    }

    public static void setEnhanced4gLteModeSetting(Context context, boolean enabled) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            mgr.setEnhanced4gLteModeSetting(enabled);
        }
        ImsManager.loge("setEnhanced4gLteModeSetting: ImsManager null, value not set.");
    }

    public void setEnhanced4gLteModeSetting(boolean enabled) {
        int prevSetting;
        if (!this.getBooleanCarrierConfig("editable_enhanced_4g_lte_bool")) {
            enabled = this.getBooleanCarrierConfig("enhanced_4g_lte_on_by_default_bool");
        }
        if ((prevSetting = SubscriptionManager.getIntegerSubscriptionProperty(this.getSubId(), "volte_vt_enabled", -1, this.mContext)) != (enabled ? 1 : 0)) {
            SubscriptionManager.setSubscriptionProperty(this.getSubId(), "volte_vt_enabled", ImsManager.booleanToPropertyString(enabled));
            if (this.isNonTtyOrTtyOnVolteEnabled()) {
                try {
                    this.setAdvanced4GMode(enabled);
                }
                catch (ImsException imsException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isNonTtyOrTtyOnVolteEnabled(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isNonTtyOrTtyOnVolteEnabled();
        }
        ImsManager.loge("isNonTtyOrTtyOnVolteEnabled: ImsManager null, returning default value.");
        return false;
    }

    public boolean isNonTtyOrTtyOnVolteEnabled() {
        if (this.getBooleanCarrierConfig("carrier_volte_tty_supported_bool")) {
            return true;
        }
        TelecomManager tm = (TelecomManager)this.mContext.getSystemService("telecom");
        if (tm == null) {
            Log.w(TAG, "isNonTtyOrTtyOnVolteEnabled: telecom not available");
            return true;
        }
        return tm.getCurrentTtyMode() == 0;
    }

    public static boolean isVolteEnabledByPlatform(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isVolteEnabledByPlatform();
        }
        ImsManager.loge("isVolteEnabledByPlatform: ImsManager null, returning default value.");
        return false;
    }

    public boolean isVolteEnabledByPlatform() {
        if (SystemProperties.getInt(PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE + Integer.toString(this.mPhoneId), -1) == 1 || SystemProperties.getInt(PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE, -1) == 1) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956923) && this.getBooleanCarrierConfig("carrier_volte_available_bool") && this.isGbaValid();
    }

    public static boolean isVolteProvisionedOnDevice(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isVolteProvisionedOnDevice();
        }
        ImsManager.loge("isVolteProvisionedOnDevice: ImsManager null, returning default value.");
        return true;
    }

    public boolean isVolteProvisionedOnDevice() {
        if (this.getBooleanCarrierConfig("carrier_volte_provisioning_required_bool")) {
            return this.isVolteProvisioned();
        }
        return true;
    }

    public static boolean isWfcProvisionedOnDevice(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isWfcProvisionedOnDevice();
        }
        ImsManager.loge("isWfcProvisionedOnDevice: ImsManager null, returning default value.");
        return true;
    }

    public boolean isWfcProvisionedOnDevice() {
        if (this.getBooleanCarrierConfig("carrier_volte_override_wfc_provisioning_bool") && !this.isVolteProvisionedOnDevice()) {
            return false;
        }
        if (this.getBooleanCarrierConfig("carrier_volte_provisioning_required_bool")) {
            return this.isWfcProvisioned();
        }
        return true;
    }

    public static boolean isVtProvisionedOnDevice(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isVtProvisionedOnDevice();
        }
        ImsManager.loge("isVtProvisionedOnDevice: ImsManager null, returning default value.");
        return true;
    }

    public boolean isVtProvisionedOnDevice() {
        if (this.getBooleanCarrierConfig("carrier_volte_provisioning_required_bool")) {
            return this.isVtProvisioned();
        }
        return true;
    }

    public static boolean isVtEnabledByPlatform(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isVtEnabledByPlatform();
        }
        ImsManager.loge("isVtEnabledByPlatform: ImsManager null, returning default value.");
        return false;
    }

    public boolean isVtEnabledByPlatform() {
        if (SystemProperties.getInt(PROPERTY_DBG_VT_AVAIL_OVERRIDE + Integer.toString(this.mPhoneId), -1) == 1 || SystemProperties.getInt(PROPERTY_DBG_VT_AVAIL_OVERRIDE, -1) == 1) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956924) && this.getBooleanCarrierConfig("carrier_vt_available_bool") && this.isGbaValid();
    }

    public static boolean isVtEnabledByUser(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isVtEnabledByUser();
        }
        ImsManager.loge("isVtEnabledByUser: ImsManager null, returning default value.");
        return false;
    }

    public boolean isVtEnabledByUser() {
        int setting = SubscriptionManager.getIntegerSubscriptionProperty(this.getSubId(), "vt_ims_enabled", -1, this.mContext);
        return setting == -1 || setting == 1;
    }

    public static void setVtSetting(Context context, boolean enabled) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            mgr.setVtSetting(enabled);
        }
        ImsManager.loge("setVtSetting: ImsManager null, can not set value.");
    }

    public void setVtSetting(boolean enabled) {
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "vt_ims_enabled", ImsManager.booleanToPropertyString(enabled));
        try {
            this.changeMmTelCapability(2, 0, enabled);
            if (enabled) {
                ImsManager.log("setVtSetting(b) : turnOnIms");
                this.turnOnIms();
            } else if (!(!this.isVolteEnabledByPlatform() || this.isVolteEnabledByPlatform() && this.isEnhanced4gLteModeSettingEnabledByUser())) {
                ImsManager.log("setVtSetting(b) : imsServiceAllowTurnOff -> turnOffIms");
                this.turnOffIms();
            }
        }
        catch (RemoteException | ImsException e) {
            ImsManager.loge("setVtSetting(b): ", e);
        }
    }

    private static boolean isTurnOffImsAllowedByPlatform(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isTurnOffImsAllowedByPlatform();
        }
        ImsManager.loge("isTurnOffImsAllowedByPlatform: ImsManager null, returning default value.");
        return true;
    }

    private boolean isTurnOffImsAllowedByPlatform() {
        if (SystemProperties.getInt(PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE + Integer.toString(this.mPhoneId), -1) == 1 || SystemProperties.getInt(PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE, -1) == 1) {
            return true;
        }
        return this.getBooleanCarrierConfig("carrier_allow_turnoff_ims_bool");
    }

    public static boolean isWfcEnabledByUser(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isWfcEnabledByUser();
        }
        ImsManager.loge("isWfcEnabledByUser: ImsManager null, returning default value.");
        return true;
    }

    public boolean isWfcEnabledByUser() {
        int setting = SubscriptionManager.getIntegerSubscriptionProperty(this.getSubId(), "wfc_ims_enabled", -1, this.mContext);
        if (setting == -1) {
            return this.getBooleanCarrierConfig("carrier_default_wfc_ims_enabled_bool");
        }
        return setting == 1;
    }

    public static void setWfcSetting(Context context, boolean enabled) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            mgr.setWfcSetting(enabled);
        }
        ImsManager.loge("setWfcSetting: ImsManager null, can not set value.");
    }

    public void setWfcSetting(boolean enabled) {
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_enabled", ImsManager.booleanToPropertyString(enabled));
        this.setWfcNonPersistent(enabled, this.getWfcMode());
    }

    public void setWfcNonPersistent(boolean enabled, int wfcMode) {
        int imsWfcModeFeatureValue = enabled ? wfcMode : 1;
        try {
            this.changeMmTelCapability(1, 1, enabled);
            if (enabled) {
                ImsManager.log("setWfcSetting() : turnOnIms");
                this.turnOnIms();
            } else if (!(!this.isTurnOffImsAllowedByPlatform() || this.isVolteEnabledByPlatform() && this.isEnhanced4gLteModeSettingEnabledByUser())) {
                ImsManager.log("setWfcSetting() : imsServiceAllowTurnOff -> turnOffIms");
                this.turnOffIms();
            }
            this.setWfcModeInternal(imsWfcModeFeatureValue);
        }
        catch (RemoteException | ImsException e) {
            ImsManager.loge("setWfcSetting(): ", e);
        }
    }

    public static int getWfcMode(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.getWfcMode();
        }
        ImsManager.loge("getWfcMode: ImsManager null, returning default value.");
        return 0;
    }

    public int getWfcMode() {
        return this.getWfcMode(false);
    }

    public static void setWfcMode(Context context, int wfcMode) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            mgr.setWfcMode(wfcMode);
        }
        ImsManager.loge("setWfcMode: ImsManager null, can not set value.");
    }

    public void setWfcMode(int wfcMode) {
        ImsManager.log("setWfcMode(i) - setting=" + wfcMode);
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_mode", Integer.toString(wfcMode));
        this.setWfcModeInternal(wfcMode);
    }

    private void updateDefaultWfcMode() {
        ImsManager.log("updateDefaultWfcMode");
        if (!this.getBooleanCarrierConfig("editable_wfc_mode_bool")) {
            this.setWfcMode(this.getIntCarrierConfig("carrier_default_wfc_ims_mode_int"));
        }
    }

    public static int getWfcMode(Context context, boolean roaming) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.getWfcMode(roaming);
        }
        ImsManager.loge("getWfcMode: ImsManager null, returning default value.");
        return 0;
    }

    public int getWfcMode(boolean roaming) {
        int setting = 0;
        if (!roaming) {
            setting = SubscriptionManager.getIntegerSubscriptionProperty(this.getSubId(), "wfc_ims_mode", -1, this.mContext);
            if (setting == -1) {
                setting = this.getIntCarrierConfig("carrier_default_wfc_ims_mode_int");
            }
            ImsManager.log("getWfcMode - setting=" + setting);
        } else {
            setting = SubscriptionManager.getIntegerSubscriptionProperty(this.getSubId(), "wfc_ims_roaming_mode", -1, this.mContext);
            if (setting == -1) {
                setting = this.getIntCarrierConfig("carrier_default_wfc_ims_roaming_mode_int");
            }
            ImsManager.log("getWfcMode (roaming) - setting=" + setting);
        }
        return setting;
    }

    public static void setWfcMode(Context context, int wfcMode, boolean roaming) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            mgr.setWfcMode(wfcMode, roaming);
        }
        ImsManager.loge("setWfcMode: ImsManager null, can not set value.");
    }

    public void setWfcMode(int wfcMode, boolean roaming) {
        if (!roaming) {
            ImsManager.log("setWfcMode(i,b) - setting=" + wfcMode);
            SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_mode", Integer.toString(wfcMode));
        } else {
            ImsManager.log("setWfcMode(i,b) (roaming) - setting=" + wfcMode);
            SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_roaming_mode", Integer.toString(wfcMode));
        }
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        if (roaming == tm.isNetworkRoaming(this.getSubId())) {
            this.setWfcModeInternal(wfcMode);
        }
    }

    private int getSubId() {
        int[] subIds = SubscriptionManager.getSubId(this.mPhoneId);
        int subId = -1;
        if (subIds != null && subIds.length >= 1) {
            subId = subIds[0];
        }
        return subId;
    }

    private static void setWfcModeInternal(Context context, int wfcMode) {
        final ImsManager imsManager = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (imsManager != null) {
            final int value = wfcMode;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        imsManager.getConfigInterface().setConfig(27, value);
                    }
                    catch (ImsException imsException) {
                        // empty catch block
                    }
                }
            });
            thread.start();
        }
    }

    private void setWfcModeInternal(int wfcMode) {
        int value = wfcMode;
        Thread thread = new Thread(() -> {
            try {
                this.getConfigInterface().setConfig(27, value);
            }
            catch (ImsException imsException) {
                // empty catch block
            }
        });
        thread.start();
    }

    public static boolean isWfcRoamingEnabledByUser(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isWfcRoamingEnabledByUser();
        }
        ImsManager.loge("isWfcRoamingEnabledByUser: ImsManager null, returning default value.");
        return false;
    }

    public boolean isWfcRoamingEnabledByUser() {
        int setting = SubscriptionManager.getIntegerSubscriptionProperty(this.getSubId(), "wfc_ims_roaming_enabled", -1, this.mContext);
        if (setting == -1) {
            return this.getBooleanCarrierConfig("carrier_default_wfc_ims_roaming_enabled_bool");
        }
        return setting == 1;
    }

    public static void setWfcRoamingSetting(Context context, boolean enabled) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            mgr.setWfcRoamingSetting(enabled);
        }
        ImsManager.loge("setWfcRoamingSetting: ImsManager null, value not set.");
    }

    public void setWfcRoamingSetting(boolean enabled) {
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_roaming_enabled", ImsManager.booleanToPropertyString(enabled));
        this.setWfcRoamingSettingInternal(enabled);
    }

    private void setWfcRoamingSettingInternal(boolean enabled) {
        int value = enabled ? 1 : 0;
        Thread thread = new Thread(() -> {
            try {
                this.getConfigInterface().setConfig(26, value);
            }
            catch (ImsException imsException) {
                // empty catch block
            }
        });
        thread.start();
    }

    public static boolean isWfcEnabledByPlatform(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            return mgr.isWfcEnabledByPlatform();
        }
        ImsManager.loge("isWfcEnabledByPlatform: ImsManager null, returning default value.");
        return false;
    }

    public boolean isWfcEnabledByPlatform() {
        if (SystemProperties.getInt(PROPERTY_DBG_WFC_AVAIL_OVERRIDE + Integer.toString(this.mPhoneId), -1) == 1 || SystemProperties.getInt(PROPERTY_DBG_WFC_AVAIL_OVERRIDE, -1) == 1) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956925) && this.getBooleanCarrierConfig("carrier_wfc_ims_available_bool") && this.isGbaValid();
    }

    private boolean isGbaValid() {
        if (this.getBooleanCarrierConfig("carrier_ims_gba_required_bool")) {
            TelephonyManager telephonyManager = new TelephonyManager(this.mContext, this.getSubId());
            String efIst = telephonyManager.getIsimIst();
            if (efIst == null) {
                ImsManager.loge("isGbaValid - ISF is NULL");
                return true;
            }
            boolean result = efIst != null && efIst.length() > 1 && (2 & (byte)efIst.charAt(1)) != 0;
            ImsManager.log("isGbaValid - GBA capable=" + result + ", ISF=" + efIst);
            return result;
        }
        return true;
    }

    private boolean getProvisionedBool(ImsConfig config, int item) throws ImsException {
        int value = config.getProvisionedValue(item);
        if (value == -1) {
            throw new ImsException("getProvisionedBool failed with error for item: " + item, 103);
        }
        return config.getProvisionedValue(item) == 1;
    }

    private boolean getProvisionedBoolNoException(int item) {
        try {
            ImsConfig config = this.getConfigInterface();
            return this.getProvisionedBool(config, item);
        }
        catch (ImsException ex) {
            return false;
        }
    }

    public static void updateImsServiceConfig(Context context, int phoneId, boolean force) {
        ImsManager mgr = ImsManager.getInstance(context, phoneId);
        if (mgr != null) {
            mgr.updateImsServiceConfig(force);
        }
        ImsManager.loge("updateImsServiceConfig: ImsManager null, returning without update.");
    }

    public void updateImsServiceConfig(boolean force) {
        TelephonyManager tm;
        if (!force && (tm = new TelephonyManager(this.mContext, this.getSubId())).getSimState() != 5) {
            ImsManager.log("updateImsServiceConfig: SIM not ready");
            return;
        }
        if (!this.mConfigUpdated || force) {
            try {
                boolean isImsUsed = this.updateVolteFeatureValue();
                isImsUsed |= this.updateWfcFeatureAndProvisionedValues();
                if ((isImsUsed |= this.updateVideoCallFeatureValue()) || !this.isTurnOffImsAllowedByPlatform()) {
                    ImsManager.log("updateImsServiceConfig: turnOnIms");
                    this.turnOnIms();
                } else {
                    ImsManager.log("updateImsServiceConfig: turnOffIms");
                    this.turnOffIms();
                }
                this.mConfigUpdated = true;
            }
            catch (RemoteException | ImsException e) {
                ImsManager.loge("updateImsServiceConfig: ", e);
                this.mConfigUpdated = false;
            }
        }
    }

    private boolean updateVolteFeatureValue() throws RemoteException {
        boolean available = this.isVolteEnabledByPlatform();
        boolean enabled = this.isEnhanced4gLteModeSettingEnabledByUser();
        boolean isNonTty = this.isNonTtyOrTtyOnVolteEnabled();
        boolean isFeatureOn = available && enabled && isNonTty;
        ImsManager.log("updateVolteFeatureValue: available = " + available + ", enabled = " + enabled + ", nonTTY = " + isNonTty);
        this.changeMmTelCapability(1, 0, isFeatureOn);
        return isFeatureOn;
    }

    private boolean updateVideoCallFeatureValue() throws RemoteException {
        boolean available = this.isVtEnabledByPlatform();
        boolean enabled = this.isVtEnabledByUser();
        boolean isNonTty = this.isNonTtyOrTtyOnVolteEnabled();
        boolean isDataEnabled = this.isDataEnabled();
        boolean ignoreDataEnabledChanged = this.getBooleanCarrierConfig("ignore_data_enabled_changed_for_video_calls");
        boolean isFeatureOn = available && enabled && isNonTty && (ignoreDataEnabledChanged || isDataEnabled);
        ImsManager.log("updateVideoCallFeatureValue: available = " + available + ", enabled = " + enabled + ", nonTTY = " + isNonTty + ", data enabled = " + isDataEnabled);
        this.changeMmTelCapability(2, 0, isFeatureOn);
        return isFeatureOn;
    }

    private boolean updateWfcFeatureAndProvisionedValues() throws RemoteException {
        TelephonyManager tm = new TelephonyManager(this.mContext, this.getSubId());
        boolean isNetworkRoaming = tm.isNetworkRoaming();
        boolean available = this.isWfcEnabledByPlatform();
        boolean enabled = this.isWfcEnabledByUser();
        this.updateDefaultWfcMode();
        int mode = this.getWfcMode(isNetworkRoaming);
        boolean roaming = this.isWfcRoamingEnabledByUser();
        boolean isFeatureOn = available && enabled;
        ImsManager.log("updateWfcFeatureAndProvisionedValues: available = " + available + ", enabled = " + enabled + ", mode = " + mode + ", roaming = " + roaming);
        this.changeMmTelCapability(1, 1, isFeatureOn);
        if (!isFeatureOn) {
            mode = 1;
            roaming = false;
        }
        ImsManager.setWfcModeInternal(this.mContext, mode);
        this.setWfcRoamingSettingInternal(roaming);
        return isFeatureOn;
    }

    @VisibleForTesting
    public ImsManager(Context context, int phoneId) {
        this.mContext = context;
        this.mPhoneId = phoneId;
        this.mConfigDynamicBind = this.mContext.getResources().getBoolean(17956943);
        this.mConfigManager = (CarrierConfigManager)context.getSystemService("carrier_config");
        this.createImsService();
    }

    public boolean isDynamicBinding() {
        return this.mConfigDynamicBind;
    }

    public boolean isServiceAvailable() {
        this.connectIfServiceIsAvailable();
        return this.mMmTelFeatureConnection.isBinderAlive();
    }

    public boolean isServiceReady() {
        this.connectIfServiceIsAvailable();
        return this.mMmTelFeatureConnection.isBinderReady();
    }

    public void connectIfServiceIsAvailable() {
        if (this.mMmTelFeatureConnection == null || !this.mMmTelFeatureConnection.isBinderAlive()) {
            this.createImsService();
        }
    }

    public void setConfigListener(ImsConfigListener listener) {
        this.mImsConfigListener = listener;
    }

    public void addNotifyStatusChangedCallbackIfAvailable(MmTelFeatureConnection.IFeatureUpdate c) throws ImsException {
        if (!this.mMmTelFeatureConnection.isBinderAlive()) {
            throw new ImsException("Binder is not active!", 106);
        }
        if (c != null) {
            this.mStatusCallbacks.add(c);
        }
    }

    public void removeNotifyStatusChangedCallback(MmTelFeatureConnection.IFeatureUpdate c) {
        if (c != null) {
            this.mStatusCallbacks.remove(c);
        } else {
            Log.w(TAG, "removeNotifyStatusChangedCallback: callback is null!");
        }
    }

    public void open(MmTelFeature.Listener listener) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        try {
            this.mMmTelFeatureConnection.openConnection(listener);
        }
        catch (RemoteException e) {
            throw new ImsException("open()", e, 106);
        }
    }

    public void addRegistrationListener(int serviceClass, ImsConnectionStateListener listener) throws ImsException {
        this.addRegistrationListener(listener);
    }

    public void addRegistrationListener(final ImsConnectionStateListener listener) throws ImsException {
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        this.addRegistrationCallback(listener);
        this.addCapabilitiesCallback(new ImsFeature.CapabilityCallback(){

            @Override
            public void onCapabilitiesStatusChanged(ImsFeature.Capabilities config) {
                listener.onFeatureCapabilityChangedAdapter(ImsManager.this.getRegistrationTech(), config);
            }
        });
        ImsManager.log("Registration Callback registered.");
    }

    public void addRegistrationCallback(ImsRegistrationImplBase.Callback callback) throws ImsException {
        if (callback == null) {
            throw new NullPointerException("registration callback can't be null");
        }
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mMmTelFeatureConnection.addRegistrationCallback(callback);
            ImsManager.log("Registration Callback registered.");
        }
        catch (RemoteException e) {
            throw new ImsException("addRegistrationCallback(IRIB)", e, 106);
        }
    }

    public void addCapabilitiesCallback(ImsFeature.CapabilityCallback callback) throws ImsException {
        if (callback == null) {
            throw new NullPointerException("capabilities callback can't be null");
        }
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mMmTelFeatureConnection.addCapabilityCallback(callback);
            ImsManager.log("Capability Callback registered.");
        }
        catch (RemoteException e) {
            throw new ImsException("addCapabilitiesCallback(IF)", e, 106);
        }
    }

    public void removeRegistrationListener(ImsConnectionStateListener listener) throws ImsException {
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mMmTelFeatureConnection.removeRegistrationCallback(listener);
            ImsManager.log("Registration Callback/Listener registered.");
        }
        catch (RemoteException e) {
            throw new ImsException("addRegistrationCallback()", e, 106);
        }
    }

    public int getRegistrationTech() {
        try {
            return this.mMmTelFeatureConnection.getRegistrationTech();
        }
        catch (RemoteException e) {
            Log.w(TAG, "getRegistrationTech: no connection to ImsService.");
            return -1;
        }
    }

    public void close() {
        if (this.mMmTelFeatureConnection != null) {
            this.mMmTelFeatureConnection.closeConnection();
        }
        this.mUt = null;
        this.mConfig = null;
        this.mEcbm = null;
        this.mMultiEndpoint = null;
    }

    public ImsUtInterface getSupplementaryServiceConfiguration() throws ImsException {
        if (this.mUt != null && this.mUt.isBinderAlive()) {
            return this.mUt;
        }
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            IImsUt iUt = this.mMmTelFeatureConnection.getUtInterface();
            if (iUt == null) {
                throw new ImsException("getSupplementaryServiceConfiguration()", 801);
            }
            this.mUt = new ImsUt(iUt);
        }
        catch (RemoteException e) {
            throw new ImsException("getSupplementaryServiceConfiguration()", e, 106);
        }
        return this.mUt;
    }

    public ImsCallProfile createCallProfile(int serviceType, int callType) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            return this.mMmTelFeatureConnection.createCallProfile(serviceType, callType);
        }
        catch (RemoteException e) {
            throw new ImsException("createCallProfile()", e, 106);
        }
    }

    public ImsCall makeCall(ImsCallProfile profile, String[] callees, ImsCall.Listener listener) throws ImsException {
        ImsManager.log("makeCall :: profile=" + profile);
        this.checkAndThrowExceptionIfServiceUnavailable();
        ImsCall call = new ImsCall(this.mContext, profile);
        call.setListener(listener);
        ImsCallSession session = this.createCallSession(profile);
        if (callees != null && callees.length == 1) {
            call.start(session, callees[0]);
        } else {
            call.start(session, callees);
        }
        return call;
    }

    public ImsCall takeCall(IImsCallSession session, Bundle incomingCallExtras, ImsCall.Listener listener) throws ImsException {
        ImsManager.log("takeCall :: incomingCall=" + incomingCallExtras);
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (incomingCallExtras == null) {
            throw new ImsException("Can't retrieve session with null intent", 101);
        }
        String callId = ImsManager.getCallId(incomingCallExtras);
        if (callId == null) {
            throw new ImsException("Call ID missing in the incoming call intent", 101);
        }
        try {
            if (session == null) {
                throw new ImsException("No pending session for the call", 107);
            }
            ImsCall call = new ImsCall(this.mContext, session.getCallProfile());
            call.attachSession(new ImsCallSession(session));
            call.setListener(listener);
            return call;
        }
        catch (Throwable t) {
            throw new ImsException("takeCall()", t, 0);
        }
    }

    public ImsConfig getConfigInterface() throws ImsException {
        if (this.mConfig != null && this.mConfig.isBinderAlive()) {
            return this.mConfig;
        }
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            IImsConfig config = this.mMmTelFeatureConnection.getConfigInterface();
            if (config == null) {
                throw new ImsException("getConfigInterface()", 131);
            }
            this.mConfig = new ImsConfig(config, this.mContext);
        }
        catch (RemoteException e) {
            throw new ImsException("getConfigInterface()", e, 106);
        }
        return this.mConfig;
    }

    public void changeMmTelCapability(int capability, int radioTech, boolean isEnabled) throws RemoteException {
        CapabilityChangeRequest request = new CapabilityChangeRequest();
        if (isEnabled) {
            request.addCapabilitiesToEnableForTech(capability, radioTech);
        } else {
            request.addCapabilitiesToDisableForTech(capability, radioTech);
        }
        this.mMmTelFeatureConnection.changeEnabledCapabilities(request, null);
        if (this.mImsConfigListener != null) {
            this.mImsConfigListener.onSetFeatureResponse(capability, this.mMmTelFeatureConnection.getRegistrationTech(), isEnabled ? 1 : 0, -1);
        }
    }

    public void setRttEnabled(boolean enabled) {
        try {
            this.setAdvanced4GMode(enabled || this.isEnhanced4gLteModeSettingEnabledByUser());
            int value = enabled ? 1 : 0;
            Thread thread = new Thread(() -> {
                try {
                    Log.i(ImsManager.class.getSimpleName(), "Setting RTT enabled to " + enabled);
                    this.getConfigInterface().setProvisionedValue(66, value);
                }
                catch (ImsException e) {
                    Log.e(ImsManager.class.getSimpleName(), "Unable to set RTT enabled to " + enabled + ": " + e);
                }
            });
            thread.start();
        }
        catch (ImsException e) {
            Log.e(ImsManager.class.getSimpleName(), "Unable to set RTT enabled to " + enabled + ": " + e);
        }
    }

    public void setTtyMode(int ttyMode) throws ImsException {
        if (!this.getBooleanCarrierConfig("carrier_volte_tty_supported_bool")) {
            this.setAdvanced4GMode(ttyMode == 0 && this.isEnhanced4gLteModeSettingEnabledByUser());
        }
    }

    public void setUiTTYMode(Context context, int uiTtyMode, Message onComplete) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mMmTelFeatureConnection.setUiTTYMode(uiTtyMode, onComplete);
        }
        catch (RemoteException e) {
            throw new ImsException("setTTYMode()", e, 106);
        }
    }

    private ImsReasonInfo makeACopy(ImsReasonInfo imsReasonInfo) {
        Parcel p = Parcel.obtain();
        imsReasonInfo.writeToParcel(p, 0);
        p.setDataPosition(0);
        ImsReasonInfo clonedReasonInfo = ImsReasonInfo.CREATOR.createFromParcel(p);
        p.recycle();
        return clonedReasonInfo;
    }

    public ArrayList<ImsReasonInfo> getRecentImsDisconnectReasons() {
        ArrayList<ImsReasonInfo> disconnectReasons = new ArrayList<ImsReasonInfo>();
        for (ImsReasonInfo reason : this.mRecentDisconnectReasons) {
            disconnectReasons.add(this.makeACopy(reason));
        }
        return disconnectReasons;
    }

    public int getImsServiceState() throws ImsException {
        return this.mMmTelFeatureConnection.getFeatureState();
    }

    private boolean getBooleanCarrierConfig(String key) {
        int[] subIds = SubscriptionManager.getSubId(this.mPhoneId);
        int subId = -1;
        if (subIds != null && subIds.length >= 1) {
            subId = subIds[0];
        }
        PersistableBundle b = null;
        if (this.mConfigManager != null) {
            b = this.mConfigManager.getConfigForSubId(subId);
        }
        if (b != null) {
            return b.getBoolean(key);
        }
        return CarrierConfigManager.getDefaultConfig().getBoolean(key);
    }

    private int getIntCarrierConfig(String key) {
        int[] subIds = SubscriptionManager.getSubId(this.mPhoneId);
        int subId = -1;
        if (subIds != null && subIds.length >= 1) {
            subId = subIds[0];
        }
        PersistableBundle b = null;
        if (this.mConfigManager != null) {
            b = this.mConfigManager.getConfigForSubId(subId);
        }
        if (b != null) {
            return b.getInt(key);
        }
        return CarrierConfigManager.getDefaultConfig().getInt(key);
    }

    private static String getCallId(Bundle incomingCallExtras) {
        if (incomingCallExtras == null) {
            return null;
        }
        return incomingCallExtras.getString(EXTRA_CALL_ID);
    }

    private void checkAndThrowExceptionIfServiceUnavailable() throws ImsException {
        if (this.mMmTelFeatureConnection == null || !this.mMmTelFeatureConnection.isBinderAlive()) {
            this.createImsService();
            if (this.mMmTelFeatureConnection == null) {
                throw new ImsException("Service is unavailable", 106);
            }
        }
    }

    private void createImsService() {
        Rlog.i(TAG, "Creating ImsService");
        this.mMmTelFeatureConnection = MmTelFeatureConnection.create(this.mContext, this.mPhoneId);
        this.mMmTelFeatureConnection.setStatusCallback(new MmTelFeatureConnection.IFeatureUpdate(){

            @Override
            public void notifyStateChanged() {
                ImsManager.this.mStatusCallbacks.forEach(MmTelFeatureConnection.IFeatureUpdate::notifyStateChanged);
            }

            @Override
            public void notifyUnavailable() {
                ImsManager.this.mStatusCallbacks.forEach(MmTelFeatureConnection.IFeatureUpdate::notifyUnavailable);
            }
        });
    }

    private ImsCallSession createCallSession(ImsCallProfile profile) throws ImsException {
        try {
            return new ImsCallSession(this.mMmTelFeatureConnection.createCallSession(profile));
        }
        catch (RemoteException e) {
            Rlog.w(TAG, "CreateCallSession: Error, remote exception: " + e.getMessage());
            throw new ImsException("createCallSession()", e, 106);
        }
    }

    private static void log(String s) {
        Rlog.d(TAG, s);
    }

    private static void loge(String s) {
        Rlog.e(TAG, s);
    }

    private static void loge(String s, Throwable t) {
        Rlog.e(TAG, s, t);
    }

    private void turnOnIms() throws ImsException {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        tm.enableIms(this.mPhoneId);
    }

    private boolean isImsTurnOffAllowed() {
        return this.isTurnOffImsAllowedByPlatform() && (!this.isWfcEnabledByPlatform() || !this.isWfcEnabledByUser());
    }

    private void setLteFeatureValues(boolean turnOn) {
        ImsManager.log("setLteFeatureValues: " + turnOn);
        CapabilityChangeRequest request = new CapabilityChangeRequest();
        if (turnOn) {
            request.addCapabilitiesToEnableForTech(1, 0);
        } else {
            request.addCapabilitiesToDisableForTech(1, 0);
        }
        if (this.isVolteEnabledByPlatform()) {
            boolean enableViLte;
            boolean ignoreDataEnabledChanged = this.getBooleanCarrierConfig("ignore_data_enabled_changed_for_video_calls");
            boolean bl = enableViLte = turnOn && this.isVtEnabledByUser() && (ignoreDataEnabledChanged || this.isDataEnabled());
            if (enableViLte) {
                request.addCapabilitiesToEnableForTech(2, 0);
            } else {
                request.addCapabilitiesToDisableForTech(2, 0);
            }
        }
        try {
            this.mMmTelFeatureConnection.changeEnabledCapabilities(request, null);
        }
        catch (RemoteException e) {
            Log.e(TAG, "setLteFeatureValues: Exception: " + e.getMessage());
        }
    }

    private void setAdvanced4GMode(boolean turnOn) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (turnOn) {
            this.setLteFeatureValues(turnOn);
            ImsManager.log("setAdvanced4GMode: turnOnIms");
            this.turnOnIms();
        } else {
            if (this.isImsTurnOffAllowed()) {
                ImsManager.log("setAdvanced4GMode: turnOffIms");
                this.turnOffIms();
            }
            this.setLteFeatureValues(turnOn);
        }
    }

    private void turnOffIms() throws ImsException {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        tm.disableIms(this.mPhoneId);
    }

    private void addToRecentDisconnectReasons(ImsReasonInfo reason) {
        if (reason == null) {
            return;
        }
        while (this.mRecentDisconnectReasons.size() >= 16) {
            this.mRecentDisconnectReasons.removeFirst();
        }
        this.mRecentDisconnectReasons.addLast(reason);
    }

    public ImsEcbm getEcbmInterface() throws ImsException {
        if (this.mEcbm != null && this.mEcbm.isBinderAlive()) {
            return this.mEcbm;
        }
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            IImsEcbm iEcbm = this.mMmTelFeatureConnection.getEcbmInterface();
            if (iEcbm == null) {
                throw new ImsException("getEcbmInterface()", 901);
            }
            this.mEcbm = new ImsEcbm(iEcbm);
        }
        catch (RemoteException e) {
            throw new ImsException("getEcbmInterface()", e, 106);
        }
        return this.mEcbm;
    }

    public void sendSms(int token, int messageRef, String format, String smsc, boolean isRetry, byte[] pdu) throws ImsException {
        try {
            this.mMmTelFeatureConnection.sendSms(token, messageRef, format, smsc, isRetry, pdu);
        }
        catch (RemoteException e) {
            throw new ImsException("sendSms()", e, 106);
        }
    }

    public void acknowledgeSms(int token, int messageRef, int result) throws ImsException {
        try {
            this.mMmTelFeatureConnection.acknowledgeSms(token, messageRef, result);
        }
        catch (RemoteException e) {
            throw new ImsException("acknowledgeSms()", e, 106);
        }
    }

    public void acknowledgeSmsReport(int token, int messageRef, int result) throws ImsException {
        try {
            this.mMmTelFeatureConnection.acknowledgeSmsReport(token, messageRef, result);
        }
        catch (RemoteException e) {
            throw new ImsException("acknowledgeSmsReport()", e, 106);
        }
    }

    public String getSmsFormat() throws ImsException {
        try {
            return this.mMmTelFeatureConnection.getSmsFormat();
        }
        catch (RemoteException e) {
            throw new ImsException("getSmsFormat()", e, 106);
        }
    }

    public void setSmsListener(IImsSmsListener listener) throws ImsException {
        try {
            this.mMmTelFeatureConnection.setSmsListener(listener);
        }
        catch (RemoteException e) {
            throw new ImsException("setSmsListener()", e, 106);
        }
    }

    public void onSmsReady() throws ImsException {
        try {
            this.mMmTelFeatureConnection.onSmsReady();
        }
        catch (RemoteException e) {
            throw new ImsException("onSmsReady()", e, 106);
        }
    }

    public ImsMultiEndpoint getMultiEndpointInterface() throws ImsException {
        if (this.mMultiEndpoint != null && this.mMultiEndpoint.isBinderAlive()) {
            return this.mMultiEndpoint;
        }
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            IImsMultiEndpoint iImsMultiEndpoint = this.mMmTelFeatureConnection.getMultiEndpointInterface();
            if (iImsMultiEndpoint == null) {
                throw new ImsException("getMultiEndpointInterface()", 902);
            }
            this.mMultiEndpoint = new ImsMultiEndpoint(iImsMultiEndpoint);
        }
        catch (RemoteException e) {
            throw new ImsException("getMultiEndpointInterface()", e, 106);
        }
        return this.mMultiEndpoint;
    }

    public static void factoryReset(Context context) {
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (mgr != null) {
            mgr.factoryReset();
        }
        ImsManager.loge("factoryReset: ImsManager null.");
    }

    public void factoryReset() {
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "volte_vt_enabled", ImsManager.booleanToPropertyString(this.getBooleanCarrierConfig("enhanced_4g_lte_on_by_default_bool")));
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_enabled", ImsManager.booleanToPropertyString(this.getBooleanCarrierConfig("carrier_default_wfc_ims_enabled_bool")));
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_mode", Integer.toString(this.getIntCarrierConfig("carrier_default_wfc_ims_mode_int")));
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "wfc_ims_roaming_enabled", ImsManager.booleanToPropertyString(this.getBooleanCarrierConfig("carrier_default_wfc_ims_roaming_enabled_bool")));
        SubscriptionManager.setSubscriptionProperty(this.getSubId(), "vt_ims_enabled", ImsManager.booleanToPropertyString(true));
        this.updateImsServiceConfig(true);
    }

    private boolean isDataEnabled() {
        return new TelephonyManager(this.mContext, this.getSubId()).isMobileDataEnabled();
    }

    private boolean isVolteProvisioned() {
        return this.getProvisionedBoolNoException(10);
    }

    private boolean isWfcProvisioned() {
        return this.getProvisionedBoolNoException(28);
    }

    private boolean isVtProvisioned() {
        return this.getProvisionedBoolNoException(11);
    }

    private static String booleanToPropertyString(boolean bool2) {
        return bool2 ? "1" : "0";
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsManager:");
        pw.println("  mPhoneId = " + this.mPhoneId);
        pw.println("  mConfigUpdated = " + this.mConfigUpdated);
        pw.println("  mImsServiceProxy = " + this.mMmTelFeatureConnection);
        pw.println("  mDataEnabled = " + this.isDataEnabled());
        pw.println("  ignoreDataEnabledChanged = " + this.getBooleanCarrierConfig("ignore_data_enabled_changed_for_video_calls"));
        pw.println("  isGbaValid = " + this.isGbaValid());
        pw.println("  isImsTurnOffAllowed = " + this.isImsTurnOffAllowed());
        pw.println("  isNonTtyOrTtyOnVolteEnabled = " + this.isNonTtyOrTtyOnVolteEnabled());
        pw.println("  isVolteEnabledByPlatform = " + this.isVolteEnabledByPlatform());
        pw.println("  isVolteProvisionedOnDevice = " + this.isVolteProvisionedOnDevice());
        pw.println("  isEnhanced4gLteModeSettingEnabledByUser = " + this.isEnhanced4gLteModeSettingEnabledByUser());
        pw.println("  isVtEnabledByPlatform = " + this.isVtEnabledByPlatform());
        pw.println("  isVtEnabledByUser = " + this.isVtEnabledByUser());
        pw.println("  isWfcEnabledByPlatform = " + this.isWfcEnabledByPlatform());
        pw.println("  isWfcEnabledByUser = " + this.isWfcEnabledByUser());
        pw.println("  getWfcMode = " + this.getWfcMode());
        pw.println("  isWfcRoamingEnabledByUser = " + this.isWfcRoamingEnabledByUser());
        pw.println("  isVtProvisionedOnDevice = " + this.isVtProvisionedOnDevice());
        pw.println("  isWfcProvisionedOnDevice = " + this.isWfcProvisionedOnDevice());
        pw.flush();
    }

    private class ImsServiceDeathRecipient
    implements IBinder.DeathRecipient {
        private ImsServiceDeathRecipient() {
        }

        @Override
        public void binderDied() {
            ImsManager.this.mMmTelFeatureConnection = null;
            ImsManager.this.mUt = null;
            ImsManager.this.mConfig = null;
            ImsManager.this.mEcbm = null;
            ImsManager.this.mMultiEndpoint = null;
        }
    }
}

