/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.util.Log;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.ims.internal.IImsUt;
import java.util.HashSet;
import java.util.Set;

public class MmTelFeatureConnection {
    protected static final String TAG = "MmTelFeatureConnection";
    protected final int mSlotId;
    protected IBinder mBinder;
    private Context mContext;
    private volatile boolean mIsAvailable = true;
    private Integer mFeatureStateCached = null;
    private IFeatureUpdate mStatusCallback;
    private final Object mLock = new Object();
    private MmTelFeature.Listener mMmTelFeatureListener;
    private ImsRegistrationCallbackAdapter mRegistrationCallbackManager = new ImsRegistrationCallbackAdapter();
    private final CapabilityCallbackManager mCapabilityCallbackManager = new CapabilityCallbackManager();
    private final IImsServiceFeatureCallback mListenerBinder = new IImsServiceFeatureCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imsFeatureCreated(int slotId, int feature) throws RemoteException {
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                if (!MmTelFeatureConnection.this.mIsAvailable && MmTelFeatureConnection.this.mSlotId == slotId && feature == 1) {
                    Log.i(MmTelFeatureConnection.TAG, "Feature enabled on slotId: " + slotId + " for feature: " + feature);
                    MmTelFeatureConnection.this.mIsAvailable = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imsFeatureRemoved(int slotId, int feature) throws RemoteException {
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                if (MmTelFeatureConnection.this.mIsAvailable && MmTelFeatureConnection.this.mSlotId == slotId && feature == 1) {
                    Log.i(MmTelFeatureConnection.TAG, "Feature disabled on slotId: " + slotId + " for feature: " + feature);
                    MmTelFeatureConnection.this.mIsAvailable = false;
                    if (MmTelFeatureConnection.this.mStatusCallback != null) {
                        MmTelFeatureConnection.this.mStatusCallback.notifyUnavailable();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imsStatusChanged(int slotId, int feature, int status) throws RemoteException {
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                Log.i(MmTelFeatureConnection.TAG, "imsStatusChanged: slot: " + slotId + " feature: " + feature + " status: " + status);
                if (MmTelFeatureConnection.this.mSlotId == slotId && feature == 1) {
                    MmTelFeatureConnection.this.mFeatureStateCached = status;
                    if (MmTelFeatureConnection.this.mStatusCallback != null) {
                        MmTelFeatureConnection.this.mStatusCallback.notifyStateChanged();
                    }
                }
            }
        }
    };

    public static MmTelFeatureConnection create(Context context, int slotId) {
        MmTelFeatureConnection serviceProxy = new MmTelFeatureConnection(context, slotId);
        TelephonyManager tm = MmTelFeatureConnection.getTelephonyManager(context);
        if (tm == null) {
            Rlog.w(TAG, "create: TelephonyManager is null!");
            return serviceProxy;
        }
        IImsMmTelFeature binder = tm.getImsMmTelFeatureAndListen(slotId, serviceProxy.getListener());
        if (binder != null) {
            serviceProxy.setBinder(binder.asBinder());
            serviceProxy.getFeatureState();
        } else {
            Rlog.w(TAG, "create: binder is null! Slot Id: " + slotId);
        }
        return serviceProxy;
    }

    public static TelephonyManager getTelephonyManager(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public MmTelFeatureConnection(Context context, int slotId) {
        this.mSlotId = slotId;
        this.mContext = context;
    }

    private IImsRegistration getRegistration() {
        TelephonyManager tm = MmTelFeatureConnection.getTelephonyManager(this.mContext);
        return tm != null ? tm.getImsRegistration(this.mSlotId, 1) : null;
    }

    private IImsConfig getConfig() {
        TelephonyManager tm = MmTelFeatureConnection.getTelephonyManager(this.mContext);
        return tm != null ? tm.getImsConfig(this.mSlotId, 1) : null;
    }

    public IImsServiceFeatureCallback getListener() {
        return this.mListenerBinder;
    }

    public void setBinder(IBinder binder) {
        this.mBinder = binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection(MmTelFeature.Listener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.mMmTelFeatureListener = listener;
            this.getServiceInterface(this.mBinder).setListener(this.mMmTelFeatureListener);
        }
    }

    public void closeConnection() {
        this.mRegistrationCallbackManager.close();
        this.mCapabilityCallbackManager.close();
        try {
            this.getServiceInterface(this.mBinder).setListener(null);
        }
        catch (RemoteException e) {
            Log.w(TAG, "closeConnection: couldn't remove listener!");
        }
    }

    public void addRegistrationCallback(ImsRegistrationImplBase.Callback callback) throws RemoteException {
        this.mRegistrationCallbackManager.addCallback(callback);
    }

    public void removeRegistrationCallback(ImsRegistrationImplBase.Callback callback) throws RemoteException {
        this.mRegistrationCallbackManager.removeCallback(callback);
    }

    public void addCapabilityCallback(ImsFeature.CapabilityCallback callback) throws RemoteException {
        this.mCapabilityCallbackManager.addCallback(callback);
    }

    public void removeCapabilityCallback(ImsFeature.CapabilityCallback callback) throws RemoteException {
        this.mCapabilityCallbackManager.removeCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEnabledCapabilities(CapabilityChangeRequest request, ImsFeature.CapabilityCallback callback) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).changeCapabilitiesConfiguration(request, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryEnabledCapabilities(int capability, int radioTech, ImsFeature.CapabilityCallback callback) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).queryCapabilityConfiguration(capability, radioTech, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmTelFeature.MmTelCapabilities queryCapabilityStatus() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return new MmTelFeature.MmTelCapabilities(this.getServiceInterface(this.mBinder).queryCapabilityStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsCallProfile createCallProfile(int callServiceType, int callType) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).createCallProfile(callServiceType, callType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsCallSession createCallSession(ImsCallProfile profile) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).createCallSession(profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsUt getUtInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getUtInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsConfig getConfigInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRegistrationTech() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            IImsRegistration registration = this.getRegistration();
            if (registration != null) {
                return registration.getRegistrationTechnology();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsEcbm getEcbmInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getEcbmInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).setUiTtyMode(uiTtyMode, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getMultiEndpointInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSms(int token, int messageRef, String format, String smsc, boolean isRetry, byte[] pdu) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).sendSms(token, messageRef, format, smsc, isRetry, pdu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSms(int token, int messageRef, int result) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).acknowledgeSms(token, messageRef, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSmsReport(int token, int messageRef, int result) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).acknowledgeSmsReport(token, messageRef, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSmsFormat() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getSmsFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSmsReady() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).onSmsReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmsListener(IImsSmsListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).setSmsListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFeatureState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBinderAlive() && this.mFeatureStateCached != null) {
                Log.i(TAG, "getFeatureState - returning cached: " + this.mFeatureStateCached);
                return this.mFeatureStateCached;
            }
        }
        Integer status = this.retrieveFeatureState();
        Object object2 = this.mLock;
        synchronized (object2) {
            if (status == null) {
                return 0;
            }
            this.mFeatureStateCached = status;
        }
        Log.i(TAG, "getFeatureState - returning " + status);
        return status;
    }

    private Integer retrieveFeatureState() {
        if (this.mBinder != null) {
            try {
                return this.getServiceInterface(this.mBinder).getFeatureState();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setStatusCallback(IFeatureUpdate c) {
        this.mStatusCallback = c;
    }

    public boolean isBinderReady() {
        return this.isBinderAlive() && this.getFeatureState() == 2;
    }

    public boolean isBinderAlive() {
        return this.mIsAvailable && this.mBinder != null && this.mBinder.isBinderAlive();
    }

    protected void checkServiceIsReady() throws RemoteException {
        if (!this.isBinderReady()) {
            throw new RemoteException("ImsServiceProxy is not ready to accept commands.");
        }
    }

    private IImsMmTelFeature getServiceInterface(IBinder b) {
        return IImsMmTelFeature.Stub.asInterface(b);
    }

    protected void checkBinderConnection() throws RemoteException {
        if (!this.isBinderAlive()) {
            throw new RemoteException("ImsServiceProxy is not available for that feature.");
        }
    }

    public static interface IFeatureUpdate {
        public void notifyStateChanged();

        public void notifyUnavailable();
    }

    private class CapabilityCallbackManager
    extends CallbackAdapterManager<ImsFeature.CapabilityCallback> {
        private final CapabilityCallbackAdapter mCallbackAdapter;

        private CapabilityCallbackManager() {
            this.mCallbackAdapter = new CapabilityCallbackAdapter();
        }

        @Override
        boolean createConnection() throws RemoteException {
            IImsMmTelFeature binder = MmTelFeatureConnection.this.getServiceInterface(MmTelFeatureConnection.this.mBinder);
            if (binder != null) {
                binder.addCapabilityCallback(this.mCallbackAdapter);
                return true;
            }
            Log.w(MmTelFeatureConnection.TAG, "create: Couldn't get IImsMmTelFeature binder");
            return false;
        }

        @Override
        void removeConnection() {
            IImsMmTelFeature binder = MmTelFeatureConnection.this.getServiceInterface(MmTelFeatureConnection.this.mBinder);
            if (binder != null) {
                try {
                    binder.removeCapabilityCallback(this.mCallbackAdapter);
                }
                catch (RemoteException e) {
                    Log.w(MmTelFeatureConnection.TAG, "remove: IImsMmTelFeature binder is dead");
                }
            } else {
                Log.w(MmTelFeatureConnection.TAG, "remove: Couldn't get IImsMmTelFeature binder");
            }
        }

        private class CapabilityCallbackAdapter
        extends ImsFeature.CapabilityCallback {
            private CapabilityCallbackAdapter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesStatusChanged(ImsFeature.Capabilities config) {
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    CapabilityCallbackManager.this.mLocalCallbacks.forEach(callback -> callback.onCapabilitiesStatusChanged(config));
                }
            }
        }
    }

    private class ImsRegistrationCallbackAdapter
    extends CallbackAdapterManager<ImsRegistrationImplBase.Callback> {
        private final RegistrationCallbackAdapter mRegistrationCallbackAdapter;

        private ImsRegistrationCallbackAdapter() {
            this.mRegistrationCallbackAdapter = new RegistrationCallbackAdapter();
        }

        @Override
        boolean createConnection() throws RemoteException {
            IImsRegistration imsRegistration = MmTelFeatureConnection.this.getRegistration();
            if (imsRegistration != null) {
                MmTelFeatureConnection.this.getRegistration().addRegistrationCallback(this.mRegistrationCallbackAdapter);
                return true;
            }
            Log.e(MmTelFeatureConnection.TAG, "ImsRegistration is null");
            return false;
        }

        @Override
        void removeConnection() {
            IImsRegistration imsRegistration = MmTelFeatureConnection.this.getRegistration();
            if (imsRegistration != null) {
                try {
                    MmTelFeatureConnection.this.getRegistration().addRegistrationCallback(this.mRegistrationCallbackAdapter);
                }
                catch (RemoteException e) {
                    Log.w(MmTelFeatureConnection.TAG, "removeConnection: couldn't remove registration callback");
                }
            } else {
                Log.e(MmTelFeatureConnection.TAG, "ImsRegistration is null");
            }
        }

        private class RegistrationCallbackAdapter
        extends IImsRegistrationCallback.Stub {
            private RegistrationCallbackAdapter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistered(int imsRadioTech) {
                Log.i(MmTelFeatureConnection.TAG, "onRegistered ::");
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    ImsRegistrationCallbackAdapter.this.mLocalCallbacks.forEach(l -> l.onRegistered(imsRadioTech));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistering(int imsRadioTech) {
                Log.i(MmTelFeatureConnection.TAG, "onRegistering ::");
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    ImsRegistrationCallbackAdapter.this.mLocalCallbacks.forEach(l -> l.onRegistering(imsRadioTech));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeregistered(ImsReasonInfo imsReasonInfo) {
                Log.i(MmTelFeatureConnection.TAG, "onDeregistered ::");
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    ImsRegistrationCallbackAdapter.this.mLocalCallbacks.forEach(l -> l.onDeregistered(imsReasonInfo));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTechnologyChangeFailed(int targetRadioTech, ImsReasonInfo imsReasonInfo) {
                Log.i(MmTelFeatureConnection.TAG, "onTechnologyChangeFailed :: targetAccessTech=" + targetRadioTech + ", imsReasonInfo=" + imsReasonInfo);
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    ImsRegistrationCallbackAdapter.this.mLocalCallbacks.forEach(l -> l.onTechnologyChangeFailed(targetRadioTech, imsReasonInfo));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscriberAssociatedUriChanged(Uri[] uris) {
                Log.i(MmTelFeatureConnection.TAG, "onSubscriberAssociatedUriChanged");
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    ImsRegistrationCallbackAdapter.this.mLocalCallbacks.forEach(l -> l.onSubscriberAssociatedUriChanged(uris));
                }
            }
        }
    }

    private abstract class CallbackAdapterManager<T> {
        private static final String TAG = "CallbackAdapterManager";
        protected final Set<T> mLocalCallbacks = new HashSet<T>();
        private boolean mHasConnected = false;

        private CallbackAdapterManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallback(T localCallback) throws RemoteException {
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                if (!this.mHasConnected) {
                    if (this.createConnection()) {
                        this.mHasConnected = true;
                    } else {
                        throw new RemoteException("Can not create connection!");
                    }
                }
                Log.i(TAG, "Local callback added: " + localCallback);
                this.mLocalCallbacks.add(localCallback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCallback(T localCallback) {
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                Log.i(TAG, "Local callback removed: " + localCallback);
                this.mLocalCallbacks.remove(localCallback);
                if (this.mHasConnected && this.mLocalCallbacks.isEmpty()) {
                    this.removeConnection();
                    this.mHasConnected = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                if (this.mHasConnected) {
                    this.removeConnection();
                    this.mHasConnected = false;
                }
                Log.i(TAG, "Closing connection and clearing callbacks");
                this.mLocalCallbacks.clear();
            }
        }

        abstract boolean createConnection() throws RemoteException;

        abstract void removeConnection();
    }
}

