/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;

public final class ColorDisplayController {
    private static final String TAG = "ColorDisplayController";
    private static final boolean DEBUG = false;
    public static final int AUTO_MODE_DISABLED = 0;
    public static final int AUTO_MODE_CUSTOM = 1;
    public static final int AUTO_MODE_TWILIGHT = 2;
    public static final int COLOR_MODE_NATURAL = 0;
    public static final int COLOR_MODE_BOOSTED = 1;
    public static final int COLOR_MODE_SATURATED = 2;
    private static final String PERSISTENT_PROPERTY_SATURATION = "persist.sys.sf.color_saturation";
    private static final String PERSISTENT_PROPERTY_NATIVE_MODE = "persist.sys.sf.native_mode";
    private final Context mContext;
    private final int mUserId;
    private final ContentObserver mContentObserver;
    private Callback mCallback;

    public ColorDisplayController(Context context) {
        this(context, ActivityManager.getCurrentUser());
    }

    public ColorDisplayController(Context context, int userId) {
        this.mContext = context.getApplicationContext();
        this.mUserId = userId;
        this.mContentObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

            @Override
            public void onChange(boolean selfChange, Uri uri) {
                String setting;
                super.onChange(selfChange, uri);
                String string2 = setting = uri == null ? null : uri.getLastPathSegment();
                if (setting != null) {
                    ColorDisplayController.this.onSettingChanged(setting);
                }
            }
        };
    }

    public boolean isActivated() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_activated", 0, this.mUserId) == 1;
    }

    public boolean setActivated(boolean activated) {
        if (this.isActivated() != activated) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "night_display_last_activated_time", LocalDateTime.now().toString(), this.mUserId);
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_activated", activated ? 1 : 0, this.mUserId);
    }

    public LocalDateTime getLastActivatedTime() {
        ContentResolver cr = this.mContext.getContentResolver();
        String lastActivatedTime = Settings.Secure.getStringForUser(cr, "night_display_last_activated_time", this.mUserId);
        if (lastActivatedTime != null) {
            try {
                return LocalDateTime.parse(lastActivatedTime);
            }
            catch (DateTimeParseException dateTimeParseException) {
                try {
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(lastActivatedTime)), ZoneId.systemDefault());
                }
                catch (NumberFormatException | DateTimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public int getAutoMode() {
        int autoMode = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", -1, this.mUserId);
        if (autoMode == -1) {
            autoMode = this.mContext.getResources().getInteger(17694763);
        }
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            Slog.e(TAG, "Invalid autoMode: " + autoMode);
            autoMode = 0;
        }
        return autoMode;
    }

    public boolean setAutoMode(int autoMode) {
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            throw new IllegalArgumentException("Invalid autoMode: " + autoMode);
        }
        if (this.getAutoMode() != autoMode) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "night_display_last_activated_time", null, this.mUserId);
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", autoMode, this.mUserId);
    }

    public LocalTime getCustomStartTime() {
        int startTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", -1, this.mUserId);
        if (startTimeValue == -1) {
            startTimeValue = this.mContext.getResources().getInteger(17694765);
        }
        return LocalTime.ofSecondOfDay(startTimeValue / 1000);
    }

    public boolean setCustomStartTime(LocalTime startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("startTime cannot be null");
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", startTime.toSecondOfDay() * 1000, this.mUserId);
    }

    public LocalTime getCustomEndTime() {
        int endTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", -1, this.mUserId);
        if (endTimeValue == -1) {
            endTimeValue = this.mContext.getResources().getInteger(17694764);
        }
        return LocalTime.ofSecondOfDay(endTimeValue / 1000);
    }

    public boolean setCustomEndTime(LocalTime endTime) {
        if (endTime == null) {
            throw new IllegalArgumentException("endTime cannot be null");
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", endTime.toSecondOfDay() * 1000, this.mUserId);
    }

    public int getColorTemperature() {
        int colorTemperature = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", -1, this.mUserId);
        if (colorTemperature == -1) {
            colorTemperature = this.getDefaultColorTemperature();
        }
        int minimumTemperature = this.getMinimumColorTemperature();
        int maximumTemperature = this.getMaximumColorTemperature();
        if (colorTemperature < minimumTemperature) {
            colorTemperature = minimumTemperature;
        } else if (colorTemperature > maximumTemperature) {
            colorTemperature = maximumTemperature;
        }
        return colorTemperature;
    }

    public boolean setColorTemperature(int colorTemperature) {
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", colorTemperature, this.mUserId);
    }

    public int getColorMode() {
        int colorMode = Settings.System.getIntForUser(this.mContext.getContentResolver(), "display_color_mode", -1, this.mUserId);
        if (colorMode < 0 || colorMode > 2) {
            if ("1".equals(SystemProperties.get(PERSISTENT_PROPERTY_NATIVE_MODE))) {
                return 2;
            }
            return "1.0".equals(SystemProperties.get(PERSISTENT_PROPERTY_SATURATION)) ? 0 : 1;
        }
        return colorMode;
    }

    public void setColorMode(int colorMode) {
        if (colorMode < 0 || colorMode > 2) {
            throw new IllegalArgumentException("Invalid colorMode: " + colorMode);
        }
        Settings.System.putIntForUser(this.mContext.getContentResolver(), "display_color_mode", colorMode, this.mUserId);
    }

    public int getMinimumColorTemperature() {
        return this.mContext.getResources().getInteger(17694830);
    }

    public int getMaximumColorTemperature() {
        return this.mContext.getResources().getInteger(17694829);
    }

    public int getDefaultColorTemperature() {
        return this.mContext.getResources().getInteger(17694828);
    }

    private void onSettingChanged(String setting) {
        if (this.mCallback != null) {
            switch (setting) {
                case "night_display_activated": {
                    this.mCallback.onActivated(this.isActivated());
                    break;
                }
                case "night_display_auto_mode": {
                    this.mCallback.onAutoModeChanged(this.getAutoMode());
                    break;
                }
                case "night_display_custom_start_time": {
                    this.mCallback.onCustomStartTimeChanged(this.getCustomStartTime());
                    break;
                }
                case "night_display_custom_end_time": {
                    this.mCallback.onCustomEndTimeChanged(this.getCustomEndTime());
                    break;
                }
                case "night_display_color_temperature": {
                    this.mCallback.onColorTemperatureChanged(this.getColorTemperature());
                    break;
                }
                case "display_color_mode": {
                    this.mCallback.onDisplayColorModeChanged(this.getColorMode());
                }
            }
        }
    }

    public void setListener(Callback callback) {
        Callback oldCallback = this.mCallback;
        if (oldCallback != callback) {
            this.mCallback = callback;
            if (callback == null) {
                this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
            } else if (oldCallback == null) {
                ContentResolver cr = this.mContext.getContentResolver();
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_activated"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_auto_mode"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_start_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_end_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_color_temperature"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.System.getUriFor("display_color_mode"), false, this.mContentObserver, this.mUserId);
            }
        }
    }

    public static boolean isAvailable(Context context) {
        return context.getResources().getBoolean(17956990);
    }

    public static interface Callback {
        default public void onActivated(boolean activated) {
        }

        default public void onAutoModeChanged(int autoMode) {
        }

        default public void onCustomStartTimeChanged(LocalTime startTime) {
        }

        default public void onCustomEndTimeChanged(LocalTime endTime) {
        }

        default public void onColorTemperatureChanged(int colorTemperature) {
        }

        default public void onDisplayColorModeChanged(int displayColorMode) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AutoMode {
    }
}

