/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.TimeAnimator;
import android.app.Activity;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;

public class PlatLogoActivity
extends Activity {
    FrameLayout layout;
    TimeAnimator anim;
    PBackground bg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.layout = new FrameLayout(this);
        this.setContentView(this.layout);
        this.bg = new PBackground();
        this.layout.setBackground(this.bg);
        this.layout.setOnTouchListener(new View.OnTouchListener(){
            final MotionEvent.PointerCoords pc0 = new MotionEvent.PointerCoords();
            final MotionEvent.PointerCoords pc1 = new MotionEvent.PointerCoords();

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getActionMasked()) {
                    case 0: 
                    case 2: {
                        if (event.getPointerCount() <= 1) break;
                        event.getPointerCoords(0, this.pc0);
                        event.getPointerCoords(1, this.pc1);
                        PlatLogoActivity.this.bg.setRadius((float)Math.hypot(this.pc0.x - this.pc1.x, this.pc0.y - this.pc1.y) / 2.0f);
                    }
                }
                return true;
            }
        });
    }

    @Override
    public void onStart() {
        super.onStart();
        this.bg.randomizePalette();
        this.anim = new TimeAnimator();
        this.anim.setTimeListener(new TimeAnimator.TimeListener(){

            @Override
            public void onTimeUpdate(TimeAnimator animation, long totalTime, long deltaTime) {
                PlatLogoActivity.this.bg.setOffset((float)totalTime / 60000.0f);
                PlatLogoActivity.this.bg.invalidateSelf();
            }
        });
        this.anim.start();
    }

    @Override
    public void onStop() {
        if (this.anim != null) {
            this.anim.cancel();
            this.anim = null;
        }
        super.onStop();
    }

    private class PBackground
    extends Drawable {
        private float maxRadius;
        private float radius;
        private float x;
        private float y;
        private float dp;
        private int[] palette;
        private int darkest;
        private float offset;

        public PBackground() {
            this.randomizePalette();
        }

        public void setRadius(float r) {
            this.radius = Math.max(48.0f * this.dp, r);
        }

        public void setPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public void setOffset(float o) {
            this.offset = o;
        }

        public float lum(int rgb) {
            return ((float)Color.red(rgb) * 299.0f + (float)Color.green(rgb) * 587.0f + (float)Color.blue(rgb) * 114.0f) / 1000.0f;
        }

        public void randomizePalette() {
            int slots = 2 + (int)(Math.random() * 2.0);
            float[] color2 = new float[]{(float)Math.random() * 360.0f, 1.0f, 1.0f};
            this.palette = new int[slots];
            this.darkest = 0;
            for (int i = 0; i < slots; ++i) {
                this.palette[i] = Color.HSVToColor(color2);
                color2[0] = color2[0] + 360.0f / (float)slots;
                if (!(this.lum(this.palette[i]) < this.lum(this.palette[this.darkest]))) continue;
                this.darkest = i;
            }
            StringBuilder str = new StringBuilder();
            for (int c : this.palette) {
                str.append(String.format("#%08x ", c));
            }
            Log.v("PlatLogoActivity", "color palette: " + str);
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.dp == 0.0f) {
                this.dp = PlatLogoActivity.this.getResources().getDisplayMetrics().density;
            }
            float width = canvas.getWidth();
            float height = canvas.getHeight();
            if (this.radius == 0.0f) {
                this.setPosition(width / 2.0f, height / 2.0f);
                this.setRadius(width / 6.0f);
            }
            float inner_w = this.radius * 0.667f;
            Paint paint = new Paint();
            paint.setStrokeCap(Paint.Cap.BUTT);
            canvas.translate(this.x, this.y);
            Path p = new Path();
            p.moveTo(-this.radius, height);
            p.lineTo(-this.radius, 0.0f);
            p.arcTo(-this.radius, -this.radius, this.radius, this.radius, -180.0f, 270.0f, false);
            p.lineTo(-this.radius, this.radius);
            float w = (float)Math.max(canvas.getWidth(), canvas.getHeight()) * 1.414f;
            paint.setStyle(Paint.Style.FILL);
            int i = 0;
            while (w > this.radius * 2.0f + inner_w * 2.0f) {
                paint.setColor(0xFF000000 | this.palette[i % this.palette.length]);
                canvas.drawOval(-w / 2.0f, -w / 2.0f, w / 2.0f, w / 2.0f, paint);
                w = (float)((double)w - (double)inner_w * ((double)1.1f + Math.sin(((float)i / 20.0f + this.offset) * 3.14159f)));
                ++i;
            }
            paint.setColor(0xFF000000 | this.palette[(this.darkest + 1) % this.palette.length]);
            canvas.drawOval(-this.radius, -this.radius, this.radius, this.radius, paint);
            p.reset();
            p.moveTo(-this.radius, height);
            p.lineTo(-this.radius, 0.0f);
            p.arcTo(-this.radius, -this.radius, this.radius, this.radius, -180.0f, 270.0f, false);
            p.lineTo(-this.radius + inner_w, this.radius);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(inner_w * 2.0f);
            paint.setColor(this.palette[this.darkest]);
            canvas.drawPath(p, paint);
            paint.setStrokeWidth(inner_w);
            paint.setColor(-1);
            canvas.drawPath(p, paint);
        }

        @Override
        public void setAlpha(int alpha) {
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
        }

        @Override
        public int getOpacity() {
            return 0;
        }
    }
}

