/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ResolverListController {
    private final Context mContext;
    private final PackageManager mpm;
    private final int mLaunchedFromUid;
    private final Intent mTargetIntent;
    private final String mReferrerPackage;
    private static final String TAG = "ResolverListController";
    private static final boolean DEBUG = false;
    Object mLock = new Object();
    @GuardedBy(value="mLock")
    private ResolverComparator mResolverComparator;
    private boolean isComputed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolverListController(Context context, PackageManager pm, Intent targetIntent, String referrerPackage, int launchedFromUid) {
        this.mContext = context;
        this.mpm = pm;
        this.mLaunchedFromUid = launchedFromUid;
        this.mTargetIntent = targetIntent;
        this.mReferrerPackage = referrerPackage;
        Object object = this.mLock;
        synchronized (object) {
            this.mResolverComparator = new ResolverComparator(this.mContext, this.mTargetIntent, this.mReferrerPackage, null);
        }
    }

    @VisibleForTesting
    public ResolveInfo getLastChosen() throws RemoteException {
        return AppGlobals.getPackageManager().getLastChosenActivity(this.mTargetIntent, this.mTargetIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 65536);
    }

    @VisibleForTesting
    public void setLastChosen(Intent intent, IntentFilter filter, int match) throws RemoteException {
        AppGlobals.getPackageManager().setLastChosenActivity(intent, intent.resolveType(this.mContext.getContentResolver()), 65536, filter, match, intent.getComponent());
    }

    @VisibleForTesting
    public List<ResolverActivity.ResolvedComponentInfo> getResolversForIntent(boolean shouldGetResolvedFilter, boolean shouldGetActivityMetadata, List<Intent> intents) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> resolvedComponents = null;
        int N = intents.size();
        for (int i = 0; i < N; ++i) {
            Intent intent = intents.get(i);
            int flags = 0x10000 | (shouldGetResolvedFilter ? 64 : 0) | (shouldGetActivityMetadata ? 128 : 0);
            if (intent.isWebIntent() || (intent.getFlags() & 0x800) != 0) {
                flags |= 0x800000;
            }
            List<ResolveInfo> infos = this.mpm.queryIntentActivities(intent, flags);
            int totalSize = infos.size();
            for (int j = totalSize - 1; j >= 0; --j) {
                ResolveInfo info = infos.get(j);
                if (info.activityInfo == null || info.activityInfo.exported) continue;
                infos.remove(j);
            }
            if (infos == null) continue;
            if (resolvedComponents == null) {
                resolvedComponents = new ArrayList<ResolverActivity.ResolvedComponentInfo>();
            }
            this.addResolveListDedupe(resolvedComponents, intent, infos);
        }
        return resolvedComponents;
    }

    @VisibleForTesting
    public void addResolveListDedupe(List<ResolverActivity.ResolvedComponentInfo> into, Intent intent, List<ResolveInfo> from) {
        int fromCount = from.size();
        int intoCount = into.size();
        for (int i = 0; i < fromCount; ++i) {
            ResolverActivity.ResolvedComponentInfo rci;
            ResolveInfo newInfo = from.get(i);
            boolean found = false;
            for (int j = 0; j < intoCount; ++j) {
                rci = into.get(j);
                if (!ResolverListController.isSameResolvedComponent(newInfo, rci)) continue;
                found = true;
                rci.add(intent, newInfo);
                break;
            }
            if (found) continue;
            ComponentName name = new ComponentName(newInfo.activityInfo.packageName, newInfo.activityInfo.name);
            rci = new ResolverActivity.ResolvedComponentInfo(name, intent, newInfo);
            rci.setPinned(this.isComponentPinned(name));
            into.add(rci);
        }
    }

    @VisibleForTesting
    public ArrayList<ResolverActivity.ResolvedComponentInfo> filterIneligibleActivities(List<ResolverActivity.ResolvedComponentInfo> inputList, boolean returnCopyOfOriginalListIfModified) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> listToReturn = null;
        for (int i = inputList.size() - 1; i >= 0; --i) {
            boolean suspended;
            ActivityInfo ai = inputList.get((int)i).getResolveInfoAt((int)0).activityInfo;
            int granted = ActivityManager.checkComponentPermission(ai.permission, this.mLaunchedFromUid, ai.applicationInfo.uid, ai.exported);
            boolean bl = suspended = (ai.applicationInfo.flags & 0x40000000) != 0;
            if (granted == 0 && !suspended && !this.isComponentFiltered(ai.getComponentName())) continue;
            if (returnCopyOfOriginalListIfModified && listToReturn == null) {
                listToReturn = new ArrayList<ResolverActivity.ResolvedComponentInfo>(inputList);
            }
            inputList.remove(i);
        }
        return listToReturn;
    }

    @VisibleForTesting
    public ArrayList<ResolverActivity.ResolvedComponentInfo> filterLowPriority(List<ResolverActivity.ResolvedComponentInfo> inputList, boolean returnCopyOfOriginalListIfModified) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> listToReturn = null;
        ResolverActivity.ResolvedComponentInfo rci0 = inputList.get(0);
        ResolveInfo r0 = rci0.getResolveInfoAt(0);
        int N = inputList.size();
        for (int i = 1; i < N; ++i) {
            ResolveInfo ri = inputList.get(i).getResolveInfoAt(0);
            if (r0.priority == ri.priority && r0.isDefault == ri.isDefault) continue;
            while (i < N) {
                if (returnCopyOfOriginalListIfModified && listToReturn == null) {
                    listToReturn = new ArrayList<ResolverActivity.ResolvedComponentInfo>(inputList);
                }
                inputList.remove(i);
                --N;
            }
        }
        return listToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void sort(List<ResolverActivity.ResolvedComponentInfo> inputList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResolverComparator == null) {
                Log.d(TAG, "Comparator has already been destroyed; skipped.");
                return;
            }
            CountDownLatch finishComputeSignal = new CountDownLatch(1);
            ComputeCallback callback = new ComputeCallback(finishComputeSignal);
            this.mResolverComparator.setCallBack(callback);
            try {
                long beforeRank = System.currentTimeMillis();
                if (!this.isComputed) {
                    this.mResolverComparator.compute(inputList);
                    finishComputeSignal.await();
                    this.isComputed = true;
                }
                Collections.sort(inputList, this.mResolverComparator);
                long l = System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                Log.e(TAG, "Compute & Sort was interrupted: " + e);
            }
        }
    }

    private static boolean isSameResolvedComponent(ResolveInfo a, ResolverActivity.ResolvedComponentInfo b) {
        ActivityInfo ai = a.activityInfo;
        return ai.packageName.equals(b.name.getPackageName()) && ai.name.equals(b.name.getClassName());
    }

    boolean isComponentPinned(ComponentName name) {
        return false;
    }

    boolean isComponentFiltered(ComponentName componentName) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public float getScore(ResolverActivity.DisplayResolveInfo target) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResolverComparator == null) {
                return 0.0f;
            }
            return this.mResolverComparator.getScore(target.getResolvedComponentName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModel(ComponentName componentName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResolverComparator != null) {
                this.mResolverComparator.updateModel(componentName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChooserCounts(String packageName, int userId, String action) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResolverComparator != null) {
                this.mResolverComparator.updateChooserCounts(packageName, userId, action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResolverComparator != null) {
                this.mResolverComparator.destroy();
            }
            this.mResolverComparator = null;
        }
    }

    private class ComputeCallback
    implements ResolverComparator.AfterCompute {
        private CountDownLatch mFinishComputeSignal;

        public ComputeCallback(CountDownLatch finishComputeSignal) {
            this.mFinishComputeSignal = finishComputeSignal;
        }

        @Override
        public void afterCompute() {
            this.mFinishComputeSignal.countDown();
        }
    }
}

