/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Debug;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.LongSparseArray;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.app.ProcessMap;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ServiceState;
import com.android.internal.app.procstats.SparseMappingTable;
import com.android.internal.app.procstats.SysMemUsageTable;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProcessStats
implements Parcelable {
    public static final String TAG = "ProcessStats";
    static final boolean DEBUG = false;
    static final boolean DEBUG_PARCEL = false;
    public static final String SERVICE_NAME = "procstats";
    public static long COMMIT_PERIOD = 10800000L;
    public static long COMMIT_UPTIME_PERIOD = 3600000L;
    public static final int STATE_NOTHING = -1;
    public static final int STATE_PERSISTENT = 0;
    public static final int STATE_TOP = 1;
    public static final int STATE_IMPORTANT_FOREGROUND = 2;
    public static final int STATE_IMPORTANT_BACKGROUND = 3;
    public static final int STATE_BACKUP = 4;
    public static final int STATE_SERVICE = 5;
    public static final int STATE_SERVICE_RESTARTING = 6;
    public static final int STATE_RECEIVER = 7;
    public static final int STATE_HEAVY_WEIGHT = 8;
    public static final int STATE_HOME = 9;
    public static final int STATE_LAST_ACTIVITY = 10;
    public static final int STATE_CACHED_ACTIVITY = 11;
    public static final int STATE_CACHED_ACTIVITY_CLIENT = 12;
    public static final int STATE_CACHED_EMPTY = 13;
    public static final int STATE_COUNT = 14;
    public static final int PSS_SAMPLE_COUNT = 0;
    public static final int PSS_MINIMUM = 1;
    public static final int PSS_AVERAGE = 2;
    public static final int PSS_MAXIMUM = 3;
    public static final int PSS_USS_MINIMUM = 4;
    public static final int PSS_USS_AVERAGE = 5;
    public static final int PSS_USS_MAXIMUM = 6;
    public static final int PSS_RSS_MINIMUM = 7;
    public static final int PSS_RSS_AVERAGE = 8;
    public static final int PSS_RSS_MAXIMUM = 9;
    public static final int PSS_COUNT = 10;
    public static final int SYS_MEM_USAGE_SAMPLE_COUNT = 0;
    public static final int SYS_MEM_USAGE_CACHED_MINIMUM = 1;
    public static final int SYS_MEM_USAGE_CACHED_AVERAGE = 2;
    public static final int SYS_MEM_USAGE_CACHED_MAXIMUM = 3;
    public static final int SYS_MEM_USAGE_FREE_MINIMUM = 4;
    public static final int SYS_MEM_USAGE_FREE_AVERAGE = 5;
    public static final int SYS_MEM_USAGE_FREE_MAXIMUM = 6;
    public static final int SYS_MEM_USAGE_ZRAM_MINIMUM = 7;
    public static final int SYS_MEM_USAGE_ZRAM_AVERAGE = 8;
    public static final int SYS_MEM_USAGE_ZRAM_MAXIMUM = 9;
    public static final int SYS_MEM_USAGE_KERNEL_MINIMUM = 10;
    public static final int SYS_MEM_USAGE_KERNEL_AVERAGE = 11;
    public static final int SYS_MEM_USAGE_KERNEL_MAXIMUM = 12;
    public static final int SYS_MEM_USAGE_NATIVE_MINIMUM = 13;
    public static final int SYS_MEM_USAGE_NATIVE_AVERAGE = 14;
    public static final int SYS_MEM_USAGE_NATIVE_MAXIMUM = 15;
    public static final int SYS_MEM_USAGE_COUNT = 16;
    public static final int ADJ_NOTHING = -1;
    public static final int ADJ_MEM_FACTOR_NORMAL = 0;
    public static final int ADJ_MEM_FACTOR_MODERATE = 1;
    public static final int ADJ_MEM_FACTOR_LOW = 2;
    public static final int ADJ_MEM_FACTOR_CRITICAL = 3;
    public static final int ADJ_MEM_FACTOR_COUNT = 4;
    public static final int ADJ_SCREEN_MOD = 4;
    public static final int ADJ_SCREEN_OFF = 0;
    public static final int ADJ_SCREEN_ON = 4;
    public static final int ADJ_COUNT = 8;
    public static final int FLAG_COMPLETE = 1;
    public static final int FLAG_SHUTDOWN = 2;
    public static final int FLAG_SYSPROPS = 4;
    public static final int ADD_PSS_INTERNAL_SINGLE = 0;
    public static final int ADD_PSS_INTERNAL_ALL_MEM = 1;
    public static final int ADD_PSS_INTERNAL_ALL_POLL = 2;
    public static final int ADD_PSS_EXTERNAL = 3;
    public static final int ADD_PSS_EXTERNAL_SLOW = 4;
    public static final int[] ALL_MEM_ADJ = new int[]{0, 1, 2, 3};
    public static final int[] ALL_SCREEN_ADJ = new int[]{0, 4};
    public static final int[] NON_CACHED_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] BACKGROUND_PROC_STATES = new int[]{2, 3, 4, 8, 5, 6, 7};
    public static final int[] ALL_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    private static final int PARCEL_VERSION = 27;
    private static final int MAGIC = 1347638356;
    public String mReadError;
    public String mTimePeriodStartClockStr;
    public int mFlags;
    public final ProcessMap<LongSparseArray<PackageState>> mPackages = new ProcessMap();
    public final ProcessMap<ProcessState> mProcesses = new ProcessMap();
    public final long[] mMemFactorDurations = new long[8];
    public int mMemFactor = -1;
    public long mStartTime;
    public long mTimePeriodStartClock;
    public long mTimePeriodStartRealtime;
    public long mTimePeriodEndRealtime;
    public long mTimePeriodStartUptime;
    public long mTimePeriodEndUptime;
    String mRuntime;
    boolean mRunning;
    boolean mHasSwappedOutPss;
    public long mInternalSinglePssCount;
    public long mInternalSinglePssTime;
    public long mInternalAllMemPssCount;
    public long mInternalAllMemPssTime;
    public long mInternalAllPollPssCount;
    public long mInternalAllPollPssTime;
    public long mExternalPssCount;
    public long mExternalPssTime;
    public long mExternalSlowPssCount;
    public long mExternalSlowPssTime;
    public final SparseMappingTable mTableData = new SparseMappingTable();
    public final long[] mSysMemUsageArgs = new long[16];
    public final SysMemUsageTable mSysMemUsage = new SysMemUsageTable(this.mTableData);
    ArrayMap<String, Integer> mCommonStringToIndex;
    ArrayList<String> mIndexToCommonString;
    private static final Pattern sPageTypeRegex = Pattern.compile("^Node\\s+(\\d+),.*. type\\s+(\\w+)\\s+([\\s\\d]+?)\\s*$");
    private final ArrayList<Integer> mPageTypeZones = new ArrayList();
    private final ArrayList<String> mPageTypeLabels = new ArrayList();
    private final ArrayList<int[]> mPageTypeSizes = new ArrayList();
    public static final Parcelable.Creator<ProcessStats> CREATOR = new Parcelable.Creator<ProcessStats>(){

        @Override
        public ProcessStats createFromParcel(Parcel in) {
            return new ProcessStats(in);
        }

        public ProcessStats[] newArray(int size) {
            return new ProcessStats[size];
        }
    };
    static final int[] BAD_TABLE = new int[0];

    public ProcessStats(boolean running) {
        this.mRunning = running;
        this.reset();
        if (running) {
            Debug.MemoryInfo info = new Debug.MemoryInfo();
            Debug.getMemoryInfo(Process.myPid(), info);
            this.mHasSwappedOutPss = info.hasSwappedOutPss();
        }
    }

    public ProcessStats(Parcel in) {
        this.reset();
        this.readFromParcel(in);
    }

    public void add(ProcessStats other) {
        int uid;
        int iu;
        SparseArray<Object> uids;
        ArrayMap<String, SparseArray<LongSparseArray<PackageState>>> pkgMap = other.mPackages.getMap();
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            uids = pkgMap.valueAt(ip);
            for (iu = 0; iu < uids.size(); ++iu) {
                uid = uids.keyAt(iu);
                LongSparseArray versions = (LongSparseArray)uids.valueAt(iu);
                for (int iv = 0; iv < versions.size(); ++iv) {
                    long vers = versions.keyAt(iv);
                    PackageState otherState = (PackageState)versions.valueAt(iv);
                    int NPROCS = otherState.mProcesses.size();
                    int NSRVS = otherState.mServices.size();
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState otherProc = otherState.mProcesses.valueAt(iproc);
                        if (otherProc.getCommonProcess() == otherProc) continue;
                        ProcessState thisProc = this.getProcessStateLocked(pkgName, uid, vers, otherProc.getName());
                        if (thisProc.getCommonProcess() == thisProc) {
                            thisProc.setMultiPackage(true);
                            long now = SystemClock.uptimeMillis();
                            PackageState pkgState = this.getPackageStateLocked(pkgName, uid, vers);
                            thisProc = thisProc.clone(now);
                            pkgState.mProcesses.put(thisProc.getName(), thisProc);
                        }
                        thisProc.add(otherProc);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        ServiceState otherSvc = otherState.mServices.valueAt(isvc);
                        ServiceState thisSvc = this.getServiceStateLocked(pkgName, uid, vers, otherSvc.getProcessName(), otherSvc.getName());
                        thisSvc.add(otherSvc);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = other.mProcesses.getMap();
        for (int ip = 0; ip < procMap.size(); ++ip) {
            uids = procMap.valueAt(ip);
            for (iu = 0; iu < uids.size(); ++iu) {
                uid = uids.keyAt(iu);
                ProcessState otherProc = (ProcessState)uids.valueAt(iu);
                String name = otherProc.getName();
                String pkg = otherProc.getPackage();
                long vers = otherProc.getVersion();
                ProcessState thisProc = this.mProcesses.get(name, uid);
                if (thisProc == null) {
                    thisProc = new ProcessState(this, pkg, uid, vers, name);
                    this.mProcesses.put(name, uid, thisProc);
                    PackageState thisState = this.getPackageStateLocked(pkg, uid, vers);
                    if (!thisState.mProcesses.containsKey(name)) {
                        thisState.mProcesses.put(name, thisProc);
                    }
                }
                thisProc.add(otherProc);
            }
        }
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.mMemFactorDurations[n] = this.mMemFactorDurations[n] + other.mMemFactorDurations[i];
        }
        this.mSysMemUsage.mergeStats(other.mSysMemUsage);
        if (other.mTimePeriodStartClock < this.mTimePeriodStartClock) {
            this.mTimePeriodStartClock = other.mTimePeriodStartClock;
            this.mTimePeriodStartClockStr = other.mTimePeriodStartClockStr;
        }
        this.mTimePeriodEndRealtime += other.mTimePeriodEndRealtime - other.mTimePeriodStartRealtime;
        this.mTimePeriodEndUptime += other.mTimePeriodEndUptime - other.mTimePeriodStartUptime;
        this.mInternalSinglePssCount += other.mInternalSinglePssCount;
        this.mInternalSinglePssTime += other.mInternalSinglePssTime;
        this.mInternalAllMemPssCount += other.mInternalAllMemPssCount;
        this.mInternalAllMemPssTime += other.mInternalAllMemPssTime;
        this.mInternalAllPollPssCount += other.mInternalAllPollPssCount;
        this.mInternalAllPollPssTime += other.mInternalAllPollPssTime;
        this.mExternalPssCount += other.mExternalPssCount;
        this.mExternalPssTime += other.mExternalPssTime;
        this.mExternalSlowPssCount += other.mExternalSlowPssCount;
        this.mExternalSlowPssTime += other.mExternalSlowPssTime;
        this.mHasSwappedOutPss |= other.mHasSwappedOutPss;
    }

    public void addSysMemUsage(long cachedMem, long freeMem, long zramMem, long kernelMem, long nativeMem) {
        if (this.mMemFactor != -1) {
            int state = this.mMemFactor * 14;
            this.mSysMemUsageArgs[0] = 1L;
            for (int i = 0; i < 3; ++i) {
                this.mSysMemUsageArgs[1 + i] = cachedMem;
                this.mSysMemUsageArgs[4 + i] = freeMem;
                this.mSysMemUsageArgs[7 + i] = zramMem;
                this.mSysMemUsageArgs[10 + i] = kernelMem;
                this.mSysMemUsageArgs[13 + i] = nativeMem;
            }
            this.mSysMemUsage.mergeStats(state, this.mSysMemUsageArgs, 0);
        }
    }

    public void computeTotalMemoryUse(TotalMemoryUseCollection data, long now) {
        int i;
        data.totalTime = 0L;
        for (i = 0; i < 14; ++i) {
            data.processStateWeight[i] = 0.0;
            data.processStatePss[i] = 0L;
            data.processStateTime[i] = 0L;
            data.processStateSamples[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            data.sysMemUsage[i] = 0L;
        }
        data.sysMemCachedWeight = 0.0;
        data.sysMemFreeWeight = 0.0;
        data.sysMemZRamWeight = 0.0;
        data.sysMemKernelWeight = 0.0;
        data.sysMemNativeWeight = 0.0;
        data.sysMemSamples = 0;
        long[] totalMemUsage = this.mSysMemUsage.getTotalMemUsage();
        for (int is = 0; is < data.screenStates.length; ++is) {
            for (int im = 0; im < data.memStates.length; ++im) {
                int tmpIndex;
                long[] tmpLongs;
                int memBucket = data.screenStates[is] + data.memStates[im];
                int stateBucket = memBucket * 14;
                long memTime = this.mMemFactorDurations[memBucket];
                if (this.mMemFactor == memBucket) {
                    memTime += now - this.mStartTime;
                }
                data.totalTime += memTime;
                int sysKey = this.mSysMemUsage.getKey((byte)stateBucket);
                long[] longs = totalMemUsage;
                int idx = 0;
                if (sysKey != -1 && (tmpLongs = this.mSysMemUsage.getArrayForKey(sysKey))[(tmpIndex = SparseMappingTable.getIndexFromKey(sysKey)) + 0] >= 3L) {
                    SysMemUsageTable.mergeSysMemUsage(data.sysMemUsage, 0, longs, idx);
                    longs = tmpLongs;
                    idx = tmpIndex;
                }
                data.sysMemCachedWeight += (double)longs[idx + 2] * (double)memTime;
                data.sysMemFreeWeight += (double)longs[idx + 5] * (double)memTime;
                data.sysMemZRamWeight += (double)longs[idx + 8] * (double)memTime;
                data.sysMemKernelWeight += (double)longs[idx + 11] * (double)memTime;
                data.sysMemNativeWeight += (double)longs[idx + 14] * (double)memTime;
                data.sysMemSamples = (int)((long)data.sysMemSamples + longs[idx + 0]);
            }
        }
        data.hasSwappedOutPss = this.mHasSwappedOutPss;
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int iproc = 0; iproc < procMap.size(); ++iproc) {
            SparseArray<ProcessState> uids = procMap.valueAt(iproc);
            for (int iu = 0; iu < uids.size(); ++iu) {
                ProcessState proc = uids.valueAt(iu);
                proc.aggregatePss(data, now);
            }
        }
    }

    public void reset() {
        this.resetCommon();
        this.mPackages.getMap().clear();
        this.mProcesses.getMap().clear();
        this.mMemFactor = -1;
        this.mStartTime = 0L;
    }

    public void resetSafely() {
        int iu;
        int ip;
        this.resetCommon();
        long now = SystemClock.uptimeMillis();
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int ip2 = procMap.size() - 1; ip2 >= 0; --ip2) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip2);
            for (int iu2 = uids.size() - 1; iu2 >= 0; --iu2) {
                uids.valueAt((int)iu2).tmpNumInUse = 0;
            }
        }
        ArrayMap<String, SparseArray<LongSparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        for (ip = pkgMap.size() - 1; ip >= 0; --ip) {
            SparseArray<LongSparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (iu = uids.size() - 1; iu >= 0; --iu) {
                LongSparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = vpkgs.size() - 1; iv >= 0; --iv) {
                    PackageState pkgState = vpkgs.valueAt(iv);
                    for (int iproc = pkgState.mProcesses.size() - 1; iproc >= 0; --iproc) {
                        ProcessState ps = pkgState.mProcesses.valueAt(iproc);
                        if (ps.isInUse()) {
                            ps.resetSafely(now);
                            ++ps.getCommonProcess().tmpNumInUse;
                            ps.getCommonProcess().tmpFoundSubProc = ps;
                            continue;
                        }
                        pkgState.mProcesses.valueAt(iproc).makeDead();
                        pkgState.mProcesses.removeAt(iproc);
                    }
                    for (int isvc = pkgState.mServices.size() - 1; isvc >= 0; --isvc) {
                        ServiceState ss = pkgState.mServices.valueAt(isvc);
                        if (ss.isInUse()) {
                            ss.resetSafely(now);
                            continue;
                        }
                        pkgState.mServices.removeAt(isvc);
                    }
                    if (pkgState.mProcesses.size() > 0 || pkgState.mServices.size() > 0) continue;
                    vpkgs.removeAt(iv);
                }
                if (vpkgs.size() > 0) continue;
                uids.removeAt(iu);
            }
            if (uids.size() > 0) continue;
            pkgMap.removeAt(ip);
        }
        for (ip = procMap.size() - 1; ip >= 0; --ip) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (iu = uids.size() - 1; iu >= 0; --iu) {
                ProcessState ps = uids.valueAt(iu);
                if (ps.isInUse() || ps.tmpNumInUse > 0) {
                    if (!ps.isActive() && ps.isMultiPackage() && ps.tmpNumInUse == 1) {
                        ps = ps.tmpFoundSubProc;
                        ps.makeStandalone();
                        uids.setValueAt(iu, ps);
                        continue;
                    }
                    ps.resetSafely(now);
                    continue;
                }
                ps.makeDead();
                uids.removeAt(iu);
            }
            if (uids.size() > 0) continue;
            procMap.removeAt(ip);
        }
        this.mStartTime = now;
    }

    private void resetCommon() {
        this.mTimePeriodStartClock = System.currentTimeMillis();
        this.buildTimePeriodStartClockStr();
        this.mTimePeriodStartRealtime = this.mTimePeriodEndRealtime = SystemClock.elapsedRealtime();
        this.mTimePeriodStartUptime = this.mTimePeriodEndUptime = SystemClock.uptimeMillis();
        this.mInternalSinglePssCount = 0L;
        this.mInternalSinglePssTime = 0L;
        this.mInternalAllMemPssCount = 0L;
        this.mInternalAllMemPssTime = 0L;
        this.mInternalAllPollPssCount = 0L;
        this.mInternalAllPollPssTime = 0L;
        this.mExternalPssCount = 0L;
        this.mExternalPssTime = 0L;
        this.mExternalSlowPssCount = 0L;
        this.mExternalSlowPssTime = 0L;
        this.mTableData.reset();
        Arrays.fill(this.mMemFactorDurations, 0L);
        this.mSysMemUsage.resetTable();
        this.mStartTime = 0L;
        this.mReadError = null;
        this.mFlags = 0;
        this.evaluateSystemProperties(true);
        this.updateFragmentation();
    }

    public boolean evaluateSystemProperties(boolean update) {
        boolean changed = false;
        String runtime = SystemProperties.get("persist.sys.dalvik.vm.lib.2", VMRuntime.getRuntime().vmLibrary());
        if (!Objects.equals(runtime, this.mRuntime)) {
            changed = true;
            if (update) {
                this.mRuntime = runtime;
            }
        }
        return changed;
    }

    private void buildTimePeriodStartClockStr() {
        this.mTimePeriodStartClockStr = DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.mTimePeriodStartClock).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFragmentation() {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader("/proc/pagetypeinfo"));
            Matcher matcher = sPageTypeRegex.matcher("");
            this.mPageTypeZones.clear();
            this.mPageTypeLabels.clear();
            this.mPageTypeSizes.clear();
            while ((line = reader.readLine()) != null) {
                Integer zone;
                matcher.reset(line);
                if (!matcher.matches() || (zone = Integer.valueOf(matcher.group(1), 10)) == null) continue;
                this.mPageTypeZones.add(zone);
                this.mPageTypeLabels.add(matcher.group(2));
                this.mPageTypeSizes.add(ProcessStats.splitAndParseNumbers(matcher.group(3)));
            }
        }
        catch (IOException ex) {
            this.mPageTypeZones.clear();
            this.mPageTypeLabels.clear();
            this.mPageTypeSizes.clear();
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int[] splitAndParseNumbers(String s) {
        boolean digit = false;
        int count = 0;
        int N = s.length();
        for (int i = 0; i < N; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (digit) continue;
                digit = true;
                ++count;
                continue;
            }
            digit = false;
        }
        int[] result = new int[count];
        int p = 0;
        int val = 0;
        for (int i = 0; i < N; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (!digit) {
                    digit = true;
                    val = c - 48;
                    continue;
                }
                val *= 10;
                val += c - 48;
                continue;
            }
            if (!digit) continue;
            digit = false;
            result[p++] = val;
        }
        if (count > 0) {
            result[count - 1] = val;
        }
        return result;
    }

    private void writeCompactedLongArray(Parcel out, long[] array2, int num) {
        for (int i = 0; i < num; ++i) {
            long val = array2[i];
            if (val < 0L) {
                Slog.w(TAG, "Time val negative: " + val);
                val = 0L;
            }
            if (val <= Integer.MAX_VALUE) {
                out.writeInt((int)val);
                continue;
            }
            int top = ~((int)(val >> 32 & Integer.MAX_VALUE));
            int bottom = (int)(val & 0xFFFFFFFFL);
            out.writeInt(top);
            out.writeInt(bottom);
        }
    }

    private void readCompactedLongArray(Parcel in, int version, long[] array2, int num) {
        int i;
        if (version <= 10) {
            in.readLongArray(array2);
            return;
        }
        int alen = array2.length;
        if (num > alen) {
            throw new RuntimeException("bad array lengths: got " + num + " array is " + alen);
        }
        for (i = 0; i < num; ++i) {
            int val = in.readInt();
            if (val >= 0) {
                array2[i] = val;
                continue;
            }
            int bottom = in.readInt();
            array2[i] = (long)(~val) << 32 | (long)bottom;
        }
        while (i < alen) {
            array2[i] = 0L;
            ++i;
        }
    }

    private void writeCommonString(Parcel out, String name) {
        Integer index = this.mCommonStringToIndex.get(name);
        if (index != null) {
            out.writeInt(index);
            return;
        }
        index = this.mCommonStringToIndex.size();
        this.mCommonStringToIndex.put(name, index);
        out.writeInt(~index.intValue());
        out.writeString(name);
    }

    private String readCommonString(Parcel in, int version) {
        if (version <= 9) {
            return in.readString();
        }
        int index = in.readInt();
        if (index >= 0) {
            return this.mIndexToCommonString.get(index);
        }
        index ^= 0xFFFFFFFF;
        String name = in.readString();
        while (this.mIndexToCommonString.size() <= index) {
            this.mIndexToCommonString.add(null);
        }
        this.mIndexToCommonString.set(index, name);
        return name;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.writeToParcel(out, SystemClock.uptimeMillis(), flags);
    }

    public void writeToParcel(Parcel out, long now, int flags) {
        int isvc;
        int NSRVS;
        int iproc;
        int NPROCS;
        PackageState pkgState;
        int iv;
        int NVERS;
        LongSparseArray<PackageState> vpkgs;
        int iu;
        int NUID;
        int ip;
        out.writeInt(1347638356);
        out.writeInt(27);
        out.writeInt(14);
        out.writeInt(8);
        out.writeInt(10);
        out.writeInt(16);
        out.writeInt(4096);
        this.mCommonStringToIndex = new ArrayMap(this.mProcesses.size());
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        int NPROC = procMap.size();
        for (int ip2 = 0; ip2 < NPROC; ++ip2) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip2);
            int NUID2 = uids.size();
            for (int iu2 = 0; iu2 < NUID2; ++iu2) {
                uids.valueAt(iu2).commitStateTime(now);
            }
        }
        ArrayMap<String, SparseArray<LongSparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        int NPKG = pkgMap.size();
        for (ip = 0; ip < NPKG; ++ip) {
            SparseArray<LongSparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            NUID = uids.size();
            for (iu = 0; iu < NUID; ++iu) {
                vpkgs = uids.valueAt(iu);
                NVERS = vpkgs.size();
                for (iv = 0; iv < NVERS; ++iv) {
                    pkgState = vpkgs.valueAt(iv);
                    NPROCS = pkgState.mProcesses.size();
                    for (iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        if (proc.getCommonProcess() == proc) continue;
                        proc.commitStateTime(now);
                    }
                    NSRVS = pkgState.mServices.size();
                    for (isvc = 0; isvc < NSRVS; ++isvc) {
                        pkgState.mServices.valueAt(isvc).commitStateTime(now);
                    }
                }
            }
        }
        out.writeLong(this.mTimePeriodStartClock);
        out.writeLong(this.mTimePeriodStartRealtime);
        out.writeLong(this.mTimePeriodEndRealtime);
        out.writeLong(this.mTimePeriodStartUptime);
        out.writeLong(this.mTimePeriodEndUptime);
        out.writeLong(this.mInternalSinglePssCount);
        out.writeLong(this.mInternalSinglePssTime);
        out.writeLong(this.mInternalAllMemPssCount);
        out.writeLong(this.mInternalAllMemPssTime);
        out.writeLong(this.mInternalAllPollPssCount);
        out.writeLong(this.mInternalAllPollPssTime);
        out.writeLong(this.mExternalPssCount);
        out.writeLong(this.mExternalPssTime);
        out.writeLong(this.mExternalSlowPssCount);
        out.writeLong(this.mExternalSlowPssTime);
        out.writeString(this.mRuntime);
        out.writeInt(this.mHasSwappedOutPss ? 1 : 0);
        out.writeInt(this.mFlags);
        this.mTableData.writeToParcel(out);
        if (this.mMemFactor != -1) {
            int n = this.mMemFactor;
            this.mMemFactorDurations[n] = this.mMemFactorDurations[n] + (now - this.mStartTime);
            this.mStartTime = now;
        }
        this.writeCompactedLongArray(out, this.mMemFactorDurations, this.mMemFactorDurations.length);
        this.mSysMemUsage.writeToParcel(out);
        out.writeInt(NPROC);
        for (ip = 0; ip < NPROC; ++ip) {
            this.writeCommonString(out, procMap.keyAt(ip));
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            NUID = uids.size();
            out.writeInt(NUID);
            for (iu = 0; iu < NUID; ++iu) {
                out.writeInt(uids.keyAt(iu));
                ProcessState proc = uids.valueAt(iu);
                this.writeCommonString(out, proc.getPackage());
                out.writeLong(proc.getVersion());
                proc.writeToParcel(out, now);
            }
        }
        out.writeInt(NPKG);
        for (ip = 0; ip < NPKG; ++ip) {
            this.writeCommonString(out, pkgMap.keyAt(ip));
            SparseArray<LongSparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            NUID = uids.size();
            out.writeInt(NUID);
            for (iu = 0; iu < NUID; ++iu) {
                out.writeInt(uids.keyAt(iu));
                vpkgs = uids.valueAt(iu);
                NVERS = vpkgs.size();
                out.writeInt(NVERS);
                for (iv = 0; iv < NVERS; ++iv) {
                    out.writeLong(vpkgs.keyAt(iv));
                    pkgState = vpkgs.valueAt(iv);
                    NPROCS = pkgState.mProcesses.size();
                    out.writeInt(NPROCS);
                    for (iproc = 0; iproc < NPROCS; ++iproc) {
                        this.writeCommonString(out, pkgState.mProcesses.keyAt(iproc));
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        if (proc.getCommonProcess() == proc) {
                            out.writeInt(0);
                            continue;
                        }
                        out.writeInt(1);
                        proc.writeToParcel(out, now);
                    }
                    NSRVS = pkgState.mServices.size();
                    out.writeInt(NSRVS);
                    for (isvc = 0; isvc < NSRVS; ++isvc) {
                        out.writeString(pkgState.mServices.keyAt(isvc));
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        this.writeCommonString(out, svc.getProcessName());
                        svc.writeToParcel(out, now);
                    }
                }
            }
        }
        int NPAGETYPES = this.mPageTypeLabels.size();
        out.writeInt(NPAGETYPES);
        for (int i = 0; i < NPAGETYPES; ++i) {
            out.writeInt(this.mPageTypeZones.get(i));
            out.writeString(this.mPageTypeLabels.get(i));
            out.writeIntArray(this.mPageTypeSizes.get(i));
        }
        this.mCommonStringToIndex = null;
    }

    private boolean readCheckedInt(Parcel in, int val, String what) {
        int got = in.readInt();
        if (got != val) {
            this.mReadError = "bad " + what + ": " + got;
            return false;
        }
        return true;
    }

    static byte[] readFully(InputStream stream, int[] outLen) throws IOException {
        int pos = 0;
        int initialAvail = stream.available();
        byte[] data = new byte[initialAvail > 0 ? initialAvail + 1 : 16384];
        while (true) {
            int amt;
            if ((amt = stream.read(data, pos, data.length - pos)) < 0) {
                outLen[0] = pos;
                return data;
            }
            if ((pos += amt) < data.length) continue;
            byte[] newData = new byte[pos + 16384];
            System.arraycopy((byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
            data = newData;
        }
    }

    public void read(InputStream stream) {
        try {
            int[] len = new int[1];
            byte[] raw2 = ProcessStats.readFully(stream, len);
            Parcel in = Parcel.obtain();
            in.unmarshall(raw2, 0, len[0]);
            in.setDataPosition(0);
            stream.close();
            this.readFromParcel(in);
        }
        catch (IOException e) {
            this.mReadError = "caught exception: " + e;
        }
    }

    public void readFromParcel(Parcel in) {
        boolean hadData;
        boolean bl = hadData = this.mPackages.getMap().size() > 0 || this.mProcesses.getMap().size() > 0;
        if (hadData) {
            this.resetSafely();
        }
        if (!this.readCheckedInt(in, 1347638356, "magic number")) {
            return;
        }
        int version = in.readInt();
        if (version != 27) {
            this.mReadError = "bad version: " + version;
            return;
        }
        if (!this.readCheckedInt(in, 14, "state count")) {
            return;
        }
        if (!this.readCheckedInt(in, 8, "adj count")) {
            return;
        }
        if (!this.readCheckedInt(in, 10, "pss count")) {
            return;
        }
        if (!this.readCheckedInt(in, 16, "sys mem usage count")) {
            return;
        }
        if (!this.readCheckedInt(in, 4096, "longs size")) {
            return;
        }
        this.mIndexToCommonString = new ArrayList();
        this.mTimePeriodStartClock = in.readLong();
        this.buildTimePeriodStartClockStr();
        this.mTimePeriodStartRealtime = in.readLong();
        this.mTimePeriodEndRealtime = in.readLong();
        this.mTimePeriodStartUptime = in.readLong();
        this.mTimePeriodEndUptime = in.readLong();
        this.mInternalSinglePssCount = in.readLong();
        this.mInternalSinglePssTime = in.readLong();
        this.mInternalAllMemPssCount = in.readLong();
        this.mInternalAllMemPssTime = in.readLong();
        this.mInternalAllPollPssCount = in.readLong();
        this.mInternalAllPollPssTime = in.readLong();
        this.mExternalPssCount = in.readLong();
        this.mExternalPssTime = in.readLong();
        this.mExternalSlowPssCount = in.readLong();
        this.mExternalSlowPssTime = in.readLong();
        this.mRuntime = in.readString();
        this.mHasSwappedOutPss = in.readInt() != 0;
        this.mFlags = in.readInt();
        this.mTableData.readFromParcel(in);
        this.readCompactedLongArray(in, version, this.mMemFactorDurations, this.mMemFactorDurations.length);
        if (!this.mSysMemUsage.readFromParcel(in)) {
            return;
        }
        int NPROC = in.readInt();
        if (NPROC < 0) {
            this.mReadError = "bad process count: " + NPROC;
            return;
        }
        while (NPROC > 0) {
            --NPROC;
            String procName = this.readCommonString(in, version);
            if (procName == null) {
                this.mReadError = "bad process name";
                return;
            }
            int NUID = in.readInt();
            if (NUID < 0) {
                this.mReadError = "bad uid count: " + NUID;
                return;
            }
            while (NUID > 0) {
                ProcessState proc;
                --NUID;
                int uid = in.readInt();
                if (uid < 0) {
                    this.mReadError = "bad uid: " + uid;
                    return;
                }
                String pkgName = this.readCommonString(in, version);
                if (pkgName == null) {
                    this.mReadError = "bad process package name";
                    return;
                }
                long vers = in.readLong();
                ProcessState processState = proc = hadData ? this.mProcesses.get(procName, uid) : null;
                if (proc != null ? !proc.readFromParcel(in, false) : !(proc = new ProcessState(this, pkgName, uid, vers, procName)).readFromParcel(in, true)) {
                    return;
                }
                this.mProcesses.put(procName, uid, proc);
            }
        }
        int NPKG = in.readInt();
        if (NPKG < 0) {
            this.mReadError = "bad package count: " + NPKG;
            return;
        }
        while (NPKG > 0) {
            --NPKG;
            String pkgName = this.readCommonString(in, version);
            if (pkgName == null) {
                this.mReadError = "bad package name";
                return;
            }
            int NUID = in.readInt();
            if (NUID < 0) {
                this.mReadError = "bad uid count: " + NUID;
                return;
            }
            while (NUID > 0) {
                --NUID;
                int uid = in.readInt();
                if (uid < 0) {
                    this.mReadError = "bad uid: " + uid;
                    return;
                }
                int NVERS = in.readInt();
                if (NVERS < 0) {
                    this.mReadError = "bad versions count: " + NVERS;
                    return;
                }
                while (NVERS > 0) {
                    int NPROCS;
                    --NVERS;
                    long vers = in.readLong();
                    PackageState pkgState = new PackageState(pkgName, uid);
                    LongSparseArray<PackageState> vpkg = this.mPackages.get(pkgName, uid);
                    if (vpkg == null) {
                        vpkg = new LongSparseArray();
                        this.mPackages.put(pkgName, uid, vpkg);
                    }
                    vpkg.put(vers, pkgState);
                    if (NPROCS < 0) {
                        this.mReadError = "bad package process count: " + NPROCS;
                        return;
                    }
                    for (NPROCS = in.readInt(); NPROCS > 0; --NPROCS) {
                        String procName = this.readCommonString(in, version);
                        if (procName == null) {
                            this.mReadError = "bad package process name";
                            return;
                        }
                        int hasProc = in.readInt();
                        ProcessState commonProc = this.mProcesses.get(procName, uid);
                        if (commonProc == null) {
                            this.mReadError = "no common proc: " + procName;
                            return;
                        }
                        if (hasProc != 0) {
                            ProcessState proc;
                            ProcessState processState = proc = hadData ? pkgState.mProcesses.get(procName) : null;
                            if (proc != null ? !proc.readFromParcel(in, false) : !(proc = new ProcessState(commonProc, pkgName, uid, vers, procName, 0L)).readFromParcel(in, true)) {
                                return;
                            }
                            pkgState.mProcesses.put(procName, proc);
                            continue;
                        }
                        pkgState.mProcesses.put(procName, commonProc);
                    }
                    int NSRVS = in.readInt();
                    if (NSRVS < 0) {
                        this.mReadError = "bad package service count: " + NSRVS;
                        return;
                    }
                    while (NSRVS > 0) {
                        ServiceState serv;
                        --NSRVS;
                        String serviceName = in.readString();
                        if (serviceName == null) {
                            this.mReadError = "bad package service name";
                            return;
                        }
                        String processName = version > 9 ? this.readCommonString(in, version) : null;
                        ServiceState serviceState = serv = hadData ? pkgState.mServices.get(serviceName) : null;
                        if (serv == null) {
                            serv = new ServiceState(this, pkgName, serviceName, processName, null);
                        }
                        if (!serv.readFromParcel(in)) {
                            return;
                        }
                        pkgState.mServices.put(serviceName, serv);
                    }
                }
            }
        }
        int NPAGETYPES = in.readInt();
        this.mPageTypeZones.clear();
        this.mPageTypeZones.ensureCapacity(NPAGETYPES);
        this.mPageTypeLabels.clear();
        this.mPageTypeLabels.ensureCapacity(NPAGETYPES);
        this.mPageTypeSizes.clear();
        this.mPageTypeSizes.ensureCapacity(NPAGETYPES);
        for (int i = 0; i < NPAGETYPES; ++i) {
            this.mPageTypeZones.add(in.readInt());
            this.mPageTypeLabels.add(in.readString());
            this.mPageTypeSizes.add(in.createIntArray());
        }
        this.mIndexToCommonString = null;
    }

    public PackageState getPackageStateLocked(String packageName, int uid, long vers) {
        PackageState as;
        LongSparseArray<PackageState> vpkg = this.mPackages.get(packageName, uid);
        if (vpkg == null) {
            vpkg = new LongSparseArray();
            this.mPackages.put(packageName, uid, vpkg);
        }
        if ((as = vpkg.get(vers)) != null) {
            return as;
        }
        as = new PackageState(packageName, uid);
        vpkg.put(vers, as);
        return as;
    }

    public ProcessState getProcessStateLocked(String packageName, int uid, long vers, String processName) {
        PackageState pkgState = this.getPackageStateLocked(packageName, uid, vers);
        ProcessState ps = pkgState.mProcesses.get(processName);
        if (ps != null) {
            return ps;
        }
        ProcessState commonProc = this.mProcesses.get(processName, uid);
        if (commonProc == null) {
            commonProc = new ProcessState(this, packageName, uid, vers, processName);
            this.mProcesses.put(processName, uid, commonProc);
        }
        if (!commonProc.isMultiPackage()) {
            if (packageName.equals(commonProc.getPackage()) && vers == commonProc.getVersion()) {
                ps = commonProc;
            } else {
                commonProc.setMultiPackage(true);
                long now = SystemClock.uptimeMillis();
                PackageState commonPkgState = this.getPackageStateLocked(commonProc.getPackage(), uid, commonProc.getVersion());
                if (commonPkgState != null) {
                    ProcessState cloned = commonProc.clone(now);
                    commonPkgState.mProcesses.put(commonProc.getName(), cloned);
                    for (int i = commonPkgState.mServices.size() - 1; i >= 0; --i) {
                        ServiceState ss = commonPkgState.mServices.valueAt(i);
                        if (ss.getProcess() != commonProc) continue;
                        ss.setProcess(cloned);
                    }
                } else {
                    Slog.w(TAG, "Cloning proc state: no package state " + commonProc.getPackage() + "/" + uid + " for proc " + commonProc.getName());
                }
                ps = new ProcessState(commonProc, packageName, uid, vers, processName, now);
            }
        } else {
            ps = new ProcessState(commonProc, packageName, uid, vers, processName, SystemClock.uptimeMillis());
        }
        pkgState.mProcesses.put(processName, ps);
        return ps;
    }

    public ServiceState getServiceStateLocked(String packageName, int uid, long vers, String processName, String className) {
        PackageState as = this.getPackageStateLocked(packageName, uid, vers);
        ServiceState ss = as.mServices.get(className);
        if (ss != null) {
            return ss;
        }
        ProcessState ps = processName != null ? this.getProcessStateLocked(packageName, uid, vers, processName) : null;
        ss = new ServiceState(this, packageName, className, processName, ps);
        as.mServices.put(className, ss);
        return ss;
    }

    public void dumpLocked(PrintWriter pw, String reqPackage, long now, boolean dumpSummary, boolean dumpAll, boolean activeOnly) {
        long totalTime = DumpUtils.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        boolean sepNeeded = false;
        if (this.mSysMemUsage.getKeyCount() > 0) {
            pw.println("System memory usage:");
            this.mSysMemUsage.dump(pw, "  ", ALL_SCREEN_ADJ, ALL_MEM_ADJ);
            sepNeeded = true;
        }
        ArrayMap<String, SparseArray<LongSparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        boolean printedHeader = false;
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            SparseArray<LongSparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                LongSparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = 0; iv < vpkgs.size(); ++iv) {
                    ProcessState proc;
                    int iproc;
                    boolean pkgMatch;
                    long vers = vpkgs.keyAt(iv);
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    int NSRVS = pkgState.mServices.size();
                    boolean bl = pkgMatch = reqPackage == null || reqPackage.equals(pkgName);
                    if (!pkgMatch) {
                        boolean procMatch = false;
                        for (iproc = 0; iproc < NPROCS; ++iproc) {
                            proc = pkgState.mProcesses.valueAt(iproc);
                            if (!reqPackage.equals(proc.getName())) continue;
                            procMatch = true;
                            break;
                        }
                        if (!procMatch) continue;
                    }
                    if (NPROCS > 0 || NSRVS > 0) {
                        if (!printedHeader) {
                            if (sepNeeded) {
                                pw.println();
                            }
                            pw.println("Per-Package Stats:");
                            printedHeader = true;
                            sepNeeded = true;
                        }
                        pw.print("  * ");
                        pw.print(pkgName);
                        pw.print(" / ");
                        UserHandle.formatUid(pw, uid);
                        pw.print(" / v");
                        pw.print(vers);
                        pw.println(":");
                    }
                    if (!dumpSummary || dumpAll) {
                        for (int iproc2 = 0; iproc2 < NPROCS; ++iproc2) {
                            ProcessState proc2 = pkgState.mProcesses.valueAt(iproc2);
                            if (!pkgMatch && !reqPackage.equals(proc2.getName())) continue;
                            if (activeOnly && !proc2.isInUse()) {
                                pw.print("      (Not active: ");
                                pw.print(pkgState.mProcesses.keyAt(iproc2));
                                pw.println(")");
                                continue;
                            }
                            pw.print("      Process ");
                            pw.print(pkgState.mProcesses.keyAt(iproc2));
                            if (proc2.getCommonProcess().isMultiPackage()) {
                                pw.print(" (multi, ");
                            } else {
                                pw.print(" (unique, ");
                            }
                            pw.print(proc2.getDurationsBucketCount());
                            pw.print(" entries)");
                            pw.println(":");
                            proc2.dumpProcessState(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, now);
                            proc2.dumpPss(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES);
                            proc2.dumpInternalLocked(pw, "        ", dumpAll);
                        }
                    } else {
                        ArrayList<ProcessState> procs = new ArrayList<ProcessState>();
                        for (iproc = 0; iproc < NPROCS; ++iproc) {
                            proc = pkgState.mProcesses.valueAt(iproc);
                            if (!pkgMatch && !reqPackage.equals(proc.getName()) || activeOnly && !proc.isInUse()) continue;
                            procs.add(proc);
                        }
                        DumpUtils.dumpProcessSummaryLocked(pw, "      ", procs, ALL_SCREEN_ADJ, ALL_MEM_ADJ, NON_CACHED_PROC_STATES, now, totalTime);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        if (!pkgMatch && !reqPackage.equals(svc.getProcessName())) continue;
                        if (activeOnly && !svc.isInUse()) {
                            pw.print("      (Not active: ");
                            pw.print(pkgState.mServices.keyAt(isvc));
                            pw.println(")");
                            continue;
                        }
                        if (dumpAll) {
                            pw.print("      Service ");
                        } else {
                            pw.print("      * ");
                        }
                        pw.print(pkgState.mServices.keyAt(isvc));
                        pw.println(":");
                        pw.print("        Process: ");
                        pw.println(svc.getProcessName());
                        svc.dumpStats(pw, "        ", "          ", "    ", now, totalTime, dumpSummary, dumpAll);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        printedHeader = false;
        int numShownProcs = 0;
        int numTotalProcs = 0;
        for (int ip = 0; ip < procMap.size(); ++ip) {
            String procName = procMap.keyAt(ip);
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                ++numTotalProcs;
                ProcessState proc = uids.valueAt(iu);
                if (proc.hasAnyData() || !proc.isMultiPackage() || reqPackage != null && !reqPackage.equals(procName) && !reqPackage.equals(proc.getPackage())) continue;
                ++numShownProcs;
                if (sepNeeded) {
                    pw.println();
                }
                sepNeeded = true;
                if (!printedHeader) {
                    pw.println("Multi-Package Common Processes:");
                    printedHeader = true;
                }
                if (activeOnly && !proc.isInUse()) {
                    pw.print("      (Not active: ");
                    pw.print(procName);
                    pw.println(")");
                    continue;
                }
                pw.print("  * ");
                pw.print(procName);
                pw.print(" / ");
                UserHandle.formatUid(pw, uid);
                pw.print(" (");
                pw.print(proc.getDurationsBucketCount());
                pw.print(" entries)");
                pw.println(":");
                proc.dumpProcessState(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, now);
                proc.dumpPss(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES);
                proc.dumpInternalLocked(pw, "        ", dumpAll);
            }
        }
        if (dumpAll) {
            pw.println();
            pw.print("  Total procs: ");
            pw.print(numShownProcs);
            pw.print(" shown of ");
            pw.print(numTotalProcs);
            pw.println(" total");
        }
        if (sepNeeded) {
            pw.println();
        }
        if (dumpSummary) {
            pw.println("Summary:");
            this.dumpSummaryLocked(pw, reqPackage, now, activeOnly);
        } else {
            this.dumpTotalsLocked(pw, now);
        }
        if (dumpAll) {
            pw.println();
            pw.println("Internal state:");
            pw.print("  mRunning=");
            pw.println(this.mRunning);
        }
        this.dumpFragmentationLocked(pw);
    }

    public void dumpSummaryLocked(PrintWriter pw, String reqPackage, long now, boolean activeOnly) {
        long totalTime = DumpUtils.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        this.dumpFilteredSummaryLocked(pw, null, "  ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, NON_CACHED_PROC_STATES, now, totalTime, reqPackage, activeOnly);
        pw.println();
        this.dumpTotalsLocked(pw, now);
    }

    private void dumpFragmentationLocked(PrintWriter pw) {
        pw.println();
        pw.println("Available pages by page size:");
        int NPAGETYPES = this.mPageTypeLabels.size();
        for (int i = 0; i < NPAGETYPES; ++i) {
            pw.format("Zone %3d  %14s ", this.mPageTypeZones.get(i), this.mPageTypeLabels.get(i));
            int[] sizes = this.mPageTypeSizes.get(i);
            int N = sizes == null ? 0 : sizes.length;
            for (int j = 0; j < N; ++j) {
                pw.format("%6d", sizes[j]);
            }
            pw.println();
        }
    }

    long printMemoryCategory(PrintWriter pw, String prefix, String label, double memWeight, long totalTime, long curTotalMem, int samples) {
        if (memWeight != 0.0) {
            long mem = (long)(memWeight * 1024.0 / (double)totalTime);
            pw.print(prefix);
            pw.print(label);
            pw.print(": ");
            DebugUtils.printSizeValue(pw, mem);
            pw.print(" (");
            pw.print(samples);
            pw.print(" samples)");
            pw.println();
            return curTotalMem + mem;
        }
        return curTotalMem;
    }

    void dumpTotalsLocked(PrintWriter pw, long now) {
        pw.println("Run time Stats:");
        DumpUtils.dumpSingleTime(pw, "  ", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        pw.println();
        pw.println("Memory usage:");
        TotalMemoryUseCollection totalMem = new TotalMemoryUseCollection(ALL_SCREEN_ADJ, ALL_MEM_ADJ);
        this.computeTotalMemoryUse(totalMem, now);
        long totalPss = 0L;
        totalPss = this.printMemoryCategory(pw, "  ", "Kernel ", totalMem.sysMemKernelWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Native ", totalMem.sysMemNativeWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        for (int i = 0; i < 14; ++i) {
            if (i == 6) continue;
            totalPss = this.printMemoryCategory(pw, "  ", DumpUtils.STATE_NAMES[i], totalMem.processStateWeight[i], totalMem.totalTime, totalPss, totalMem.processStateSamples[i]);
        }
        totalPss = this.printMemoryCategory(pw, "  ", "Cached ", totalMem.sysMemCachedWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Free   ", totalMem.sysMemFreeWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Z-Ram  ", totalMem.sysMemZRamWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        pw.print("  TOTAL  : ");
        DebugUtils.printSizeValue(pw, totalPss);
        pw.println();
        this.printMemoryCategory(pw, "  ", DumpUtils.STATE_NAMES[6], totalMem.processStateWeight[6], totalMem.totalTime, totalPss, totalMem.processStateSamples[6]);
        pw.println();
        pw.println("PSS collection stats:");
        pw.print("  Internal Single: ");
        pw.print(this.mInternalSinglePssCount);
        pw.print("x over ");
        TimeUtils.formatDuration(this.mInternalSinglePssTime, pw);
        pw.println();
        pw.print("  Internal All Procs (Memory Change): ");
        pw.print(this.mInternalAllMemPssCount);
        pw.print("x over ");
        TimeUtils.formatDuration(this.mInternalAllMemPssTime, pw);
        pw.println();
        pw.print("  Internal All Procs (Polling): ");
        pw.print(this.mInternalAllPollPssCount);
        pw.print("x over ");
        TimeUtils.formatDuration(this.mInternalAllPollPssTime, pw);
        pw.println();
        pw.print("  External: ");
        pw.print(this.mExternalPssCount);
        pw.print("x over ");
        TimeUtils.formatDuration(this.mExternalPssTime, pw);
        pw.println();
        pw.print("  External Slow: ");
        pw.print(this.mExternalSlowPssCount);
        pw.print("x over ");
        TimeUtils.formatDuration(this.mExternalSlowPssTime, pw);
        pw.println();
        pw.println();
        pw.print("          Start time: ");
        pw.print(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mTimePeriodStartClock));
        pw.println();
        pw.print("        Total uptime: ");
        TimeUtils.formatDuration((this.mRunning ? SystemClock.uptimeMillis() : this.mTimePeriodEndUptime) - this.mTimePeriodStartUptime, pw);
        pw.println();
        pw.print("  Total elapsed time: ");
        TimeUtils.formatDuration((this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime) - this.mTimePeriodStartRealtime, pw);
        boolean partial = true;
        if ((this.mFlags & 2) != 0) {
            pw.print(" (shutdown)");
            partial = false;
        }
        if ((this.mFlags & 4) != 0) {
            pw.print(" (sysprops)");
            partial = false;
        }
        if ((this.mFlags & 1) != 0) {
            pw.print(" (complete)");
            partial = false;
        }
        if (partial) {
            pw.print(" (partial)");
        }
        if (this.mHasSwappedOutPss) {
            pw.print(" (swapped-out-pss)");
        }
        pw.print(' ');
        pw.print(this.mRuntime);
        pw.println();
    }

    void dumpFilteredSummaryLocked(PrintWriter pw, String header, String prefix, int[] screenStates, int[] memStates, int[] procStates, int[] sortProcStates, long now, long totalTime, String reqPackage, boolean activeOnly) {
        ArrayList<ProcessState> procs = this.collectProcessesLocked(screenStates, memStates, procStates, sortProcStates, now, reqPackage, activeOnly);
        if (procs.size() > 0) {
            if (header != null) {
                pw.println();
                pw.println(header);
            }
            DumpUtils.dumpProcessSummaryLocked(pw, prefix, procs, screenStates, memStates, sortProcStates, now, totalTime);
        }
    }

    public ArrayList<ProcessState> collectProcessesLocked(int[] screenStates, int[] memStates, int[] procStates, int[] sortProcStates, long now, String reqPackage, boolean activeOnly) {
        ArraySet<ProcessState> foundProcs = new ArraySet<ProcessState>();
        ArrayMap<String, SparseArray<LongSparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            SparseArray<LongSparseArray<PackageState>> procs = pkgMap.valueAt(ip);
            for (int iu = 0; iu < procs.size(); ++iu) {
                LongSparseArray<PackageState> vpkgs = procs.valueAt(iu);
                int NVERS = vpkgs.size();
                for (int iv = 0; iv < NVERS; ++iv) {
                    PackageState state = vpkgs.valueAt(iv);
                    int NPROCS = state.mProcesses.size();
                    boolean pkgMatch = reqPackage == null || reqPackage.equals(pkgName);
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = state.mProcesses.valueAt(iproc);
                        if (!pkgMatch && !reqPackage.equals(proc.getName()) || activeOnly && !proc.isInUse()) continue;
                        foundProcs.add(proc.getCommonProcess());
                    }
                }
            }
        }
        ArrayList<ProcessState> outProcs = new ArrayList<ProcessState>(foundProcs.size());
        for (int i = 0; i < foundProcs.size(); ++i) {
            ProcessState proc = (ProcessState)foundProcs.valueAt(i);
            if (proc.computeProcessTimeLocked(screenStates, memStates, procStates, now) <= 0L) continue;
            outProcs.add(proc);
            if (procStates == sortProcStates) continue;
            proc.computeProcessTimeLocked(screenStates, memStates, sortProcStates, now);
        }
        Collections.sort(outProcs, ProcessState.COMPARATOR);
        return outProcs;
    }

    public void dumpCheckinLocked(PrintWriter pw, String reqPackage) {
        long now = SystemClock.uptimeMillis();
        ArrayMap<String, SparseArray<LongSparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        pw.println("vers,5");
        pw.print("period,");
        pw.print(this.mTimePeriodStartClockStr);
        pw.print(",");
        pw.print(this.mTimePeriodStartRealtime);
        pw.print(",");
        pw.print(this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime);
        boolean partial = true;
        if ((this.mFlags & 2) != 0) {
            pw.print(",shutdown");
            partial = false;
        }
        if ((this.mFlags & 4) != 0) {
            pw.print(",sysprops");
            partial = false;
        }
        if ((this.mFlags & 1) != 0) {
            pw.print(",complete");
            partial = false;
        }
        if (partial) {
            pw.print(",partial");
        }
        if (this.mHasSwappedOutPss) {
            pw.print(",swapped-out-pss");
        }
        pw.println();
        pw.print("config,");
        pw.println(this.mRuntime);
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            if (reqPackage != null && !reqPackage.equals(pkgName)) continue;
            SparseArray<LongSparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                LongSparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = 0; iv < vpkgs.size(); ++iv) {
                    long vers = vpkgs.keyAt(iv);
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    int NSRVS = pkgState.mServices.size();
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        proc.dumpPackageProcCheckin(pw, pkgName, uid, vers, pkgState.mProcesses.keyAt(iproc), now);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        String serviceName = DumpUtils.collapseString(pkgName, pkgState.mServices.keyAt(isvc));
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        svc.dumpTimesCheckin(pw, pkgName, uid, vers, serviceName, now);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int ip = 0; ip < procMap.size(); ++ip) {
            String procName = procMap.keyAt(ip);
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                ProcessState procState = uids.valueAt(iu);
                procState.dumpProcCheckin(pw, procName, uid, now);
            }
        }
        pw.print("total");
        DumpUtils.dumpAdjTimesCheckin(pw, ",", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        pw.println();
        int sysMemUsageCount = this.mSysMemUsage.getKeyCount();
        if (sysMemUsageCount > 0) {
            pw.print("sysmemusage");
            for (int i = 0; i < sysMemUsageCount; ++i) {
                int key = this.mSysMemUsage.getKeyAt(i);
                byte type = SparseMappingTable.getIdFromKey(key);
                pw.print(",");
                DumpUtils.printProcStateTag(pw, type);
                for (int j = 0; j < 16; ++j) {
                    if (j > 1) {
                        pw.print(":");
                    }
                    pw.print(this.mSysMemUsage.getValue(key, j));
                }
            }
        }
        pw.println();
        TotalMemoryUseCollection totalMem = new TotalMemoryUseCollection(ALL_SCREEN_ADJ, ALL_MEM_ADJ);
        this.computeTotalMemoryUse(totalMem, now);
        pw.print("weights,");
        pw.print(totalMem.totalTime);
        pw.print(",");
        pw.print(totalMem.sysMemCachedWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemFreeWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemZRamWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemKernelWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemNativeWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        for (int i = 0; i < 14; ++i) {
            pw.print(",");
            pw.print(totalMem.processStateWeight[i]);
            pw.print(":");
            pw.print(totalMem.processStateSamples[i]);
        }
        pw.println();
        int NPAGETYPES = this.mPageTypeLabels.size();
        for (int i = 0; i < NPAGETYPES; ++i) {
            pw.print("availablepages,");
            pw.print(this.mPageTypeLabels.get(i));
            pw.print(",");
            pw.print(this.mPageTypeZones.get(i));
            pw.print(",");
            int[] sizes = this.mPageTypeSizes.get(i);
            int N = sizes == null ? 0 : sizes.length;
            for (int j = 0; j < N; ++j) {
                if (j != 0) {
                    pw.print(",");
                }
                pw.print(sizes[j]);
            }
            pw.println();
        }
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, long now) {
        ArrayMap<String, SparseArray<LongSparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        long token = proto.start(fieldId);
        proto.write(0x10300000001L, this.mTimePeriodStartRealtime);
        proto.write(1112396529666L, this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime);
        proto.write(0x10300000003L, this.mTimePeriodStartUptime);
        proto.write(1112396529668L, this.mTimePeriodEndUptime);
        proto.write(1138166333445L, this.mRuntime);
        proto.write(1133871366150L, this.mHasSwappedOutPss);
        boolean partial = true;
        if ((this.mFlags & 2) != 0) {
            proto.write(2259152797703L, 3);
            partial = false;
        }
        if ((this.mFlags & 4) != 0) {
            proto.write(2259152797703L, 4);
            partial = false;
        }
        if ((this.mFlags & 1) != 0) {
            proto.write(2259152797703L, 1);
            partial = false;
        }
        if (partial) {
            proto.write(2259152797703L, 2);
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int ip = 0; ip < procMap.size(); ++ip) {
            String procName = procMap.keyAt(ip);
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                ProcessState procState = uids.valueAt(iu);
                procState.writeToProto(proto, 2246267895816L, procName, uid, now);
            }
        }
        proto.end(token);
    }

    public static class TotalMemoryUseCollection {
        final int[] screenStates;
        final int[] memStates;
        public long totalTime;
        public long[] processStatePss = new long[14];
        public double[] processStateWeight = new double[14];
        public long[] processStateTime = new long[14];
        public int[] processStateSamples = new int[14];
        public long[] sysMemUsage = new long[16];
        public double sysMemCachedWeight;
        public double sysMemFreeWeight;
        public double sysMemZRamWeight;
        public double sysMemKernelWeight;
        public double sysMemNativeWeight;
        public int sysMemSamples;
        public boolean hasSwappedOutPss;

        public TotalMemoryUseCollection(int[] _screenStates, int[] _memStates) {
            this.screenStates = _screenStates;
            this.memStates = _memStates;
        }
    }

    public static final class ProcessDataCollection {
        final int[] screenStates;
        final int[] memStates;
        final int[] procStates;
        public long totalTime;
        public long numPss;
        public long minPss;
        public long avgPss;
        public long maxPss;
        public long minUss;
        public long avgUss;
        public long maxUss;
        public long minRss;
        public long avgRss;
        public long maxRss;

        public ProcessDataCollection(int[] _screenStates, int[] _memStates, int[] _procStates) {
            this.screenStates = _screenStates;
            this.memStates = _memStates;
            this.procStates = _procStates;
        }

        void print(PrintWriter pw, long overallTime, boolean full) {
            if (this.totalTime > overallTime) {
                pw.print("*");
            }
            DumpUtils.printPercent(pw, (double)this.totalTime / (double)overallTime);
            if (this.numPss > 0L) {
                pw.print(" (");
                DebugUtils.printSizeValue(pw, this.minPss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.avgPss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.maxPss * 1024L);
                pw.print("/");
                DebugUtils.printSizeValue(pw, this.minUss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.avgUss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.maxUss * 1024L);
                pw.print("/");
                DebugUtils.printSizeValue(pw, this.minRss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.avgRss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.maxRss * 1024L);
                if (full) {
                    pw.print(" over ");
                    pw.print(this.numPss);
                }
                pw.print(")");
            }
        }
    }

    public static final class PackageState {
        public final ArrayMap<String, ProcessState> mProcesses = new ArrayMap();
        public final ArrayMap<String, ServiceState> mServices = new ArrayMap();
        public final String mPackageName;
        public final int mUid;

        public PackageState(String packageName, int uid) {
            this.mUid = uid;
            this.mPackageName = packageName;
        }
    }

    public static final class ProcessStateHolder {
        public final long appVersion;
        public ProcessState state;

        public ProcessStateHolder(long _appVersion) {
            this.appVersion = _appVersion;
        }
    }
}

