/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Build;
import android.os.Parcel;
import android.util.Slog;
import com.android.internal.util.GrowingArrayUtils;
import java.util.ArrayList;
import libcore.util.EmptyArray;

public class SparseMappingTable {
    private static final String TAG = "SparseMappingTable";
    public static final int ARRAY_SIZE = 4096;
    public static final int INVALID_KEY = -1;
    private static final int ID_SHIFT = 0;
    private static final int ID_MASK = 255;
    private static final int ARRAY_SHIFT = 8;
    private static final int ARRAY_MASK = 255;
    private static final int INDEX_SHIFT = 16;
    private static final int INDEX_MASK = 65535;
    private int mSequence;
    private int mNextIndex;
    private final ArrayList<long[]> mLongs = new ArrayList();

    public SparseMappingTable() {
        this.mLongs.add(new long[4096]);
    }

    public void reset() {
        this.mLongs.clear();
        this.mLongs.add(new long[4096]);
        this.mNextIndex = 0;
        ++this.mSequence;
    }

    public void writeToParcel(Parcel out) {
        out.writeInt(this.mSequence);
        out.writeInt(this.mNextIndex);
        int N = this.mLongs.size();
        out.writeInt(N);
        for (int i = 0; i < N - 1; ++i) {
            long[] array2 = this.mLongs.get(i);
            out.writeInt(array2.length);
            SparseMappingTable.writeCompactedLongArray(out, array2, array2.length);
        }
        long[] lastLongs = this.mLongs.get(N - 1);
        out.writeInt(this.mNextIndex);
        SparseMappingTable.writeCompactedLongArray(out, lastLongs, this.mNextIndex);
    }

    public void readFromParcel(Parcel in) {
        this.mSequence = in.readInt();
        this.mNextIndex = in.readInt();
        this.mLongs.clear();
        int N = in.readInt();
        for (int i = 0; i < N; ++i) {
            int size = in.readInt();
            long[] array2 = new long[size];
            SparseMappingTable.readCompactedLongArray(in, array2, size);
            this.mLongs.add(array2);
        }
    }

    public String dumpInternalState(boolean includeData) {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseMappingTable{");
        sb.append("mSequence=");
        sb.append(this.mSequence);
        sb.append(" mNextIndex=");
        sb.append(this.mNextIndex);
        sb.append(" mLongs.size=");
        int N = this.mLongs.size();
        sb.append(N);
        sb.append("\n");
        if (includeData) {
            for (int i = 0; i < N; ++i) {
                long[] array2 = this.mLongs.get(i);
                for (int j = 0; j < array2.length && (i != N - 1 || j != this.mNextIndex); ++j) {
                    sb.append(String.format(" %4d %d 0x%016x %-19d\n", i, j, array2[j], array2[j]));
                }
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static void writeCompactedLongArray(Parcel out, long[] array2, int num) {
        for (int i = 0; i < num; ++i) {
            long val = array2[i];
            if (val < 0L) {
                Slog.w(TAG, "Time val negative: " + val);
                val = 0L;
            }
            if (val <= Integer.MAX_VALUE) {
                out.writeInt((int)val);
                continue;
            }
            int top = ~((int)(val >> 32 & Integer.MAX_VALUE));
            int bottom = (int)(val & 0xFFFFFFFFL);
            out.writeInt(top);
            out.writeInt(bottom);
        }
    }

    private static void readCompactedLongArray(Parcel in, long[] array2, int num) {
        int i;
        int alen = array2.length;
        if (num > alen) {
            SparseMappingTable.logOrThrow("bad array lengths: got " + num + " array is " + alen);
            return;
        }
        for (i = 0; i < num; ++i) {
            int val = in.readInt();
            if (val >= 0) {
                array2[i] = val;
                continue;
            }
            int bottom = in.readInt();
            array2[i] = (long)(~val) << 32 | (long)bottom;
        }
        while (i < alen) {
            array2[i] = 0L;
            ++i;
        }
    }

    public static byte getIdFromKey(int key) {
        return (byte)(key >> 0 & 0xFF);
    }

    public static int getArrayFromKey(int key) {
        return key >> 8 & 0xFF;
    }

    public static int getIndexFromKey(int key) {
        return key >> 16 & 0xFFFF;
    }

    private static void logOrThrow(String message) {
        SparseMappingTable.logOrThrow(message, new RuntimeException("Stack trace"));
    }

    private static void logOrThrow(String message, Throwable th) {
        Slog.e(TAG, message, th);
        if (Build.IS_ENG) {
            throw new RuntimeException(message, th);
        }
    }

    public static class Table {
        private SparseMappingTable mParent;
        private int mSequence = 1;
        private int[] mTable;
        private int mSize;

        public Table(SparseMappingTable parent) {
            this.mParent = parent;
            this.mSequence = parent.mSequence;
        }

        public void copyFrom(Table copyFrom, int valueCount) {
            this.mTable = null;
            this.mSize = 0;
            int N = copyFrom.getKeyCount();
            for (int i = 0; i < N; ++i) {
                int theirKey = copyFrom.getKeyAt(i);
                long[] theirLongs = (long[])copyFrom.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(theirKey));
                byte id2 = SparseMappingTable.getIdFromKey(theirKey);
                int myKey = this.getOrAddKey(id2, valueCount);
                long[] myLongs = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(myKey));
                System.arraycopy((long[])theirLongs, (int)SparseMappingTable.getIndexFromKey(theirKey), (long[])myLongs, (int)SparseMappingTable.getIndexFromKey(myKey), (int)valueCount);
            }
        }

        public int getOrAddKey(byte id2, int count) {
            this.assertConsistency();
            int idx = this.binarySearch(id2);
            if (idx >= 0) {
                return this.mTable[idx];
            }
            ArrayList list = this.mParent.mLongs;
            int whichArray = list.size() - 1;
            long[] array2 = (long[])list.get(whichArray);
            if (this.mParent.mNextIndex + count > array2.length) {
                array2 = new long[4096];
                list.add(array2);
                ++whichArray;
                this.mParent.mNextIndex = 0;
            }
            int key = whichArray << 8 | this.mParent.mNextIndex << 16 | id2 << 0;
            this.mParent.mNextIndex += count;
            this.mTable = GrowingArrayUtils.insert(this.mTable != null ? this.mTable : EmptyArray.INT, this.mSize, ~idx, key);
            ++this.mSize;
            return key;
        }

        public int getKey(byte id2) {
            this.assertConsistency();
            int idx = this.binarySearch(id2);
            if (idx >= 0) {
                return this.mTable[idx];
            }
            return -1;
        }

        public long getValue(int key) {
            return this.getValue(key, 0);
        }

        public long getValue(int key, int index) {
            this.assertConsistency();
            try {
                long[] array2 = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
                return array2[SparseMappingTable.getIndexFromKey(key) + index];
            }
            catch (IndexOutOfBoundsException ex) {
                SparseMappingTable.logOrThrow("key=0x" + Integer.toHexString(key) + " index=" + index + " -- " + this.dumpInternalState(), ex);
                return 0L;
            }
        }

        public long getValueForId(byte id2) {
            return this.getValueForId(id2, 0);
        }

        public long getValueForId(byte id2, int index) {
            this.assertConsistency();
            int idx = this.binarySearch(id2);
            if (idx >= 0) {
                int key = this.mTable[idx];
                try {
                    long[] array2 = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
                    return array2[SparseMappingTable.getIndexFromKey(key) + index];
                }
                catch (IndexOutOfBoundsException ex) {
                    SparseMappingTable.logOrThrow("id=0x" + Integer.toHexString(id2) + " idx=" + idx + " key=0x" + Integer.toHexString(key) + " index=" + index + " -- " + this.dumpInternalState(), ex);
                    return 0L;
                }
            }
            return 0L;
        }

        public long[] getArrayForKey(int key) {
            this.assertConsistency();
            return (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
        }

        public void setValue(int key, long value) {
            this.setValue(key, 0, value);
        }

        public void setValue(int key, int index, long value) {
            this.assertConsistency();
            if (value < 0L) {
                SparseMappingTable.logOrThrow("can't store negative values key=0x" + Integer.toHexString(key) + " index=" + index + " value=" + value + " -- " + this.dumpInternalState());
                return;
            }
            try {
                long[] array2 = (long[])this.mParent.mLongs.get(SparseMappingTable.getArrayFromKey(key));
                array2[SparseMappingTable.getIndexFromKey((int)key) + index] = value;
            }
            catch (IndexOutOfBoundsException ex) {
                SparseMappingTable.logOrThrow("key=0x" + Integer.toHexString(key) + " index=" + index + " value=" + value + " -- " + this.dumpInternalState(), ex);
                return;
            }
        }

        public void resetTable() {
            this.mTable = null;
            this.mSize = 0;
            this.mSequence = this.mParent.mSequence;
        }

        public void writeToParcel(Parcel out) {
            out.writeInt(this.mSequence);
            out.writeInt(this.mSize);
            for (int i = 0; i < this.mSize; ++i) {
                out.writeInt(this.mTable[i]);
            }
        }

        public boolean readFromParcel(Parcel in) {
            this.mSequence = in.readInt();
            this.mSize = in.readInt();
            if (this.mSize != 0) {
                this.mTable = new int[this.mSize];
                for (int i = 0; i < this.mSize; ++i) {
                    this.mTable[i] = in.readInt();
                }
            } else {
                this.mTable = null;
            }
            if (this.validateKeys(true)) {
                return true;
            }
            this.mSize = 0;
            this.mTable = null;
            return false;
        }

        public int getKeyCount() {
            return this.mSize;
        }

        public int getKeyAt(int i) {
            return this.mTable[i];
        }

        private void assertConsistency() {
        }

        private int binarySearch(byte id2) {
            int lo = 0;
            int hi = this.mSize - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                byte midId = (byte)(this.mTable[mid] >> 0 & 0xFF);
                if (midId < id2) {
                    lo = mid + 1;
                    continue;
                }
                if (midId > id2) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return ~lo;
        }

        private boolean validateKeys(boolean log) {
            ArrayList longs = this.mParent.mLongs;
            int longsSize = longs.size();
            int N = this.mSize;
            for (int i = 0; i < N; ++i) {
                int key = this.mTable[i];
                int arrayIndex = SparseMappingTable.getArrayFromKey(key);
                int index = SparseMappingTable.getIndexFromKey(key);
                if (arrayIndex < longsSize && index < ((long[])longs.get(arrayIndex)).length) continue;
                if (log) {
                    Slog.w(SparseMappingTable.TAG, "Invalid stats at index " + i + " -- " + this.dumpInternalState());
                }
                return false;
            }
            return true;
        }

        public String dumpInternalState() {
            StringBuilder sb = new StringBuilder();
            sb.append("SparseMappingTable.Table{mSequence=");
            sb.append(this.mSequence);
            sb.append(" mParent.mSequence=");
            sb.append(this.mParent.mSequence);
            sb.append(" mParent.mLongs.size()=");
            sb.append(this.mParent.mLongs.size());
            sb.append(" mSize=");
            sb.append(this.mSize);
            sb.append(" mTable=");
            if (this.mTable == null) {
                sb.append("null");
            } else {
                int N = this.mTable.length;
                sb.append('[');
                for (int i = 0; i < N; ++i) {
                    int key = this.mTable[i];
                    sb.append("0x");
                    sb.append(Integer.toHexString(key >> 0 & 0xFF));
                    sb.append("/0x");
                    sb.append(Integer.toHexString(key >> 8 & 0xFF));
                    sb.append("/0x");
                    sb.append(Integer.toHexString(key >> 16 & 0xFFFF));
                    if (i == N - 1) continue;
                    sb.append(", ");
                }
                sb.append(']');
            }
            sb.append(" clazz=");
            sb.append(this.getClass().getName());
            sb.append('}');
            return sb.toString();
        }
    }
}

