/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.colorextraction.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.colorextraction.ColorExtractor;
import com.android.internal.graphics.ColorUtils;

public class GradientDrawable
extends Drawable {
    private static final String TAG = "GradientDrawable";
    private static final float CENTRALIZED_CIRCLE_1 = -2.0f;
    private static final int GRADIENT_RADIUS = 480;
    private static final long COLOR_ANIMATION_DURATION = 2000L;
    private int mAlpha = 255;
    private float mDensity;
    private final Paint mPaint;
    private final Rect mWindowBounds;
    private final Splat mSplat;
    private int mMainColor;
    private int mSecondaryColor;
    private ValueAnimator mColorAnimation;

    public GradientDrawable(Context context) {
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mSplat = new Splat(0.5f, 1.0f, 480.0f, -2.0f);
        this.mWindowBounds = new Rect();
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void setColors(ColorExtractor.GradientColors colors) {
        this.setColors(colors.getMainColor(), colors.getSecondaryColor(), true);
    }

    public void setColors(ColorExtractor.GradientColors colors, boolean animated) {
        this.setColors(colors.getMainColor(), colors.getSecondaryColor(), animated);
    }

    public void setColors(int mainColor, int secondaryColor, boolean animated) {
        if (mainColor == this.mMainColor && secondaryColor == this.mSecondaryColor) {
            return;
        }
        if (this.mColorAnimation != null && this.mColorAnimation.isRunning()) {
            this.mColorAnimation.cancel();
        }
        if (animated) {
            int mainFrom = this.mMainColor;
            int secFrom = this.mSecondaryColor;
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(2000L);
            anim2.addUpdateListener(animation -> {
                float ratio = ((Float)animation.getAnimatedValue()).floatValue();
                this.mMainColor = ColorUtils.blendARGB(mainFrom, mainColor, ratio);
                this.mSecondaryColor = ColorUtils.blendARGB(secFrom, secondaryColor, ratio);
                this.buildPaints();
                this.invalidateSelf();
            });
            anim2.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation, boolean isReverse) {
                    if (GradientDrawable.this.mColorAnimation == animation) {
                        GradientDrawable.this.mColorAnimation = null;
                    }
                }
            });
            anim2.setInterpolator(new DecelerateInterpolator());
            anim2.start();
            this.mColorAnimation = anim2;
        } else {
            this.mMainColor = mainColor;
            this.mSecondaryColor = secondaryColor;
            this.buildPaints();
            this.invalidateSelf();
        }
    }

    @Override
    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.mPaint.setAlpha(this.mAlpha);
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void setXfermode(Xfermode mode) {
        this.mPaint.setXfermode(mode);
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    public void setScreenSize(int width, int height) {
        this.mWindowBounds.set(0, 0, width, height);
        this.setBounds(0, 0, width, height);
        this.buildPaints();
    }

    private void buildPaints() {
        Rect bounds = this.mWindowBounds;
        if (bounds.width() == 0) {
            return;
        }
        float w = bounds.width();
        float h = bounds.height();
        float x = this.mSplat.x * w;
        float y = this.mSplat.y * h;
        float radius = this.mSplat.radius * this.mDensity;
        RadialGradient radialGradient = new RadialGradient(x, y, radius, this.mSecondaryColor, this.mMainColor, Shader.TileMode.CLAMP);
        this.mPaint.setShader(radialGradient);
    }

    @Override
    public void draw(Canvas canvas) {
        Rect bounds = this.mWindowBounds;
        if (bounds.width() == 0) {
            throw new IllegalStateException("You need to call setScreenSize before drawing.");
        }
        float w = bounds.width();
        float h = bounds.height();
        float x = this.mSplat.x * w;
        float y = this.mSplat.y * h;
        float radius = Math.max(w, h);
        canvas.drawRect(x - radius, y - radius, x + radius, y + radius, this.mPaint);
    }

    @VisibleForTesting
    public int getMainColor() {
        return this.mMainColor;
    }

    @VisibleForTesting
    public int getSecondaryColor() {
        return this.mSecondaryColor;
    }

    static final class Splat {
        final float x;
        final float y;
        final float radius;
        final float colorIndex;

        Splat(float x, float y, float radius, float colorIndex) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.colorIndex = colorIndex;
        }
    }
}

