/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.pm.PackageParser;
import android.os.Build;
import android.os.SELinux;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import dalvik.system.CloseGuard;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.List;

public class NativeLibraryHelper {
    private static final String TAG = "NativeHelper";
    private static final boolean DEBUG_NATIVE = false;
    public static final String LIB_DIR_NAME = "lib";
    public static final String LIB64_DIR_NAME = "lib64";
    public static final String CLEAR_ABI_OVERRIDE = "-";
    private static final int BITCODE_PRESENT = 1;
    private static final boolean HAS_NATIVE_BRIDGE = !"0".equals(SystemProperties.get("ro.dalvik.vm.native.bridge", "0"));

    private static native long nativeOpenApk(String var0);

    private static native long nativeOpenApkFd(FileDescriptor var0, String var1);

    private static native void nativeClose(long var0);

    private static native long nativeSumNativeBinaries(long var0, String var2, boolean var3);

    private static native int nativeCopyNativeBinaries(long var0, String var2, String var3, boolean var4, boolean var5, boolean var6);

    private static long sumNativeBinaries(Handle handle, String abi) {
        long sum = 0L;
        for (long apkHandle : handle.apkHandles) {
            sum += NativeLibraryHelper.nativeSumNativeBinaries(apkHandle, abi, handle.debuggable);
        }
        return sum;
    }

    public static int copyNativeBinaries(Handle handle, File sharedLibraryDir, String abi) {
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.nativeCopyNativeBinaries(apkHandle, sharedLibraryDir.getPath(), abi, handle.extractNativeLibs, HAS_NATIVE_BRIDGE, handle.debuggable);
            if (res == 1) continue;
            return res;
        }
        return 1;
    }

    public static int findSupportedAbi(Handle handle, String[] supportedAbis) {
        int finalRes = -114;
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.nativeFindSupportedAbi(apkHandle, supportedAbis, handle.debuggable);
            if (res == -114) continue;
            if (res == -113) {
                if (finalRes >= 0) continue;
                finalRes = -113;
                continue;
            }
            if (res >= 0) {
                if (finalRes >= 0 && res >= finalRes) continue;
                finalRes = res;
                continue;
            }
            return res;
        }
        return finalRes;
    }

    private static native int nativeFindSupportedAbi(long var0, String[] var2, boolean var3);

    public static void removeNativeBinariesLI(String nativeLibraryPath) {
        if (nativeLibraryPath == null) {
            return;
        }
        NativeLibraryHelper.removeNativeBinariesFromDirLI(new File(nativeLibraryPath), false);
    }

    public static void removeNativeBinariesFromDirLI(File nativeLibraryRoot, boolean deleteRootDir) {
        if (nativeLibraryRoot.exists()) {
            File[] files = nativeLibraryRoot.listFiles();
            if (files != null) {
                for (int nn = 0; nn < files.length; ++nn) {
                    if (files[nn].isDirectory()) {
                        NativeLibraryHelper.removeNativeBinariesFromDirLI(files[nn], true);
                        continue;
                    }
                    if (files[nn].delete()) continue;
                    Slog.w(TAG, "Could not delete native binary: " + files[nn].getPath());
                }
            }
            if (deleteRootDir && !nativeLibraryRoot.delete()) {
                Slog.w(TAG, "Could not delete native binary directory: " + nativeLibraryRoot.getPath());
            }
        }
    }

    private static void createNativeLibrarySubdir(File path) throws IOException {
        if (!path.isDirectory()) {
            path.delete();
            if (!path.mkdir()) {
                throw new IOException("Cannot create " + path.getPath());
            }
            try {
                Os.chmod(path.getPath(), OsConstants.S_IRWXU | OsConstants.S_IRGRP | OsConstants.S_IXGRP | OsConstants.S_IROTH | OsConstants.S_IXOTH);
            }
            catch (ErrnoException e) {
                throw new IOException("Cannot chmod native library directory " + path.getPath(), e);
            }
        } else if (!SELinux.restorecon(path)) {
            throw new IOException("Cannot set SELinux context for " + path.getPath());
        }
    }

    private static long sumNativeBinariesForSupportedAbi(Handle handle, String[] abiList) {
        int abi = NativeLibraryHelper.findSupportedAbi(handle, abiList);
        if (abi >= 0) {
            return NativeLibraryHelper.sumNativeBinaries(handle, abiList[abi]);
        }
        return 0L;
    }

    public static int copyNativeBinariesForSupportedAbi(Handle handle, File libraryRoot, String[] abiList, boolean useIsaSubdir) throws IOException {
        NativeLibraryHelper.createNativeLibrarySubdir(libraryRoot);
        int abi = NativeLibraryHelper.findSupportedAbi(handle, abiList);
        if (abi >= 0) {
            File subDir;
            String instructionSet = VMRuntime.getInstructionSet(abiList[abi]);
            if (useIsaSubdir) {
                File isaSubdir = new File(libraryRoot, instructionSet);
                NativeLibraryHelper.createNativeLibrarySubdir(isaSubdir);
                subDir = isaSubdir;
            } else {
                subDir = libraryRoot;
            }
            int copyRet = NativeLibraryHelper.copyNativeBinaries(handle, subDir, abiList[abi]);
            if (copyRet != 1) {
                return copyRet;
            }
        }
        return abi;
    }

    public static int copyNativeBinariesWithOverride(Handle handle, File libraryRoot, String abiOverride) {
        try {
            if (handle.multiArch) {
                if (abiOverride != null && !CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                    Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
                }
                int copyRet = -114;
                if (Build.SUPPORTED_32_BIT_ABIS.length > 0 && (copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, Build.SUPPORTED_32_BIT_ABIS, true)) < 0 && copyRet != -114 && copyRet != -113) {
                    Slog.w(TAG, "Failure copying 32 bit native libraries; copyRet=" + copyRet);
                    return copyRet;
                }
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && (copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, Build.SUPPORTED_64_BIT_ABIS, true)) < 0 && copyRet != -114 && copyRet != -113) {
                    Slog.w(TAG, "Failure copying 64 bit native libraries; copyRet=" + copyRet);
                    return copyRet;
                }
            } else {
                int copyRet;
                String[] abiList;
                String[] stringArray;
                String cpuAbiOverride = null;
                if (CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                    cpuAbiOverride = null;
                } else if (abiOverride != null) {
                    cpuAbiOverride = abiOverride;
                }
                if (cpuAbiOverride != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = cpuAbiOverride;
                } else {
                    stringArray = abiList = Build.SUPPORTED_ABIS;
                }
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                    abiList = Build.SUPPORTED_32_BIT_ABIS;
                }
                if ((copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, abiList, true)) < 0 && copyRet != -114) {
                    Slog.w(TAG, "Failure copying native libraries [errorCode=" + copyRet + "]");
                    return copyRet;
                }
            }
            return 1;
        }
        catch (IOException e) {
            Slog.e(TAG, "Copying native libraries failed", e);
            return -110;
        }
    }

    public static long sumNativeBinariesWithOverride(Handle handle, String abiOverride) throws IOException {
        long sum = 0L;
        if (handle.multiArch) {
            if (abiOverride != null && !CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
            }
            if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, Build.SUPPORTED_32_BIT_ABIS);
            }
            if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, Build.SUPPORTED_64_BIT_ABIS);
            }
        } else {
            String[] abiList;
            String[] stringArray;
            String cpuAbiOverride = null;
            if (CLEAR_ABI_OVERRIDE.equals(abiOverride)) {
                cpuAbiOverride = null;
            } else if (abiOverride != null) {
                cpuAbiOverride = abiOverride;
            }
            if (cpuAbiOverride != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = cpuAbiOverride;
            } else {
                stringArray = abiList = Build.SUPPORTED_ABIS;
            }
            if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                abiList = Build.SUPPORTED_32_BIT_ABIS;
            }
            sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, abiList);
        }
        return sum;
    }

    private static native int hasRenderscriptBitcode(long var0);

    public static boolean hasRenderscriptBitcode(Handle handle) throws IOException {
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.hasRenderscriptBitcode(apkHandle);
            if (res < 0) {
                throw new IOException("Error scanning APK, code: " + res);
            }
            if (res != 1) continue;
            return true;
        }
        return false;
    }

    public static class Handle
    implements Closeable {
        private final CloseGuard mGuard = CloseGuard.get();
        private volatile boolean mClosed;
        final long[] apkHandles;
        final boolean multiArch;
        final boolean extractNativeLibs;
        final boolean debuggable;

        public static Handle create(File packageFile) throws IOException {
            try {
                PackageParser.PackageLite lite = PackageParser.parsePackageLite(packageFile, 0);
                return Handle.create(lite);
            }
            catch (PackageParser.PackageParserException e) {
                throw new IOException("Failed to parse package: " + packageFile, e);
            }
        }

        public static Handle create(PackageParser.Package pkg) throws IOException {
            return Handle.create(pkg.getAllCodePaths(), (pkg.applicationInfo.flags & Integer.MIN_VALUE) != 0, (pkg.applicationInfo.flags & 0x10000000) != 0, (pkg.applicationInfo.flags & 2) != 0);
        }

        public static Handle create(PackageParser.PackageLite lite) throws IOException {
            return Handle.create(lite.getAllCodePaths(), lite.multiArch, lite.extractNativeLibs, lite.debuggable);
        }

        private static Handle create(List<String> codePaths, boolean multiArch, boolean extractNativeLibs, boolean debuggable) throws IOException {
            int size = codePaths.size();
            long[] apkHandles = new long[size];
            for (int i = 0; i < size; ++i) {
                String path = codePaths.get(i);
                apkHandles[i] = NativeLibraryHelper.nativeOpenApk(path);
                if (apkHandles[i] != 0L) continue;
                for (int j = 0; j < i; ++j) {
                    NativeLibraryHelper.nativeClose(apkHandles[j]);
                }
                throw new IOException("Unable to open APK: " + path);
            }
            return new Handle(apkHandles, multiArch, extractNativeLibs, debuggable);
        }

        public static Handle createFd(PackageParser.PackageLite lite, FileDescriptor fd) throws IOException {
            long[] apkHandles = new long[1];
            String path = lite.baseCodePath;
            apkHandles[0] = NativeLibraryHelper.nativeOpenApkFd(fd, path);
            if (apkHandles[0] == 0L) {
                throw new IOException("Unable to open APK " + path + " from fd " + fd);
            }
            return new Handle(apkHandles, lite.multiArch, lite.extractNativeLibs, lite.debuggable);
        }

        Handle(long[] apkHandles, boolean multiArch, boolean extractNativeLibs, boolean debuggable) {
            this.apkHandles = apkHandles;
            this.multiArch = multiArch;
            this.extractNativeLibs = extractNativeLibs;
            this.debuggable = debuggable;
            this.mGuard.open("close");
        }

        @Override
        public void close() {
            for (long apkHandle : this.apkHandles) {
                NativeLibraryHelper.nativeClose(apkHandle);
            }
            this.mGuard.close();
            this.mClosed = true;
        }

        protected void finalize() throws Throwable {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            try {
                if (!this.mClosed) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

