/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.dex.DexMetadataHelper;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.NativeLibraryHelper;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import libcore.io.IoUtils;

public class PackageHelper {
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_INSTALL_EPHEMERAL = 3;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int RECOMMEND_FAILED_INVALID_APK = -2;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    public static final int RECOMMEND_FAILED_INVALID_URI = -6;
    public static final int RECOMMEND_FAILED_VERSION_DOWNGRADE = -7;
    private static final String TAG = "PackageHelper";
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int APP_INSTALL_EXTERNAL = 2;
    private static TestableInterface sDefaultTestableInterface = null;

    public static IStorageManager getStorageManager() throws RemoteException {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IStorageManager.Stub.asInterface(service);
        }
        Log.e(TAG, "Can't get storagemanager service");
        throw new RemoteException("Could not contact storagemanager service");
    }

    private static synchronized TestableInterface getDefaultTestableInterface() {
        if (sDefaultTestableInterface == null) {
            sDefaultTestableInterface = new TestableInterface(){

                @Override
                public StorageManager getStorageManager(Context context) {
                    return context.getSystemService(StorageManager.class);
                }

                @Override
                public boolean getForceAllowOnExternalSetting(Context context) {
                    return Settings.Global.getInt(context.getContentResolver(), "force_allow_on_external", 0) != 0;
                }

                @Override
                public boolean getAllow3rdPartyOnInternalConfig(Context context) {
                    return context.getResources().getBoolean(17956869);
                }

                @Override
                public ApplicationInfo getExistingAppInfo(Context context, String packageName) {
                    ApplicationInfo existingInfo = null;
                    try {
                        existingInfo = context.getPackageManager().getApplicationInfo(packageName, 0x400000);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                    return existingInfo;
                }

                @Override
                public File getDataDirectory() {
                    return Environment.getDataDirectory();
                }
            };
        }
        return sDefaultTestableInterface;
    }

    @Deprecated
    @VisibleForTesting
    public static String resolveInstallVolume(Context context, String packageName, int installLocation, long sizeBytes, TestableInterface testInterface) throws IOException {
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(-1);
        params.appPackageName = packageName;
        params.installLocation = installLocation;
        params.sizeBytes = sizeBytes;
        return PackageHelper.resolveInstallVolume(context, params, testInterface);
    }

    public static String resolveInstallVolume(Context context, PackageInstaller.SessionParams params) throws IOException {
        TestableInterface testableInterface = PackageHelper.getDefaultTestableInterface();
        return PackageHelper.resolveInstallVolume(context, params.appPackageName, params.installLocation, params.sizeBytes, testableInterface);
    }

    @VisibleForTesting
    public static String resolveInstallVolume(Context context, PackageInstaller.SessionParams params, TestableInterface testInterface) throws IOException {
        boolean forceAllowOnExternal = testInterface.getForceAllowOnExternalSetting(context);
        boolean allow3rdPartyOnInternal = testInterface.getAllow3rdPartyOnInternalConfig(context);
        ApplicationInfo existingInfo = testInterface.getExistingAppInfo(context, params.appPackageName);
        boolean fitsOnInternal = testInterface.fitsOnInternalStorage(context, params);
        StorageManager storageManager = testInterface.getStorageManager(context);
        if (existingInfo != null && existingInfo.isSystemApp()) {
            if (fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            throw new IOException("Not enough space on existing volume " + existingInfo.volumeUuid + " for system app " + params.appPackageName + " upgrade");
        }
        ArraySet<String> allCandidates = new ArraySet<String>();
        VolumeInfo bestCandidate = null;
        long bestCandidateAvailBytes = Long.MIN_VALUE;
        for (VolumeInfo vol : storageManager.getVolumes()) {
            boolean isInternalStorage = "private".equals(vol.id);
            if (vol.type != 1 || !vol.isMountedWritable() || isInternalStorage && !allow3rdPartyOnInternal) continue;
            UUID target = storageManager.getUuidForPath(new File(vol.path));
            long availBytes = storageManager.getAllocatableBytes(target, PackageHelper.translateAllocateFlags(params.installFlags));
            if (availBytes >= params.sizeBytes) {
                allCandidates.add(vol.fsUuid);
            }
            if (availBytes < bestCandidateAvailBytes) continue;
            bestCandidate = vol;
            bestCandidateAvailBytes = availBytes;
        }
        if (!forceAllowOnExternal && params.installLocation == 1) {
            if (existingInfo != null && !Objects.equals(existingInfo.volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL)) {
                throw new IOException("Cannot automatically move " + params.appPackageName + " from " + existingInfo.volumeUuid + " to internal storage");
            }
            if (!allow3rdPartyOnInternal) {
                throw new IOException("Not allowed to install non-system apps on internal storage");
            }
            if (fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            throw new IOException("Requested internal only, but not enough space");
        }
        if (existingInfo != null) {
            if (Objects.equals(existingInfo.volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL) && fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            if (allCandidates.contains(existingInfo.volumeUuid)) {
                return existingInfo.volumeUuid;
            }
            throw new IOException("Not enough space on existing volume " + existingInfo.volumeUuid + " for " + params.appPackageName + " upgrade");
        }
        if (bestCandidate != null) {
            return bestCandidate.fsUuid;
        }
        throw new IOException("No special requests, but no room on allowed volumes.  allow3rdPartyOnInternal? " + allow3rdPartyOnInternal);
    }

    public static boolean fitsOnInternal(Context context, PackageInstaller.SessionParams params) throws IOException {
        UUID target;
        StorageManager storage = context.getSystemService(StorageManager.class);
        return params.sizeBytes <= storage.getAllocatableBytes(target = storage.getUuidForPath(Environment.getDataDirectory()), PackageHelper.translateAllocateFlags(params.installFlags));
    }

    public static boolean fitsOnExternal(Context context, PackageInstaller.SessionParams params) {
        StorageManager storage = context.getSystemService(StorageManager.class);
        StorageVolume primary = storage.getPrimaryVolume();
        return params.sizeBytes > 0L && !primary.isEmulated() && "mounted".equals(primary.getState()) && params.sizeBytes <= storage.getStorageBytesUntilLow(primary.getPathFile());
    }

    @Deprecated
    public static int resolveInstallLocation(Context context, String packageName, int installLocation, long sizeBytes, int installFlags) {
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(-1);
        params.appPackageName = packageName;
        params.installLocation = installLocation;
        params.sizeBytes = sizeBytes;
        params.installFlags = installFlags;
        try {
            return PackageHelper.resolveInstallLocation(context, params);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static int resolveInstallLocation(Context context, PackageInstaller.SessionParams params) throws IOException {
        boolean checkBoth;
        int prefer;
        ApplicationInfo existingInfo = null;
        try {
            existingInfo = context.getPackageManager().getApplicationInfo(params.appPackageName, 0x400000);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        boolean ephemeral = false;
        if ((params.installFlags & 0x800) != 0) {
            prefer = 1;
            ephemeral = true;
            checkBoth = false;
        } else if ((params.installFlags & 0x10) != 0) {
            prefer = 1;
            checkBoth = false;
        } else if ((params.installFlags & 8) != 0) {
            prefer = 2;
            checkBoth = false;
        } else if (params.installLocation == 1) {
            prefer = 1;
            checkBoth = false;
        } else if (params.installLocation == 2) {
            prefer = 2;
            checkBoth = true;
        } else if (params.installLocation == 0) {
            prefer = existingInfo != null ? ((existingInfo.flags & 0x40000) != 0 ? 2 : 1) : 1;
            checkBoth = true;
        } else {
            prefer = 1;
            checkBoth = false;
        }
        boolean fitsOnInternal = false;
        if (checkBoth || prefer == 1) {
            fitsOnInternal = PackageHelper.fitsOnInternal(context, params);
        }
        boolean fitsOnExternal = false;
        if (checkBoth || prefer == 2) {
            fitsOnExternal = PackageHelper.fitsOnExternal(context, params);
        }
        if (prefer == 1) {
            if (fitsOnInternal) {
                return ephemeral ? 3 : 1;
            }
        } else if (prefer == 2 && fitsOnExternal) {
            return 2;
        }
        if (checkBoth) {
            if (fitsOnInternal) {
                return 1;
            }
            if (fitsOnExternal) {
                return 2;
            }
        }
        return -1;
    }

    @Deprecated
    public static long calculateInstalledSize(PackageParser.PackageLite pkg, boolean isForwardLocked, String abiOverride) throws IOException {
        return PackageHelper.calculateInstalledSize(pkg, abiOverride);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite pkg, String abiOverride) throws IOException {
        return PackageHelper.calculateInstalledSize(pkg, abiOverride, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateInstalledSize(PackageParser.PackageLite pkg, String abiOverride, FileDescriptor fd) throws IOException {
        long l;
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = fd != null ? NativeLibraryHelper.Handle.createFd(pkg, fd) : NativeLibraryHelper.Handle.create(pkg);
            l = PackageHelper.calculateInstalledSize(pkg, handle, abiOverride);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(handle);
            throw throwable;
        }
        IoUtils.closeQuietly(handle);
        return l;
    }

    @Deprecated
    public static long calculateInstalledSize(PackageParser.PackageLite pkg, boolean isForwardLocked, NativeLibraryHelper.Handle handle, String abiOverride) throws IOException {
        return PackageHelper.calculateInstalledSize(pkg, handle, abiOverride);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite pkg, NativeLibraryHelper.Handle handle, String abiOverride) throws IOException {
        long sizeBytes = 0L;
        for (String codePath : pkg.getAllCodePaths()) {
            File codeFile = new File(codePath);
            sizeBytes += codeFile.length();
        }
        sizeBytes += DexMetadataHelper.getPackageDexMetadataSize(pkg);
        return sizeBytes += NativeLibraryHelper.sumNativeBinariesWithOverride(handle, abiOverride);
    }

    public static String replaceEnd(String str, String before, String after) {
        if (!str.endsWith(before)) {
            throw new IllegalArgumentException("Expected " + str + " to end with " + before);
        }
        return str.substring(0, str.length() - before.length()) + after;
    }

    public static int translateAllocateFlags(int installFlags) {
        if ((installFlags & 0x8000) != 0) {
            return 1;
        }
        return 0;
    }

    public static abstract class TestableInterface {
        public abstract StorageManager getStorageManager(Context var1);

        public abstract boolean getForceAllowOnExternalSetting(Context var1);

        public abstract boolean getAllow3rdPartyOnInternalConfig(Context var1);

        public abstract ApplicationInfo getExistingAppInfo(Context var1, String var2);

        public abstract File getDataDirectory();

        public boolean fitsOnInternalStorage(Context context, PackageInstaller.SessionParams params) throws IOException {
            UUID target;
            StorageManager storage = this.getStorageManager(context);
            return params.sizeBytes <= storage.getAllocatableBytes(target = storage.getUuidForPath(this.getDataDirectory()), PackageHelper.translateAllocateFlags(params.installFlags));
        }
    }
}

