/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.hardware;

import android.content.Context;
import android.os.Build;
import android.os.SystemProperties;
import android.provider.Settings;
import android.text.TextUtils;

public class AmbientDisplayConfiguration {
    private final Context mContext;

    public AmbientDisplayConfiguration(Context context) {
        this.mContext = context;
    }

    public boolean enabled(int user) {
        return this.pulseOnNotificationEnabled(user) || this.pulseOnPickupEnabled(user) || this.pulseOnDoubleTapEnabled(user) || this.pulseOnLongPressEnabled(user) || this.alwaysOnEnabled(user);
    }

    public boolean available() {
        return this.pulseOnNotificationAvailable() || this.pulseOnPickupAvailable() || this.pulseOnDoubleTapAvailable();
    }

    public boolean pulseOnNotificationEnabled(int user) {
        return this.boolSettingDefaultOn("doze_enabled", user) && this.pulseOnNotificationAvailable();
    }

    public boolean pulseOnNotificationAvailable() {
        return this.ambientDisplayAvailable();
    }

    public boolean pulseOnPickupEnabled(int user) {
        boolean settingEnabled = this.boolSettingDefaultOn("doze_pulse_on_pick_up", user);
        return (settingEnabled || this.alwaysOnEnabled(user)) && this.pulseOnPickupAvailable();
    }

    public boolean pulseOnPickupAvailable() {
        return this.mContext.getResources().getBoolean(17956936) && this.ambientDisplayAvailable();
    }

    public boolean pulseOnPickupCanBeModified(int user) {
        return !this.alwaysOnEnabled(user);
    }

    public boolean pulseOnDoubleTapEnabled(int user) {
        return this.boolSettingDefaultOn("doze_pulse_on_double_tap", user) && this.pulseOnDoubleTapAvailable();
    }

    public boolean pulseOnDoubleTapAvailable() {
        return !TextUtils.isEmpty(this.doubleTapSensorType()) && this.ambientDisplayAvailable();
    }

    public String doubleTapSensorType() {
        return this.mContext.getResources().getString(17039661);
    }

    public String longPressSensorType() {
        return this.mContext.getResources().getString(17039662);
    }

    public boolean pulseOnLongPressEnabled(int user) {
        return this.pulseOnLongPressAvailable() && this.boolSettingDefaultOff("doze_pulse_on_long_press", user);
    }

    private boolean pulseOnLongPressAvailable() {
        return !TextUtils.isEmpty(this.longPressSensorType());
    }

    public boolean alwaysOnEnabled(int user) {
        return this.boolSettingDefaultOn("doze_always_on", user) && this.alwaysOnAvailable() && !this.accessibilityInversionEnabled(user);
    }

    public boolean alwaysOnAvailable() {
        return (this.alwaysOnDisplayDebuggingEnabled() || this.alwaysOnDisplayAvailable()) && this.ambientDisplayAvailable();
    }

    public boolean alwaysOnAvailableForUser(int user) {
        return this.alwaysOnAvailable() && !this.accessibilityInversionEnabled(user);
    }

    public String ambientDisplayComponent() {
        return this.mContext.getResources().getString(17039660);
    }

    public boolean accessibilityInversionEnabled(int user) {
        return this.boolSettingDefaultOff("accessibility_display_inversion_enabled", user);
    }

    private boolean ambientDisplayAvailable() {
        return !TextUtils.isEmpty(this.ambientDisplayComponent());
    }

    private boolean alwaysOnDisplayAvailable() {
        return this.mContext.getResources().getBoolean(17956935);
    }

    private boolean alwaysOnDisplayDebuggingEnabled() {
        return SystemProperties.getBoolean("debug.doze.aod", false) && Build.IS_DEBUGGABLE;
    }

    private boolean boolSettingDefaultOn(String name, int user) {
        return this.boolSetting(name, user, 1);
    }

    private boolean boolSettingDefaultOff(String name, int user) {
        return this.boolSetting(name, user, 0);
    }

    private boolean boolSetting(String name, int user, int def) {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), name, def, user) != 0;
    }
}

