/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.text.TextUtils;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import java.util.Objects;

public class InputMethodSubtypeHandle {
    private final String mInputMethodId;
    private final int mSubtypeId;

    public InputMethodSubtypeHandle(InputMethodInfo info, InputMethodSubtype subtype) {
        this.mInputMethodId = info.getId();
        this.mSubtypeId = subtype != null ? subtype.hashCode() : -1;
    }

    public InputMethodSubtypeHandle(String inputMethodId, int subtypeId) {
        this.mInputMethodId = inputMethodId;
        this.mSubtypeId = subtypeId;
    }

    public String getInputMethodId() {
        return this.mInputMethodId;
    }

    public int getSubtypeId() {
        return this.mSubtypeId;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InputMethodSubtypeHandle)) {
            return false;
        }
        InputMethodSubtypeHandle other = (InputMethodSubtypeHandle)o;
        return TextUtils.equals(this.mInputMethodId, other.getInputMethodId()) && this.mSubtypeId == other.getSubtypeId();
    }

    public int hashCode() {
        return Objects.hashCode(this.mInputMethodId) * 31 + this.mSubtypeId;
    }

    public String toString() {
        return "InputMethodSubtypeHandle{mInputMethodId=" + this.mInputMethodId + ", mSubtypeId=" + this.mSubtypeId + "}";
    }
}

