/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.icu.util.ULocale;
import android.os.LocaleList;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class LocaleUtils {
    private static byte calculateMatchingSubScore(ULocale supported, ULocale desired) {
        if (supported.equals(desired)) {
            return 3;
        }
        String supportedScript = supported.getScript();
        if (supportedScript.isEmpty() || !supportedScript.equals(desired.getScript())) {
            return 1;
        }
        String supportedCountry = supported.getCountry();
        if (supportedCountry.isEmpty() || !supportedCountry.equals(desired.getCountry())) {
            return 2;
        }
        return 3;
    }

    @VisibleForTesting
    public static <T> void filterByLanguage(List<T> sources, LocaleExtractor<T> extractor, LocaleList preferredLocales, ArrayList<T> dest) {
        if (preferredLocales.isEmpty()) {
            return;
        }
        int numPreferredLocales = preferredLocales.size();
        HashMap<String, ScoreEntry> scoreboard = new HashMap<String, ScoreEntry>();
        byte[] score = new byte[numPreferredLocales];
        ULocale[] preferredULocaleCache = new ULocale[numPreferredLocales];
        int sourceSize = sources.size();
        for (int i = 0; i < sourceSize; ++i) {
            Locale locale = extractor.get(sources.get(i));
            if (locale == null) continue;
            boolean canSkip = true;
            for (int j = 0; j < numPreferredLocales; ++j) {
                Locale preferredLocale = preferredLocales.get(j);
                if (!TextUtils.equals(locale.getLanguage(), preferredLocale.getLanguage())) {
                    score[j] = 0;
                    continue;
                }
                if (preferredULocaleCache[j] == null) {
                    preferredULocaleCache[j] = ULocale.addLikelySubtags(ULocale.forLocale(preferredLocale));
                }
                score[j] = LocaleUtils.calculateMatchingSubScore(preferredULocaleCache[j], ULocale.addLikelySubtags(ULocale.forLocale(locale)));
                if (!canSkip || score[j] == 0) continue;
                canSkip = false;
            }
            if (canSkip) continue;
            String lang = locale.getLanguage();
            ScoreEntry bestScore = (ScoreEntry)scoreboard.get(lang);
            if (bestScore == null) {
                scoreboard.put(lang, new ScoreEntry(score, i));
                continue;
            }
            bestScore.updateIfBetter(score, i);
        }
        Object[] result = scoreboard.values().toArray(new ScoreEntry[scoreboard.size()]);
        Arrays.sort(result);
        for (Object entry : result) {
            dest.add(sources.get(((ScoreEntry)entry).mIndex));
        }
    }

    private static final class ScoreEntry
    implements Comparable<ScoreEntry> {
        public int mIndex = -1;
        public final byte[] mScore;

        ScoreEntry(byte[] score, int index) {
            this.mScore = new byte[score.length];
            this.set(score, index);
        }

        private void set(byte[] score, int index) {
            for (int i = 0; i < this.mScore.length; ++i) {
                this.mScore[i] = score[i];
            }
            this.mIndex = index;
        }

        public void updateIfBetter(byte[] score, int index) {
            if (ScoreEntry.compare(this.mScore, score) == -1) {
                this.set(score, index);
            }
        }

        private static int compare(byte[] left, byte[] right) {
            for (int i = 0; i < left.length; ++i) {
                if (left[i] > right[i]) {
                    return 1;
                }
                if (left[i] >= right[i]) continue;
                return -1;
            }
            return 0;
        }

        @Override
        public int compareTo(ScoreEntry other) {
            return -1 * ScoreEntry.compare(this.mScore, other.mScore);
        }
    }

    @VisibleForTesting
    public static interface LocaleExtractor<T> {
        public Locale get(T var1);
    }
}

