/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location.gnssmetrics;

import android.os.SystemClock;
import android.os.connectivity.GpsBatteryStats;
import android.util.Base64;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.app.IBatteryStats;
import com.android.internal.location.nano.GnssLogsProto;
import java.util.Arrays;

public class GnssMetrics {
    private static final String TAG = GnssMetrics.class.getSimpleName();
    public static final int GPS_SIGNAL_QUALITY_POOR = 0;
    public static final int GPS_SIGNAL_QUALITY_GOOD = 1;
    public static final int NUM_GPS_SIGNAL_QUALITY_LEVELS = 2;
    private static final int DEFAULT_TIME_BETWEEN_FIXES_MILLISECS = 1000;
    private String logStartInElapsedRealTime;
    private GnssPowerMetrics mGnssPowerMetrics;
    private Statistics locationFailureStatistics;
    private Statistics timeToFirstFixSecStatistics;
    private Statistics positionAccuracyMeterStatistics;
    private Statistics topFourAverageCn0Statistics;

    public GnssMetrics(IBatteryStats stats) {
        this.mGnssPowerMetrics = new GnssPowerMetrics(stats);
        this.locationFailureStatistics = new Statistics();
        this.timeToFirstFixSecStatistics = new Statistics();
        this.positionAccuracyMeterStatistics = new Statistics();
        this.topFourAverageCn0Statistics = new Statistics();
        this.reset();
    }

    public void logReceivedLocationStatus(boolean isSuccessful) {
        if (!isSuccessful) {
            this.locationFailureStatistics.addItem(1.0);
            return;
        }
        this.locationFailureStatistics.addItem(0.0);
    }

    public void logMissedReports(int desiredTimeBetweenFixesMilliSeconds, int actualTimeBetweenFixesMilliSeconds) {
        int numReportMissed = actualTimeBetweenFixesMilliSeconds / Math.max(1000, desiredTimeBetweenFixesMilliSeconds) - 1;
        if (numReportMissed > 0) {
            for (int i = 0; i < numReportMissed; ++i) {
                this.locationFailureStatistics.addItem(1.0);
            }
        }
    }

    public void logTimeToFirstFixMilliSecs(int timeToFirstFixMilliSeconds) {
        this.timeToFirstFixSecStatistics.addItem(timeToFirstFixMilliSeconds / 1000);
    }

    public void logPositionAccuracyMeters(float positionAccuracyMeters) {
        this.positionAccuracyMeterStatistics.addItem(positionAccuracyMeters);
    }

    public void logCn0(float[] cn0s, int numSv) {
        if (numSv == 0 || cn0s == null || cn0s.length == 0 || cn0s.length < numSv) {
            if (numSv == 0) {
                this.mGnssPowerMetrics.reportSignalQuality(null, 0);
            }
            return;
        }
        float[] cn0Array = Arrays.copyOf(cn0s, numSv);
        Arrays.sort(cn0Array);
        this.mGnssPowerMetrics.reportSignalQuality(cn0Array, numSv);
        if (numSv < 4) {
            return;
        }
        if ((double)cn0Array[numSv - 4] > 0.0) {
            double top4AvgCn0 = 0.0;
            for (int i = numSv - 4; i < numSv; ++i) {
                top4AvgCn0 += (double)cn0Array[i];
            }
            this.topFourAverageCn0Statistics.addItem(top4AvgCn0 /= 4.0);
        }
    }

    public String dumpGnssMetricsAsProtoString() {
        GnssLogsProto.GnssLog msg = new GnssLogsProto.GnssLog();
        if (this.locationFailureStatistics.getCount() > 0) {
            msg.numLocationReportProcessed = this.locationFailureStatistics.getCount();
            msg.percentageLocationFailure = (int)(100.0 * this.locationFailureStatistics.getMean());
        }
        if (this.timeToFirstFixSecStatistics.getCount() > 0) {
            msg.numTimeToFirstFixProcessed = this.timeToFirstFixSecStatistics.getCount();
            msg.meanTimeToFirstFixSecs = (int)this.timeToFirstFixSecStatistics.getMean();
            msg.standardDeviationTimeToFirstFixSecs = (int)this.timeToFirstFixSecStatistics.getStandardDeviation();
        }
        if (this.positionAccuracyMeterStatistics.getCount() > 0) {
            msg.numPositionAccuracyProcessed = this.positionAccuracyMeterStatistics.getCount();
            msg.meanPositionAccuracyMeters = (int)this.positionAccuracyMeterStatistics.getMean();
            msg.standardDeviationPositionAccuracyMeters = (int)this.positionAccuracyMeterStatistics.getStandardDeviation();
        }
        if (this.topFourAverageCn0Statistics.getCount() > 0) {
            msg.numTopFourAverageCn0Processed = this.topFourAverageCn0Statistics.getCount();
            msg.meanTopFourAverageCn0DbHz = this.topFourAverageCn0Statistics.getMean();
            msg.standardDeviationTopFourAverageCn0DbHz = this.topFourAverageCn0Statistics.getStandardDeviation();
        }
        msg.powerMetrics = this.mGnssPowerMetrics.buildProto();
        String s = Base64.encodeToString(GnssLogsProto.GnssLog.toByteArray(msg), 0);
        this.reset();
        return s;
    }

    public String dumpGnssMetricsAsText() {
        StringBuilder s = new StringBuilder();
        s.append("GNSS_KPI_START").append('\n');
        s.append("  KPI logging start time: ").append(this.logStartInElapsedRealTime).append("\n");
        s.append("  KPI logging end time: ");
        TimeUtils.formatDuration(SystemClock.elapsedRealtimeNanos() / 1000000L, s);
        s.append("\n");
        s.append("  Number of location reports: ").append(this.locationFailureStatistics.getCount()).append("\n");
        if (this.locationFailureStatistics.getCount() > 0) {
            s.append("  Percentage location failure: ").append(100.0 * this.locationFailureStatistics.getMean()).append("\n");
        }
        s.append("  Number of TTFF reports: ").append(this.timeToFirstFixSecStatistics.getCount()).append("\n");
        if (this.timeToFirstFixSecStatistics.getCount() > 0) {
            s.append("  TTFF mean (sec): ").append(this.timeToFirstFixSecStatistics.getMean()).append("\n");
            s.append("  TTFF standard deviation (sec): ").append(this.timeToFirstFixSecStatistics.getStandardDeviation()).append("\n");
        }
        s.append("  Number of position accuracy reports: ").append(this.positionAccuracyMeterStatistics.getCount()).append("\n");
        if (this.positionAccuracyMeterStatistics.getCount() > 0) {
            s.append("  Position accuracy mean (m): ").append(this.positionAccuracyMeterStatistics.getMean()).append("\n");
            s.append("  Position accuracy standard deviation (m): ").append(this.positionAccuracyMeterStatistics.getStandardDeviation()).append("\n");
        }
        s.append("  Number of CN0 reports: ").append(this.topFourAverageCn0Statistics.getCount()).append("\n");
        if (this.topFourAverageCn0Statistics.getCount() > 0) {
            s.append("  Top 4 Avg CN0 mean (dB-Hz): ").append(this.topFourAverageCn0Statistics.getMean()).append("\n");
            s.append("  Top 4 Avg CN0 standard deviation (dB-Hz): ").append(this.topFourAverageCn0Statistics.getStandardDeviation()).append("\n");
        }
        s.append("GNSS_KPI_END").append("\n");
        GpsBatteryStats stats = this.mGnssPowerMetrics.getGpsBatteryStats();
        if (stats != null) {
            s.append("Power Metrics").append('\n');
            long[] t = stats.getTimeInGpsSignalQualityLevel();
            if (t != null && t.length == 2) {
                s.append("  Amount of time (while on battery) Top 4 Avg CN0 > " + Double.toString(20.0) + " dB-Hz (min): ").append((double)t[1] / 60000.0).append("\n");
                s.append("  Amount of time (while on battery) Top 4 Avg CN0 <= " + Double.toString(20.0) + " dB-Hz (min): ").append((double)t[0] / 60000.0).append("\n");
            }
            s.append("  Energy consumed while on battery (mAh): ").append((double)stats.getEnergyConsumedMaMs() / 3600000.0).append("\n");
        }
        return s.toString();
    }

    private void reset() {
        StringBuilder s = new StringBuilder();
        TimeUtils.formatDuration(SystemClock.elapsedRealtimeNanos() / 1000000L, s);
        this.logStartInElapsedRealTime = s.toString();
        this.locationFailureStatistics.reset();
        this.timeToFirstFixSecStatistics.reset();
        this.positionAccuracyMeterStatistics.reset();
        this.topFourAverageCn0Statistics.reset();
    }

    private class GnssPowerMetrics {
        public static final double POOR_TOP_FOUR_AVG_CN0_THRESHOLD_DB_HZ = 20.0;
        private static final double REPORTING_THRESHOLD_DB_HZ = 1.0;
        private final IBatteryStats mBatteryStats;
        private double mLastAverageCn0;

        public GnssPowerMetrics(IBatteryStats stats) {
            this.mBatteryStats = stats;
            this.mLastAverageCn0 = -100.0;
        }

        public GnssLogsProto.PowerMetrics buildProto() {
            GnssLogsProto.PowerMetrics p = new GnssLogsProto.PowerMetrics();
            GpsBatteryStats stats = GnssMetrics.this.mGnssPowerMetrics.getGpsBatteryStats();
            if (stats != null) {
                p.loggingDurationMs = stats.getLoggingDurationMs();
                p.energyConsumedMah = (double)stats.getEnergyConsumedMaMs() / 3600000.0;
                long[] t = stats.getTimeInGpsSignalQualityLevel();
                p.timeInSignalQualityLevelMs = new long[t.length];
                for (int i = 0; i < t.length; ++i) {
                    p.timeInSignalQualityLevelMs[i] = t[i];
                }
            }
            return p;
        }

        public GpsBatteryStats getGpsBatteryStats() {
            try {
                return this.mBatteryStats.getGpsBatteryStats();
            }
            catch (Exception e) {
                Log.w(TAG, "Exception", e);
                return null;
            }
        }

        public void reportSignalQuality(float[] ascendingCN0Array, int numSv) {
            double avgCn0 = 0.0;
            if (numSv > 0) {
                for (int i = Math.max(0, numSv - 4); i < numSv; ++i) {
                    avgCn0 += (double)ascendingCN0Array[i];
                }
                avgCn0 /= (double)Math.min(numSv, 4);
            }
            if (Math.abs(avgCn0 - this.mLastAverageCn0) < 1.0) {
                return;
            }
            try {
                this.mBatteryStats.noteGpsSignalQuality(this.getSignalLevel(avgCn0));
                this.mLastAverageCn0 = avgCn0;
            }
            catch (Exception e) {
                Log.w(TAG, "Exception", e);
            }
        }

        private int getSignalLevel(double cn0) {
            if (cn0 > 20.0) {
                return 1;
            }
            return 0;
        }
    }

    private class Statistics {
        private int count;
        private double sum;
        private double sumSquare;

        private Statistics() {
        }

        public void reset() {
            this.count = 0;
            this.sum = 0.0;
            this.sumSquare = 0.0;
        }

        public void addItem(double item) {
            ++this.count;
            this.sum += item;
            this.sumSquare += item * item;
        }

        public int getCount() {
            return this.count;
        }

        public double getMean() {
            return this.sum / (double)this.count;
        }

        public double getStandardDeviation() {
            double m = this.sum / (double)this.count;
            double v = this.sumSquare / (double)this.count;
            if (v > (m *= m)) {
                return Math.sqrt(v - m);
            }
            return 0.0;
        }
    }
}

