/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.net.NetworkStats;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ProcFileReader;
import com.android.server.NetworkManagementSocketTagger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.ProtocolException;
import libcore.io.IoUtils;

public class NetworkStatsFactory {
    private static final String TAG = "NetworkStatsFactory";
    private static final boolean USE_NATIVE_PARSING = true;
    private static final boolean SANITY_CHECK_NATIVE = false;
    private static final String CLATD_INTERFACE_PREFIX = "v4-";
    private static final int IPV4V6_HEADER_DELTA = 20;
    private final File mStatsIfaceDev;
    private final File mStatsXtIfaceAll;
    private final File mStatsXtIfaceFmt;
    private final File mStatsXtUid;
    private boolean mUseBpfStats;
    @GuardedBy(value="sStackedIfaces")
    private static final ArrayMap<String, String> sStackedIfaces = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noteStackedIface(String stackedIface, String baseIface) {
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            if (baseIface != null) {
                sStackedIfaces.put(stackedIface, baseIface);
            } else {
                sStackedIfaces.remove(stackedIface);
            }
        }
    }

    public NetworkStatsFactory() {
        this(new File("/proc/"), new File("/sys/fs/bpf/traffic_uid_stats_map").exists());
    }

    @VisibleForTesting
    public NetworkStatsFactory(File procRoot, boolean useBpfStats) {
        this.mStatsIfaceDev = new File(procRoot, "net/dev");
        this.mStatsXtIfaceAll = new File(procRoot, "net/xt_qtaguid/iface_stat_all");
        this.mStatsXtIfaceFmt = new File(procRoot, "net/xt_qtaguid/iface_stat_fmt");
        this.mStatsXtUid = new File(procRoot, "net/xt_qtaguid/stats");
        this.mUseBpfStats = useBpfStats;
    }

    @VisibleForTesting
    public NetworkStats readNetworkStatsIfaceDev() throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.mStatsIfaceDev));
            reader.readLine();
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] values = line.trim().split("\\:?\\s+");
                entry.iface = values[0];
                entry.uid = -1;
                entry.set = -1;
                entry.tag = 0;
                entry.rxBytes = Long.parseLong(values[1]);
                entry.rxPackets = Long.parseLong(values[2]);
                entry.txBytes = Long.parseLong(values[9]);
                entry.txPackets = Long.parseLong(values[10]);
                stats.addValues(entry);
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            try {
                throw new ProtocolException("problem parsing stats", (Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    public NetworkStats readNetworkStatsSummaryDev() throws IOException {
        if (this.mUseBpfStats) {
            return this.readNetworkStatsIfaceDev();
        }
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceAll));
            while (reader.hasMoreData()) {
                entry.iface = reader.nextString();
                entry.uid = -1;
                entry.set = -1;
                entry.tag = 0;
                boolean active = reader.nextInt() != 0;
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                if (active) {
                    entry.rxBytes += reader.nextLong();
                    entry.rxPackets += reader.nextLong();
                    entry.txBytes += reader.nextLong();
                    entry.txPackets += reader.nextLong();
                }
                stats.addValues(entry);
                reader.finishLine();
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            try {
                throw new ProtocolException("problem parsing stats", (Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    public NetworkStats readNetworkStatsSummaryXt() throws IOException {
        if (this.mUseBpfStats) {
            return this.readNetworkStatsIfaceDev();
        }
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        if (!this.mStatsXtIfaceFmt.exists()) {
            return null;
        }
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceFmt));
            reader.finishLine();
            while (reader.hasMoreData()) {
                entry.iface = reader.nextString();
                entry.uid = -1;
                entry.set = -1;
                entry.tag = 0;
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                stats.addValues(entry);
                reader.finishLine();
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            try {
                throw new ProtocolException("problem parsing stats", (Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    public NetworkStats readNetworkStatsDetail() throws IOException {
        return this.readNetworkStatsDetail(-1, null, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkStats readNetworkStatsDetail(int limitUid, String[] limitIfaces, int limitTag, NetworkStats lastStats) throws IOException {
        ArrayMap<String, String> stackedIfaces;
        NetworkStats stats = this.readNetworkStatsDetailInternal(limitUid, limitIfaces, limitTag, lastStats);
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            stackedIfaces = new ArrayMap<String, String>(sStackedIfaces);
        }
        NetworkStats adjustments = new NetworkStats(0L, stackedIfaces.size());
        NetworkStats.Entry entry = null;
        for (int i = 0; i < stats.size(); ++i) {
            String baseIface;
            entry = stats.getValues(i, entry);
            if (entry.iface == null || !entry.iface.startsWith(CLATD_INTERFACE_PREFIX) || (baseIface = stackedIfaces.get(entry.iface)) == null) continue;
            NetworkStats.Entry adjust = new NetworkStats.Entry(baseIface, 0, 0, 0, 0, 0, 0, 0L, 0L, 0L, 0L, 0L);
            adjust.rxBytes -= entry.rxBytes + entry.rxPackets * 20L;
            adjust.txBytes -= entry.txBytes + entry.txPackets * 20L;
            adjust.rxPackets -= entry.rxPackets;
            adjust.txPackets -= entry.txPackets;
            adjustments.combineValues(adjust);
            entry.rxBytes = entry.rxPackets * 20L;
            entry.txBytes = entry.txPackets * 20L;
            entry.rxPackets = 0L;
            entry.txPackets = 0L;
            stats.combineValues(entry);
        }
        stats.combineAllValues(adjustments);
        return stats;
    }

    private NetworkStats readNetworkStatsDetailInternal(int limitUid, String[] limitIfaces, int limitTag, NetworkStats lastStats) throws IOException {
        NetworkStats stats;
        if (lastStats != null) {
            stats = lastStats;
            stats.setElapsedRealtime(SystemClock.elapsedRealtime());
        } else {
            stats = new NetworkStats(SystemClock.elapsedRealtime(), -1);
        }
        if (NetworkStatsFactory.nativeReadNetworkStatsDetail(stats, this.mStatsXtUid.getAbsolutePath(), limitUid, limitIfaces, limitTag, this.mUseBpfStats) != 0) {
            throw new IOException("Failed to parse network stats");
        }
        return stats;
    }

    @VisibleForTesting
    public static NetworkStats javaReadNetworkStatsDetail(File detailPath, int limitUid, String[] limitIfaces, int limitTag) throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 24);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        int idx = 1;
        int lastIdx = 1;
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(detailPath));
            reader.finishLine();
            while (reader.hasMoreData()) {
                idx = reader.nextInt();
                if (idx != lastIdx + 1) {
                    throw new ProtocolException("inconsistent idx=" + idx + " after lastIdx=" + lastIdx);
                }
                lastIdx = idx;
                entry.iface = reader.nextString();
                entry.tag = NetworkManagementSocketTagger.kernelToTag(reader.nextString());
                entry.uid = reader.nextInt();
                entry.set = reader.nextInt();
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                if (!(limitIfaces != null && !ArrayUtils.contains(limitIfaces, entry.iface) || limitUid != -1 && limitUid != entry.uid || limitTag != -1 && limitTag != entry.tag)) {
                    stats.addValues(entry);
                }
                reader.finishLine();
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            try {
                throw new ProtocolException("problem parsing idx " + idx, (Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    public void assertEquals(NetworkStats expected, NetworkStats actual) {
        if (expected.size() != actual.size()) {
            throw new AssertionError((Object)("Expected size " + expected.size() + ", actual size " + actual.size()));
        }
        NetworkStats.Entry expectedRow = null;
        NetworkStats.Entry actualRow = null;
        for (int i = 0; i < expected.size(); ++i) {
            if (!(expectedRow = expected.getValues(i, expectedRow)).equals(actualRow = actual.getValues(i, actualRow))) {
                throw new AssertionError((Object)("Expected row " + i + ": " + expectedRow + ", actual row " + actualRow));
            }
        }
    }

    @VisibleForTesting
    public static native int nativeReadNetworkStatsDetail(NetworkStats var0, String var1, int var2, String[] var3, int var4, boolean var5);
}

