/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.notification;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.os.RemoteException;
import android.provider.Settings;
import java.util.ArrayList;
import java.util.Arrays;

public class SystemNotificationChannels {
    public static String VIRTUAL_KEYBOARD = "VIRTUAL_KEYBOARD";
    public static String PHYSICAL_KEYBOARD = "PHYSICAL_KEYBOARD";
    public static String SECURITY = "SECURITY";
    public static String CAR_MODE = "CAR_MODE";
    public static String ACCOUNT = "ACCOUNT";
    public static String DEVELOPER = "DEVELOPER";
    public static String UPDATES = "UPDATES";
    public static String NETWORK_STATUS = "NETWORK_STATUS";
    public static String NETWORK_ALERTS = "NETWORK_ALERTS";
    public static String NETWORK_AVAILABLE = "NETWORK_AVAILABLE";
    public static String VPN = "VPN";
    public static String DEVICE_ADMIN = "DEVICE_ADMIN";
    public static String ALERTS = "ALERTS";
    public static String RETAIL_MODE = "RETAIL_MODE";
    public static String USB = "USB";
    public static String FOREGROUND_SERVICE = "FOREGROUND_SERVICE";
    public static String HEAVY_WEIGHT_APP = "HEAVY_WEIGHT_APP";

    public static void createAll(Context context) {
        NotificationManager nm = context.getSystemService(NotificationManager.class);
        ArrayList<NotificationChannel> channelsList = new ArrayList<NotificationChannel>();
        channelsList.add(new NotificationChannel(VIRTUAL_KEYBOARD, context.getString(17040346), 2));
        NotificationChannel physicalKeyboardChannel = new NotificationChannel(PHYSICAL_KEYBOARD, context.getString(17040340), 3);
        physicalKeyboardChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        channelsList.add(physicalKeyboardChannel);
        channelsList.add(new NotificationChannel(SECURITY, context.getString(17040342), 2));
        channelsList.add(new NotificationChannel(CAR_MODE, context.getString(17040329), 2));
        channelsList.add(SystemNotificationChannels.newAccountChannel(context));
        channelsList.add(new NotificationChannel(DEVELOPER, context.getString(17040330), 2));
        channelsList.add(new NotificationChannel(UPDATES, context.getString(17040344), 2));
        channelsList.add(new NotificationChannel(NETWORK_STATUS, context.getString(17040339), 2));
        NotificationChannel networkAlertsChannel = new NotificationChannel(NETWORK_ALERTS, context.getString(17040337), 4);
        networkAlertsChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        channelsList.add(networkAlertsChannel);
        channelsList.add(new NotificationChannel(NETWORK_AVAILABLE, context.getString(17040338), 2));
        channelsList.add(new NotificationChannel(VPN, context.getString(17040348), 2));
        channelsList.add(new NotificationChannel(DEVICE_ADMIN, context.getString(17040331), 2));
        NotificationChannel alertsChannel = new NotificationChannel(ALERTS, context.getString(17040327), 3);
        alertsChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        channelsList.add(alertsChannel);
        channelsList.add(new NotificationChannel(RETAIL_MODE, context.getString(17040341), 2));
        channelsList.add(new NotificationChannel(USB, context.getString(17040345), 1));
        NotificationChannel foregroundChannel = new NotificationChannel(FOREGROUND_SERVICE, context.getString(17040333), 2);
        foregroundChannel.setBlockableSystem(true);
        channelsList.add(foregroundChannel);
        NotificationChannel heavyWeightChannel = new NotificationChannel(HEAVY_WEIGHT_APP, context.getString(17040334), 3);
        heavyWeightChannel.setShowBadge(false);
        heavyWeightChannel.setSound(null, new AudioAttributes.Builder().setContentType(4).setUsage(10).build());
        channelsList.add(heavyWeightChannel);
        nm.createNotificationChannels(channelsList);
    }

    public static void createAccountChannelForPackage(String pkg, int uid, Context context) {
        INotificationManager iNotificationManager = NotificationManager.getService();
        try {
            iNotificationManager.createNotificationChannelsForPackage(pkg, uid, new ParceledListSlice<NotificationChannel>(Arrays.asList(SystemNotificationChannels.newAccountChannel(context))));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static NotificationChannel newAccountChannel(Context context) {
        return new NotificationChannel(ACCOUNT, context.getString(17040326), 2);
    }

    private SystemNotificationChannels() {
    }
}

