/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Handler;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.SparseIntArray;
import com.android.internal.util.Preconditions;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class BinderInternal {
    private static final String TAG = "BinderInternal";
    static WeakReference<GcWatcher> sGcWatcher = new WeakReference<GcWatcher>(new GcWatcher());
    static ArrayList<Runnable> sGcWatchers = new ArrayList();
    static Runnable[] sTmpWatchers = new Runnable[1];
    static long sLastGcTime;
    static final BinderProxyLimitListenerDelegate sBinderProxyLimitListenerDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGcWatcher(Runnable watcher) {
        ArrayList<Runnable> arrayList = sGcWatchers;
        synchronized (arrayList) {
            sGcWatchers.add(watcher);
        }
    }

    public static final native void joinThreadPool();

    public static long getLastGcTime() {
        return sLastGcTime;
    }

    public static final native IBinder getContextObject();

    public static final native void disableBackgroundScheduling(boolean var0);

    public static final native void setMaxThreads(int var0);

    static final native void handleGc();

    public static void forceGc(String reason) {
        EventLog.writeEvent(2741, reason);
        VMRuntime.getRuntime().requestConcurrentGC();
    }

    static void forceBinderGc() {
        BinderInternal.forceGc("Binder");
    }

    public static final native void nSetBinderProxyCountEnabled(boolean var0);

    public static final native SparseIntArray nGetBinderProxyPerUidCounts();

    public static final native int nGetBinderProxyCount(int var0);

    public static final native void nSetBinderProxyCountWatermarks(int var0, int var1);

    public static void binderProxyLimitCallbackFromNative(int uid) {
        sBinderProxyLimitListenerDelegate.notifyClient(uid);
    }

    public static void setBinderProxyCountCallback(BinderProxyLimitListener listener, Handler handler) {
        Preconditions.checkNotNull(handler, "Must provide NonNull Handler to setBinderProxyCountCallback when setting BinderProxyLimitListener");
        sBinderProxyLimitListenerDelegate.setListener(listener, handler);
    }

    public static void clearBinderProxyCountCallback() {
        sBinderProxyLimitListenerDelegate.setListener(null, null);
    }

    static {
        sBinderProxyLimitListenerDelegate = new BinderProxyLimitListenerDelegate();
    }

    private static class BinderProxyLimitListenerDelegate {
        private BinderProxyLimitListener mBinderProxyLimitListener;
        private Handler mHandler;

        private BinderProxyLimitListenerDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setListener(BinderProxyLimitListener listener, Handler handler) {
            BinderProxyLimitListenerDelegate binderProxyLimitListenerDelegate = this;
            synchronized (binderProxyLimitListenerDelegate) {
                this.mBinderProxyLimitListener = listener;
                this.mHandler = handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyClient(final int uid) {
            BinderProxyLimitListenerDelegate binderProxyLimitListenerDelegate = this;
            synchronized (binderProxyLimitListenerDelegate) {
                if (this.mBinderProxyLimitListener != null) {
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            mBinderProxyLimitListener.onLimitReached(uid);
                        }
                    });
                }
            }
        }
    }

    public static interface BinderProxyLimitListener {
        public void onLimitReached(int var1);
    }

    static final class GcWatcher {
        GcWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            BinderInternal.handleGc();
            sLastGcTime = SystemClock.uptimeMillis();
            ArrayList<Runnable> arrayList = sGcWatchers;
            synchronized (arrayList) {
                sTmpWatchers = sGcWatchers.toArray(sTmpWatchers);
            }
            for (int i = 0; i < sTmpWatchers.length; ++i) {
                if (sTmpWatchers[i] == null) continue;
                sTmpWatchers[i].run();
            }
            sGcWatcher = new WeakReference<GcWatcher>(new GcWatcher());
        }
    }
}

