/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelUidCpuFreqTimeReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class KernelSingleUidTimeReader {
    private final String TAG = KernelUidCpuFreqTimeReader.class.getName();
    private final boolean DBG = false;
    private final String PROC_FILE_DIR = "/proc/uid/";
    private final String PROC_FILE_NAME = "/time_in_state";
    @VisibleForTesting
    public static final int TOTAL_READ_ERROR_COUNT = 5;
    @GuardedBy(value="this")
    private final int mCpuFreqsCount;
    @GuardedBy(value="this")
    private SparseArray<long[]> mLastUidCpuTimeMs = new SparseArray();
    @GuardedBy(value="this")
    private int mReadErrorCounter;
    @GuardedBy(value="this")
    private boolean mSingleUidCpuTimesAvailable = true;
    @GuardedBy(value="this")
    private boolean mHasStaleData;
    private final Injector mInjector;

    KernelSingleUidTimeReader(int cpuFreqsCount) {
        this(cpuFreqsCount, new Injector());
    }

    public KernelSingleUidTimeReader(int cpuFreqsCount, Injector injector) {
        this.mInjector = injector;
        this.mCpuFreqsCount = cpuFreqsCount;
        if (this.mCpuFreqsCount == 0) {
            this.mSingleUidCpuTimesAvailable = false;
        }
    }

    public boolean singleUidCpuTimesAvailable() {
        return this.mSingleUidCpuTimesAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readDeltaMs(int uid) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            if (!this.mSingleUidCpuTimesAvailable) {
                return null;
            }
            String procFile = "/proc/uid/" + uid + "/time_in_state";
            long[] cpuTimesMs = new long[this.mCpuFreqsCount];
            try {
                byte[] data = this.mInjector.readData(procFile);
                ByteBuffer buffer = ByteBuffer.wrap(data);
                buffer.order(ByteOrder.nativeOrder());
                for (int i = 0; i < this.mCpuFreqsCount; ++i) {
                    cpuTimesMs[i] = buffer.getLong() * 10L;
                }
            }
            catch (Exception e) {
                if (++this.mReadErrorCounter >= 5) {
                    this.mSingleUidCpuTimesAvailable = false;
                }
                return null;
            }
            return this.computeDelta(uid, cpuTimesMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] computeDelta(int uid, long[] latestCpuTimesMs) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            if (!this.mSingleUidCpuTimesAvailable) {
                return null;
            }
            long[] lastCpuTimesMs = this.mLastUidCpuTimeMs.get(uid);
            long[] deltaTimesMs = this.getDeltaLocked(lastCpuTimesMs, latestCpuTimesMs);
            if (deltaTimesMs == null) {
                return null;
            }
            boolean hasNonZero = false;
            for (int i = deltaTimesMs.length - 1; i >= 0; --i) {
                if (deltaTimesMs[i] <= 0L) continue;
                hasNonZero = true;
                break;
            }
            if (hasNonZero) {
                this.mLastUidCpuTimeMs.put(uid, latestCpuTimesMs);
                return deltaTimesMs;
            }
            return null;
        }
    }

    @GuardedBy(value="this")
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public long[] getDeltaLocked(long[] lastCpuTimesMs, long[] latestCpuTimesMs) {
        for (int i = latestCpuTimesMs.length - 1; i >= 0; --i) {
            if (latestCpuTimesMs[i] >= 0L) continue;
            return null;
        }
        if (lastCpuTimesMs == null) {
            return latestCpuTimesMs;
        }
        long[] deltaTimesMs = new long[latestCpuTimesMs.length];
        for (int i = latestCpuTimesMs.length - 1; i >= 0; --i) {
            deltaTimesMs[i] = latestCpuTimesMs[i] - lastCpuTimesMs[i];
            if (deltaTimesMs[i] >= 0L) continue;
            return null;
        }
        return deltaTimesMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDataAsStale(boolean hasStaleData) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mHasStaleData = hasStaleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStaleData() {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            return this.mHasStaleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllUidsCpuTimesMs(SparseArray<long[]> allUidsCpuTimesMs) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mLastUidCpuTimeMs.clear();
            for (int i = allUidsCpuTimesMs.size() - 1; i >= 0; --i) {
                long[] cpuTimesMs = allUidsCpuTimesMs.valueAt(i);
                if (cpuTimesMs == null) continue;
                this.mLastUidCpuTimeMs.put(allUidsCpuTimesMs.keyAt(i), (long[])cpuTimesMs.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUid(int uid) {
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mLastUidCpuTimeMs.delete(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            return;
        }
        KernelSingleUidTimeReader kernelSingleUidTimeReader = this;
        synchronized (kernelSingleUidTimeReader) {
            this.mLastUidCpuTimeMs.put(startUid, null);
            this.mLastUidCpuTimeMs.put(endUid, null);
            int startIdx = this.mLastUidCpuTimeMs.indexOfKey(startUid);
            int endIdx = this.mLastUidCpuTimeMs.indexOfKey(endUid);
            this.mLastUidCpuTimeMs.removeAtRange(startIdx, endIdx - startIdx + 1);
        }
    }

    @VisibleForTesting
    public SparseArray<long[]> getLastUidCpuTimeMs() {
        return this.mLastUidCpuTimeMs;
    }

    @VisibleForTesting
    public void setSingleUidCpuTimesAvailable(boolean singleUidCpuTimesAvailable) {
        this.mSingleUidCpuTimesAvailable = singleUidCpuTimesAvailable;
    }

    @VisibleForTesting
    public static class Injector {
        public byte[] readData(String procFile) throws IOException {
            return Files.readAllBytes(Paths.get(procFile, new String[0]));
        }
    }
}

