/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class KernelUidCpuActiveTimeReader {
    private static final boolean DEBUG = false;
    private static final String TAG = "KernelUidCpuActiveTimeReader";
    private static final String UID_TIMES_PROC_FILE = "/proc/uid_concurrent_active_time";
    private int mCoreCount;
    private long mLastTimeReadMs;
    private long mNowTimeMs;
    private SparseArray<long[]> mLastUidCpuActiveTimeMs = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDelta(Callback cb) {
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try (BufferedReader reader = new BufferedReader(new FileReader(UID_TIMES_PROC_FILE));){
            this.mNowTimeMs = SystemClock.elapsedRealtime();
            this.readDeltaInternal(reader, cb);
            this.mLastTimeReadMs = this.mNowTimeMs;
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read /proc/uid_concurrent_active_time: " + e);
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    public void removeUid(int uid) {
        this.mLastUidCpuActiveTimeMs.delete(uid);
    }

    public void removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            Slog.w(TAG, "End UID " + endUid + " is smaller than start UID " + startUid);
            return;
        }
        this.mLastUidCpuActiveTimeMs.put(startUid, null);
        this.mLastUidCpuActiveTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidCpuActiveTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidCpuActiveTimeMs.indexOfKey(endUid);
        this.mLastUidCpuActiveTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    @VisibleForTesting
    public void readDeltaInternal(BufferedReader reader, Callback cb) throws IOException {
        String line = reader.readLine();
        if (line == null || !line.startsWith("active:")) {
            Slog.e(TAG, String.format("Malformed proc file: %s ", UID_TIMES_PROC_FILE));
            return;
        }
        if (this.mCoreCount == 0) {
            this.mCoreCount = Integer.parseInt(line.substring(line.indexOf(32) + 1));
        }
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(32);
            int uid = Integer.parseInt(line.substring(0, index - 1), 10);
            this.readTimesForUid(uid, line.substring(index + 1), cb);
        }
    }

    private void readTimesForUid(int uid, String line, Callback cb) {
        String[] timesStr;
        long[] lastActiveTime = this.mLastUidCpuActiveTimeMs.get(uid);
        if (lastActiveTime == null) {
            lastActiveTime = new long[this.mCoreCount];
            this.mLastUidCpuActiveTimeMs.put(uid, lastActiveTime);
        }
        if ((timesStr = line.split(" ")).length != this.mCoreCount) {
            Slog.e(TAG, String.format("# readings don't match # cores, readings: %d, CPU cores: %d", timesStr.length, this.mCoreCount));
            return;
        }
        long sumDeltas = 0L;
        long[] curActiveTime = new long[this.mCoreCount];
        boolean notify = false;
        for (int i = 0; i < this.mCoreCount; ++i) {
            curActiveTime[i] = Long.parseLong(timesStr[i], 10) * 10L;
            long delta = curActiveTime[i] - lastActiveTime[i];
            if (delta < 0L || curActiveTime[i] < 0L) {
                return;
            }
            notify |= delta > 0L;
            sumDeltas += delta / (long)(i + 1);
        }
        if (notify) {
            System.arraycopy((long[])curActiveTime, (int)0, (long[])lastActiveTime, (int)0, (int)this.mCoreCount);
            if (cb != null) {
                cb.onUidCpuActiveTime(uid, sumDeltas);
            }
        }
    }

    public static interface Callback {
        public void onUidCpuActiveTime(int var1, long var2);
    }
}

