/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class KernelUidCpuClusterTimeReader {
    private static final boolean DEBUG = false;
    private static final String TAG = "KernelUidCpuClusterTimeReader";
    private static final String UID_TIMES_PROC_FILE = "/proc/uid_concurrent_policy_time";
    private int[] mCoreOnCluster;
    private int mCores;
    private long mLastTimeReadMs;
    private long mNowTimeMs;
    private SparseArray<long[]> mLastUidPolicyTimeMs = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDelta(Callback cb) {
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try (BufferedReader reader = new BufferedReader(new FileReader(UID_TIMES_PROC_FILE));){
            this.mNowTimeMs = SystemClock.elapsedRealtime();
            this.readDeltaInternal(reader, cb);
            this.mLastTimeReadMs = this.mNowTimeMs;
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read /proc/uid_concurrent_policy_time: " + e);
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    public void removeUid(int uid) {
        this.mLastUidPolicyTimeMs.delete(uid);
    }

    public void removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            Slog.w(TAG, "End UID " + endUid + " is smaller than start UID " + startUid);
            return;
        }
        this.mLastUidPolicyTimeMs.put(startUid, null);
        this.mLastUidPolicyTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidPolicyTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidPolicyTimeMs.indexOfKey(endUid);
        this.mLastUidPolicyTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    @VisibleForTesting
    public void readDeltaInternal(BufferedReader reader, Callback cb) throws IOException {
        String line = reader.readLine();
        if (line == null || !line.startsWith("policy")) {
            Slog.e(TAG, String.format("Malformed proc file: %s ", UID_TIMES_PROC_FILE));
            return;
        }
        if (this.mCoreOnCluster == null) {
            int i;
            ArrayList<Integer> list = new ArrayList<Integer>();
            String[] policies = line.split(" ");
            if (policies.length == 0 || policies.length % 2 != 0) {
                Slog.e(TAG, String.format("Malformed proc file: %s ", UID_TIMES_PROC_FILE));
                return;
            }
            for (i = 0; i < policies.length; i += 2) {
                list.add(Integer.parseInt(policies[i + 1]));
            }
            this.mCoreOnCluster = new int[list.size()];
            for (i = 0; i < list.size(); ++i) {
                this.mCoreOnCluster[i] = (Integer)list.get(i);
                this.mCores += this.mCoreOnCluster[i];
            }
        }
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(32);
            int uid = Integer.parseInt(line.substring(0, index - 1), 10);
            this.readTimesForUid(uid, line.substring(index + 1), cb);
        }
    }

    private void readTimesForUid(int uid, String line, Callback cb) {
        String[] timeStr;
        long[] lastPolicyTime = this.mLastUidPolicyTimeMs.get(uid);
        if (lastPolicyTime == null) {
            lastPolicyTime = new long[this.mCores];
            this.mLastUidPolicyTimeMs.put(uid, lastPolicyTime);
        }
        if ((timeStr = line.split(" ")).length != this.mCores) {
            Slog.e(TAG, String.format("# readings don't match # cores, readings: %d, # CPU cores: %d", timeStr.length, this.mCores));
            return;
        }
        long[] deltaPolicyTime = new long[this.mCores];
        long[] currPolicyTime = new long[this.mCores];
        boolean notify = false;
        for (int i = 0; i < this.mCores; ++i) {
            currPolicyTime[i] = Long.parseLong(timeStr[i], 10) * 10L;
            deltaPolicyTime[i] = currPolicyTime[i] - lastPolicyTime[i];
            if (deltaPolicyTime[i] < 0L || currPolicyTime[i] < 0L) {
                return;
            }
            notify |= deltaPolicyTime[i] > 0L;
        }
        if (notify) {
            System.arraycopy((long[])currPolicyTime, (int)0, (long[])lastPolicyTime, (int)0, (int)this.mCores);
            if (cb != null) {
                long[] times = new long[this.mCoreOnCluster.length];
                int core = 0;
                for (int i = 0; i < this.mCoreOnCluster.length; ++i) {
                    for (int j = 0; j < this.mCoreOnCluster[i]; ++j) {
                        int n = i;
                        times[n] = times[n] + deltaPolicyTime[core++] / (long)(j + 1);
                    }
                }
                cb.onUidCpuPolicyTime(uid, times);
            }
        }
    }

    public static interface Callback {
        public void onUidCpuPolicyTime(int var1, long[] var2);
    }
}

