/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.os.SystemClock;
import android.util.IntArray;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.PowerProfile;
import com.android.internal.util.Preconditions;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class KernelUidCpuFreqTimeReader {
    private static final boolean DEBUG = false;
    private static final String TAG = "KernelUidCpuFreqTimeReader";
    private static final String UID_TIMES_PROC_FILE = "/proc/uid_time_in_state";
    private long[] mCpuFreqs;
    private int mCpuFreqsCount;
    private long mLastTimeReadMs;
    private long mNowTimeMs;
    private SparseArray<long[]> mLastUidCpuFreqTimeMs = new SparseArray();
    private static final int TOTAL_READ_ERROR_COUNT = 5;
    private int mReadErrorCounter;
    private boolean mPerClusterTimesAvailable;
    private boolean mAllUidTimesAvailable = true;

    public boolean perClusterTimesAvailable() {
        return this.mPerClusterTimesAvailable;
    }

    public boolean allUidTimesAvailable() {
        return this.mAllUidTimesAvailable;
    }

    public SparseArray<long[]> getAllUidCpuFreqTimeMs() {
        return this.mLastUidCpuFreqTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readFreqs(PowerProfile powerProfile) {
        Preconditions.checkNotNull(powerProfile);
        if (this.mCpuFreqs != null) {
            return this.mCpuFreqs;
        }
        if (!this.mAllUidTimesAvailable) {
            return null;
        }
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try {
            long[] lArray;
            BufferedReader reader = new BufferedReader(new FileReader(UID_TIMES_PROC_FILE));
            Throwable throwable = null;
            try {
                lArray = this.readFreqs(reader, powerProfile);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        KernelUidCpuFreqTimeReader.$closeResource(throwable, reader);
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    if (++this.mReadErrorCounter >= 5) {
                        this.mAllUidTimesAvailable = false;
                    }
                    Slog.e(TAG, "Failed to read /proc/uid_time_in_state: " + e);
                    throwable = null;
                    return throwable;
                }
            }
            KernelUidCpuFreqTimeReader.$closeResource(throwable, reader);
            return lArray;
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    @VisibleForTesting
    public long[] readFreqs(BufferedReader reader, PowerProfile powerProfile) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        return this.readCpuFreqs(line, powerProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDelta(Callback callback) {
        if (this.mCpuFreqs == null) {
            return;
        }
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try (BufferedReader reader = new BufferedReader(new FileReader(UID_TIMES_PROC_FILE));){
            this.mNowTimeMs = SystemClock.elapsedRealtime();
            this.readDelta(reader, callback);
            this.mLastTimeReadMs = this.mNowTimeMs;
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read /proc/uid_time_in_state: " + e);
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    public void removeUid(int uid) {
        this.mLastUidCpuFreqTimeMs.delete(uid);
    }

    public void removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            return;
        }
        this.mLastUidCpuFreqTimeMs.put(startUid, null);
        this.mLastUidCpuFreqTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidCpuFreqTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidCpuFreqTimeMs.indexOfKey(endUid);
        this.mLastUidCpuFreqTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    @VisibleForTesting
    public void readDelta(BufferedReader reader, Callback callback) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(32);
            int uid = Integer.parseInt(line.substring(0, index - 1), 10);
            this.readTimesForUid(uid, line.substring(index + 1, line.length()), callback);
        }
    }

    private void readTimesForUid(int uid, String line, Callback callback) {
        String[] timesStr;
        int size;
        long[] uidTimeMs = this.mLastUidCpuFreqTimeMs.get(uid);
        if (uidTimeMs == null) {
            uidTimeMs = new long[this.mCpuFreqsCount];
            this.mLastUidCpuFreqTimeMs.put(uid, uidTimeMs);
        }
        if ((size = (timesStr = line.split(" ")).length) != uidTimeMs.length) {
            Slog.e(TAG, "No. of readings don't match cpu freqs, readings: " + size + " cpuFreqsCount: " + uidTimeMs.length);
            return;
        }
        long[] deltaUidTimeMs = new long[size];
        long[] curUidTimeMs = new long[size];
        boolean notify = false;
        for (int i = 0; i < size; ++i) {
            long totalTimeMs = Long.parseLong(timesStr[i], 10) * 10L;
            deltaUidTimeMs[i] = totalTimeMs - uidTimeMs[i];
            if (deltaUidTimeMs[i] < 0L || totalTimeMs < 0L) {
                return;
            }
            curUidTimeMs[i] = totalTimeMs;
            notify = notify || deltaUidTimeMs[i] > 0L;
        }
        if (notify) {
            System.arraycopy((long[])curUidTimeMs, (int)0, (long[])uidTimeMs, (int)0, (int)size);
            if (callback != null) {
                callback.onUidCpuFreqTime(uid, deltaUidTimeMs);
            }
        }
    }

    private long[] readCpuFreqs(String line, PowerProfile powerProfile) {
        String[] freqStr = line.split(" ");
        this.mCpuFreqsCount = freqStr.length - 1;
        this.mCpuFreqs = new long[this.mCpuFreqsCount];
        for (int i = 0; i < this.mCpuFreqsCount; ++i) {
            this.mCpuFreqs[i] = Long.parseLong(freqStr[i + 1], 10);
        }
        IntArray numClusterFreqs = this.extractClusterInfoFromProcFileFreqs();
        int numClusters = powerProfile.getNumCpuClusters();
        if (numClusterFreqs.size() == numClusters) {
            this.mPerClusterTimesAvailable = true;
            for (int i = 0; i < numClusters; ++i) {
                if (numClusterFreqs.get(i) == powerProfile.getNumSpeedStepsInCpuCluster(i)) continue;
                this.mPerClusterTimesAvailable = false;
                break;
            }
        } else {
            this.mPerClusterTimesAvailable = false;
        }
        Slog.i(TAG, "mPerClusterTimesAvailable=" + this.mPerClusterTimesAvailable);
        return this.mCpuFreqs;
    }

    private IntArray extractClusterInfoFromProcFileFreqs() {
        IntArray numClusterFreqs = new IntArray();
        int freqsFound = 0;
        for (int i = 0; i < this.mCpuFreqsCount; ++i) {
            ++freqsFound;
            if (i + 1 != this.mCpuFreqsCount && this.mCpuFreqs[i + 1] > this.mCpuFreqs[i]) continue;
            numClusterFreqs.add(freqsFound);
            freqsFound = 0;
        }
        return numClusterFreqs;
    }

    public static interface Callback {
        public void onUidCpuFreqTime(int var1, long[] var2);
    }
}

