/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import dalvik.system.ZygoteHooks;

public final class Zygote {
    public static final int DEBUG_ENABLE_JDWP = 1;
    public static final int DEBUG_ENABLE_CHECKJNI = 2;
    public static final int DEBUG_ENABLE_ASSERT = 4;
    public static final int DEBUG_ENABLE_SAFEMODE = 8;
    public static final int DEBUG_ENABLE_JNI_LOGGING = 16;
    public static final int DEBUG_GENERATE_DEBUG_INFO = 32;
    public static final int DEBUG_ALWAYS_JIT = 64;
    public static final int DEBUG_NATIVE_DEBUGGABLE = 128;
    public static final int DEBUG_JAVA_DEBUGGABLE = 256;
    public static final int DISABLE_VERIFIER = 512;
    public static final int ONLY_USE_SYSTEM_OAT_FILES = 1024;
    public static final int DISABLE_HIDDEN_API_CHECKS = 2048;
    public static final int DEBUG_GENERATE_MINI_DEBUG_INFO = 4096;
    public static final int MOUNT_EXTERNAL_NONE = 0;
    public static final int MOUNT_EXTERNAL_DEFAULT = 1;
    public static final int MOUNT_EXTERNAL_READ = 2;
    public static final int MOUNT_EXTERNAL_WRITE = 3;
    private static final ZygoteHooks VM_HOOKS = new ZygoteHooks();

    private Zygote() {
    }

    static native void nativeSecurityInit();

    public static int forkAndSpecialize(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, int mountExternal, String seInfo, String niceName, int[] fdsToClose, int[] fdsToIgnore, String instructionSet, String appDataDir) {
        VM_HOOKS.preFork();
        Zygote.resetNicePriority();
        int pid = Zygote.nativeForkAndSpecialize(uid, gid, gids, runtimeFlags, rlimits, mountExternal, seInfo, niceName, fdsToClose, fdsToIgnore, instructionSet, appDataDir);
        if (pid == 0) {
            Trace.setTracingEnabled(true, runtimeFlags);
            Trace.traceBegin(64L, "PostFork");
        }
        VM_HOOKS.postForkCommon();
        return pid;
    }

    private static native int nativeForkAndSpecialize(int var0, int var1, int[] var2, int var3, int[][] var4, int var5, String var6, String var7, int[] var8, int[] var9, String var10, String var11);

    static native void nativePreApplicationInit();

    public static int forkSystemServer(int uid, int gid, int[] gids, int runtimeFlags, int[][] rlimits, long permittedCapabilities, long effectiveCapabilities) {
        VM_HOOKS.preFork();
        Zygote.resetNicePriority();
        int pid = Zygote.nativeForkSystemServer(uid, gid, gids, runtimeFlags |= 0x800, rlimits, permittedCapabilities, effectiveCapabilities);
        if (pid == 0) {
            Trace.setTracingEnabled(true, runtimeFlags);
        }
        VM_HOOKS.postForkCommon();
        return pid;
    }

    private static native int nativeForkSystemServer(int var0, int var1, int[] var2, int var3, int[][] var4, long var5, long var7);

    protected static native void nativeAllowFileAcrossFork(String var0);

    protected static native void nativeUnmountStorageOnInit();

    private static void callPostForkChildHooks(int runtimeFlags, boolean isSystemServer, String instructionSet) {
        VM_HOOKS.postForkChild(runtimeFlags, isSystemServer, instructionSet);
    }

    static void resetNicePriority() {
        Thread.currentThread().setPriority(5);
    }

    public static void execShell(String command) {
        String[] args = new String[]{"/system/bin/sh", "-c", command};
        try {
            Os.execv(args[0], args);
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendQuotedShellArgs(StringBuilder command, String[] args) {
        for (String arg : args) {
            command.append(" '").append(arg.replace("'", "'\\''")).append("'");
        }
    }
}

